/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.fetchdata.zb.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcret.business.declare.fetchdata.zb.IZbFetchDataService;
import kd.taxc.tcret.common.utils.DataSetUtils;

public class FcsFetchDataService
implements IZbFetchDataService {
    private static final String GROUP_SELECT_SQL = "select xh, taxtype,sm,org,startdate,enddate,sl,sum(ynse) as ynse,sum(jmse) as jmse,sum(jsyj) as jsyj  group by xh,taxtype,sm,org,startdate,enddate,sl";
    private static final String GROUP_SELECT_HALF_YNSE_SQL = "select xh, taxtype,sm,org,startdate,enddate,sl,sum(ynse/2) as ynse,sum(jmse) as jmse,sum(jsyj) as jsyj  group by xh,taxtype,sm,org,startdate,enddate,sl";
    private static final String SELECT_SQL = "select xh, taxtype,sm,org,startdate,enddate,sl,ynse,jmse,jsyj";
    private static final String NUMBER_GROUP_SELECT_HALF_YNSE_SQL = "select xh, taxtype,sm,org,startdate,enddate,sl,sum(ynse/2) as ynse,sum(jmse) as jmse,sum(jsyj) as jsyj  group by xh,taxtype,sm,org,number,startdate,enddate,sl";

    @Override
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        Object sbbid = bussinessParamsVo.getExtendParams().get("sbbid");
        String detaildeclare = (String)bussinessParamsVo.getExtendParams().get("detaildeclare");
        String reliefPolicy = (String)bussinessParamsVo.getExtendParams().get("reliefPolicy");
        QFilter[] qFilters = this.buildQFilterList(sbbid, detaildeclare, reliefPolicy);
        String sql = this.getQuerySql(detaildeclare, reliefPolicy);
        DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tcret_pbt_tds_sum_tp", (String)("1 as xh,'" + FcsFetchDataService.getTDS() + "' as taxtype,landlevel as sm,org,number,sjssqq as startdate,sjssqz as enddate,taxstandard as sl,currentpayable as ynse,taxlimit,currentjmamount as jmse,taxbasis as jsyj"), (QFilter[])qFilters, (String)"skssqq asc");
        DataSet select1 = dataSet1.executeSql(sql);
        DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tcret_pbt_fcs_hire_sum_tp", (String)("2 as xh,'" + FcsFetchDataService.getFcs() + "' as taxtype,'" + FcsFetchDataService.getCZFCS() + "' as sm,org,number,sjssqq as startdate,sjssqz as enddate,taxrate as sl,currentpayable as ynse,taxlimit,currentjmamount as jmse,currental as jsyj"), (QFilter[])qFilters, (String)"skssqq asc");
        DataSet select2 = dataSet2.executeSql(sql);
        DataSet dataSet3 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tcret_pbt_fcs_price_sum_tp", (String)("3 as xh,'" + FcsFetchDataService.getFcs() + "' as taxtype,'" + FcsFetchDataService.getCJFCS() + "' as sm,org,number,sjssqq as startdate,sjssqz as enddate,taxrate as sl,currentpayable as ynse,taxlimit,currentjmamount as jmse,taxbasis as jsyj"), (QFilter[])qFilters, (String)"skssqq asc");
        DataSet select3 = dataSet3.executeSql(sql);
        DataSet orderedDataSet = select1.union(new DataSet[]{select2, select3}).orderBy(new String[]{"xh asc"});
        return DataSetUtils.dataSet2ListMap(orderedDataSet, "tcret_ccxws_zb_hb", FIELDS, SCALE_2_AMOUNT_FIELDS);
    }

    private QFilter[] buildQFilterList(Object sbbid, String detaildeclare, String reliefPolicy) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("sbbid", "=", sbbid));
        if ("true".equals(detaildeclare) && EmptyCheckUtils.isEmpty((Object)reliefPolicy)) {
            qFilters.add(new QFilter("isxgm", "=", (Object)"0"));
        }
        return qFilters.toArray(new QFilter[0]);
    }

    private String getQuerySql(String detaildeclare, String reliefPolicy) {
        if (StringUtil.isNotBlank((CharSequence)reliefPolicy)) {
            if ("true".equals(detaildeclare)) {
                return NUMBER_GROUP_SELECT_HALF_YNSE_SQL;
            }
            return GROUP_SELECT_HALF_YNSE_SQL;
        }
        if ("true".equals(detaildeclare)) {
            return SELECT_SQL;
        }
        return GROUP_SELECT_SQL;
    }

    private static String getFcs() {
        return ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"FcsFetchDataService_0", (String)"taxc-tcret", (Object[])new Object[0]);
    }

    private static String getCZFCS() {
        return ResManager.loadKDString((String)"\u4ece\u79df\u8ba1\u5f81", (String)"FcsFetchDataService_1", (String)"taxc-tcret", (Object[])new Object[0]);
    }

    private static String getCJFCS() {
        return ResManager.loadKDString((String)"\u4ece\u4ef7\u8ba1\u5f81", (String)"FcsFetchDataService_2", (String)"taxc-tcret", (Object[])new Object[0]);
    }

    private static String getTDS() {
        return ResManager.loadKDString((String)"\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", (String)"FcsFetchDataService_3", (String)"taxc-tcret", (Object[])new Object[0]);
    }
}

