/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.initparam;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.DefaultInitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.common.utils.TcretSystemParamUtil;
import org.apache.commons.lang3.StringUtils;

public class TcretCcxwsInitParams
extends DefaultInitParams {
    private static final String TCRET_YHS_TAX_SOURCE_INFO = "tcret_yhs_tax_source_info_tp";
    private static final String FCS_HIRE = "tcret_pbt_fcs_hire_sum_tp";
    private static final String FCS_PRICE = "tcret_pbt_fcs_price_sum_tp";
    private static final String FCS_TDS = "tcret_pbt_tds_sum_tp";
    private static final String ISXGM = "isXgm";
    private static final String DECLARE_MONTH = "declaremonth";

    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map param = super.buildBizParam(requestModel);
        String declareMonth = requestModel.getBusinessValue(DECLARE_MONTH);
        param.put(DECLARE_MONTH, declareMonth);
        this.getMinPeriod(requestModel.getId(), param);
        this.getYhsjz(declareMonth, param);
        this.getReliefPolicyType(requestModel, param);
        this.getDetailDeclare(requestModel, param);
        return param;
    }

    private void getDetailDeclare(DeclareRequestModel requestModel, Map<String, String> param) {
        if (EmptyCheckUtils.isEmpty((Object)requestModel.getBusinessValue("detaildeclare"))) {
            Boolean detaildeclare = TcretSystemParamUtil.getDetailDeclare(requestModel.getOrgId());
            param.put("detaildeclare", detaildeclare.toString());
        } else {
            param.put("detaildeclare", requestModel.getBusinessValue("detaildeclare"));
        }
    }

    private void getReliefPolicyType(DeclareRequestModel requestModel, Map<String, String> param) {
        String reliefPolicyType = TaxBaseDataUtils.getReliefPolicyType((Long)requestModel.getOrgId(), (Date)DateUtils.stringToDate((String)requestModel.getSkssqq()), (Date)DateUtils.stringToDate((String)requestModel.getSkssqz()), (boolean)true);
        if ("xgmnsr".equals(reliefPolicyType)) {
            param.put(ISXGM, "1");
        } else {
            param.put(ISXGM, "0");
        }
        param.put("reliefPolicy", reliefPolicyType);
        if (null != requestModel.getBusinessValue("isxxwlqy")) {
            String isxxwlqy = requestModel.getBusinessValue("isxxwlqy");
            if ("true".equals(isxxwlqy)) {
                param.put("reliefPolicy", "xxwlqy");
            } else if (("false".equals(isxxwlqy) || "".equals(isxxwlqy)) && "xxwlqy".equals(reliefPolicyType)) {
                param.put("reliefPolicy", "");
            }
        }
    }

    private void getMinPeriod(Long sbbid, Map<String, String> param) {
        QFilter sbbidQFilter = new QFilter("sbbid", "=", (Object)sbbid);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)TCRET_YHS_TAX_SOURCE_INFO, (String)"skssqq,skssqz", (QFilter[])new QFilter[]{sbbidQFilter});
        List skssqqList = objects.stream().map(o -> o.getDate("skssqq")).collect(Collectors.toList());
        List skssqzList = objects.stream().map(o -> o.getDate("skssqz")).collect(Collectors.toList());
        DynamicObjectCollection fcshire = QueryServiceHelper.query((String)FCS_HIRE, (String)"skssqq,skssqz", (QFilter[])new QFilter[]{sbbidQFilter});
        skssqqList.addAll(fcshire.stream().map(o -> o.getDate("skssqq")).collect(Collectors.toList()));
        skssqzList.addAll(fcshire.stream().map(o -> o.getDate("skssqz")).collect(Collectors.toList()));
        DynamicObjectCollection fcsprice = QueryServiceHelper.query((String)FCS_PRICE, (String)"skssqq,skssqz", (QFilter[])new QFilter[]{sbbidQFilter});
        skssqqList.addAll(fcsprice.stream().map(o -> o.getDate("skssqq")).collect(Collectors.toList()));
        skssqzList.addAll(fcsprice.stream().map(o -> o.getDate("skssqz")).collect(Collectors.toList()));
        DynamicObjectCollection fcstds = QueryServiceHelper.query((String)FCS_TDS, (String)"skssqq,skssqz", (QFilter[])new QFilter[]{sbbidQFilter});
        skssqqList.addAll(fcstds.stream().map(o -> o.getDate("skssqq")).collect(Collectors.toList()));
        skssqzList.addAll(fcstds.stream().map(o -> o.getDate("skssqz")).collect(Collectors.toList()));
        String minDate = skssqqList.size() > 0 ? DateUtils.formatMonth((Date)((Date)Collections.min(skssqqList))) : "";
        String maxdate = skssqzList.size() > 0 ? DateUtils.formatMonth((Date)((Date)Collections.max(skssqzList))) : "";
        String minskssqq = skssqqList.size() > 0 ? DateUtils.format((Date)((Date)Collections.min(skssqqList))) : "";
        String maxskssqz = skssqzList.size() > 0 ? DateUtils.format((Date)((Date)Collections.max(skssqzList))) : "";
        String maxyear = "";
        String maxmonth = "";
        String minyear = "";
        String minmonth = "";
        if (StringUtil.isNotEmpty((CharSequence)maxdate)) {
            maxyear = maxdate.substring(0, 4);
            maxmonth = maxdate.substring(5, 7);
        }
        if (StringUtil.isNotEmpty((CharSequence)minDate)) {
            minyear = minDate.substring(0, 4);
            minmonth = minDate.substring(5, 7);
        }
        param.put("maxyear", maxyear);
        param.put("maxmonth", maxmonth);
        param.put("minyear", minyear);
        param.put("minmonth", minmonth);
        param.put("minskssqq", minskssqq);
        param.put("maxskssqz", maxskssqz);
    }

    private void getYhsjz(String declareMonth, Map<String, String> param) {
        if (StringUtils.isNotEmpty((CharSequence)declareMonth)) {
            QFilter qFilter = new QFilter("number", "in", (Object)"YHSJZ").and(new QFilter("entryentity.startdate", "<=", (Object)DateUtils.stringToDate((String)declareMonth, (String)"yyyy-MM-dd"))).and(new QFilter("entryentity.enddate", ">=", (Object)DateUtils.stringToDate((String)declareMonth, (String)"yyyy-MM-dd")));
            DynamicObject assistObj = QueryServiceHelper.queryOne((String)"tpo_tcvat_assist", (String)"entryentity.fvalue1", (QFilter[])new QFilter[]{qFilter});
            if (assistObj != null) {
                param.put("yhsjz", assistObj.getString("entryentity.fvalue1"));
            }
        }
    }
}

