/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.draft;

import java.util.HashMap;
import java.util.Map;
import kd.taxc.tcret.business.declare.engine.EngineService;
import kd.taxc.tcret.business.declare.engine.impl.AbstractEngine;
import kd.taxc.tcret.business.declare.engine.impl.CcsEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.FcsHireEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.FcsPriceEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.FcsTdsEngineServiceImpl;
import kd.taxc.tcret.business.declare.provider.ServiceProvider;
import kd.taxc.tcret.business.declare.provider.impl.CcsServiceProvider;
import kd.taxc.tcret.business.declare.provider.impl.FcsServiceProvider;
import kd.taxc.tcret.common.constant.TcretDraftConstant;

public class DraftCalculateServiceFactory
implements TcretDraftConstant {
    private static Map<String, AbstractEngine> serviceMap = new HashMap<String, AbstractEngine>();
    private static Map<String, EngineService> engineServiceMap = new HashMap<String, EngineService>();
    private static Map<String, ServiceProvider> providerServiceMap = new HashMap<String, ServiceProvider>();

    public static AbstractEngine getService(String category) {
        return serviceMap.get(category);
    }

    public static EngineService getEngineService(String category) {
        return engineServiceMap.get(category);
    }

    public static ServiceProvider getProviderServiceMap(String category) {
        return providerServiceMap.get(category);
    }

    static {
        serviceMap.put("tcret_fcscj_taxdraft", new FcsPriceEngineServiceImpl());
        serviceMap.put("tcret_fcscz_taxdraft", new FcsHireEngineServiceImpl());
        serviceMap.put("tcret_cztds_taxdraft", new FcsTdsEngineServiceImpl());
        engineServiceMap.put("tcret_fcscj_taxdraft", new FcsPriceEngineServiceImpl());
        engineServiceMap.put("tcret_fcscz_taxdraft", new FcsHireEngineServiceImpl());
        engineServiceMap.put("tcret_cztds_taxdraft", new FcsTdsEngineServiceImpl());
        engineServiceMap.put("tcret_ccs_taxdraft", new CcsEngineServiceImpl());
        providerServiceMap.put("tcret_fcscj_taxdraft", new FcsServiceProvider());
        providerServiceMap.put("tcret_fcscz_taxdraft", new FcsServiceProvider());
        providerServiceMap.put("tcret_cztds_taxdraft", new FcsServiceProvider());
        providerServiceMap.put("tcret_ccs_taxdraft", new CcsServiceProvider());
    }
}

