/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.tcret.common.utils.EngineUtils;

public class HouseRentServiceHelper {
    public static Map<Long, List<DynamicObject>> fetchRules(List<Object> houseRentalIds, Long orgId) {
        QFilter q1 = new QFilter("leasecontractno", "in", houseRentalIds);
        QFilter q2 = new QFilter("enable", "=", (Object)"1");
        Map<Long, List<DynamicObject>> shareLeaseRulesMap = HouseRentServiceHelper.getShareRule(houseRentalIds, orgId);
        List ruleIds = QueryServiceHelper.queryPrimaryKeys((String)"tcret_rule_fcczzj", (QFilter[])new QFilter[]{q1, q2}, null, (int)-1);
        DynamicObject[] rules = BusinessDataServiceHelper.load((Object[])ruleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcret_rule_fcczzj"));
        Map<Long, List<DynamicObject>> leaseRulesMap = Arrays.stream(rules).collect(Collectors.groupingBy(rule -> rule.getDynamicObject("leasecontractno").getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : shareLeaseRulesMap.entrySet()) {
            if (leaseRulesMap.containsKey(entry.getKey())) {
                leaseRulesMap.get(entry.getKey()).addAll((Collection<DynamicObject>)entry.getValue());
                continue;
            }
            leaseRulesMap.put(entry.getKey(), entry.getValue());
        }
        return leaseRulesMap;
    }

    private static Map<Long, List<DynamicObject>> getShareRule(List<Object> houseRentalIds, Long orgId) {
        QFilter sharingorg = new QFilter("orgentity.orgid", "=", (Object)orgId);
        QFilter sharingLease = new QFilter("leaseentity.leaseid", "in", houseRentalIds);
        DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tcret_sharingscheme", (String)"orgentity.orgid as orgid,ruleentity.ruleid as ruleid, ruleentity.type as type, leaseentity.leaseid as leaseid", (QFilter[])new QFilter[]{sharingorg, sharingLease});
        Map<Long, List<DynamicObject>> leaseidMap = sharingRules.stream().collect(Collectors.groupingBy(rule -> rule.getLong("leaseid")));
        HashMap<Long, List<DynamicObject>> leaseRulesMap = new HashMap<Long, List<DynamicObject>>(leaseidMap.size());
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        for (Map.Entry<Long, List<DynamicObject>> entry : leaseidMap.entrySet()) {
            QFilter ids = new QFilter("id", "in", (Object)entry.getValue().stream().map(rule -> rule.getLong("ruleid")).toArray());
            List ruleIds = QueryServiceHelper.queryPrimaryKeys((String)"tcret_rule_fcczzj", (QFilter[])new QFilter[]{ids, enable}, null, (int)-1);
            DynamicObject[] shareRules = BusinessDataServiceHelper.load((Object[])ruleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcret_rule_fcczzj"));
            leaseRulesMap.put(entry.getKey(), Arrays.asList(shareRules));
        }
        return leaseRulesMap;
    }

    public static int getGatherStatus(Map<Long, List<DynamicObject>> rulesMap, Long houseRentalId, Date startdate, Date enddate) {
        QFilter q1 = new QFilter("id", "=", (Object)houseRentalId);
        QFilter q2 = new QFilter("rententryentity.startdate", "<=", (Object)startdate).and("rententryentity.enddate", ">=", (Object)startdate);
        QFilter q3 = new QFilter("rententryentity.startdate", "<=", (Object)enddate).and("rententryentity.enddate", ">=", (Object)enddate);
        QFilter q4 = new QFilter("rententryentity.startdate", ">=", (Object)startdate).and("rententryentity.enddate", "<=", (Object)enddate);
        boolean isexist = QueryServiceHelper.exists((String)"tdm_house_rental_info", (QFilter[])new QFilter[]{q1.and(q2.or(q3).or(q4))});
        if (isexist) {
            return 2;
        }
        if (rulesMap != null && rulesMap.get(houseRentalId) == null) {
            return 1;
        }
        return 0;
    }

    public static void gatherHouseRent(String orgId, String skssqq, String skssqz, Long taxauthority) {
        EngineModel engineModel = new EngineModel(orgId, skssqq, skssqz);
        engineModel.getCustom().put("FromClass", "HouseRentAutoCollect");
        engineModel.getCustom().put("OrgRelation", Collections.singletonList(Long.parseLong(orgId)));
        engineModel.getCustom().put("taxauthority", taxauthority);
        EngineUtils.execute(Collections.singletonList(engineModel));
    }
}

