/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.account.PrePayAccountServiceHepler;
import kd.taxc.tcret.common.enums.YhsPrepayTypeEnum;
import kd.taxc.tcret.common.utils.EngineUtils;
import kd.taxc.tcret.common.utils.YhsUtils;
import org.apache.commons.lang.StringUtils;

public class YhsAccountServiceHelper {
    private static final String TCSD_RULE_YSHTPZ = "tcsd_rule_yshtpz";
    private static final String TCSD_RULE_CQZYSJ = "tcsd_rule_cqzysj";
    private static final String TCSD_RULE_ZJZB = "tcsd_rule_zjzb";
    private static final String TCRET_YHS_TAX_ACCOUNT = "tcret_yhs_tax_account";
    private static final String TCRET_YSH_TAX_SOURCE_DE = "tcret_ysh_tax_source_de";
    private static final String TAX_SOURCE_YHSSM = "tcret_tax_source_yhssm";
    private static final String EFFECTIVEDATE = "effectivedate";
    private static final String EXPIRYDATE = "expirydate";
    private static final String GATHERNUMBER = "gathernumber";
    private static final List<String> taxitemList = new ArrayList<String>(10);
    private static final HashMap<String, String> ruleTypeMap = new HashMap();

    public static void createAccount(Long orgId, Date skssqq, Date skssqz) {
        HashMap<String, Map<String, String>> extendMap = new HashMap<String, Map<String, String>>();
        List<DynamicObject> fitTaxItem = YhsAccountServiceHelper.findFitTaxItem(orgId, skssqq, skssqz);
        List<DynamicObject> fitCollectTaxItem = YhsAccountServiceHelper.findFitCollectTaxItem(fitTaxItem, Lists.newArrayList((Object[])new Long[]{orgId}), skssqq, skssqz, extendMap);
        try (TXHandle h = TX.requiresNew();){
            try {
                String gathernumber = UUID.randomUUID();
                YhsAccountServiceHelper.saveFitTaxItems(fitCollectTaxItem, gathernumber, orgId, skssqq, skssqz, extendMap);
                YhsAccountServiceHelper.runEngine(gathernumber);
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
    }

    public static void createAccount(DynamicObjectCollection entryEntity, String gathernumber) {
        YhsAccountServiceHelper.deleteUncheckedSm(entryEntity, gathernumber);
        YhsAccountServiceHelper.runEngine(gathernumber);
    }

    private static List<DynamicObject> findFitTaxItem(Long orgId, Date skssqq, Date skssqz) {
        TaxResult taxResult;
        Boolean yhsEnable = (Boolean)TaxcMainDataServiceHelper.isTaxcMainYhsEnableByOrgId((Long)orgId).getData();
        if (yhsEnable.booleanValue() && (taxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(orgId))).isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            String taxLimit = DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz);
            DynamicObject taxMain = (DynamicObject)((List)taxResult.getData()).get(0);
            return taxMain.getDynamicObjectCollection("yhsentity").stream().filter(a -> {
                boolean validate = YhsUtils.isValidate(a, skssqq, skssqz, null, taxLimit);
                return validate && !Lists.newArrayList((Object[])new String[]{"013", "014"}).contains(a.getString("taxrate.number"));
            }).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>();
    }

    private static void saveFitTaxItems(List<DynamicObject> fitTaxItem, String gathernumber, Long orgId, Date skssqq, Date skssqz, Map<String, Map<String, String>> extendMap) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter(EFFECTIVEDATE, "=", (Object)skssqq);
        QFilter q3 = new QFilter(EXPIRYDATE, "=", (Object)skssqz);
        DeleteServiceHelper.delete((String)TAX_SOURCE_YHSSM, (QFilter[])new QFilter[]{q1, q2, q3});
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(fitTaxItem.size());
        Date now = new Date();
        for (DynamicObject object : fitTaxItem) {
            DynamicObject taxItem = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TAX_SOURCE_YHSSM));
            taxItem.set("taxitem", object.get("taxrate.id"));
            taxItem.set("declaretype", object.get("declaretype"));
            taxItem.set("taxlimit", object.get("period"));
            taxItem.set("isverify", object.get("isverify"));
            taxItem.set("hdrate", object.get("hdrate"));
            taxItem.set(EFFECTIVEDATE, extendMap.get(object.getString("id")).get("paytype").equals("bdjn") ? skssqq : object.get(EFFECTIVEDATE));
            taxItem.set(EXPIRYDATE, extendMap.get(object.getString("id")).get("paytype").equals("bdjn") ? skssqz : object.get(EXPIRYDATE));
            taxItem.set(GATHERNUMBER, (Object)gathernumber);
            taxItem.set("createtime", (Object)now);
            DynamicObject taxMain = (DynamicObject)object.getParent();
            taxItem.set("org", taxMain.get("taxorg.id"));
            taxItem.set("taxoffice", (Object)extendMap.get(object.getString("id")).get("taxoffice"));
            taxItem.set("paytype", (Object)extendMap.get(object.getString("id")).get("paytype"));
            arrayList.add(taxItem);
        }
        SaveServiceHelper.save((DynamicObject[])arrayList.toArray(new DynamicObject[0]));
    }

    private static void runEngine(String gathernumber) {
        QFilter qFilter = new QFilter(GATHERNUMBER, "=", (Object)gathernumber);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TAX_SOURCE_YHSSM, (String)"org.id as orgid,taxitem.id as taxitem,taxitem.taxrate as taxrate,taxitem.number as tnumber,declaretype,isverify,effectivedate,expirydate,taxlimit,hdrate,gathernumber,taxoffice,paytype", (QFilter[])qFilter.toArray());
        if (query.size() > 0) {
            DynamicObjectCollection queryprepay = query.stream().filter(s -> SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"prepay", (long)s.getLong("orgid")) && taxitemList.contains(s.get("tnumber").toString()) && s.getString("paytype").equals("ydjn")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            PrePayAccountServiceHepler.runEngine(queryprepay, gathernumber);
            query.removeAll((Collection)queryprepay);
            Map<String, List<DynamicObject>> collect = query.stream().collect(Collectors.groupingBy(a -> StringUtil.join((Object[])new String[]{String.valueOf(a.getLong("orgid")), DateUtils.format((Date)a.getDate(EFFECTIVEDATE)), DateUtils.format((Date)a.getDate(EXPIRYDATE))})));
            ArrayList<EngineModel> engineModels = new ArrayList<EngineModel>(collect.size());
            for (Map.Entry<String, List<DynamicObject>> entry : collect.entrySet()) {
                DynamicObject object = entry.getValue().get(0);
                EngineModel engineModel = new EngineModel(String.valueOf(object.getLong("orgid")), DateUtils.format((Date)object.getDate(EFFECTIVEDATE)), DateUtils.format((Date)object.getDate(EXPIRYDATE)));
                engineModel.getCustom().put("validcard", entry.getValue());
                engineModel.getCustom().put(GATHERNUMBER, gathernumber);
                Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(Collections.singletonList(object.getLong("orgid")), (Date)object.getDate(EFFECTIVEDATE), (Date)object.getDate(EXPIRYDATE));
                engineModel.addCustom("OrgRelationMap", (Object)orgRelationMap);
                engineModels.add(engineModel);
            }
            EngineUtils.execute(engineModels);
        }
    }

    private static void deleteUncheckedSm(DynamicObjectCollection entryEntity, String gathernumber) {
        QFilter qFilter = new QFilter(GATHERNUMBER, "=", (Object)gathernumber);
        entryEntity.stream().filter(a -> !a.getBoolean("getconfirm")).forEach(a -> {
            QFilter qFilter1 = new QFilter("org", "=", (Object)a.getLong("taxorg.id"));
            QFilter qFilter2 = new QFilter("taxlimit", "=", (Object)a.getString("taxlimit"));
            QFilter qFilter3 = new QFilter(EFFECTIVEDATE, "=", (Object)a.getDate("skssqq"));
            QFilter qFilter4 = new QFilter(EXPIRYDATE, "=", (Object)a.getDate("skssqz"));
            QFilter qFilter5 = new QFilter("taxitem", "=", a.get("taxitem.id"));
            QFilter qFilter6 = new QFilter("taxoffice", "=", a.get("taxoffice.id"));
            QFilter qFilter7 = new QFilter("paytype", "=", (Object)a.getString("paytype"));
            DeleteServiceHelper.delete((String)TAX_SOURCE_YHSSM, (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3, qFilter4, qFilter5, qFilter6, qFilter7});
        });
    }

    public static DynamicObjectCollection queryYhsTaxAccountIds(Long orgId, Date skssqq, Date skssqz, String declaretype) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)skssqz));
        QFilter declaretypeFilter = new QFilter("declaretype", "=", (Object)declaretype);
        QFilter typeFilter = new QFilter("datasource", "=", (Object)"system");
        return QueryServiceHelper.query((String)TCRET_YHS_TAX_ACCOUNT, (String)"id", (QFilter[])new QFilter[]{orgFilter, dateFilter, declaretypeFilter, typeFilter});
    }

    public static DynamicObject queryYhsAccountDetails(String serialno, String orgId, String skssqq, String skssqz) {
        String selectProperties = "id,org,taxorg,taxaccountserialno,skssqq,skssqz,adjustamount,totalamount,tzsm,prepayitem,amount";
        List<QFilter> filters = YhsAccountServiceHelper.buildQFilterList(serialno, orgId, skssqq, skssqz);
        return QueryServiceHelper.queryOne((String)"tcret_yhs_prepay_deta", (String)selectProperties, (QFilter[])filters.toArray(new QFilter[0]));
    }

    private static List<QFilter> buildQFilterList(String serialno, String orgId, String skssqq, String skssqz) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (EmptyCheckUtils.isNotEmpty((Object)orgId)) {
            QFilter orgFilter = new QFilter("taxorg", "=", (Object)Long.parseLong(orgId));
            filters.add(orgFilter);
        }
        QFilter startFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq));
        filters.add(startFilter);
        QFilter endFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz));
        filters.add(endFilter);
        QFilter serialnoFilter = new QFilter("taxaccountserialno", "=", (Object)serialno);
        filters.add(serialnoFilter);
        return filters;
    }

    public static void PrepayAccountCalculate(DynamicObject object, String gathernumber, DynamicObjectCollection prepayAccount, DynamicObject mappingObject) {
        ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>(prepayAccount.size());
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(prepayAccount.size());
        ArrayList<DynamicObject> prepayDetailList = new ArrayList<DynamicObject>(1);
        List<String> declareserialnoList = prepayAccount.stream().map(a -> a.getString("declareserialno")).collect(Collectors.toList());
        long id = DBUtils.getLongId((String)TCRET_YHS_TAX_ACCOUNT);
        DynamicObject summary = YhsAccountServiceHelper.getSummaryObject(id, object, gathernumber, mappingObject);
        YhsAccountServiceHelper.setPrepayDetailList(object.getLong("orgid"), object.getDate(EFFECTIVEDATE), object.getDate(EXPIRYDATE), prepayDetailList, declareserialnoList, id, prepayAccount, summary);
        summary.set("taxoffice", object.get("taxoffice"));
        BigDecimal totalTaxableitem = BigDecimalUtil.sumDynamicObjectAmount(prepayDetailList, (String)"amount");
        summary.set("calctaxamount", (Object)totalTaxableitem);
        summaryAccountingList.addAll(prepayDetailList);
        summaryList.add(summary);
        SaveServiceHelper.save((DynamicObject[])summaryAccountingList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
    }

    public static void setPrepayDetailList(Long rootOrgId, Date startDate, Date endDate, List<DynamicObject> summaryAccountingList, List<String> declareserialnoList, long id, DynamicObjectCollection prepayAccount, DynamicObject summary) {
        DynamicObject prepayDeclare;
        DynamicObjectCollection prepayDeclareQuery = QueryServiceHelper.query((String)"tcvat_prepay_declare_bill", (String)"sbbid,modifytime,declareserialno", (QFilter[])new QFilter[]{new QFilter("declareserialno", "in", declareserialnoList)});
        List sbbidList = prepayDeclareQuery.stream().map(p -> p.getString("sbbid")).collect(Collectors.toList());
        List modifytimeList = prepayDeclareQuery.stream().sorted(Comparator.comparing(s -> s.getDate("modifytime"))).collect(Collectors.toList());
        Optional<DynamicObject> first = prepayAccount.stream().filter(s -> s.get("declareserialno").equals(((DynamicObject)modifytimeList.get(0)).get("declareserialno")) && s.get("entryentity.taxtype").equals(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"YhsAccountServiceHelper_0", (String)"taxc-tcret", (Object[])new Object[0]))).findFirst();
        if (first.isPresent()) {
            String taxrate = first.get().getString("entryentity.prepayrate");
            if (taxrate.contains("%")) {
                BigDecimal taxrateBigDecimal = new BigDecimal(taxrate.replace("%", ""));
                taxrateBigDecimal = taxrateBigDecimal.multiply(BigDecimal.valueOf(10L));
                taxrate = taxrateBigDecimal.toString() + "\u2030";
            }
            summary.set("taxrate", (Object)taxrate);
        }
        if (null != (prepayDeclare = QueryServiceHelper.queryOne((String)"tcvat_prepay", (String)"sum(sale) as amount", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbidList), new QFilter("ewblxh", "=", (Object)YhsPrepayTypeEnum.getRowkeyByType(((DynamicObject)prepayAccount.get(0)).get("prepaytype").toString()))}))) {
            DynamicObject detailObject = BusinessDataServiceHelper.newDynamicObject((String)"tcret_yhs_prepay_deta");
            detailObject.set("id", (Object)id);
            detailObject.set("taxaccountserialno", (Object)String.valueOf(id));
            detailObject.set("org", (Object)rootOrgId);
            detailObject.set("skssqq", (Object)startDate);
            detailObject.set("skssqz", (Object)endDate);
            detailObject.set("taxorg", (Object)rootOrgId);
            detailObject.set("amount", (Object)prepayDeclare.getBigDecimal("amount"));
            detailObject.set("prepayitem", (Object)YhsPrepayTypeEnum.getItemByType(((DynamicObject)prepayAccount.get(0)).get("prepaytype").toString()));
            summaryAccountingList.add(detailObject);
        }
    }

    public static DynamicObject getSummaryObject(long id, DynamicObject object, String gathernumber, DynamicObject mappingObject) {
        DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)TCRET_YHS_TAX_ACCOUNT);
        summary.set("id", (Object)id);
        summary.set("org", object.get("orgid"));
        summary.set("skssqq", (Object)object.getDate(EFFECTIVEDATE));
        summary.set("skssqz", (Object)object.getDate(EXPIRYDATE));
        summary.set("taxitem", object.get("taxitem"));
        summary.set("billstatus", (Object)"A");
        summary.set("declaretype", object.get("declaretype"));
        summary.set("datasource", (Object)"prepay");
        summary.set("taxlimit", object.get("taxlimit"));
        summary.set("createtime", (Object)new Date());
        summary.set(GATHERNUMBER, (Object)gathernumber);
        summary.set("taxation", (Object)(object.getBoolean("isverify") ? "hdzs" : "aqhz"));
        summary.set("verifyrate", object.get("hdrate"));
        String taxrate = object.getString("taxrate");
        if (object.get("tnumber").equals("02001")) {
            taxrate = mappingObject.getString("entryentity.subitem.value");
        }
        summary.set("taxrate", (Object)taxrate);
        summary.set("subtaxitem", (Object)mappingObject.getLong("entryentity.subitem"));
        summary.set("paytype", (Object)"ydjn");
        return summary;
    }

    public static List<DynamicObject> findFitCollectTaxItem(List<DynamicObject> fitTaxItem, List<Long> orgIds, Date skssqq, Date skssqz, Map<String, Map<String, String>> extendMap) {
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        Map<Long, Map<String, Boolean>> orgprepaymap = YhsAccountServiceHelper.createOrgPrepayMap(orgIds);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tcret_taxitem_mapping", (String)"entryentity.precollectitem,entryentity.taxitem.number,entryentity.subitem,orgentryentity.orgid", (QFilter[])new QFilter[]{new QFilter("orgentryentity.orgid", "in", orgIds), new QFilter("enable", "=", (Object)"1")});
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> removeList = new ArrayList<DynamicObject>();
        for (DynamicObject object : fitTaxItem) {
            Optional<DynamicObject> generalOption;
            DynamicObject taxMain = (DynamicObject)object.getParent();
            Long orgId = taxMain.getLong("taxorg.id");
            String taxofficeId = taxMain.getString("taxoffice.id");
            paramMap.put("taxoffice", taxofficeId);
            paramMap.put("paytype", "bdjn");
            extendMap.put(object.getString("id"), paramMap);
            Boolean isprepay = orgprepaymap.get(orgId).get(orgId.toString());
            if (!isprepay.booleanValue() || !orgprepaymap.get(orgId).containsKey(object.getString("taxrate.number")) || !orgprepaymap.get(orgId).get(object.getString("taxrate.number")).booleanValue() || !(generalOption = dynamicObjectCollection.stream().filter(a -> a.getLong("orgentryentity.orgid") == orgId.longValue() && a.get("entryentity.taxitem.number").equals(object.getString("taxrate.number"))).findFirst()).isPresent()) continue;
            String precollectitem = generalOption.get().getString("entryentity.precollectitem");
            List<String> prepaytype = YhsPrepayTypeEnum.getTypeByItem(precollectitem);
            if (skssqq == null || skssqz == null) {
                skssqq = object.getDate(EFFECTIVEDATE);
                skssqz = object.getDate(EXPIRYDATE);
            }
            YhsAccountServiceHelper.queryPrepay(orgId, skssqq, skssqz, prepaytype, object, newList, removeList, extendMap);
        }
        fitTaxItem.removeAll(removeList);
        fitTaxItem.addAll(newList);
        return fitTaxItem;
    }

    public static void queryPrepay(Long orgid, Date skssqq, Date skssqz, List<String> prepaytype, DynamicObject object, List<DynamicObject> newList, List<DynamicObject> removeList, Map<String, Map<String, String>> extendMap) {
        List declareserialnoList;
        QFilter accountFilter;
        DynamicObjectCollection prepayAccount;
        List monthBetween = DateUtils.getMonthBetween((Date)skssqq, (Date)skssqz, (String)"yyyy-MM-dd");
        List<Date> monthList = monthBetween.stream().map(m -> DateUtils.stringToDate((String)m)).collect(Collectors.toList());
        QFilter filter = new QFilter("org", "=", (Object)orgid).and(new QFilter("billstatus", "=", (Object)"C"));
        QFilter timefilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        monthList.forEach(s -> timefilter.or(new QFilter("skssqq", "=", s).and(new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)s)))));
        DynamicObjectCollection prepayDeclareQuery = QueryServiceHelper.query((String)"tcvat_prepay_declare_bill", (String)"sbbid,declareserialno", (QFilter[])new QFilter[]{filter, timefilter});
        if (prepayDeclareQuery != null && prepayDeclareQuery.size() > 0 && (prepayAccount = QueryServiceHelper.query((String)"tcvat_project_account", (String)"orgid,taxoffice,prepaytype,declareserialno,startdate,enddate", (QFilter[])new QFilter[]{accountFilter = new QFilter("orgid", "=", (Object)orgid).and(new QFilter("declareserialno", "in", declareserialnoList = prepayDeclareQuery.stream().map(p -> p.getString("declareserialno")).collect(Collectors.toList()))).and(new QFilter("prepaytype", "in", prepaytype)).and(new QFilter("entryentity.taxtype", "=", (Object)ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"YhsAccountServiceHelper_0", (String)"taxc-tcret", (Object[])new Object[0])))})) != null && prepayAccount.size() > 0) {
            Map<String, List<DynamicObject>> accountGroupByMap = prepayAccount.stream().collect(Collectors.groupingBy(p -> p.getString("taxoffice")));
            YhsAccountServiceHelper.generateTaxitem(accountGroupByMap, skssqq, skssqz, object, newList, extendMap);
        }
    }

    private static void generateTaxitem(Map<String, List<DynamicObject>> accountGroupByMap, Date skssqq, Date skssqz, DynamicObject object, List<DynamicObject> newList, Map<String, Map<String, String>> extendMap) {
        for (List<DynamicObject> accountList : accountGroupByMap.values()) {
            DynamicObject dynamicObject = new DynamicObject(object.getDynamicObjectType());
            DynamicObject taxMain = (DynamicObject)object.getParent();
            long id = DBUtils.getLongId((String)TAX_SOURCE_YHSSM);
            dynamicObject.setParent(object.getParent());
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("isverify", object.get("isverify"));
            dynamicObject.set(EFFECTIVEDATE, (Object)skssqq);
            dynamicObject.set(EXPIRYDATE, (Object)skssqz);
            dynamicObject.set("taxrate", object.get("taxrate"));
            dynamicObject.set("taxrate.number", object.get("taxrate.number"));
            dynamicObject.set("taxrate.name", object.get("taxrate.name"));
            dynamicObject.set("declaretype", object.get("declaretype"));
            dynamicObject.set("period", object.get("period"));
            dynamicObject.set("hdstartdate", object.get("hdstartdate"));
            dynamicObject.set("hdenddate", object.get("hdenddate"));
            dynamicObject.set("hdrate", object.get("hdrate"));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("taxoffice", accountList.get(0).getString("taxoffice"));
            paramMap.put("paytype", "ydjn");
            extendMap.put(String.valueOf(id), paramMap);
            newList.add(dynamicObject);
        }
    }

    public static Map<Long, Map<String, Boolean>> createOrgPrepayMap(List<Long> ids) {
        HashMap<Long, Map<String, Boolean>> orgprepaymap = new HashMap<Long, Map<String, Boolean>>(ids.size());
        for (Long id : ids) {
            HashMap<String, Boolean> prepaymap = new HashMap<String, Boolean>(4);
            prepaymap.put(id.toString(), SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"prepay", (long)id));
            prepaymap.put("02001", SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"titletransfer", (long)id));
            prepaymap.put("01005", SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"construction", (long)id));
            prepaymap.put("01008", SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"hire", (long)id));
            orgprepaymap.put(id, prepaymap);
        }
        return orgprepaymap;
    }

    public static boolean verifyTaxoffice(Object org, Object taxoffice) {
        if (org == null || taxoffice == null) {
            return false;
        }
        DynamicObject result = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)((DynamicObject)org).getLong("id")).getData();
        if (result != null) {
            return result.getLong("taxoffice.id") == ((DynamicObject)taxoffice).getLong("id");
        }
        return false;
    }

    public static DynamicObject createTaxAccountDynamicObject(EngineModel engineModel, DynamicObject rule, DynamicObject yhsCardItem, String serialNo, BigDecimal calctaxamount) {
        DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCRET_YHS_TAX_ACCOUNT));
        summary.set("serialno", (Object)serialNo);
        summary.set("org", (Object)engineModel.getOrgId());
        summary.set("taxitem", (Object)yhsCardItem.getLong("taxitem"));
        String ruleEntityName = rule.getDataEntityType().getName();
        if (TCSD_RULE_CQZYSJ.equals(ruleEntityName) || TCSD_RULE_YSHTPZ.equals(ruleEntityName)) {
            summary.set("subtaxitem", rule.get("subtaxitem"));
        }
        summary.set("skssqq", (Object)DateUtils.stringToDate((String)engineModel.getStartDate()));
        summary.set("skssqz", (Object)DateUtils.stringToDate((String)engineModel.getEndDate()));
        summary.set("billstatus", (Object)"A");
        summary.set("declaretype", yhsCardItem.get("declaretype"));
        String remark = rule.getString("number") + "|" + rule.getString("name");
        summary.set("remark", (Object)remark);
        summary.set("datasource", (Object)"system");
        summary.set("createtime", (Object)new Date());
        summary.set("taxlimit", yhsCardItem.get("taxlimit"));
        summary.set(GATHERNUMBER, engineModel.getCustomValue(GATHERNUMBER));
        summary.set("taxoffice", engineModel.getCustomValue("taxoffice"));
        summary.set("paytype", (Object)"bdjn");
        String billno = CodeRuleServiceHelper.getNumber((String)TCRET_YHS_TAX_ACCOUNT, (DynamicObject)summary, null);
        summary.set("billno", (Object)billno);
        DynamicObject taxitem = rule.getDynamicObject("taxitem");
        String number = taxitem.getString("number");
        String taxrate = taxitem.getString("taxrate");
        if ((TCSD_RULE_CQZYSJ.equals(ruleEntityName) || TCSD_RULE_YSHTPZ.equals(ruleEntityName)) && "02001".equals(number)) {
            DynamicObject subtaxitem = rule.getDynamicObject("subtaxitem");
            taxrate = subtaxitem.getString("value");
        }
        summary.set("taxrate", (Object)taxrate);
        summary.set("taxation", (Object)(yhsCardItem.getBoolean("isverify") ? "hdzs" : "aqhz"));
        BigDecimal hdrate = yhsCardItem.getBigDecimal("hdrate");
        summary.set("verifyrate", (Object)hdrate);
        summary.set("calctaxamount", (Object)calctaxamount.setScale(2, 4));
        summary.set("vouchernum", (Object)(calctaxamount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0));
        DynamicObject dynamicObject = null;
        if (rule.getBoolean("suitable")) {
            dynamicObject = rule.getDynamicObject("deductioncode");
        }
        summary.set("deductioncode", (Object)dynamicObject);
        return summary;
    }

    public static DynamicObject createAccountDetailDynamicObject(String entity, Map<String, Object> amountMap, String serialNo, EngineModel engineModel, Date skssqq, Date skssqz, DynamicObject rule, DynamicObject ruleSetting) {
        DynamicObject detailDynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        String ruleEntityName = rule.getDataEntityType().getName();
        detailDynamicObject.set("type", (Object)ruleTypeMap.get(ruleEntityName));
        detailDynamicObject.set("org", (Object)engineModel.getOrgId());
        detailDynamicObject.set("ruleid", (Object)String.valueOf(rule.get("id")));
        detailDynamicObject.set("serialno", (Object)serialNo);
        detailDynamicObject.set("skssqq", (Object)skssqq);
        detailDynamicObject.set("skssqz", (Object)skssqz);
        detailDynamicObject.set("taxperiod", (Object)YhsAccountServiceHelper.composeTaxPeriod(engineModel.getStartDate(), engineModel.getEndDate()));
        detailDynamicObject.set("bizname", ruleSetting.get("bizname"));
        DynamicObject table = ruleSetting.getDynamicObject("table");
        detailDynamicObject.set("table", (Object)table);
        detailDynamicObject.set("filtercondition", ruleSetting.get("filtercondition"));
        DynamicObject amountfield = ruleSetting.getDynamicObject("amountfield");
        detailDynamicObject.set("amountfield", (Object)amountfield.getLong("id"));
        boolean absolute = ruleSetting.getBoolean("absolute");
        detailDynamicObject.set("absolute", (Object)absolute);
        detailDynamicObject.set("datatype", ruleSetting.get("datatype"));
        detailDynamicObject.set("datadirection", ruleSetting.get("datadirection"));
        BigDecimal fetchamount = (BigDecimal)amountMap.get("fetchamount");
        fetchamount = absolute ? fetchamount.abs() : fetchamount;
        detailDynamicObject.set("fetchamount", (Object)fetchamount);
        String dataType = ruleSetting.getString("datatype");
        String dataDirection = ruleSetting.getString("datadirection");
        BigDecimal vatRate = ruleSetting.getBigDecimal("vatrate");
        BigDecimal amount = (BigDecimal)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleEnginService", (String)"getAmount", (Object[])new Object[]{fetchamount, dataDirection, dataType, vatRate});
        detailDynamicObject.set("amount", (Object)amount);
        detailDynamicObject.set("accountorg", amountMap.get("accountorg") != null ? amountMap.get("accountorg") : Long.valueOf(0L));
        detailDynamicObject.set("bizdimensiontype", amountMap.get("bizdimensiontype") != null ? amountMap.get("bizdimensiontype") : "");
        detailDynamicObject.set("bizdimensionname", amountMap.get("bizdimensionname") != null ? amountMap.get("bizdimensionname") : "");
        detailDynamicObject.set("bizdimensionid", amountMap.get("bizdimensionid") != null ? amountMap.get("bizdimensionid") : "");
        return detailDynamicObject;
    }

    private static String composeTaxPeriod(String startDate, String endDate) {
        String endMonth;
        String year = startDate.substring(0, 4);
        String startMonth = startDate.substring(5, 7);
        String taxPeriod = StringUtils.equals((String)startMonth, (String)(endMonth = endDate.substring(5, 7))) ? String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708", (String)"YhsAccountServiceHelper_1", (String)"taxc-tcret", (Object[])new Object[0]), year, startMonth) : String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s-%3$s\u6708", (String)"YhsAccountServiceHelper_2", (String)"taxc-tcret", (Object[])new Object[0]), year, startMonth, endMonth);
        return taxPeriod;
    }

    static {
        ruleTypeMap.put(TCSD_RULE_YSHTPZ, "1");
        ruleTypeMap.put(TCSD_RULE_CQZYSJ, "2");
        ruleTypeMap.put(TCSD_RULE_ZJZB, "3");
        taxitemList.add("01005");
        taxitemList.add("01008");
        taxitemList.add("02001");
    }
}

