/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.common.utils.YhsUtils;
import org.apache.commons.collections.CollectionUtils;

public class YhsTaxSourceServiceHelper {
    private static final String YHS_TAX_ACCOUNT = "tcret_yhs_tax_account";
    private static final String YHS_TAX_ACCOUNT_FB = "tcret_yhs_tax_account_fb";
    private static final String YHS_TAX_SOURCE_INFO = "tcret_yhs_tax_source_info";
    private static final String STRING = "-";
    private static final String HDZS = "hdzs";
    private static final String ORG = "org";
    private static final String YHS_TAX_SOURCE_INFO_FIELDS = "voucherno,isxgm,vouchername,declaretype,vouchernum,taxitem.number as taxitemnumber,taxitem.name as taxitemname,subtaxitem.number as subtaxitemnumber,subtaxitem.projectname as subtaxitemname,skssqq,skssqz,voucherdate,calctaxamount,actualsettledate,actualsettleamount,verifyrate,taxrate,ynse,deductioncode.id as deductioncodeid,deductioncode.number as deductioncode,deductioncode.name as deductioncodename,deducttax,yjse,deductioncode.secondcode as secondcode,deductioncode.secondcode as secondcodename,dfslrmc,dfslrnssbh,dfslrsjje,verifybasis";

    public static List<Map<String, Object>> getYhsTaxSourceInfoBySbbId(Long sbbId) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(8);
        if (sbbId == null || sbbId == 0L) {
            return data;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)YHS_TAX_SOURCE_INFO, (String)YHS_TAX_SOURCE_INFO_FIELDS, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)});
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return data;
        }
        Optional<DynamicObject> xgm = collection.stream().filter(c -> c.getBoolean("isxgm")).findFirst();
        List sourceList = collection.stream().filter(c -> !c.getBoolean("isxgm")).collect(Collectors.toList());
        for (DynamicObject obj : sourceList) {
            HashMap<String, Object> temp = new HashMap<String, Object>(16);
            DynamicObjectType dynamicObjectType = obj.getDynamicObjectType();
            DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
            for (IDataEntityProperty property : properties) {
                String key = property.getName();
                if (property.getPropertyType().isAssignableFrom(Timestamp.class)) {
                    temp.put(key, DateUtils.format((Date)obj.getDate(key)));
                    continue;
                }
                temp.put(key, obj.get(key));
            }
            YhsTaxSourceServiceHelper.doSetLslf(obj, temp, xgm.isPresent());
            data.add(temp);
        }
        return data;
    }

    private static void doSetLslf(DynamicObject obj, Map<String, Object> temp, boolean isXgm) {
        temp.put("lslfdeducttax", 0);
        if (!isXgm) {
            return;
        }
        BigDecimal amount = BigDecimalUtil.subtractObject((Object)obj.getBigDecimal("ynse"), (Object)obj.getBigDecimal("deducttax"), (int)2);
        BigDecimal lslfdeducttax = BigDecimalUtil.multiplyObject((Object)amount, (Object)BigDecimal.valueOf(0.5), (int)2, (int)4);
        temp.put("lslfdeducttax", lslfdeducttax);
    }

    public static List<DynamicObject> queryYhsTaxSource(Long orgId, Long taxoffice, Date declareDate) {
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>();
        if (orgId == null || taxoffice == null || declareDate == null) {
            return objectList;
        }
        boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)orgId);
        if (!zeroDeclare) {
            QFilter q1 = new QFilter("declaretype", "=", (Object)"acsb");
            QFilter q2 = new QFilter(ORG, "=", (Object)orgId);
            QFilter q3 = new QFilter("sbbid", "=", (Object)0L);
            QFilter q4 = new QFilter("skssqz", "<=", (Object)declareDate);
            QFilter q5 = new QFilter("taxoffice", "=", (Object)taxoffice);
            QFilter q6 = new QFilter("isxgm", "=", (Object)"0");
            DynamicObjectCollection objects = QueryServiceHelper.query((String)YHS_TAX_SOURCE_INFO, (String)"taxitem,subtaxitem,skssqq,skssqz,declaretype,taxation,verifybasis,ynse,deductioncode", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6});
            objectList.addAll((Collection<DynamicObject>)objects);
        }
        for (String taxLimit : TaxConstant.TAX_LIMITS) {
            Map skssqzMap = DateUtils.getSkssqzMap((Date)declareDate, (String)taxLimit);
            if (skssqzMap == null) continue;
            Date skssqq = (Date)skssqzMap.get("skssqq");
            Date skssqz = (Date)skssqzMap.get("skssqz");
            QFilter q1 = new QFilter("declaretype", "=", (Object)"aqsb");
            QFilter q2 = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)DateUtils.trunc((Date)skssqz));
            QFilter q3 = new QFilter(ORG, "=", (Object)orgId);
            QFilter q4 = new QFilter("sbbid", "=", (Object)0L);
            QFilter q5 = new QFilter("taxoffice", "=", (Object)taxoffice);
            QFilter q6 = new QFilter("isxgm", "=", (Object)"0");
            DynamicObjectCollection objects = QueryServiceHelper.query((String)YHS_TAX_SOURCE_INFO, (String)"taxitem,subtaxitem,skssqq,skssqz,declaretype,taxation,verifybasis,ynse,deductioncode", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6});
            objectList.addAll((Collection<DynamicObject>)objects);
        }
        return objectList;
    }

    public static void gatherTaxSource(Long orgId, Date skssqq, Date skssqz, List<DynamicObject> needGatherTzList, boolean override, Set<String> messages, String taxLimit) {
        Function<DynamicObject, String> function;
        QFilter qFilter1;
        QFilter qFilter = new QFilter(ORG, "=", (Object)orgId);
        if ("count".equals(taxLimit)) {
            qFilter1 = new QFilter("skssqz", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)skssqz)).and("skssqz", "<=", (Object)skssqz);
            qFilter1.and("declaretype", "=", (Object)"acsb");
            function = a -> a.getLong("taxitem.id") + STRING + a.getLong("subtaxitem.id") + STRING + a.getString("taxation") + STRING + a.getLong("deductioncode.id") + STRING + a.getString("declaretype") + STRING + a.getLong("taxoffice.id") + STRING + a.getString("paytype") + STRING + DateUtils.format((Date)a.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
        } else {
            qFilter1 = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz);
            qFilter1.and("declaretype", "=", (Object)"aqsb");
            function = a -> a.getLong("taxitem.id") + STRING + a.getLong("subtaxitem.id") + STRING + a.getString("taxation") + STRING + a.getLong("deductioncode.id") + STRING + a.getString("declaretype") + STRING + a.getLong("taxoffice.id") + STRING + a.getString("paytype");
        }
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)YHS_TAX_ACCOUNT, (String)MetadataUtil.getAllFieldToQuery((String)YHS_TAX_ACCOUNT), (QFilter[])new QFilter[]{qFilter, qFilter1});
        Map<String, List<DynamicObject>> accountGroup = Arrays.stream(accounts).collect(Collectors.groupingBy(function));
        DynamicObject[] sy = BusinessDataServiceHelper.load((String)YHS_TAX_SOURCE_INFO, (String)MetadataUtil.getAllFieldToQuery((String)YHS_TAX_SOURCE_INFO), (QFilter[])new QFilter[]{qFilter, qFilter1});
        Map<String, List<DynamicObject>> syGroup = Arrays.stream(sy).collect(Collectors.groupingBy(function));
        Map<String, String> sbbBillStatusMap = YhsUtils.getSbbBillStatus(orgId, skssqq, skssqz, taxLimit, sy);
        Function<DynamicObject, String> functiontz = "count".equals(taxLimit) ? a -> a.getLong("taxitem.id") + STRING + a.getLong("subtaxitem.id") + STRING + a.getString("taxation") + STRING + a.getLong("deductioncode.id") + STRING + a.getString("declaretype") + STRING + a.getLong("taxoffice.id") + STRING + a.getString("paytype") + STRING + a.getString("taxperiod").substring(12, 23) : function;
        Map<String, List<DynamicObject>> needGatherTzGroup = needGatherTzList.stream().filter(a -> a.getBoolean("getconfirm")).filter(a -> a.getString("taxperiod").length() >= 23).collect(Collectors.groupingBy(functiontz));
        ArrayList<DynamicObject> taxSources = new ArrayList<DynamicObject>(accountGroup.size());
        ArrayList<DynamicObject> saveAccounts = new ArrayList<DynamicObject>(accounts.length);
        try (TXHandle h = TX.requiresNew();){
            try {
                for (Map.Entry<String, List<DynamicObject>> entry : accountGroup.entrySet()) {
                    String sbbBillStatus;
                    String key = entry.getKey();
                    List<DynamicObject> accountList = entry.getValue();
                    DynamicObject object = entry.getValue().get(0);
                    if (!CollectionUtils.isEmpty(needGatherTzList) && needGatherTzGroup.get(key) == null) continue;
                    List<DynamicObject> syList = syGroup.get(key);
                    boolean isSyExist = EmptyCheckUtils.isNotEmpty(syList);
                    String mapKey = object.getString("taxitem.name") + "_" + DateUtils.format((Date)object.getDate("skssqq")) + "_" + DateUtils.format((Date)object.getDate("skssqz"));
                    if ("acsb".equals(object.get("declaretype"))) {
                        mapKey = object.getString("taxitem.name") + "_" + DateUtils.format((Date)object.getDate("skssqz")) + "_" + DateUtils.format((Date)object.getDate("skssqz"));
                    }
                    String getresult = Objects.equals("C", sbbBillStatus = sbbBillStatusMap.get(mapKey)) || Objects.equals("B", sbbBillStatus) ? "2" : (isSyExist ? "3" : "1");
                    if (!override && !"1".equals(getresult)) continue;
                    String[] split = key.split(STRING);
                    String taxitemId = split[0];
                    String subtaxitemId = split[1];
                    String taxation = split[2];
                    String deductioncodeId = split[3];
                    String declaretype = split[4];
                    String taxofficeId = split[5];
                    String paytype = split[6];
                    QFilter qFilter2 = new QFilter("taxitem.id", "=", (Object)Long.parseLong(taxitemId)).and("taxation", "=", (Object)taxation).and("deductioncode.id", "=", (Object)Long.parseLong(deductioncodeId)).and("subtaxitem.id", "=", (Object)Long.parseLong(subtaxitemId)).and("taxoffice.id", "=", (Object)Long.parseLong(taxofficeId)).and("paytype", "=", (Object)paytype).and("declaretype", "=", (Object)declaretype);
                    if ("acsb".equals(declaretype)) {
                        QFilter qFilter3 = new QFilter("skssqq", "=", (Object)accountList.get(0).getDate("skssqz")).and("skssqz", "=", (Object)accountList.get(0).getDate("skssqz"));
                        DeleteServiceHelper.delete((String)YHS_TAX_SOURCE_INFO, (QFilter[])new QFilter[]{qFilter, qFilter3, qFilter2});
                        QFilter qFilter4 = new QFilter("skssqz", "=", (Object)accountList.get(0).getDate("skssqz"));
                        DeleteServiceHelper.delete((String)YHS_TAX_ACCOUNT_FB, (QFilter[])new QFilter[]{qFilter, qFilter4, qFilter2});
                    } else if ("aqsb".equals(declaretype)) {
                        DeleteServiceHelper.delete((String)YHS_TAX_SOURCE_INFO, (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2});
                        DeleteServiceHelper.delete((String)YHS_TAX_ACCOUNT_FB, (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2});
                    }
                    DynamicObject sum = YhsTaxSourceServiceHelper.buildTaxSource(saveAccounts, orgId, skssqq, skssqz, Long.parseLong(taxitemId), taxation, deductioncodeId, declaretype, accountList, Long.parseLong(taxofficeId), paytype, messages);
                    taxSources.add(sum);
                }
                SaveServiceHelper.save((DynamicObject[])taxSources.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])saveAccounts.toArray(new DynamicObject[0]));
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
    }

    public static void gatherZeroDeclareTaxSource(long orgId, Date startDate, Date endDate) {
        ArrayList<DynamicObject> taxSources = new ArrayList<DynamicObject>();
        Map<String, DynamicObject> filterTaxSourceList = YhsTaxSourceServiceHelper.getExistsTaxSourceList(orgId, startDate, endDate);
        Boolean yhsEnable = (Boolean)TaxcMainDataServiceHelper.isTaxcMainYhsEnableByOrgId((Long)orgId).getData();
        if (yhsEnable.booleanValue()) {
            DynamicObject taxMain = (DynamicObject)((List)TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(orgId)).getData()).get(0);
            List<DynamicObject> yhsEntitys = YhsTaxSourceServiceHelper.filterYhsEntity(orgId, startDate, endDate, filterTaxSourceList);
            if (CollectionUtils.isEmpty(yhsEntitys)) {
                return;
            }
            for (DynamicObject yhsEntity : yhsEntitys) {
                DynamicObject taxSource = YhsTaxSourceServiceHelper.buildTaxSource(orgId, startDate, endDate, yhsEntity, taxMain);
                taxSources.add(taxSource);
            }
        }
        SaveServiceHelper.save((DynamicObject[])taxSources.toArray(new DynamicObject[0]));
    }

    private static DynamicObject buildTaxSource(long orgId, Date skssqq, Date skssqz, DynamicObject yhsEntity, DynamicObject taxMain) {
        DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)YHS_TAX_SOURCE_INFO));
        summary.set(ORG, (Object)orgId);
        summary.set("taxitem", (Object)yhsEntity.getDynamicObject("taxrate").getLong("id"));
        summary.set("vouchername", (Object)"");
        summary.set("taxation", (Object)(yhsEntity.getBoolean("isverify") ? HDZS : "aqhz"));
        summary.set("verifyrate", yhsEntity.get("hdrate"));
        summary.set("deductioncode", (Object)YhsTaxSourceServiceHelper.getDefaultCode(yhsEntity.getDynamicObject("taxrate")));
        summary.set("skssqq", (Object)skssqq);
        summary.set("skssqz", (Object)skssqz);
        summary.set("billstatus", (Object)"A");
        summary.set("declaretype", (Object)"aqsb");
        summary.set("datasource", (Object)"useradd");
        String billno = CodeRuleServiceHelper.getNumber((String)YHS_TAX_SOURCE_INFO, (DynamicObject)summary, null);
        summary.set("billno", (Object)billno);
        String taxLimit = DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz);
        summary.set("taxlimit", (Object)taxLimit);
        summary.set("gathernumber", (Object)"");
        summary.set("vouchernum", (Object)0);
        summary.set("yjse", (Object)0.0);
        summary.set("voucherno", (Object)"");
        summary.set("voucherdate", (Object)"");
        summary.set("calctaxamount", (Object)0.0);
        summary.set("taxoffice", (Object)taxMain.getLong("taxoffice.id"));
        summary.set("paytype", (Object)"bdjn");
        summary.set("verifybasis", (Object)BigDecimal.ZERO);
        summary.set("taxrate", (Object)YhsTaxSourceServiceHelper.getTaxrate(yhsEntity.getDynamicObject("taxrate").getLong("id")));
        summary.set("dfslrsjje", (Object)0.0);
        return summary;
    }

    private static String getTaxrate(long id) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"tctb_tcsd_taxratetree", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return object.getString("taxrate");
    }

    private static Long getDefaultCode(DynamicObject taxrate) {
        String number = taxrate.getString("number");
        if (number.equals("012")) {
            return YhsTaxSourceServiceHelper.getDeductiontype("09129906");
        }
        if (number.equals("013")) {
            return YhsTaxSourceServiceHelper.getDeductiontype("09129907");
        }
        return null;
    }

    public static Long getDeductiontype(String number) {
        QFilter idFilter = new QFilter("number", "=", (Object)number);
        DynamicObject taxdeduction = QueryServiceHelper.queryOne((String)"tpo_taxdeduction", (String)"id,deductiontype", (QFilter[])new QFilter[]{idFilter});
        if (taxdeduction != null) {
            return taxdeduction.getLong("id");
        }
        return 0L;
    }

    public static Map<String, DynamicObject> getExistsTaxSourceList(Long org, Date skssqq, Date skssqz) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
        QFilter orgIdFilter = new QFilter(ORG, "=", (Object)org);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)skssqz));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)YHS_TAX_SOURCE_INFO, (String)"taxitem.number as number,taxation", (QFilter[])new QFilter[]{orgIdFilter, dateFilter});
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            dynamicObjects.stream().forEach(s -> result.computeIfAbsent(s.getString("number") + s.getString("taxation"), v -> s));
        }
        return result;
    }

    private static List<DynamicObject> filterYhsEntity(Long orgId, Date startDate, Date endDate, Map<String, DynamicObject> filterTaxSourceList) {
        List yhsEntity = YhsUtils.queryYhsEntity(orgId, startDate, endDate, "aqsb");
        if (yhsEntity == null) {
            return new DynamicObjectCollection();
        }
        yhsEntity = (List)yhsEntity.stream().filter(s -> {
            if (filterTaxSourceList.isEmpty()) {
                return true;
            }
            String key = s.getDynamicObject("taxrate").getString("number") + (s.getBoolean("isverify") ? HDZS : "aqhz");
            return !filterTaxSourceList.containsKey(key);
        }).collect(Collectors.toCollection(DynamicObjectCollection::new));
        return yhsEntity;
    }

    private static DynamicObject buildTaxSource(List<DynamicObject> saveAccounts, Object orgId, Date skssqq, Date skssqz, Long taxitemId, String taxation, String deductioncodeId, String declaretype, List<DynamicObject> accountList, Long taxofficeId, String paytype, Set<String> messages) {
        String gathernumber = UUID.randomUUID();
        accountList.forEach(account -> saveAccounts.add(YhsTaxSourceServiceHelper.createTaxAccountFB(orgId, skssqq, skssqz, taxitemId, gathernumber, account, taxofficeId, paytype)));
        return YhsTaxSourceServiceHelper.createTaxSourceInfo(orgId, skssqq, skssqz, taxitemId, taxation, deductioncodeId, declaretype, accountList, gathernumber, taxofficeId, paytype, messages);
    }

    public static DynamicObject createTaxSourceInfo(Object orgId, Date skssqq, Date skssqz, Long taxitemId, String taxation, String deductioncodeId, String declaretype, List<DynamicObject> accountList, String gathernumber, Long taxofficeId, String paytype, Set<String> messages) {
        String taxrate;
        BigDecimal verifybasis;
        Optional<DynamicObject> voucherno;
        String taxLimit;
        DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)YHS_TAX_SOURCE_INFO));
        long id = DB.genLongId((String)YHS_TAX_SOURCE_INFO);
        summary.set("id", (Object)id);
        summary.set(ORG, orgId);
        summary.set("taxitem", (Object)taxitemId);
        if ("acsb".equals(declaretype)) {
            DynamicObject object = accountList.get(0);
            summary.set("skssqq", (Object)object.getDate("skssqz"));
            summary.set("skssqz", (Object)object.getDate("skssqz"));
            taxLimit = "single";
            summary.set("voucherdate", (Object)object.getDate("skssqz"));
        } else {
            summary.set("skssqq", (Object)skssqq);
            summary.set("skssqz", (Object)skssqz);
            taxLimit = DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz);
            Optional<DynamicObject> voucherdate = accountList.stream().filter(a -> a.getDate("voucherdate") != null).sorted(Comparator.comparing(s -> s.getDate("createtime"))).findFirst();
            if (voucherdate.isPresent()) {
                summary.set("voucherdate", (Object)voucherdate.get().getDate("voucherdate"));
            } else {
                summary.set("voucherdate", (Object)skssqz);
            }
        }
        summary.set("billstatus", (Object)"A");
        summary.set("declaretype", (Object)declaretype);
        summary.set("datasource", (Object)"fromacc");
        summary.set("taxlimit", (Object)taxLimit);
        summary.set("gathernumber", (Object)gathernumber);
        summary.set("taxation", (Object)taxation);
        summary.set("taxoffice", (Object)taxofficeId);
        summary.set("paytype", (Object)paytype);
        summary.set("vouchernum", (Object)accountList.stream().mapToLong(a -> a.getLong("vouchernum")).sum());
        summary.set("subtaxitem", accountList.get(0).get("subtaxitem"));
        summary.set("deductioncode", StringUtil.isEmpty((CharSequence)deductioncodeId) ? null : Long.valueOf(Long.parseLong(deductioncodeId)));
        BigDecimal calctaxamount = accountList.stream().map(a -> a.getBigDecimal("calctaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        String billno = CodeRuleServiceHelper.getNumber((String)YHS_TAX_SOURCE_INFO, (DynamicObject)summary, null);
        summary.set("billno", (Object)billno);
        if (calctaxamount.compareTo(BigDecimal.ZERO) < 0) {
            YhsTaxSourceServiceHelper.insertAdjustDetail(id, orgId, skssqq, skssqz, gathernumber, calctaxamount);
            calctaxamount = BigDecimal.ZERO;
            String message = String.format(ResManager.loadKDString((String)"%s\u53f0\u8d26\u6570\u636e\u5408\u8ba1\u91d1\u989d\u5b58\u5728\u8d1f\u6570\u60c5\u51b5\uff0c\u5df2\u8c03\u6574\u4e3a0\u3002", (String)"YhsTaxSourceServiceHelper_0", (String)"taxc-tcret", (Object[])new Object[0]), YhsTaxSourceServiceHelper.getOrgName((Long)orgId));
            messages.add(message);
        }
        if ((voucherno = accountList.stream().filter(a -> StringUtil.isNotEmpty((CharSequence)a.getString("voucherno"))).findFirst()).isPresent()) {
            summary.set("voucherno", (Object)voucherno.get().getString("voucherno"));
        }
        summary.set("calctaxamount", (Object)calctaxamount);
        if (Objects.equals(HDZS, taxation)) {
            BigDecimal verifyrate = accountList.get(0).getBigDecimal("verifyrate");
            summary.set("verifyrate", (Object)verifyrate);
            verifybasis = verifyrate.multiply(calctaxamount).setScale(2, 4);
        } else {
            verifybasis = calctaxamount;
        }
        summary.set("verifybasis", (Object)verifybasis);
        DynamicObject taxitem = (DynamicObject)accountList.get(0).get("taxitem");
        summary.set("vouchername", (Object)taxitem.getString("name"));
        String number = taxitem.getString("number");
        if ("02001".equals(number)) {
            DynamicObject subtaxitem = (DynamicObject)accountList.get(0).get("subtaxitem");
            taxrate = subtaxitem.getString("value");
        } else {
            taxrate = taxitem.getString("taxrate");
        }
        if ("ydjn".equals(paytype)) {
            taxrate = accountList.get(0).getString("taxrate");
        }
        summary.set("taxrate", (Object)taxrate);
        BigDecimal taxrateBigDecimal = new BigDecimal(taxrate.replace("\u2030", ""));
        if (taxrate.contains("\u2030")) {
            taxrateBigDecimal = taxrateBigDecimal.divide(BigDecimal.valueOf(1000L));
        }
        BigDecimal ynse = BigDecimalUtil.multiplyObject((Object)taxrateBigDecimal, (Object)(verifybasis == null ? BigDecimal.ZERO : verifybasis), (int)2);
        summary.set("ynse", (Object)ynse);
        if (StringUtil.isNotEmpty((CharSequence)deductioncodeId) && !Objects.equals("0", deductioncodeId)) {
            String deductiontype;
            DynamicObject deduction = (DynamicObject)accountList.get(0).get("deductioncode");
            switch (deductiontype = deduction.getString("deductiontype")) {
                case "1": {
                    summary.set("deducttax", (Object)ynse);
                    break;
                }
                case "2": {
                    summary.set("deducttax", (Object)ynse.divide(BigDecimal.valueOf(2L)).setScale(2, 4));
                }
            }
        }
        return summary;
    }

    private static void insertAdjustDetail(long id, Object orgId, Date skssqq, Date skssqz, String gathernumber, BigDecimal calctaxamount) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcret_sycj_adjust_detail"));
        dynamicObject.set(ORG, orgId);
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("skssqz", (Object)skssqz);
        dynamicObject.set("serialno", (Object)gathernumber);
        dynamicObject.set("amount", (Object)calctaxamount);
        dynamicObject.set("ruleid", (Object)id);
        dynamicObject.set("type", (Object)"tcsdtaxsource");
        dynamicObject.set("titlename", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"YhsTaxSourceServiceHelper_1", (String)"taxc-tcret", (Object[])new Object[0]));
        dynamicObject.set("adjustamount", (Object)calctaxamount.abs());
        dynamicObject.set("totalamount", (Object)BigDecimal.ZERO);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static DynamicObject createTaxAccountFB(Object orgId, Date skssqq, Date skssqz, Long taxitemId, String gathernumber, DynamicObject account, Long taxofficeId, String paytype) {
        String taxLimit;
        DynamicObject accountFb = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)YHS_TAX_ACCOUNT_FB));
        accountFb.set(ORG, orgId);
        accountFb.set("taxitem", (Object)taxitemId);
        accountFb.set("subtaxitem", account.get("subtaxitem"));
        if ("acsb".equals(account.getString("declaretype"))) {
            accountFb.set("skssqq", (Object)account.getDate("skssqq"));
            accountFb.set("skssqz", (Object)account.getDate("skssqz"));
            taxLimit = "single";
        } else {
            accountFb.set("skssqq", (Object)skssqq);
            accountFb.set("skssqz", (Object)skssqz);
            taxLimit = DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz);
        }
        accountFb.set("voucherno", account.get("voucherno"));
        accountFb.set("vouchername", account.get("vouchername"));
        accountFb.set("vouchernum", account.get("vouchernum"));
        accountFb.set("yjse", account.get("yjse"));
        accountFb.set("taxrate", account.get("taxrate"));
        accountFb.set("voucherdate", account.get("voucherdate"));
        accountFb.set("declaretype", (Object)account.getString("declaretype"));
        accountFb.set("taxlimit", (Object)taxLimit);
        accountFb.set("taxation", account.get("taxation"));
        accountFb.set("verifyrate", account.get("verifyrate"));
        accountFb.set("calctaxamount", account.get("calctaxamount"));
        accountFb.set("deductioncode", account.get("deductioncode"));
        accountFb.set("taxsourceno", (Object)gathernumber);
        accountFb.set("orignalid", account.get("id"));
        accountFb.set("createtime", (Object)new Date());
        accountFb.set("taxoffice", (Object)taxofficeId);
        accountFb.set("paytype", (Object)paytype);
        accountFb.set("accountorg", account.get("accountorg"));
        accountFb.set("bizdimensiontype", account.get("bizdimensiontype"));
        accountFb.set("bizdimensionname", account.get("bizdimensionname"));
        accountFb.set("bizdimensionid", account.get("bizdimensionid"));
        return accountFb;
    }

    private static String getOrgName(Long orgId) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            return ((DynamicObject)result.getData()).getString("orgid.name");
        }
        return "";
    }

    public static DynamicObjectCollection getTaxSource(List<Long> idList) {
        return QueryServiceHelper.query((String)YHS_TAX_SOURCE_INFO, (String)"id,org,billno,billstatus,datasource,gathernumber,declaretype", (QFilter[])new QFilter[]{new QFilter("id", "in", idList), new QFilter("datasource", "=", (Object)"fromacc")});
    }

    public static DynamicObjectCollection getAccountFb(List<Long> orgList, List<String> gathernumberList) {
        QFilter orgFilter = new QFilter(ORG, "in", orgList);
        QFilter serialnoFilter = new QFilter("taxsourceno", "in", gathernumberList);
        return QueryServiceHelper.query((String)YHS_TAX_ACCOUNT_FB, (String)"id,org,orignalid,taxsourceno", (QFilter[])new QFilter[]{orgFilter, serialnoFilter});
    }

    public static DynamicObjectCollection getAccount(List<Long> orignalidList) {
        return QueryServiceHelper.query((String)YHS_TAX_ACCOUNT, (String)"id,org,serialno", (QFilter[])new QFilter[]{new QFilter("id", "in", orignalidList), new QFilter("datasource", "=", (Object)"system")});
    }

    public static DynamicObjectCollection getAdjustDetail(List<String> serialnoList) {
        return QueryServiceHelper.query((String)"tcret_sycj_adjust_detail", (String)"id,org,serialno", (QFilter[])new QFilter[]{new QFilter("serialno", "in", serialnoList)});
    }

    public static DynamicObjectCollection getAdjustDetailBySyxxId(List<Long> ruleidList) {
        List ruleidStringList = ruleidList.stream().map(Object::toString).collect(Collectors.toList());
        QFilter qFilter = new QFilter("adjustamount", ">", (Object)0).or(new QFilter("adjustamount", "<", (Object)0));
        return QueryServiceHelper.query((String)"tcret_sycj_adjust_detail", (String)"id,org,serialno,ruleid", (QFilter[])new QFilter[]{new QFilter("ruleid", "in", ruleidStringList), qFilter});
    }

    public static DynamicObject isCheckUniqueness(DynamicObject taxitem, DynamicObject org, DynamicObject subtaxitem, Date skssqq, Date skssqz, String taxation, DynamicObject deductioncode) {
        QFilter orgFilter = new QFilter(ORG, "=", (Object)org.getLong("id"));
        QFilter taxitemFilter = new QFilter("taxitem", "=", (Object)(taxitem == null ? 0L : taxitem.getLong("id")));
        QFilter subtaxitemFilter = new QFilter("subtaxitem", "=", (Object)(subtaxitem == null ? 0L : subtaxitem.getLong("id")));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter taxationFilter = new QFilter("taxation", "=", (Object)taxation);
        QFilter deductionFilter = new QFilter("deductioncode", "=", (Object)(deductioncode == null ? 0L : deductioncode.getLong("id")));
        return QueryServiceHelper.queryOne((String)YHS_TAX_SOURCE_INFO, (String)"id", (QFilter[])new QFilter[]{orgFilter, taxitemFilter, subtaxitemFilter, skssqqFilter, skssqzFilter, taxationFilter, deductionFilter});
    }
}

