/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource.detail.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.taxsource.detail.TaxSourceDetailService;

public abstract class AbstractTaxSourceDetailServiceImpl
implements TaxSourceDetailService {
    @Override
    public Map<String, List<Map<String, Object>>> queryTaxSourceDetailBySbbId(Long sbbId) {
        return new HashMap<String, List<Map<String, Object>>>(8);
    }

    protected abstract void dealField(DynamicObject var1, Map<String, Object> var2, String var3);

    void putPropertyMap(DynamicObject obj, Map<String, Object> temp, String entityNames, String fields, String entityFields) {
        String[] entitys;
        DynamicObjectType dynamicObjectType = obj.getDynamicObjectType();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        this.putProperty(properties, temp, obj);
        this.dealField(obj, temp, fields);
        for (String entityName : entitys = entityNames.split(",")) {
            if (!obj.containsProperty(entityName)) continue;
            DynamicObjectCollection entityObjs = obj.getDynamicObjectCollection(entityName);
            ArrayList<HashMap<String, Object>> entryInfos = new ArrayList<HashMap<String, Object>>();
            for (DynamicObject entityObj : entityObjs) {
                DynamicObjectType entityObjType = entityObj.getDynamicObjectType();
                DataEntityPropertyCollection entityObjProperties = entityObjType.getProperties();
                HashMap<String, Object> entryMap = new HashMap<String, Object>(16);
                this.putProperty(entityObjProperties, entryMap, entityObj);
                this.dealField(entityObj, entryMap, entityFields);
                entryInfos.add(entryMap);
            }
            temp.put(entityName, SerializationUtils.toJsonString(entryInfos));
        }
    }

    private void putProperty(DataEntityPropertyCollection properties, Map<String, Object> temp, DynamicObject obj) {
        for (IDataEntityProperty property : properties) {
            String key = property.getName();
            if (property.getPropertyType() != null && property.getPropertyType().isAssignableFrom(Timestamp.class)) {
                temp.put(key, DateUtils.format((Date)obj.getDate(key)));
                continue;
            }
            if (property.getPropertyType() != null && property.getPropertyType().isAssignableFrom(BigDecimal.class)) {
                temp.put(key, obj.getBigDecimal(key) != null ? obj.getBigDecimal(key).toPlainString() : null);
                continue;
            }
            if (property.getPropertyType() == null || property.getPropertyType().isAssignableFrom(DynamicObject.class)) continue;
            temp.put(key, obj.get(key));
        }
    }
}

