/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource.detail.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bd.admindivision.AdminDivisionDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.taxsource.detail.impl.AbstractTaxSourceDetailServiceImpl;

public class CztdsysTaxSourceDetailServiceImpl
extends AbstractTaxSourceDetailServiceImpl {
    private static Log logger = LogFactory.getLog(CztdsysTaxSourceDetailServiceImpl.class);
    private static final String TCRET_PBT_TDS_SUM = "tcret_pbt_tds_sum";
    private static final String ENTRYENTITY = "entryentity";
    private static final String FIELDS = "sourceid.addr,taxauthority.name,sourceid.changetime";
    private static final String ENTITYFIELDS = "jmcode.name,jmcode.number,jmcode.secondcode";
    private static final String TCRET_PBT_TDS_SUM_FIELDS = "isxgm,number,parcelcode,name,fixassertnumber,sourceid.addr,detailaddr,occupylandarea,taxauthority.name,obtaintime,sourceid.obtaintime,sourceid.changetime,changedate,landlevel,taxstandard,taxbasis,currentpayable,currentjmamount,skssqq,skssqz,entryentity.jmcode,entryentity.amount,entryentity.yjmamount,entryentity.start,entryentity.end";

    @Override
    public Map<String, List<Map<String, Object>>> queryTaxSourceDetailBySbbId(Long sbbId) {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>(8);
        if (sbbId == null || sbbId == 0L) {
            return map;
        }
        DynamicObjectCollection tdsCollectionIds = QueryServiceHelper.query((String)TCRET_PBT_TDS_SUM, (String)"id", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)});
        DynamicObject[] tdsCollection = BusinessDataServiceHelper.load((Object[])tdsCollectionIds.stream().map(e -> e.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCRET_PBT_TDS_SUM));
        if (tdsCollection.length > 0) {
            List tdsDetailList = Arrays.stream(tdsCollection).filter(c -> !c.getBoolean("isxgm")).collect(Collectors.toList());
            List xgmtdsDetailList = Arrays.stream(tdsCollection).filter(c -> c.getBoolean("isxgm")).collect(Collectors.toList());
            Map<String, BigDecimal> xgmtdsDetailMap = Arrays.stream(tdsCollection).filter(c -> c.getBoolean("isxgm")).collect(Collectors.toMap(k -> k.getString("number") + DateUtils.format((Date)k.getDate("skssqq")) + DateUtils.format((Date)k.getDate("skssqz")), v -> v.getBigDecimal("currentjmamount")));
            List locationIds = tdsDetailList.stream().map(a -> a.getLong("sourceid.addr")).collect(Collectors.toList());
            Map locationMap = new HashMap();
            TaxResult taxResult = AdminDivisionDataServiceHelper.getPathNameByIds(locationIds);
            if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                locationMap = (Map)taxResult.getData();
            }
            ArrayList<HashMap<String, Object>> tdsData = new ArrayList<HashMap<String, Object>>(8);
            for (DynamicObject obj : tdsDetailList) {
                HashMap<String, Object> temp = new HashMap<String, Object>(16);
                this.putPropertyMap(obj, temp, ENTRYENTITY, FIELDS, ENTITYFIELDS);
                if (locationMap.get(obj.getLong("sourceid.addr")) != null) {
                    List list = (List)locationMap.get(obj.getLong("sourceid.addr"));
                    if (list != null) {
                        temp.put("locationxzqh", list.size() > 3 ? list.subList(0, 3).stream().collect(Collectors.joining()) : list.stream().collect(Collectors.joining()));
                        temp.put("locationscjx", list.size() > 3 ? list.get(3) : "");
                    } else {
                        temp.put("locationxzqh", "");
                        temp.put("locationscjx", "");
                    }
                }
                if (!xgmtdsDetailMap.isEmpty()) {
                    BigDecimal jmamount = obj.getBigDecimal("currentjmamount");
                    jmamount = jmamount.add(xgmtdsDetailMap.getOrDefault(obj.getString("number") + DateUtils.format((Date)obj.getDate("skssqq")) + DateUtils.format((Date)obj.getDate("skssqz")), BigDecimal.ZERO));
                    temp.put("currentjmamount", jmamount.toPlainString());
                }
                tdsData.add(temp);
            }
            map.put(TCRET_PBT_TDS_SUM, tdsData);
        }
        logger.info("\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e\u7a0e\u6e90\u660e\u7ec6\uff1a" + SerializationUtils.toJsonString(map));
        return map;
    }

    @Override
    protected void dealField(DynamicObject obj, Map<String, Object> temp, String fields) {
        String[] fieldList;
        for (String field : fieldList = fields.split(",")) {
            if ("sourceid.changetime".equals(field)) {
                temp.put(field.replace(".", ""), DateUtils.format((Date)obj.getDate(field)));
                continue;
            }
            temp.put(field.replace(".", ""), obj.getString(field));
        }
    }
}

