/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource.egine;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.taxsource.task.AccountDetailTask;

public class TdzzsYjAutoCollectEngine
implements IEngine<EngineModel> {
    private static Log logger = LogFactory.getLog(TdzzsYjAutoCollectEngine.class);
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    private static final String ORG = "org";

    public void deleteData(EngineModel model) {
        String sbbid = (String)model.getCustom().get("sbbid");
        QFilter sbbidFliter = new QFilter("sbbid", "=", (Object)Long.parseLong(sbbid));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter skssqqzFilter = new QFilter(SKSSQQ, "=", (Object)startDate).and(new QFilter(SKSSQZ, "=", (Object)endDate));
        QFilter yjxmFilter = new QFilter("yjxm", "=", model.getCustom().get("yjxm"));
        DeleteServiceHelper.delete((String)"tcret_tdzzs_yj_det_tp", (QFilter[])new QFilter[]{sbbidFliter, skssqqzFilter, yjxmFilter});
        DeleteServiceHelper.delete((String)"tcret_tdzzsyj_adjust_de_tp", (QFilter[])new QFilter[]{sbbidFliter, skssqqzFilter, yjxmFilter});
        DeleteServiceHelper.delete((String)"tcret_tdzzdyj_edit_tp", (QFilter[])new QFilter[]{sbbidFliter, skssqqzFilter, yjxmFilter});
    }

    public void runEngine(EngineModel engineModel) {
        try {
            logger.info("\u5f00\u59cb\u6267\u884c\u571f\u5730\u589e\u503c\u7a0e\u9884\u7f34\u7a0e\u6e90\u53d6\u6570\u5f15\u64ce");
            long start = System.currentTimeMillis();
            ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
            ConcurrentHashMap<String, Map<String, Object>> errorMap = new ConcurrentHashMap<String, Map<String, Object>>();
            ConcurrentHashMap<String, String> dataMap = new ConcurrentHashMap<String, String>();
            this.calSummaryAccountList(summaryAccountingList, errorMap, dataMap, engineModel);
            logger.info("\u7ed3\u675f\u571f\u5730\u589e\u503c\u7a0e\u9884\u7f34\u7a0e\u6e90\u53d6\u6570\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void calSummaryAccountList(List<DynamicObject> summaryAccountingList, Map<String, Map<String, Object>> errorMap, Map<String, String> dataMap, EngineModel engineModel) throws Exception {
        DynamicObject[] rules;
        QFilter q2 = new QFilter("enable", "=", (Object)"1");
        QFilter q3 = new QFilter("yjxm", "=", engineModel.getCustom().get("yjxm"));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tcret_lvat_rule", (String)"id", (QFilter[])new QFilter[]{q2, q3});
        List ids = query.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
        for (DynamicObject rule : rules = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcret_lvat_rule"))) {
            this.calTask(summaryAccountingList, dataMap, errorMap, rule, engineModel);
        }
        DynamicObjectCollection prepaymentinfo = engineModel.getCustom().get("prepaymentinfo") == null ? new DynamicObjectCollection() : (DynamicObjectCollection)engineModel.getCustom().get("prepaymentinfo");
        QFilter orgqFilter = new QFilter("orgentity.orgid", "=", (Object)Long.valueOf(engineModel.getOrgId()));
        QFilter prepayqFilter = new QFilter("prepayentity.prepayid", "=", engineModel.getCustom().get("yjxm"));
        for (DynamicObject dynamicObject : prepaymentinfo) {
            DynamicObject[] sharingRules;
            QFilter fclxzmqFilter = new QFilter("fclxzmentity.fclxzmid", "=", (Object)dynamicObject.getLong("subbuildingtype.id"));
            DynamicObjectCollection sharings = QueryServiceHelper.query((String)"tcret_tdzzs_share", (String)"ruleentity.ruleid as ruleid", (QFilter[])new QFilter[]{orgqFilter, prepayqFilter, fclxzmqFilter});
            List ruleIds = sharings.stream().map(s -> s.getLong("ruleid")).collect(Collectors.toList());
            for (DynamicObject rule : sharingRules = BusinessDataServiceHelper.load((Object[])ruleIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcret_lvat_rule"))) {
                rule.set("yjxm", engineModel.getCustom().get("yjxm"));
                rule.set("buildingtype", (Object)dynamicObject.getLong("buildingtype.id"));
                rule.set("subbuildingtype", (Object)dynamicObject.getLong("subbuildingtype.id"));
                this.calTask(summaryAccountingList, dataMap, errorMap, rule, engineModel);
            }
        }
        SaveServiceHelper.save((DynamicObject[])summaryAccountingList.toArray(new DynamicObject[0]));
    }

    private void calTask(List<DynamicObject> summaryAccountingList, Map<String, String> dataMap, Map<String, Map<String, Object>> errorMap, DynamicObject rule, EngineModel engineModel) throws Exception {
        String serialNo = UUID.randomUUID();
        AccountDetailTask ruleSettingTask = new AccountDetailTask(dataMap, errorMap, rule, engineModel, (DynamicObjectCollection)rule.get("entryentity"), serialNo, "tcret_tdzzs_yj_det_tp", null, rule.getDataEntityType().getName(), null, DeclareTaxType.TDZZS.getBaseTaxId(), null);
        List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
        List accountingList = EngineTask.getFutureList((List)futures);
        summaryAccountingList.addAll(accountingList);
    }
}

