/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource.fetchdata;

import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcret.common.utils.EngineUtils;

public class TdzzsSyFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    private static final String KEY_FORMAT = "%s_%s_%s";
    private static final Map<String, Long> incomeTypeMapping = new HashMap<String, Long>();

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        EngineModel engineModel = new EngineModel(bussinessParamsVo.getOrgId(), DateUtils.format((Date)bussinessParamsVo.getStartDate()), DateUtils.format((Date)bussinessParamsVo.getEndDate()));
        engineModel.getCustom().put("FromClass", "TdzzsYjAutoCollectEngine");
        List orgids = Longs.asList((long[])new long[]{Long.parseLong(bussinessParamsVo.getOrgId())});
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs((List)orgids, (Date)bussinessParamsVo.getStartDate(), (Date)bussinessParamsVo.getEndDate());
        engineModel.addCustom("OrgRelationMap", (Object)orgRelationMap);
        Map extendParams = bussinessParamsVo.getExtendParams();
        engineModel.addCustom("yjxm", (Object)Long.parseLong((String)extendParams.get("taxsourceid")));
        String taxsourceid = (String)extendParams.get("taxsourceid");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(taxsourceid), (String)"tdm_tdzzs_clearing_unit");
        DynamicObjectCollection prepaymentinfo = object.getDynamicObjectCollection("prepaymentinfo");
        engineModel.addCustom("prepaymentinfo", (Object)prepaymentinfo);
        String sbbid = String.valueOf(extendParams.get("sbbid"));
        engineModel.addCustom("sbbid", (Object)sbbid);
        EngineUtils.execute(Collections.singletonList(engineModel));
        QFilter yjxmFilter = new QFilter("yjxm", "=", (Object)Long.parseLong((String)extendParams.get("taxsourceid")));
        QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)Long.parseLong(sbbid));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcret_tdzzs_yj_det_tp", (String)"incometype,amount,buildingtype,subbuildingtype", (QFilter[])new QFilter[]{yjxmFilter, sbbIdFilter});
        Function<DynamicObject, String> function = d -> String.format(KEY_FORMAT, d.getString("incometype"), d.getString("buildingtype"), d.getString("subbuildingtype"));
        Map<String, List<DynamicObject>> detMap = dynamicObjects.stream().collect(Collectors.groupingBy(function));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(prepaymentinfo.size());
        for (DynamicObject dynamicObject : prepaymentinfo) {
            HashMap<String, Number> map = new HashMap<String, Number>(6);
            long buildingtypeId = dynamicObject.getDynamicObject("buildingtype").getLong("id");
            map.put("tcret_tdzzssy_mx#buildingtype", buildingtypeId);
            long subbuildingtypeId = dynamicObject.getDynamicObject("subbuildingtype").getLong("id");
            map.put("tcret_tdzzssy_mx#subbuildingtype", subbuildingtypeId);
            for (Map.Entry<String, Long> mapping : incomeTypeMapping.entrySet()) {
                String field = mapping.getKey();
                Long incometypeId = mapping.getValue();
                String key = String.format(KEY_FORMAT, incometypeId, buildingtypeId, subbuildingtypeId);
                map.put("tcret_tdzzssy_mx#" + field, BigDecimalUtil.sumDynamicObjectAmount(detMap.get(key), (String)"amount"));
            }
            map.put("tcret_tdzzssy_mx#yzl", dynamicObject.getBigDecimal("prelevyrate"));
            result.add(map);
        }
        return result;
    }

    static {
        incomeTypeMapping.put("hbsr", 1361447775962687488L);
        incomeTypeMapping.put("swjqtsr", 1361447775962687489L);
        incomeTypeMapping.put("stxssr", 1361447775962687490L);
    }
}

