/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.zys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleAccessConfigService;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class ZysCollectAccessConfigServiceImpl
extends AbstractRuleAccessConfigService {
    private static Log logger = LogFactory.getLog(ZysCollectAccessConfigServiceImpl.class);

    public ZysCollectAccessConfigServiceImpl() {
        this.accessConfigEntityName = "tcret_zys_rule";
        this.accessConfigSelectFields = MetadataUtil.getAllSubFieldString((String)this.accessConfigEntityName);
    }

    public List<DynamicObject> queryMatchAccessConfig(Long orgId, QFilter accessWhereFilter, QFilter sharingPlanWhereFilter) {
        ArrayList<DynamicObject> allAccessConfigList = new ArrayList<DynamicObject>();
        List<DynamicObject> privateAccessConfigList = this.queryPrivateAccessConfig(orgId, accessWhereFilter);
        allAccessConfigList.addAll(privateAccessConfigList);
        List<DynamicObject> sharingPlanList = this.querySharingPlanAccessConfig(orgId, sharingPlanWhereFilter);
        List publicAccessProjectIds = sharingPlanList.stream().map(o -> o.getLong(this.sharingPlan_Rule)).collect(Collectors.toList());
        if (ObjectUtils.isNotEmpty(publicAccessProjectIds)) {
            ArrayList publicAccessConfigList = new ArrayList();
            QFilter accessIdQ = new QFilter("id", "in", publicAccessProjectIds);
            QFilter publicFilter = new QFilter(this.accessConfig_RuleType, "=", (Object)"public");
            List list = this.buildEnableQfilter(this.accessConfigEntityName);
            list.stream().forEach(o -> accessIdQ.and(o));
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)this.accessConfigEntityName, (String)this.accessConfigSelectFields, (QFilter[])new QFilter[]{accessIdQ, publicFilter});
            if (ObjectUtils.isNotEmpty((Object)collection)) {
                Collections.addAll(publicAccessConfigList, collection);
                allAccessConfigList.addAll(publicAccessConfigList);
            }
        }
        return allAccessConfigList;
    }

    public List<DynamicObject> queryPrivateAccessConfig(Long orgId, QFilter accessWhereFilter) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        QFilter orgQ = new QFilter(this.accessConfig_Org, "=", (Object)orgId);
        QFilter privateFilter = new QFilter(this.accessConfig_RuleType, "=", (Object)"private");
        List enableQList = this.buildEnableQfilter(this.accessConfigEntityName);
        enableQList.stream().forEach(o -> accessWhereFilter.and(o));
        DynamicObject[] privateAccessConfigList = BusinessDataServiceHelper.load((String)this.accessConfigEntityName, (String)this.accessConfigSelectFields, (QFilter[])new QFilter[]{orgQ, accessWhereFilter, privateFilter});
        if (ObjectUtils.isNotEmpty((Object)privateAccessConfigList)) {
            Collections.addAll(list, privateAccessConfigList);
        }
        return list;
    }

    public List<DynamicObject> querySharingPlanAccessConfig(Long orgId, QFilter sharingPlanWhereFilter) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (StringUtil.isBlank((CharSequence)this.sharingplanEntityName)) {
            return list;
        }
        return super.querySharingPlanAccessConfig(orgId, sharingPlanWhereFilter);
    }
}

