/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.zys;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.business.rule.RuleAccessConfigService;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleEngineService;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCardDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleAccessDetailDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.zys.ZysCollectAccessConfigServiceImpl;
import org.apache.commons.lang3.ObjectUtils;

public class ZysCollectRuleEngineServiceImpl
extends AbstractRuleEngineService {
    private static Log logger = LogFactory.getLog(AbstractRuleEngineService.class);
    private Map<String, String> ITEMMAP = new HashMap<String, String>(){
        {
            this.put("entryentity", "xssl");
            this.put("entryentity1", "xse");
            this.put("entryentity2", "yzf");
            this.put("entryentity3", "gjsl");
            this.put("entryentity4", "gjje");
        }
    };

    public ZysCollectRuleEngineServiceImpl() {
        this.accessConfigEntityName = "tcret_zys_rule";
    }

    protected RuleAccessConfigService registerRuleAccessConfigService() {
        return ZysCollectRuleEngineServiceImpl.getRuleFetchBusiness();
    }

    public static RuleAccessConfigService getRuleFetchBusiness() {
        return RuleAccessConfigServiceInner.ruleFetchBusiness;
    }

    protected void saveOrDelDraftData(RuleFetchMainDto ruleFetchMainList) {
    }

    public RuleFetchMainDto businessHandler(RuleEngineParamDto engineParamDto) {
        Map orgMatchAccessConfigMap = this.getAllOrgMatchAccessConfigMap(engineParamDto);
        List allOrgAccessAmount = this.getAllOrgAccessAmount(engineParamDto, orgMatchAccessConfigMap);
        RuleFetchMainDto ruleFetchMainDto = this.handleBuildRuleFetchMainDto(engineParamDto, allOrgAccessAmount);
        if (0L == this.callRuleFetchService(ruleFetchMainDto)) {
            return new RuleFetchMainDto(engineParamDto.getTaxOrgId(), engineParamDto.getSkssqq(), engineParamDto.getSkssqz(), engineParamDto.getTemplateId());
        }
        this.saveOrDelDraftData(ruleFetchMainDto);
        return ruleFetchMainDto;
    }

    protected RuleFetchMainDto handleBuildRuleFetchMainDto(RuleEngineParamDto engineParamDto, List<Map<Long, List<Map<String, List<RuleAccessDetailDto>>>>> allOrgAccessResult) {
        logger.info("start handleBuildRuleFetchMainDto");
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(engineParamDto.getTaxOrgId(), engineParamDto.getSkssqq(), engineParamDto.getSkssqz(), engineParamDto.getTemplateId());
        Map orgAccessResult = allOrgAccessResult.stream().filter(o -> o.containsKey(engineParamDto.getTaxOrgId())).findFirst().orElseGet(() -> new HashMap());
        for (Map.Entry singleOrgAccessResult : orgAccessResult.entrySet()) {
            List allAccessConfigResultList = (List)singleOrgAccessResult.getValue();
            ArrayList ruleFetchCellSummaryList = new ArrayList();
            ruleFetchMainDto.getRuleFetchCellSummaryList().addAll(ruleFetchCellSummaryList);
            for (Map singleAccessConfigResultMap : allAccessConfigResultList) {
                singleAccessConfigResultMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(this.entryentity)).forEach(entry -> {
                    String entryName = (String)entry.getKey();
                    List accessDetailDtoList = (List)entry.getValue();
                    ArrayList<RuleFetchDetailDto> ruleFetchDetailDtoList = new ArrayList<RuleFetchDetailDto>(accessDetailDtoList.size());
                    BigDecimal sumFetchAmount = BigDecimal.ZERO;
                    BigDecimal sumOriginAmount = BigDecimal.ZERO;
                    DynamicObject accessConfigObject = null;
                    for (RuleAccessDetailDto accessDetailDto : accessDetailDtoList) {
                        if (ObjectUtils.isEmpty(accessConfigObject)) {
                            accessConfigObject = accessDetailDto.getAccessConfigObject();
                        }
                        RuleFetchDetailDto fetchDetailDto = new RuleFetchDetailDto(accessDetailDto.getSkssqq(), accessDetailDto.getSkssqz(), accessDetailDto.getBizName(), accessDetailDto.getDataSource(), accessDetailDto.getAmountField(), accessDetailDto.getFetchType(), accessDetailDto.getFetchDirection(), accessDetailDto.getFetchAmount(), accessDetailDto.getOriginAmount(), accessDetailDto.getAbsolute(), accessDetailDto.getFilterCondition());
                        ruleFetchDetailDtoList.add(fetchDetailDto);
                        sumFetchAmount = sumFetchAmount.add(accessDetailDto.getFetchAmount());
                        sumOriginAmount = sumOriginAmount.add(accessDetailDto.getOriginAmount());
                    }
                    String ruleId = "";
                    String ruleName = "";
                    String ruleitem = "";
                    if (null != accessConfigObject) {
                        ruleId = accessConfigObject.getString("id");
                        ruleName = accessConfigObject.getString("name");
                        ruleitem = accessConfigObject.getString("taxsource.id") + "_" + accessConfigObject.getString("taxitem.id") + "_" + accessConfigObject.getString("taxsubitem.id");
                    }
                    RuleFetchCardDto cardDto = new RuleFetchCardDto(ruleName, ruleId, ruleName, engineParamDto.getTaxOrgId(), sumFetchAmount);
                    cardDto.getRuleFetchDetailList().addAll(ruleFetchDetailDtoList);
                    ArrayList<RuleFetchCardDto> ruleFetchCardList = new ArrayList<RuleFetchCardDto>();
                    ruleFetchCardList.add(cardDto);
                    RuleFetchCellSummaryDto cellSummaryDto = new RuleFetchCellSummaryDto(this.accessConfigEntityName, ruleId, "nssb", this.ITEMMAP.get(entryName), sumFetchAmount, sumOriginAmount, entryName);
                    cellSummaryDto.getRuleFetchCardList().addAll(ruleFetchCardList);
                    ruleFetchCellSummaryList.add(cellSummaryDto);
                    ruleFetchMainDto.setRuleFetchCellSummaryList(ruleFetchCellSummaryList);
                });
            }
        }
        logger.info("finish handleBuildRuleFetchMainDto");
        return ruleFetchMainDto;
    }

    protected Map<String, List<RuleAccessDetailDto>> handleBuildRuleAccessDetailDto(Long orgId, RuleEngineParamDto engineParamDto, DynamicObject accessConfig) {
        HashMap<String, List<RuleAccessDetailDto>> map = new HashMap<String, List<RuleAccessDetailDto>>(1);
        Date skssqq = engineParamDto.getSkssqq();
        Date skssqz = engineParamDto.getSkssqz();
        DataEntityPropertyCollection properties = accessConfig.getDataEntityType().getProperties();
        properties.stream().forEach(property -> {
            if (property instanceof EntryProp) {
                String name = property.getName();
                String suffix = name.substring(this.entryentity.length());
                DynamicObjectCollection collection = accessConfig.getDynamicObjectCollection(name);
                ArrayList<RuleAccessDetailDto> list = new ArrayList<RuleAccessDetailDto>(8);
                IDataEntityProperty vatRateProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty(this.vatrate);
                IDataEntityProperty jsblProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty(this.jsbl);
                for (DynamicObject row : collection) {
                    String bizName = row.getString(this.bizname + suffix);
                    String amountFieldEntity = row.getDynamicObject(this.amountfield + suffix).getString("fieldsubname");
                    String amountFieldNum = row.getDynamicObject(this.amountfield + suffix).getString("fieldname");
                    Long amountFieldId = row.getDynamicObject(this.amountfield + suffix).getLong("id");
                    String dataDirection = row.getString(this.datadirection + suffix);
                    String absoluteB = row.getString(this.absolute + suffix);
                    String filterCondition = row.getString(this.filtercondition + suffix);
                    String dataType = row.getString(this.datatype + suffix);
                    Long dataSourceId = row.getDynamicObject(this.ftable + suffix).getLong("id");
                    String conditionJsonS = row.getString(this.conditionjson + suffix);
                    BigDecimal vatRate = null != vatRateProperty ? row.getBigDecimal(this.vatrate + suffix) : null;
                    BigDecimal jsBl = null != jsblProperty ? row.getBigDecimal(this.jsbl + suffix) : null;
                    RuleAccessDetailDto detailDto = new RuleAccessDetailDto(accessConfig, orgId, skssqq, skssqz, bizName, dataSourceId, amountFieldId, dataDirection, absoluteB, filterCondition, dataType, null, conditionJsonS, null, amountFieldEntity, amountFieldNum, vatRate, jsBl);
                    list.add(detailDto);
                }
                map.put(name, list);
            }
        });
        return map;
    }

    protected BigDecimal convertFetchAmount(BigDecimal originAmount, RuleAccessDetailDto detailRowDto) {
        BigDecimal resultAmount = super.convertFetchAmount(originAmount, detailRowDto);
        String datatypeS = detailRowDto.getFetchType();
        BigDecimal jsBl = detailRowDto.getJsbl();
        if (StringUtil.isNotEmpty((CharSequence)datatypeS) && null != jsBl && "gjqs".equals(datatypeS)) {
            resultAmount = resultAmount.multiply(jsBl).setScale(2, RoundingMode.HALF_UP);
        }
        return resultAmount;
    }

    private static class RuleAccessConfigServiceInner {
        private static final RuleAccessConfigService ruleFetchBusiness = new ZysCollectAccessConfigServiceImpl();

        private RuleAccessConfigServiceInner() {
        }
    }
}

