/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.enums;

import com.google.common.collect.Lists;
import java.util.List;

public enum CcsTypeEnum {
    CCSCL("ccscl", "tdm_car_tax_fund_info", "tcret_pbt_ccs_sum", Lists.newArrayList((Object[])new String[]{"10", "11", "12", "13"}), "org", "sbqx", "vehicleregdate", "vin", "platenumber"),
    CCSCB("ccscb", "tdm_ship_tax_fund_info", "tcret_pbt_ccs_sum", Lists.newArrayList((Object[])new String[]{"5", "6", "7", "8", "13"}), "orgfield", "sbyf", "ownershipdate", "shipnumber", "initregnumber");

    private String type;
    private String sourceEntity;
    private String entityName;
    private List<String> jsyj;
    private String org;
    private String sbqx;
    private String start;
    private String ccsbdm;
    private String ccpzdm;

    private CcsTypeEnum(String type, String sourceEntity, String entityName, List<String> jsyj, String org, String sbqx, String start, String ccsbdm, String ccpzdm) {
        this.type = type;
        this.sourceEntity = sourceEntity;
        this.entityName = entityName;
        this.jsyj = jsyj;
        this.org = org;
        this.sbqx = sbqx;
        this.start = start;
        this.ccsbdm = ccsbdm;
        this.ccpzdm = ccpzdm;
    }

    public String getCcsbdm() {
        return this.ccsbdm;
    }

    public String getCcpzdm() {
        return this.ccpzdm;
    }

    public String getOrg() {
        return this.org;
    }

    public String getSbqx() {
        return this.sbqx;
    }

    public String getStart() {
        return this.start;
    }

    public List<String> getJsyj() {
        return this.jsyj;
    }

    public static CcsTypeEnum getByTaxType(String taxType) {
        for (CcsTypeEnum value : CcsTypeEnum.values()) {
            if (!value.getType().equals(taxType)) continue;
            return value;
        }
        return CCSCL;
    }

    public String getType() {
        return this.type;
    }

    public String getSourceEntity() {
        return this.sourceEntity;
    }

    public String getEntityName() {
        return this.entityName;
    }
}

