/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.enums;

public enum FcsTypeEnum {
    FCS_BY_PRICE("fcscj", "tdm_fcs_basic_info", "tcret_pbt_fcs_price_sum", "taxpaylimit", "acquiredate", "changedate", 7L, "accountorg"),
    FCS_BY_HIRE("fcscz", "tdm_house_rental_info", "tcret_pbt_fcs_hire_sum", "fcsbyhirelimit", "rententryentity.startdate", "rententryentity.enddate", 7L, "accorg"),
    TDS("cztdsys", "tdm_tds_basic_info", "tcret_pbt_tds_sum", "taxtimelimit", "obtaintime", "changetime", 9L, "accountorg");

    private String type;
    private String sourceEntity;
    private String entityName;
    private String taxtimelimitKey;
    private String acquiredateKey;
    private String changedateKey;
    private Long taxCategory;
    private String accountOrg;

    private FcsTypeEnum(String type, String sourceEntity, String entityName, String taxtimelimitKey, String acquiredateKey, String changedateKey, Long taxCategory, String accountOrg) {
        this.type = type;
        this.sourceEntity = sourceEntity;
        this.entityName = entityName;
        this.taxtimelimitKey = taxtimelimitKey;
        this.acquiredateKey = acquiredateKey;
        this.changedateKey = changedateKey;
        this.taxCategory = taxCategory;
        this.accountOrg = accountOrg;
    }

    public static FcsTypeEnum getBySourceEntity(String sourceEntity) {
        for (FcsTypeEnum value : FcsTypeEnum.values()) {
            if (!value.getSourceEntity().equals(sourceEntity)) continue;
            return value;
        }
        return FCS_BY_PRICE;
    }

    public static FcsTypeEnum getByTaxType(String taxType) {
        for (FcsTypeEnum value : FcsTypeEnum.values()) {
            if (!value.getType().equals(taxType)) continue;
            return value;
        }
        return FCS_BY_PRICE;
    }

    public String getType() {
        return this.type;
    }

    public String getSourceEntity() {
        return this.sourceEntity;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTaxtimelimitKey() {
        return this.taxtimelimitKey;
    }

    public String getAcquiredateKey() {
        return this.acquiredateKey;
    }

    public String getChangedateKey() {
        return this.changedateKey;
    }

    public String getAccountOrg() {
        return this.accountOrg;
    }

    public Long getTaxCategory() {
        return this.taxCategory;
    }
}

