/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.enums;

import java.util.Arrays;

public enum RuleTypeEnum {
    ZYS("zys", "tcret_zys_rule", 2000804860148101120L),
    DEFAULT("default", "", 0L);

    private String ruleType;
    private String formId;
    private Long groupId;

    private RuleTypeEnum(String ruleType, String formId, Long groupId) {
        this.ruleType = ruleType;
        this.formId = formId;
        this.groupId = groupId;
    }

    public String getRuleType() {
        return this.ruleType;
    }

    public String getFormId() {
        return this.formId;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public static RuleTypeEnum getStrategyByGroupId(String groupId) {
        for (RuleTypeEnum value : RuleTypeEnum.values()) {
            if (!value.groupId.toString().equals(groupId)) continue;
            return value;
        }
        return DEFAULT;
    }

    public static Long getGroupId(String formId) {
        return Arrays.stream(RuleTypeEnum.values()).filter(s -> s.getFormId().equals(formId)).map(s -> s.getGroupId()).findFirst().orElseGet(() -> 0L);
    }
}

