/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum TcretAccrualEnum {
    FCS("fcs", "tcret_fcs_accrual_draft"),
    CZTDSYS("cztdsys", "tcret_fcs_accrual_draft"),
    YHS("yhs", "tcret_yhs_acccrual"),
    HJBHS("hjbhs", "tcret_hbs_accrual_draft"),
    CCS("ccs", "tcret_ccs_accrual_draft"),
    SZYS("szys", "tcret_szys_accrual_draft");

    private String drafttype;
    private String entity;

    public String getDrafttype() {
        return this.drafttype;
    }

    public String getEntity() {
        return this.entity;
    }

    private TcretAccrualEnum(String drafttype, String entity) {
        this.drafttype = drafttype;
        this.entity = entity;
    }

    public static String getEntityByDraftType(String drafttype) {
        for (TcretAccrualEnum tcretAccrualEnum : TcretAccrualEnum.values()) {
            if (!tcretAccrualEnum.getDrafttype().equals(drafttype)) continue;
            return tcretAccrualEnum.getEntity();
        }
        return null;
    }

    public static List<String> getAllDraftTypes() {
        return Arrays.stream(TcretAccrualEnum.values()).map(TcretAccrualEnum::getDrafttype).collect(Collectors.toList());
    }
}

