/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.enums;

import java.util.ArrayList;
import java.util.List;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;

public enum TcretDraftEnum {
    CCSCL("ccscl", BaseTaxCategory.CCS, new MultiLangEnumBridge("\u8f66\u8f86\u7a0e\u6e90\u4fe1\u606f", "TcretDraftEnum_0", "taxc-tcret"), "sourceid", "tcret_ccs_taxdraft", "ccs"),
    CCSCB("ccscb", BaseTaxCategory.CCS, new MultiLangEnumBridge("\u8239\u8236\u7a0e\u6e90\u4fe1\u606f", "TcretDraftEnum_1", "taxc-tcret"), "sourceid", "tcret_ccs_taxdraft", "ccs"),
    FCS_BY_PRICE("fcscj", BaseTaxCategory.FCS, new MultiLangEnumBridge("\u623f\u4ea7\u57fa\u7840\u4fe1\u606f", "TcretDraftEnum_2", "taxc-tcret"), "number", "tcret_fcscj_taxdraft", "fcscj"),
    FCS_BY_HIRE("fcscz", BaseTaxCategory.FCS, new MultiLangEnumBridge("\u623f\u4ea7\u51fa\u79df\u4fe1\u606f", "TcretDraftEnum_3", "taxc-tcret"), "sourceid", "tcret_fcscz_taxdraft", "fcscz"),
    TDS("cztdsys", BaseTaxCategory.CZTDSYS, new MultiLangEnumBridge("\u571f\u5730\u7a0e\u6e90\u4fe1\u606f", "TcretDraftEnum_4", "taxc-tcret"), "number", "tcret_cztds_taxdraft", "cztdsys");

    private String type;
    private Long taxCategoryId;
    private MultiLangEnumBridge name;
    private String matchField;
    private String draft;
    private String draftType;

    private TcretDraftEnum(String type, Long taxCategoryId, MultiLangEnumBridge name, String matchField, String draft, String draftType) {
        this.type = type;
        this.taxCategoryId = taxCategoryId;
        this.name = name;
        this.matchField = matchField;
        this.draft = draft;
        this.draftType = draftType;
    }

    public String getType() {
        return this.type;
    }

    public Long getTaxCategoryId() {
        return this.taxCategoryId;
    }

    public MultiLangEnumBridge getName() {
        return this.name;
    }

    public String getNameStr() {
        return this.name.getDescription();
    }

    public String getMatchField() {
        return this.matchField;
    }

    public String getDraft() {
        return this.draft;
    }

    private String getDraftType() {
        return this.draftType;
    }

    public static TcretDraftEnum getByTaxType(String taxType) {
        for (TcretDraftEnum value : TcretDraftEnum.values()) {
            if (!value.getType().equals(taxType)) continue;
            return value;
        }
        return CCSCL;
    }

    public static List<String> getTypeList() {
        ArrayList<String> list = new ArrayList<String>(8);
        for (TcretDraftEnum value : TcretDraftEnum.values()) {
            list.add(value.getType());
        }
        return list;
    }
}

