/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.enums;

import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;

public enum TcretTaxTypeEnum {
    TAXTYPE_FCS_PRICE("fcs", "fcscj", DeclareTaxType.FCS.getBaseTaxId(), "tdm_fcs_basic_info", new MultiLangEnumBridge("\u623f\u4ea7\u7a0e", "TcretTaxTypeEnum_0", "taxc-tcret"), new MultiLangEnumBridge("\u623f\u4ea7\u7a0e\uff08\u4ece\u4ef7\uff09", "TcretTaxTypeEnum_1", "taxc-tcret")),
    TAXTYPE_FCS_HIRE("fcs", "fcscz", DeclareTaxType.FCS.getBaseTaxId(), "tdm_house_rental_info", new MultiLangEnumBridge("\u623f\u4ea7\u7a0e", "TcretTaxTypeEnum_0", "taxc-tcret"), new MultiLangEnumBridge("\u623f\u4ea7\u7a0e\uff08\u4ece\u79df\uff09", "TcretTaxTypeEnum_2", "taxc-tcret")),
    TAXTYPE_FCS_TDS("cztdsys", "cztdsys", DeclareTaxType.CZTDSYS.getBaseTaxId(), "tdm_tds_basic_info", new MultiLangEnumBridge("\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", "TcretTaxTypeEnum_3", "taxc-tcret"), new MultiLangEnumBridge("\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", "TcretTaxTypeEnum_3", "taxc-tcret")),
    TAXTYPE_YHS_AC("yhs", "yhsac", DeclareTaxType.YHS.getBaseTaxId(), "tcret_yhs_tax_source_info", new MultiLangEnumBridge("\u5370\u82b1\u7a0e", "TcretTaxTypeEnum_4", "taxc-tcret"), new MultiLangEnumBridge("\u5370\u82b1\u7a0e\uff08\u6309\u6b21\uff09", "TcretTaxTypeEnum_5", "taxc-tcret")),
    TAXTYPE_YHS_AQ("yhs", "yhsaq", DeclareTaxType.YHS.getBaseTaxId(), "tcret_yhs_tax_source_info", new MultiLangEnumBridge("\u5370\u82b1\u7a0e", "TcretTaxTypeEnum_4", "taxc-tcret"), new MultiLangEnumBridge("\u5370\u82b1\u7a0e\uff08\u6309\u671f\uff09", "TcretTaxTypeEnum_6", "taxc-tcret")),
    TAXTYPE_HBS_AQ("hjbhs", "hbsaq", DeclareTaxType.HBS.getBaseTaxId(), new MultiLangEnumBridge("\u73af\u5883\u4fdd\u62a4\u7a0e", "TcretTaxTypeEnum_7", "taxc-tcret"), new MultiLangEnumBridge("\u73af\u4fdd\u7a0e\uff08\u6309\u671f\uff09", "TcretTaxTypeEnum_8", "taxc-tcret")),
    TAXTYPE_CCS_CL("ccs", "ccscl", DeclareTaxType.CCSYS.getBaseTaxId(), "tdm_car_tax_fund_info", new MultiLangEnumBridge("\u8f66\u8239\u7a0e", "TcretTaxTypeEnum_9", "taxc-tcret"), new MultiLangEnumBridge("\u8f66\u8239\u7a0e\uff08\u8f66\u8f86\uff09", "TcretTaxTypeEnum_10", "taxc-tcret")),
    TAXTYPE_CCS_CB("ccs", "ccscb", DeclareTaxType.CCSYS.getBaseTaxId(), "tdm_ship_tax_fund_info", new MultiLangEnumBridge("\u8f66\u8239\u7a0e", "TcretTaxTypeEnum_9", "taxc-tcret"), new MultiLangEnumBridge("\u8f66\u8239\u7a0e\uff08\u8239\u8236\uff09", "TcretTaxTypeEnum_11", "taxc-tcret")),
    TAXTYPE_QS(null, "qs", DeclareTaxType.QS.getBaseTaxId(), "tdm_qishui_dj", new MultiLangEnumBridge("\u5951\u7a0e", "TcretTaxTypeEnum_12", "taxc-tcret"), new MultiLangEnumBridge("\u5951\u7a0e", "TcretTaxTypeEnum_12", "taxc-tcret")),
    TAXTYPE_TDZZS("tdzzs", "tdzzs", DeclareTaxType.TDZZS.getBaseTaxId(), "tcret_tdzzssy_list", new MultiLangEnumBridge("\u571f\u5730\u589e\u503c\u7a0e", "TcretTaxTypeEnum_13", "taxc-tcret"), new MultiLangEnumBridge("\u571f\u5730\u589e\u503c\u7a0e\uff08\u5c3e\u76d8\uff09", "TcretTaxTypeEnum_14", "taxc-tcret")),
    TAXTYPE_TDZZSYJ("tdzzs", "tdzzsyj", DeclareTaxType.TDZZS.getBaseTaxId(), "tcret_tdzzssy_list", new MultiLangEnumBridge("\u571f\u5730\u589e\u503c\u7a0e", "TcretTaxTypeEnum_13", "taxc-tcret"), new MultiLangEnumBridge("\u571f\u5730\u589e\u503c\u7a0e\uff08\u9884\u5f81\uff09", "TcretTaxTypeEnum_15", "taxc-tcret")),
    TAXTYPE_TDZZSQS("tdzzs", "tdzzsqs", DeclareTaxType.TDZZS.getBaseTaxId(), "tcret_tdzzssy_list", new MultiLangEnumBridge("\u571f\u5730\u589e\u503c\u7a0e", "TcretTaxTypeEnum_13", "taxc-tcret"), new MultiLangEnumBridge("\u571f\u5730\u589e\u503c\u7a0e\uff08\u6e05\u7b97\uff09", "TcretTaxTypeEnum_16", "taxc-tcret")),
    TAXTYPE_ZYS_AY("zys", "zysay", DeclareTaxType.ZYS.getBaseTaxId(), "tcret_zys_collect", new MultiLangEnumBridge("\u8d44\u6e90\u7a0e", "TcretTaxTypeEnum_17", "taxc-tcret"), new MultiLangEnumBridge("\u8d44\u6e90\u7a0e\uff08\u6309\u6708\uff09", "TcretTaxTypeEnum_18", "taxc-tcret")),
    TAXTYPE_ZYS_AJ("zys", "zysaj", DeclareTaxType.ZYS.getBaseTaxId(), "tcret_zys_collect", new MultiLangEnumBridge("\u8d44\u6e90\u7a0e", "TcretTaxTypeEnum_17", "taxc-tcret"), new MultiLangEnumBridge("\u8d44\u6e90\u7a0e\uff08\u6309\u5b63\uff09", "TcretTaxTypeEnum_19", "taxc-tcret")),
    TAXTYPE_ZYS_AC("zys", "zysac", DeclareTaxType.ZYS.getBaseTaxId(), "tcret_zys_collect", new MultiLangEnumBridge("\u8d44\u6e90\u7a0e", "TcretTaxTypeEnum_17", "taxc-tcret"), new MultiLangEnumBridge("\u8d44\u6e90\u7a0e\uff08\u6309\u6b21\uff09", "TcretTaxTypeEnum_20", "taxc-tcret"));

    private String category;
    private String taxtype;
    private Long baseTaxId;
    private String sourceEntity;
    private MultiLangEnumBridge categoryName;
    private MultiLangEnumBridge taxtypeName;

    private TcretTaxTypeEnum(String category, String taxtype, Long baseTaxId, String sourceEntity, MultiLangEnumBridge categoryName, MultiLangEnumBridge taxtypeName) {
        this.category = category;
        this.taxtype = taxtype;
        this.baseTaxId = baseTaxId;
        this.sourceEntity = sourceEntity;
        this.categoryName = categoryName;
        this.taxtypeName = taxtypeName;
    }

    private TcretTaxTypeEnum(String category, String taxtype, Long baseTaxId, MultiLangEnumBridge categoryName, MultiLangEnumBridge taxtypeName) {
        this.category = category;
        this.taxtype = taxtype;
        this.baseTaxId = baseTaxId;
        this.categoryName = categoryName;
        this.taxtypeName = taxtypeName;
    }

    public String getCategory() {
        return this.category;
    }

    public String getTaxtype() {
        return this.taxtype;
    }

    public void setTaxtype(String taxtype) {
        this.taxtype = taxtype;
    }

    public Long getBaseTaxId() {
        return this.baseTaxId;
    }

    public String getSourceEntity() {
        return this.sourceEntity;
    }

    public MultiLangEnumBridge getCategoryName() {
        return this.categoryName;
    }

    public MultiLangEnumBridge getTaxtypeName() {
        return this.taxtypeName;
    }

    public static Long getBaseTaxIdByTaxtype(String taxtype) {
        for (TcretTaxTypeEnum value : TcretTaxTypeEnum.values()) {
            if (!value.taxtype.equals(taxtype)) continue;
            return value.getBaseTaxId();
        }
        return null;
    }

    public static String getBaseTaxIdByCategory(String category) {
        for (TcretTaxTypeEnum value : TcretTaxTypeEnum.values()) {
            if (TAXTYPE_QS.getTaxtype().equals(category)) {
                return TAXTYPE_QS.getBaseTaxId().toString();
            }
            if (!value.getCategory().equals(category)) continue;
            return String.valueOf(value.getBaseTaxId());
        }
        return null;
    }

    public static String getCateGoryByTaxtype(String taxtype) {
        for (TcretTaxTypeEnum tcretTaxTypeEnum : TcretTaxTypeEnum.values()) {
            if (TAXTYPE_QS.getTaxtype().equals(taxtype)) {
                return TAXTYPE_QS.getTaxtype();
            }
            if (!tcretTaxTypeEnum.getTaxtype().equals(taxtype)) continue;
            return tcretTaxTypeEnum.getCategory();
        }
        return null;
    }

    public static String getSourceEntity(String taxtype) {
        for (TcretTaxTypeEnum tcretTaxTypeEnum : TcretTaxTypeEnum.values()) {
            if (!tcretTaxTypeEnum.getTaxtype().equals(taxtype)) continue;
            return tcretTaxTypeEnum.getSourceEntity();
        }
        return null;
    }

    public static String getCategoryName(String taxtype) {
        for (TcretTaxTypeEnum tcretTaxTypeEnum : TcretTaxTypeEnum.values()) {
            if (!tcretTaxTypeEnum.getTaxtype().equals(taxtype)) continue;
            return tcretTaxTypeEnum.getCategoryName().loadKDString();
        }
        return null;
    }

    public static String getTaxtypeName(String taxtype) {
        for (TcretTaxTypeEnum tcretTaxTypeEnum : TcretTaxTypeEnum.values()) {
            if (!tcretTaxTypeEnum.getTaxtype().equals(taxtype)) continue;
            return tcretTaxTypeEnum.getTaxtypeName().loadKDString();
        }
        return null;
    }

    public static String getTaxtypeByCategoryName(String categoryName) {
        for (TcretTaxTypeEnum tcretTaxTypeEnum : TcretTaxTypeEnum.values()) {
            if (!tcretTaxTypeEnum.getCategoryName().loadKDString().equals(categoryName)) continue;
            return tcretTaxTypeEnum.getCategory();
        }
        return null;
    }
}

