/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.enums;

import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;

public enum TcretTypeEnum {
    FCS_BY_PRICE("fcscj", "tcret_fcscj_taxdraft", "tdm_fcs_basic_info", "tcret_pbt_fcs_price_sum", "tcret_pbt_fcs_price_sum_tp", new MultiLangEnumBridge("\u4ece\u4ef7\u8ba1\u5f81\u623f\u4ea7\u7a0e", "TcretTypeEnum_0", "taxc-tcret")),
    FCS_BY_HIRE("fcscz", "tcret_fcscz_taxdraft", "tdm_house_rental_info", "tcret_pbt_fcs_hire_sum", "tcret_pbt_fcs_hire_sum_tp", new MultiLangEnumBridge("\u4ece\u79df\u8ba1\u5f81\u623f\u4ea7\u7a0e", "TcretTypeEnum_1", "taxc-tcret")),
    TDS("cztdsys", "tcret_cztds_taxdraft", "tdm_tds_basic_info", "tcret_pbt_tds_sum", "tcret_pbt_tds_sum_tp", new MultiLangEnumBridge("\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", "TcretTypeEnum_2", "taxc-tcret")),
    CCSCL("ccscl", "tcret_ccs_taxdraft", "tdm_car_tax_fund_info", "tcret_pbt_ccs_sum", "tcret_pbt_ccs_sum_tp", new MultiLangEnumBridge("\u8f66\u8f86\u7a0e", "TcretTypeEnum_3", "taxc-tcret")),
    CCSCB("ccscb", "tcret_ccs_taxdraft", "tdm_ship_tax_fund_info", "tcret_pbt_ccs_sum", "tcret_pbt_ccs_sum_tp", new MultiLangEnumBridge("\u8239\u8236\u7a0e", "TcretTypeEnum_4", "taxc-tcret"));

    private String type;
    private String draftEntity;
    private String sourceEntity;
    private String entityName;
    private String entityNameTp;
    private MultiLangEnumBridge taxname;

    private TcretTypeEnum(String type, String draftEntity, String sourceEntity, String entityName, String entityNameTp, MultiLangEnumBridge taxname) {
        this.type = type;
        this.draftEntity = draftEntity;
        this.sourceEntity = sourceEntity;
        this.entityName = entityName;
        this.entityNameTp = entityNameTp;
        this.taxname = taxname;
    }

    public String getType() {
        return this.type;
    }

    public String getSourceEntity() {
        return this.sourceEntity;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityNameTp() {
        return this.entityNameTp;
    }

    public String getDraftEntity() {
        return this.draftEntity;
    }

    public MultiLangEnumBridge getTaxname() {
        return this.taxname;
    }

    public static String getEntityNameTpByType(String type) {
        for (TcretTypeEnum value : TcretTypeEnum.values()) {
            if (!value.type.equals(type)) continue;
            return value.getEntityNameTp();
        }
        return "";
    }

    public static String getDraftByType(String type) {
        for (TcretTypeEnum value : TcretTypeEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value.getDraftEntity();
        }
        return "";
    }

    public static String getTaxName(String type) {
        for (TcretTypeEnum value : TcretTypeEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value.getTaxname().loadKDString();
        }
        return "";
    }
}

