/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.LinkQueryPkId;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;

public class CompareUtils {
    public static void openProvistonBillPage(IFormView view, DynamicObject dynamicObject) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("itp_proviston_taxes");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("isFromDraft", "true");
        hashMap.put("entitynumber", dynamicObject.getString("billno"));
        hashMap.put("orgId", dynamicObject.getString("org.id"));
        hashMap.put("taxsystem", dynamicObject.getString("taxsystem.id"));
        hashMap.put("taxtype.number", "007,008,009");
        listShowParameter.setCustomParams((Map)hashMap);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static void openAccrualListPage(IFormView view, DynamicObject dynamicObject) {
        QFilter q1 = new QFilter("org", "=", (Object)dynamicObject.getLong("org.id"));
        QFilter q2 = new QFilter("taxtype", "=", (Object)dynamicObject.getLong("taxtype.id"));
        QFilter q3 = new QFilter("drafttype", "not like", (Object)"%_bd");
        QFilter q4 = new QFilter("skssqq", ">=", (Object)dynamicObject.getDate("skssqq")).and("skssqz", "<=", (Object)dynamicObject.getDate("skssqz"));
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"tcret_fcs_accrual_draft", (QFilter[])new QFilter[]{q1, q2, q3, q4}, null, (int)-1);
        if (EmptyCheckUtils.isEmpty((Object)pkIds)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u6570\u636e\u3002", (String)"CompareUtils_0", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        for (Object pkid : pkIds) {
            linkQueryPkIdCollection.add((Object)new LinkQueryPkId(pkid));
        }
        PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tcret_fcs_accrual_draft", null, (IFormView)view, null, (LinkQueryPkIdCollection)linkQueryPkIdCollection);
    }

    public static void openTcretDeclareListPage(IFormView view, DynamicObject dynamicObject) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)dynamicObject.getLong("org.id")));
        AccrualListEnum accrualListEnum = AccrualListEnum.valueOfBaseTaxId((Long)dynamicObject.getLong("taxtype.id"));
        QFilter timeFilter = new QFilter("entryentity.startdate", "=", (Object)dynamicObject.getDate("skssqq")).and("entryentity.enddate", "=", (Object)dynamicObject.getDate("skssqz"));
        if (accrualListEnum != null) {
            qFilters.add(new QFilter("entryentity.taxtype", "=", (Object)accrualListEnum.getTaxtype()));
            if ("season".equals(dynamicObject.getString("frequency")) && "yhs".equals(accrualListEnum.getTaxtype())) {
                timeFilter = new QFilter("entryentity.startdate", ">=", (Object)dynamicObject.getDate("skssqq")).and("entryentity.enddate", "<=", (Object)dynamicObject.getDate("skssqz"));
            }
        }
        qFilters.add(timeFilter);
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"tcret_query_report", (QFilter[])qFilters.toArray(new QFilter[0]), null, (int)-1);
        if (EmptyCheckUtils.isEmpty((Object)pkIds)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u6570\u636e\u3002", (String)"CompareUtils_0", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        for (Object pkid : pkIds) {
            linkQueryPkIdCollection.add((Object)new LinkQueryPkId(pkid));
        }
        PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tcret_query_report", null, (IFormView)view, null, (LinkQueryPkIdCollection)linkQueryPkIdCollection);
    }

    public static void openPayRecordListPage(IFormView view, DynamicObject dynamicObject) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)dynamicObject.getLong("org.id")));
        AccrualListEnum accrualListEnum = AccrualListEnum.valueOfBaseTaxId((Long)dynamicObject.getLong("taxtype.id"));
        QFilter timeFilter = new QFilter("skssqq", "=", (Object)dynamicObject.getDate("skssqq")).and("skssqz", "=", (Object)dynamicObject.getDate("skssqz"));
        if (accrualListEnum != null) {
            qFilters.add(new QFilter("taxtype", "=", (Object)accrualListEnum.getTaxtype()));
            if ("season".equals(dynamicObject.getString("frequency")) && "yhs".equals(accrualListEnum.getTaxtype())) {
                timeFilter = new QFilter("skssqq", ">=", (Object)dynamicObject.getDate("skssqq")).and("skssqz", "<=", (Object)dynamicObject.getDate("skssqz"));
            }
        }
        qFilters.add(timeFilter);
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"bdtaxr_pay_record", (QFilter[])qFilters.toArray(new QFilter[0]), null, (int)-1);
        if (EmptyCheckUtils.isEmpty((Object)pkIds)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u6570\u636e\u3002", (String)"CompareUtils_0", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        for (Object pkid : pkIds) {
            linkQueryPkIdCollection.add((Object)new LinkQueryPkId(pkid));
        }
        PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"bdtaxr_pay_record", null, (IFormView)view, null, (LinkQueryPkIdCollection)linkQueryPkIdCollection);
    }
}

