/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class DataSetUtils {
    public static List<Map<String, Object>> dataSet2ListMap(DataSet dataSet, String entry, List<String> fields, List<String> scale2Fields) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(10);
        while (dataSet.hasNext()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            Row row = dataSet.next();
            for (String field : fields) {
                String key = String.format("%s#%s", entry, field);
                if (Objects.equals("sl", field)) {
                    String taxrate = row.get(field).toString();
                    BigDecimal taxrateBigDecimal = new BigDecimal(taxrate.replace("\u2030", ""));
                    if (taxrate.contains("\u2030")) {
                        taxrateBigDecimal = taxrateBigDecimal.divide(BigDecimal.valueOf(1000L));
                    }
                    resultMap.put(key, taxrateBigDecimal.toPlainString());
                } else {
                    resultMap.put(key, row.get(field));
                }
                if (row.get(field) instanceof Date) {
                    resultMap.put(key, DateUtils.format((Date)((Date)row.get(field))));
                    continue;
                }
                if (scale2Fields == null || !scale2Fields.contains(field) || !(row.get(field) instanceof BigDecimal)) continue;
                resultMap.put(key, BigDecimalUtil.setScale((Object)row.get(field)));
            }
            maps.add(resultMap);
        }
        return maps;
    }

    public static List<Map<String, Object>> dataSet2ListMap4Hbs(DataSet dataSet, String entry, List<String> fields, List<String> scale2Fields) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(10);
        while (dataSet.hasNext()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            Row row = dataSet.next();
            for (String field : fields) {
                String key = String.format("%s#%s", entry, field);
                if (Objects.equals("sl", field)) {
                    String taxrate = row.get(field).toString();
                    BigDecimal taxrateBigDecimal = new BigDecimal(taxrate.replace("\u2030", ""));
                    if (taxrate.contains("\u2030")) {
                        taxrateBigDecimal = taxrateBigDecimal.divide(BigDecimal.valueOf(1000L));
                    }
                    resultMap.put(key, taxrateBigDecimal.toPlainString());
                } else if ("sm".equals(field)) {
                    Object wrwzszm = row.get("wrwzszm");
                    Object wrwmc = row.get("wrwmc");
                    resultMap.put(key, wrwzszm == null ? wrwmc : wrwzszm);
                } else {
                    resultMap.put(key, row.get(field));
                }
                if (row.get(field) instanceof Date) {
                    resultMap.put(key, DateUtils.format((Date)((Date)row.get(field))));
                    continue;
                }
                if (scale2Fields == null || !scale2Fields.contains(field) || !(row.get(field) instanceof BigDecimal)) continue;
                resultMap.put(key, BigDecimalUtil.setScale((Object)row.get(field)));
            }
            maps.add(resultMap);
        }
        return maps;
    }

    public static List<Map<String, Object>> dataSet2ListMapForZys(DataSet dataSet, String entry, List<String> fields, List<String> scale2Fields) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(10);
        while (dataSet.hasNext()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            Row row = dataSet.next();
            for (String field : fields) {
                String key = String.format("%s#%s", entry, field);
                if (Objects.equals("sl", field)) {
                    String taxrate = row.get(field).toString();
                    BigDecimal taxrateBigDecimal = new BigDecimal(taxrate.replace("\u2030", ""));
                    if (taxrate.contains("\u2030")) {
                        taxrateBigDecimal = taxrateBigDecimal.divide(BigDecimal.valueOf(1000L));
                    }
                    resultMap.put(key, taxrateBigDecimal.toPlainString());
                } else if ("jsyj".equals(field)) {
                    String levy = row.getString("levy");
                    if ("cjjz".equals(levy)) {
                        resultMap.put(key, BigDecimalUtil.setScale((Object)row.getBigDecimal("jsxse")));
                    } else if ("cljz".equals(levy)) {
                        resultMap.put(key, BigDecimalUtil.setScale((Object)row.getBigDecimal("jsxssl")));
                    }
                } else {
                    resultMap.put(key, row.get(field));
                }
                if ("jsyj".equals(field)) continue;
                if (row.get(field) instanceof Date) {
                    resultMap.put(key, DateUtils.format((Date)((Date)row.get(field))));
                    continue;
                }
                if (scale2Fields == null || !scale2Fields.contains(field) || !(row.get(field) instanceof BigDecimal)) continue;
                resultMap.put(key, BigDecimalUtil.setScale((Object)row.get(field)));
            }
            maps.add(resultMap);
        }
        return maps;
    }
}

