/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.common.constant.HbsConstant;

public class HbsUtils {
    private static final Map<String, MultiLangEnumBridge> ZH_ENGLISH = new HashMap<String, MultiLangEnumBridge>();
    public static final String TCRET_POLLUTION_BASEDATA = "tcret_pollution_basedata";
    public static final String SELECT_FIELDS = "id,pfksszgswjg,number,pfknum,name,entryentity.wrwlb,entryentity.swrwzl,entryentity.wrwmc,entryentity.zszm,entryentity.wrwpfljsff,entryentity.bzndz,startdate,enddate";
    public static final String TDM_POLLUTION_AIR_WATER = "tdm_pollution_air_water";
    public static final String TDM_POLLUTE_AIRWATER_TP = "tdm_pollute_airwater_tp";

    public static List<String> checkMustinput(List<String> checklist, DynamicObject dynamicObject, List<String> errorMesge, String headString) {
        if (CollectionUtils.isEmpty(checklist)) {
            return errorMesge;
        }
        headString = String.format(headString, dynamicObject.get("seq"));
        StringBuilder builder = new StringBuilder(headString);
        Boolean haveError = false;
        for (String s : checklist) {
            if ("wrwdlz".equals(s)) {
                DynamicObject wrwmc = (DynamicObject)dynamicObject.get("wrwmc");
                if (!"405".equals(wrwmc.get("number")) && !"407".equals(wrwmc.get("number")) || dynamicObject.get(s) != null) continue;
                builder.append(ZH_ENGLISH.get(s).loadKDString()).append("\u3001");
                haveError = true;
                continue;
            }
            if ("syxs".equals(s) && !StringUtils.isEmpty((Object)dynamicObject.getString("syxs")) && dynamicObject.get(dynamicObject.getString("syxs")) == null) {
                builder.append(ZH_ENGLISH.get(dynamicObject.getString("syxs")).loadKDString()).append("\u3001");
                haveError = true;
            }
            if ("sdcbbs".equals(s)) {
                if (!"101212302".equals(dynamicObject.get("wrwmc.number")) || dynamicObject.get("sdcbbs") != null) continue;
                builder.append(ZH_ENGLISH.get("sdcbbs").loadKDString()).append("\u3001");
                haveError = true;
                continue;
            }
            if (dynamicObject.get(s) != null && !"".equals(dynamicObject.get(s))) continue;
            builder.append(ZH_ENGLISH.get(s).loadKDString()).append("\u3001");
            haveError = true;
        }
        if (haveError.booleanValue()) {
            builder.replace(builder.lastIndexOf("\u3001"), builder.lastIndexOf("\u3001") + 1, "\u3002");
            errorMesge.add(builder.toString());
        }
        return errorMesge;
    }

    public static List<String> checkBigThanZero(List<String> checklist, DynamicObject dynamicObject, List<String> errorMesge, String headString) {
        if (CollectionUtils.isEmpty(checklist)) {
            return errorMesge;
        }
        headString = String.format(headString, dynamicObject.get("seq"));
        StringBuilder builder = new StringBuilder(headString);
        Boolean haveError = false;
        for (String s : checklist) {
            DynamicObject wrwmc = (DynamicObject)dynamicObject.get("wrwmc");
            if ("wrwdlz".equals(s) && ("405".equals(wrwmc.get("number")) || "407".equals(wrwmc.get("number")))) {
                if (dynamicObject.get(s) == null || BigDecimal.ZERO.compareTo(dynamicObject.getBigDecimal(s)) < 0) continue;
                builder.append(ZH_ENGLISH.get(s).loadKDString()).append("\u3001");
                haveError = true;
                continue;
            }
            if ("dwse".equals(s) || "101212302".equals(wrwmc.get("number")) && "sdcbbs".equals(s) || "tzl".equals(s) || "qcpwxs".equals(s)) {
                if (dynamicObject.get(s) == null || BigDecimal.ZERO.compareTo(dynamicObject.getBigDecimal(s)) < 0) continue;
                builder.append(ZH_ENGLISH.get(s).loadKDString()).append("\u3001");
                haveError = true;
                continue;
            }
            if (dynamicObject.get(s) == null || BigDecimal.ZERO.compareTo(dynamicObject.getBigDecimal(s)) <= 0) continue;
            builder.append(ZH_ENGLISH.get(s).loadKDString()).append("\u3001");
            haveError = true;
        }
        if (haveError.booleanValue()) {
            builder.replace(builder.lastIndexOf("\u3001"), builder.lastIndexOf("\u3001") + 1, "\u3002");
            errorMesge.add(builder.toString());
        }
        return errorMesge;
    }

    public static List<String> checkWrwdlz(DynamicObject dynamicObject, List<String> errorMesge, String headString) {
        headString = String.format(headString, dynamicObject.get("seq"));
        StringBuilder builder = new StringBuilder(headString);
        BigDecimal wrwdlz = dynamicObject.getBigDecimal("wrwdlz");
        if (wrwdlz == null || BigDecimal.ZERO.compareTo(wrwdlz) >= 0) {
            builder.append(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u7a0e\u52a1\u653f\u7b56\u8fd0\u7ef4\u7ef4\u62a4\u6b64\u6c61\u67d3\u7269\u540d\u79f0\u7684\u6c61\u67d3\u7269\u5f53\u91cf\u503c\u3002", (String)"HbsUtils_17", (String)"taxc-tcret", (Object[])new Object[0]));
            errorMesge.add(builder.toString());
        }
        return errorMesge;
    }

    public static String checkMustinput(List<String> errorMessage) {
        StringBuilder builder = new StringBuilder();
        for (String s : errorMessage) {
            builder.append(s).append("\n");
        }
        return builder.toString();
    }

    public static List<String> checkJmxzDm(DynamicObject dynamicObject, Long orgid, List<String> errorMesge, String model, String headString) {
        Object jmxzdmhxmmc = dynamicObject.get("jmxzdmhxmmc.number");
        if (jmxzdmhxmmc == null) {
            return errorMesge;
        }
        headString = String.format(headString, dynamicObject.get("seq"));
        StringBuilder builder = new StringBuilder(headString);
        if ("1".equals(model)) {
            if ("16064006".equals(jmxzdmhxmmc) && (dynamicObject.getBigDecimal("bzndz").compareTo(dynamicObject.getBigDecimal("zgndz")) < 0 || dynamicObject.getBigDecimal("ydndz").compareTo(dynamicObject.getBigDecimal("bzndz").multiply(BigDecimal.valueOf(0.5))) < 0 || dynamicObject.getBigDecimal("ydndz").compareTo(dynamicObject.getBigDecimal("bzndz").multiply(BigDecimal.valueOf(0.7))) >= 0)) {
                errorMesge.add(builder.append(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u653e\u6570\u636e\u4e0d\u6ee1\u8db3\u51cf\u514d\u7a0e\u653f\u7b56\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\u5df2\u5f55\u5165\u7684\u4fe1\u606f\u3002", (String)"HbsUtils_18", (String)"taxc-tcret", (Object[])new Object[0])).toString());
            }
            if ("16064007".equals(jmxzdmhxmmc) && (dynamicObject.getBigDecimal("bzndz").compareTo(dynamicObject.getBigDecimal("zgndz")) < 0 || dynamicObject.getBigDecimal("ydndz").compareTo(dynamicObject.getBigDecimal("bzndz").multiply(BigDecimal.valueOf(0.5))) >= 0)) {
                errorMesge.add(builder.append(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u653e\u6570\u636e\u4e0d\u6ee1\u8db3\u51cf\u514d\u7a0e\u653f\u7b56\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\u5df2\u5f55\u5165\u7684\u4fe1\u606f\u3002", (String)"HbsUtils_18", (String)"taxc-tcret", (Object[])new Object[0])).toString());
            }
        } else if ("2".equals(model)) {
            if ("16064006".equals(jmxzdmhxmmc) || "16064007".equals(jmxzdmhxmmc)) {
                errorMesge.add(builder.append(ResManager.loadKDString((String)"\u8be5\u51cf\u514d\u653f\u7b56\u4ec5\u9002\u7528\u4e8e\u81ea\u52a8\u76d1\u6d4b\u6216\u76d1\u6d4b\u673a\u6784\u76d1\u6d4b\u7684\u6c61\u67d3\u7269\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"HbsUtils_19", (String)"taxc-tcret", (Object[])new Object[0])).toString());
            }
        } else if ("3".equals(model)) {
            dynamicObject.set("jmxzdmhxmmc", null);
        }
        if ("16064003".equals(jmxzdmhxmmc) && !HbsUtils.isCxwsjzclcsOrshljjzclcs(orgid)) {
            errorMesge.add(builder.append(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u4e3a\u57ce\u4e61\u6c61\u6c34\u96c6\u4e2d\u5904\u7406\u573a\u6240\u6216\u751f\u6d3b\u5783\u573e\u96c6\u4e2d\u5904\u7406\u573a\u6240\uff0c\u8bf7\u786e\u8ba4\u7a0e\u79cd\u5361\u7247\u4fe1\u606f\u3002", (String)"HbsUtils_20", (String)"taxc-tcret", (Object[])new Object[0])).toString());
            return errorMesge;
        }
        return errorMesge;
    }

    public static boolean isCxwsjzclcsOrshljjzclcs(Long orgId) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainHjbhsByOrgId(Collections.singletonList(orgId));
        if (!taxResult.isSuccess() || EmptyCheckUtils.isEmpty((Object)taxResult.getData())) {
            return false;
        }
        DynamicObject taxMain = (DynamicObject)((List)taxResult.getData()).get(0);
        if (EmptyCheckUtils.isEmpty((Object)taxMain.getDynamicObjectCollection("hjbhsentity"))) {
            return false;
        }
        DynamicObject hjbhsentity = (DynamicObject)taxMain.getDynamicObjectCollection("hjbhsentity").get(0);
        return hjbhsentity.getBoolean("hjbhs_cxwsjzclcs") || hjbhsentity.getBoolean("hjbhs_shljjzclcs");
    }

    public static List<String> checkOnlyOne(DynamicObject dynamicObject, Object orgid, Object taxMonth, List<String> errorMesge, String headString) {
        headString = String.format(headString, dynamicObject.get("seq"));
        StringBuilder builder = new StringBuilder(headString);
        QFilter taxNumberFilter = new QFilter("number1", "=", (Object)dynamicObject.getLong("pwkid"));
        QFilter wrwmcnameFilter = new QFilter("wrwmc", "=", (Object)dynamicObject.getLong("wrwmc.id"));
        QFilter wrwnameFilter = new QFilter("wrwname", "=", (Object)dynamicObject.getString("wrwname"));
        QFilter wrwlb2Filter = new QFilter("wrwlb", "=", dynamicObject.get("wrwlb.id"));
        QFilter swrwzlFilter = new QFilter("swrzl", "=", dynamicObject.get("swrwzl.id"));
        QFilter orgFilter = new QFilter("org", "=", orgid);
        QFilter taxPeriodFilter = new QFilter("month", "=", taxMonth);
        if (QueryServiceHelper.exists((String)TDM_POLLUTION_AIR_WATER, (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, taxNumberFilter, wrwmcnameFilter, wrwnameFilter, wrwlb2Filter, swrwzlFilter})) {
            errorMesge.add(builder.append(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7ec4\u7ec7\u3001\u76f8\u540c\u7a0e\u6e90\u7f16\u53f7\u3001\u76f8\u540c\u7a0e\u671f\u3001\u76f8\u540c\u6c61\u67d3\u7269\u540d\u79f0\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HbsUtils_21", (String)"taxc-tcret", (Object[])new Object[0])).toString());
        }
        return errorMesge;
    }

    public static DynamicObject entryToObject(DynamicObject entry, DynamicObject org, Object taxMonth) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TDM_POLLUTION_AIR_WATER);
        dynamicObject.set("org", (Object)org);
        dynamicObject.set("month", taxMonth);
        dynamicObject.set("monthend", (Object)DateUtils.getLastDateOfMonth1((Date)((Date)taxMonth)));
        dynamicObject.set("number1", entry.get("pwkid"));
        dynamicObject.set("number", entry.get("number"));
        dynamicObject.set("name", entry.get("name"));
        dynamicObject.set("pfksszgswjg", entry.get("pfksszgswjg"));
        dynamicObject.set("pfknum", entry.get("pfknum"));
        dynamicObject.set("wrwlb", entry.get("wrwlb"));
        dynamicObject.set("swrzl", entry.get("swrwzl"));
        dynamicObject.set("wrwname", entry.get("wrwname"));
        dynamicObject.set("wrwmc", entry.get("wrwmc"));
        dynamicObject.set("zszm", entry.get("zszm"));
        dynamicObject.set("wrwzszm", entry.get("wrwzszm"));
        dynamicObject.set("wrwpfljsff", entry.get("wrwpfljsff"));
        dynamicObject.set("startdate", entry.get("startdate"));
        dynamicObject.set("enddate", entry.get("enddate"));
        dynamicObject.set("wrwpfl", entry.get("wrwpfl"));
        dynamicObject.set("wrwdlz", entry.get("wrwdlz"));
        dynamicObject.set("wrwdls", entry.get("wrwdls"));
        dynamicObject.set("dwse", entry.get("dwse"));
        dynamicObject.set("ynse", entry.get("ynse"));
        dynamicObject.set("jmxzdmhxmmc", entry.get("jmxzdmhxmmc"));
        dynamicObject.set("jmbl", entry.get("jmbl"));
        dynamicObject.set("jmse", entry.get("jmse"));
        dynamicObject.set("bqyjse", entry.get("bqyjse"));
        dynamicObject.set("bqybtse", entry.get("bqybtse"));
        dynamicObject.set("sbbbillno", (Object)ResManager.loadKDString((String)"\u672a\u751f\u6210\u7533\u62a5\u8868", (String)"HbsUtils_22", (String)"taxc-tcret", (Object[])new Object[0]));
        dynamicObject.set("datasource", (Object)"1");
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("attachmentfield", entry.get("attachmentfield"));
        dynamicObject.set("testreport", entry.get("testreport"));
        dynamicObject.set("billno", (Object)codeRuleService.getNumber(TDM_POLLUTION_AIR_WATER, dynamicObject, null));
        return dynamicObject;
    }

    public static DynamicObject entryToObject3(DynamicObject entry, DynamicObject org, Object taxMonth, Object status) {
        DynamicObject dynamicObject = new DynamicObject();
        dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TDM_POLLUTE_AIRWATER_TP);
        dynamicObject.set("org", (Object)org);
        dynamicObject.set("month", taxMonth);
        dynamicObject.set("monthend", (Object)DateUtils.getLastDateOfMonth1((Date)((Date)taxMonth)));
        dynamicObject.set("number1", entry.get("pwkid"));
        dynamicObject.set("number", entry.get("number"));
        dynamicObject.set("name", entry.get("name"));
        dynamicObject.set("pfksszgswjg", entry.get("pfksszgswjg"));
        dynamicObject.set("pfknum", entry.get("pfknum"));
        dynamicObject.set("wrwlb", entry.get("wrwlb"));
        dynamicObject.set("swrzl", entry.get("swrwzl"));
        dynamicObject.set("wrwname", entry.get("wrwname"));
        dynamicObject.set("wrwmc", entry.get("wrwmc"));
        dynamicObject.set("zszm", entry.get("zszm"));
        dynamicObject.set("wrwpfljsff", entry.get("wrwpfljsff"));
        dynamicObject.set("startdate", entry.get("startdate"));
        dynamicObject.set("enddate", entry.get("enddate"));
        dynamicObject.set("wrwpfl", HbsUtils.getNumValue(entry, "wrwpfl"));
        dynamicObject.set("wrwdlz", HbsUtils.getNumValue(entry, "wrwdlz"));
        dynamicObject.set("wrwdls", HbsUtils.getNumValue(entry, "wrwdls"));
        dynamicObject.set("dwse", HbsUtils.getNumValue(entry, "dwse"));
        dynamicObject.set("ynse", HbsUtils.getNumValue(entry, "ynse"));
        dynamicObject.set("jmxzdmhxmmc", entry.get("jmxzdmhxmmc"));
        dynamicObject.set("jmbl", entry.get("jmbl"));
        dynamicObject.set("jmse", entry.get("jmse"));
        dynamicObject.set("bqyjse", entry.get("bqyjse"));
        dynamicObject.set("bqybtse", HbsUtils.getNumValue(entry, "bqybtse"));
        dynamicObject.set("sbbbillno", (Object)ResManager.loadKDString((String)"\u672a\u751f\u6210\u7533\u62a5\u8868", (String)"HbsUtils_22", (String)"taxc-tcret", (Object[])new Object[0]));
        dynamicObject.set("datasource", (Object)"1");
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("testreport", entry.get("testreport"));
        dynamicObject.set("attachmentfield", entry.get("attachmentfield"));
        return dynamicObject;
    }

    public static DynamicObject saveToObject(DynamicObject org, Object taxMonth, String type) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tdm_airwater_tp");
        dynamicObject.set("org", (Object)org);
        dynamicObject.set("month", taxMonth);
        dynamicObject.set("type", (Object)type);
        dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
        return dynamicObject;
    }

    private static Object getNumValue(DynamicObject obj, String key) {
        if (obj == null) {
            return null;
        }
        if (obj.get(key) == null) {
            return 0;
        }
        return obj.get(key);
    }

    public static void entryToObject2(IDataModel model, DynamicObject dynamicObject, int rowIndex) {
        model.setValue("pwkid", (Object)dynamicObject.getLong("id"), rowIndex);
        model.setValue("pfksszgswjg", (Object)dynamicObject.getLong("pfksszgswjg"), rowIndex);
        model.setValue("number", (Object)dynamicObject.getString("number"), rowIndex);
        model.setValue("pfknum", (Object)dynamicObject.getString("pfknum"), rowIndex);
        model.setValue("name", (Object)dynamicObject.getString("name"), rowIndex);
        model.setValue("wrwlb", (Object)dynamicObject.getLong("entryentity.wrwlb"), rowIndex);
        model.setValue("swrwzl", (Object)dynamicObject.getLong("entryentity.swrwzl"), rowIndex);
        model.setValue("wrwmc", (Object)dynamicObject.getLong("entryentity.wrwmc"), rowIndex);
        model.setValue("wrwzszm", (Object)dynamicObject.getString("entryentity.zszm"), rowIndex);
        model.setValue("wrwpfljsff", (Object)dynamicObject.getLong("entryentity.wrwpfljsff"), rowIndex);
        model.setValue("startdate", dynamicObject.get("startdate"), rowIndex);
        model.setValue("enddate", dynamicObject.get("enddate"), rowIndex);
    }

    public static void entryToObject4(IDataModel model, DynamicObject dynamicObject, int rowIndex) {
        model.setValue("pwkid", dynamicObject.get("number1"), rowIndex);
        model.setValue("pfksszgswjg", dynamicObject.get("pfksszgswjg"), rowIndex);
        model.setValue("number", (Object)dynamicObject.getString("number"), rowIndex);
        model.setValue("pfknum", (Object)dynamicObject.getString("pfknum"), rowIndex);
        model.setValue("name", (Object)dynamicObject.getString("name"), rowIndex);
        model.setValue("wrwlb", dynamicObject.get("wrwlb"), rowIndex);
        model.setValue("swrwzl", dynamicObject.get("swrzl"), rowIndex);
        model.setValue("wrwname", (Object)dynamicObject.getString("wrwname"), rowIndex);
        model.setValue("wrwmc", dynamicObject.get("wrwmc"), rowIndex);
        model.setValue("zszm", (Object)dynamicObject.getString("zszm"), rowIndex);
        model.setValue("wrwpfljsff", dynamicObject.get("wrwpfljsff"), rowIndex);
        model.setValue("startdate", dynamicObject.get("startdate"), rowIndex);
        model.setValue("enddate", dynamicObject.get("enddate"), rowIndex);
        model.setValue("wrwpfl", dynamicObject.get("wrwpfl"), rowIndex);
        model.setValue("wrwdlz", dynamicObject.get("wrwdlz"), rowIndex);
        model.setValue("wrwdls", dynamicObject.get("wrwdls"), rowIndex);
        model.setValue("dwse", dynamicObject.get("dwse"), rowIndex);
        model.setValue("ynse", dynamicObject.get("ynse"), rowIndex);
        model.setValue("jmxzdmhxmmc", dynamicObject.get("jmxzdmhxmmc"), rowIndex);
        model.setValue("jmbl", dynamicObject.get("jmbl"), rowIndex);
        model.setValue("jmse", dynamicObject.get("jmse"), rowIndex);
        model.setValue("bqyjse", dynamicObject.get("bqyjse"), rowIndex);
        model.setValue("bqybtse", dynamicObject.get("bqybtse"), rowIndex);
        model.setValue("rowid", (Object)dynamicObject.getLong("id"), rowIndex);
        model.setValue("testreport", dynamicObject.get("testreport"), rowIndex);
    }

    public static void setModleValue(IDataModel model, DynamicObject entry) {
        model.setValue("org", entry.get("org"));
        model.setValue("taxMonth", entry.get("month"));
        model.setValue("number", entry.get("number"));
        model.setValue("name", entry.get("name"));
        model.setValue("pfksszgswjg", entry.get("pfksszgswjg"));
        model.setValue("pfknum", entry.get("pfknum"));
        model.setValue("wrwlb", entry.get("wrwlb"));
        model.setValue("swrwzl", entry.get("swrzl"));
        model.setValue("wrwzszm", entry.get("wrwzszm"));
        model.setValue("wrwpfljsff", entry.get("wrwpfljsff"));
        model.setValue("wrwpfl", entry.get("wrwpfl"));
        model.setValue("wrwdlz", entry.get("wrwdlz"));
        model.setValue("wrwdls", entry.get("wrwdls"));
        model.setValue("dwse", entry.get("dwse"));
        model.setValue("ynse", entry.get("ynse"));
        model.setValue("jmxzdmhxmmc", entry.get("jmxzdmhxmmc"));
        model.setValue("jmbl", entry.get("jmbl"));
        model.setValue("jmse", entry.get("jmse"));
        model.setValue("bqyjse", entry.get("bqyjse"));
        model.setValue("bqybtse", entry.get("bqybtse"));
        model.setValue("sbbbillstatus", (Object)(entry.getDynamicObject("sbbid") == null ? "" : entry.getDynamicObject("sbbid").getString("billstatus")));
        model.setValue("wrwmc", entry.get("wrwmc"));
        model.setValue("templatefrom", entry.get("templatefrom"));
        model.setValue("testreport", entry.get("testreport"));
    }

    public static void setEntryValue(IDataModel model, DynamicObject entry) {
        entry.set("wrwpfl", model.getValue("wrwpfl"));
        entry.set("wrwdlz", model.getValue("wrwdlz"));
        entry.set("wrwdls", model.getValue("wrwdls"));
        entry.set("dwse", model.getValue("dwse"));
        entry.set("ynse", model.getValue("ynse"));
        entry.set("jmxzdmhxmmc", model.getValue("jmxzdmhxmmc"));
        entry.set("jmbl", model.getValue("jmbl"));
        entry.set("jmse", model.getValue("jmse"));
        entry.set("bqyjse", model.getValue("bqyjse"));
        entry.set("bqybtse", model.getValue("bqybtse"));
        entry.set("testreport", model.getValue("testreport"));
    }

    public static boolean checkJmxzdmhxmmc(DynamicObject dataEntity) {
        boolean hasZgndz = dataEntity.containsProperty("zgndz");
        boolean hasBzndz = dataEntity.containsProperty("bzndz");
        boolean hasYdndz = dataEntity.containsProperty("ydndz");
        BigDecimal zgndz = hasZgndz ? dataEntity.getBigDecimal("zgndz") : BigDecimal.ZERO;
        BigDecimal bzndz = hasBzndz ? dataEntity.getBigDecimal("bzndz") : BigDecimal.ZERO;
        BigDecimal ydndz = hasYdndz ? dataEntity.getBigDecimal("ydndz") : BigDecimal.ZERO;
        long jmxzdmhxmmcId = dataEntity.getLong("jmxzdmhxmmc.id");
        if (jmxzdmhxmmcId == HbsConstant.JMZCDM_ID_16064006) {
            return hasZgndz && hasBzndz && hasYdndz && HbsUtils.isJmzcdm_16064006(zgndz, bzndz, ydndz);
        }
        if (jmxzdmhxmmcId == HbsConstant.JMZCDM_ID_16064007) {
            return hasZgndz && hasBzndz && hasYdndz && HbsUtils.isJmzcdm_16064007(zgndz, bzndz, ydndz);
        }
        return true;
    }

    public static boolean isJmzcdm_16064007(BigDecimal zgndz, BigDecimal bzndz, BigDecimal ydndz) {
        return bzndz.compareTo(zgndz) >= 0 && ydndz.compareTo(bzndz.multiply(BigDecimal.valueOf(0.5))) < 0;
    }

    public static boolean isJmzcdm_16064006(BigDecimal zgndz, BigDecimal bzndz, BigDecimal ydndz) {
        return bzndz.compareTo(zgndz) >= 0 && ydndz.compareTo(bzndz.multiply(BigDecimal.valueOf(0.5))) >= 0 && ydndz.compareTo(bzndz.multiply(BigDecimal.valueOf(0.7))) < 0;
    }

    public static List<Long> filterPollutionAirWater(DynamicObjectCollection dynamicObjectCollection) {
        ArrayList<DynamicObject> airList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> waterList_301 = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> waterList_302 = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> waterList_303 = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> waterList_304 = new ArrayList<DynamicObject>();
        dynamicObjectCollection.forEach(o -> {
            String wrwlb = o.getString("wrwlb.number");
            if ("101".equals(wrwlb)) {
                String swrzl = o.getString("swrzl.number");
                if ("301".equals(swrzl)) {
                    waterList_301.add((DynamicObject)o);
                } else if ("302".equals(swrzl)) {
                    waterList_302.add((DynamicObject)o);
                } else if ("303".equals(swrzl)) {
                    waterList_303.add((DynamicObject)o);
                } else if ("304".equals(swrzl)) {
                    waterList_304.add((DynamicObject)o);
                }
            } else if ("102".equals(wrwlb)) {
                airList.add((DynamicObject)o);
            }
        });
        Comparator<DynamicObject> comparator = Comparator.comparing(o -> o.getBigDecimal("wrwdls")).reversed();
        Function<DynamicObject, String> function = o -> o.getString("number") + "_" + DateUtils.format((Date)o.getDate("month"), (String)"yyyy-MM");
        ArrayList<Long> ids = new ArrayList<Long>();
        HbsUtils.filterIds(comparator, function, airList, ids, 3);
        HbsUtils.filterIds(comparator, function, waterList_301, ids, 5);
        HbsUtils.filterIdsKeepMaxOne(comparator, function, waterList_302, ids, 3);
        HbsUtils.filterIds(comparator, function, waterList_303, ids, 3);
        HbsUtils.filterIds(comparator, function, waterList_304, ids, 3);
        return ids;
    }

    private static void filterIdsKeepMaxOne(Comparator<DynamicObject> comparator, Function<DynamicObject, String> function, List<DynamicObject> waterList302, List<Long> ids, int count) {
        ArrayList limitOnlyOne = Lists.newArrayList((Object[])new Long[]{1215020474711792643L, 1215020474711792644L, 1215020474711792645L});
        Map<String, List<DynamicObject>> collect = waterList302.stream().sorted(comparator).collect(Collectors.groupingBy(function));
        for (List<DynamicObject> objectList : collect.values()) {
            boolean getMaxData = false;
            ArrayList<Long> tempIds = new ArrayList<Long>();
            for (DynamicObject object : objectList) {
                Long wrwmcId = object.getLong("wrwmc.id");
                Long sourceId = object.getLong("id");
                if (limitOnlyOne.contains(wrwmcId)) {
                    if (getMaxData) continue;
                    tempIds.add(sourceId);
                    getMaxData = true;
                    continue;
                }
                tempIds.add(sourceId);
            }
            ids.addAll(tempIds.stream().limit(count).collect(Collectors.toList()));
        }
    }

    private static void filterIds(Comparator<DynamicObject> comparator, Function<DynamicObject, String> function, List<DynamicObject> airList, List<Long> ids, int count) {
        Map<String, List<DynamicObject>> collect = airList.stream().sorted(comparator).collect(Collectors.groupingBy(function));
        for (List<DynamicObject> objectList : collect.values()) {
            for (int i = 0; i < Math.min(objectList.size(), count); ++i) {
                ids.add(objectList.get(i).getLong("id"));
            }
        }
    }

    public static String doQueryTaxItem(Long wrwzszm, Long wrwmc) {
        Long smId = HbsUtils.getsmId(wrwzszm, wrwmc);
        QFilter qFilter = new QFilter("entry_detail.id", "=", (Object)smId);
        DynamicObject tpoHbsBizdef = QueryServiceHelper.queryOne((String)"tpo_hbs_bizdef", (String)"entry_detail.projectname", (QFilter[])new QFilter[]{qFilter});
        if (tpoHbsBizdef != null) {
            return tpoHbsBizdef.getString("entry_detail.projectname");
        }
        return "";
    }

    private static Long getsmId(Long wrwzszm, Long wrwmc) {
        if (Objects.equals(wrwmc, 1215039940770257924L) || Objects.equals(wrwmc, 1215010325099995148L)) {
            return wrwmc;
        }
        return wrwzszm == null || wrwzszm == 0L ? wrwmc : wrwzszm;
    }

    static {
        ZH_ENGLISH.put("fqfspfl", new MultiLangEnumBridge("\"\u5e9f\u6c14\uff08\u5e9f\u6c34\uff09\u6392\u653e\u91cf\"", "HbsUtils_0", "taxc-tcret"));
        ZH_ENGLISH.put("scndz", new MultiLangEnumBridge("\"\u5b9e\u6d4b\u6d53\u5ea6\u503c\"", "HbsUtils_1", "taxc-tcret"));
        ZH_ENGLISH.put("ydndz", new MultiLangEnumBridge("\"\u6708\u5747\u6d53\u5ea6\u503c\"", "HbsUtils_2", "taxc-tcret"));
        ZH_ENGLISH.put("zgndz", new MultiLangEnumBridge("\"\u6700\u9ad8\u6d53\u5ea6\u503c\"", "HbsUtils_3", "taxc-tcret"));
        ZH_ENGLISH.put("wrwpfl", new MultiLangEnumBridge("\"\u6c61\u67d3\u7269\u6392\u653e\u91cf\"", "HbsUtils_4", "taxc-tcret"));
        ZH_ENGLISH.put("wrwdlz", new MultiLangEnumBridge("\"\u6c61\u67d3\u5f53\u91cf\u503c\"", "HbsUtils_5", "taxc-tcret"));
        ZH_ENGLISH.put("dwse", new MultiLangEnumBridge("\"\u5355\u4f4d\u7a0e\u989d\"", "HbsUtils_6", "taxc-tcret"));
        ZH_ENGLISH.put("bzndz", new MultiLangEnumBridge("\"\u6807\u51c6\u6d53\u5ea6\u503c\"", "HbsUtils_7", "taxc-tcret"));
        ZH_ENGLISH.put("bqyjse", new MultiLangEnumBridge("\"\u672c\u671f\u5df2\u7f34\u7a0e\u989d\"", "HbsUtils_8", "taxc-tcret"));
        ZH_ENGLISH.put("wrwdw", new MultiLangEnumBridge("\"\u6c61\u67d3\u7269\u5355\u4f4d\"", "HbsUtils_9", "taxc-tcret"));
        ZH_ENGLISH.put("qcwrwdw", new MultiLangEnumBridge("\"\u6c61\u67d3\u7269\u5355\u4f4d\"", "HbsUtils_9", "taxc-tcret"));
        ZH_ENGLISH.put("jsjcdw", new MultiLangEnumBridge("\"\u8ba1\u7a0e\u57fa\u6570\u5355\u4f4d\"", "HbsUtils_10", "taxc-tcret"));
        ZH_ENGLISH.put("jsjc", new MultiLangEnumBridge("\"\u8ba1\u7b97\u57fa\u6570\"", "HbsUtils_11", "taxc-tcret"));
        ZH_ENGLISH.put("syxs", new MultiLangEnumBridge("\"\u9002\u7528\u7cfb\u6570\"", "HbsUtils_12", "taxc-tcret"));
        ZH_ENGLISH.put("cwxs", new MultiLangEnumBridge("\"\u4ea7\u6c61\u7cfb\u6570\"", "HbsUtils_13", "taxc-tcret"));
        ZH_ENGLISH.put("pwxs", new MultiLangEnumBridge("\"\u6392\u6c61\u7cfb\u6570\"", "HbsUtils_14", "taxc-tcret"));
        ZH_ENGLISH.put("qcpwxs", new MultiLangEnumBridge("\"\u6392\u6c61\u7cfb\u6570\"", "HbsUtils_14", "taxc-tcret"));
        ZH_ENGLISH.put("sdcbbs", new MultiLangEnumBridge("\"\u8272\u5ea6\u8d85\u6807\u500d\u6570\"", "HbsUtils_15", "taxc-tcret"));
        ZH_ENGLISH.put("tzl", new MultiLangEnumBridge("\"\u7279\u5f81\u91cf\"", "HbsUtils_16", "taxc-tcret"));
        ZH_ENGLISH.put("constructionarea", new MultiLangEnumBridge("\"\u65bd\u5de5\u9762\u79ef\"", "HbsUtils_23", "taxc-tcret"));
        ZH_ENGLISH.put("dustgenerationcoefficie", new MultiLangEnumBridge("\"\u626c\u5c18\u4ea7\u751f\u91cf\u7cfb\u6570\"", "HbsUtils_24", "taxc-tcret"));
        ZH_ENGLISH.put("reductioncoefficient", new MultiLangEnumBridge("\"\u524a\u51cf\u7cfb\u6570\"", "HbsUtils_25", "taxc-tcret"));
        ZH_ENGLISH.put("characteristiccoefficien", new MultiLangEnumBridge("\"\u7279\u5f81\u7cfb\u6570\"", "HbsUtils_26", "taxc-tcret"));
    }
}

