/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class HouseRentEngineUtils {
    private static final String MONTH = "month";
    private static final String SEASON = "season";
    private static final String YEAR = "year";
    private static final String HALF_YEAR = "halfyear";
    private static final int DEFAULT_VALUE_1 = 1;
    private static final int SEASON_VALUE = 3;
    private static final int HALF_YEAR_VALUE = 6;
    private static final int YEAR_VALUE = 12;
    private static final int HALF_YEAR_LENGTH = 183;
    private static final int YEAR_LENGTH = 365;

    public static List<String> getAllSkssq(String taxLimit, Date start, Date end) {
        ArrayList<String> allSkssq = new ArrayList<String>();
        LocalDate startDate = HouseRentEngineUtils.getLocalDate(start);
        LocalDate endDate = HouseRentEngineUtils.getLocalDate(end);
        switch (taxLimit) {
            case "month": {
                while (!endDate.isBefore(startDate)) {
                    allSkssq.add(endDate.getYear() + HouseRentEngineUtils.getYearCn() + HouseRentEngineUtils.getMonthString(endDate) + HouseRentEngineUtils.getMonthCn());
                    endDate = endDate.minusMonths(1L);
                }
                break;
            }
            case "season": {
                while (startDate.compareTo(endDate) < 0) {
                    if (!allSkssq.contains(startDate.getYear() + HouseRentEngineUtils.getYearCn() + HouseRentEngineUtils.getSeasonNow(startDate) + HouseRentEngineUtils.getSeasonCn())) {
                        allSkssq.add(startDate.getYear() + HouseRentEngineUtils.getYearCn() + HouseRentEngineUtils.getSeasonNow(startDate) + HouseRentEngineUtils.getSeasonCn());
                    }
                    startDate = startDate.plusMonths(1L);
                }
                break;
            }
            case "year": {
                int yearStart = startDate.getYear();
                for (int endYear = endDate.getYear(); yearStart <= endYear; --endYear) {
                    allSkssq.add(endYear + HouseRentEngineUtils.getYearCn());
                }
                break;
            }
            case "halfyear": {
                while (!endDate.isBefore(startDate)) {
                    allSkssq.add(endDate.getYear() + HouseRentEngineUtils.getYearCn() + HouseRentEngineUtils.getHalfYearNow(endDate));
                    endDate = endDate.minusMonths(6L);
                }
                String last = startDate.getYear() + HouseRentEngineUtils.getYearCn() + HouseRentEngineUtils.getHalfYearNow(startDate);
                if (allSkssq.contains(last)) break;
                allSkssq.add(last);
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        Collections.sort(allSkssq);
        return allSkssq;
    }

    public static Function<BigDecimal, BigDecimal> calculateFristValue(String limit, Date startdate, Date enddate) {
        int endDuration;
        int startDuration;
        LocalDate start = HouseRentEngineUtils.getLocalDate(startdate);
        LocalDate end = HouseRentEngineUtils.getLocalDate(enddate);
        switch (limit) {
            case "month": {
                startDuration = 1;
                endDuration = 1;
                break;
            }
            case "season": {
                startDuration = HouseRentEngineUtils.getSeasonDaysBefore(start);
                endDuration = HouseRentEngineUtils.getSeasonDaysAfter(end);
                break;
            }
            case "year": {
                startDuration = 12 - start.getMonthValue() + 1;
                endDuration = end.getMonthValue();
                break;
            }
            case "halfyear": {
                startDuration = HouseRentEngineUtils.getHalfYearDaysBefore(start);
                endDuration = HouseRentEngineUtils.getHalfYearDaysAfter(end);
                break;
            }
            default: {
                startDuration = 1;
                endDuration = 1;
            }
        }
        return amount -> amount.multiply(new BigDecimal(startDuration)).divide(new BigDecimal(startDuration + endDuration), 2, 4);
    }

    public static int getSeasonDaysAfter(LocalDate end) {
        int season = HouseRentEngineUtils.getSeasonNow(end);
        int monthValue = end.getMonthValue();
        return monthValue - (season - 1) * 3;
    }

    public static int getSeasonDaysBefore(LocalDate start) {
        int season = HouseRentEngineUtils.getSeasonNow(start);
        int monthValue = start.getMonthValue();
        return 3 * season - monthValue + 1;
    }

    public static int getHalfYearDaysAfter(LocalDate end) {
        int days = end.getDayOfYear();
        int duration = days < 183 ? days : days - 183;
        return duration;
    }

    public static int getHalfYearDaysBefore(LocalDate start) {
        int days = start.getDayOfYear();
        int duration = days < 183 ? 183 - days : 365 - days;
        return duration;
    }

    public static LocalDate getLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalDate();
    }

    public static String getMonthString(LocalDate endDate) {
        int month = endDate.getMonth().getValue();
        return String.format("%02d", month);
    }

    public static int getSeasonNow(LocalDate date) {
        return (date.getMonth().getValue() + 2) / 3;
    }

    public static String getHalfYearNow(LocalDate date) {
        if (date.getMonth().getValue() <= 6) {
            return HouseRentEngineUtils.getFirstHalfYearCn();
        }
        return HouseRentEngineUtils.getSecondHalfYearCN();
    }

    public static BigDecimal getEachIncome(BigDecimal income, int monthNo, int taxLimitNo) {
        if (monthNo <= taxLimitNo) {
            return income;
        }
        return BigDecimalUtil.divideObject((Object)income.multiply(new BigDecimal(taxLimitNo)), (Object)monthNo, (int)2);
    }

    public static int getFirstMonthNum(String taxlimit, Date start) {
        if (start == null) {
            return 0;
        }
        Map skssqzMap = DateUtils.getPeriodByTaxLimit((Date)start, (String)taxlimit);
        if (EmptyCheckUtils.isNotEmpty((Object)skssqzMap) && skssqzMap.get("endDate") != null) {
            List monthList = DateUtils.getMonthBetween((Date)start, (Date)((Date)skssqzMap.get("endDate")));
            return monthList.size();
        }
        return 0;
    }

    public static String getYearCn() {
        return ResManager.loadKDString((String)"\u5e74", (String)"HouseRentEngineUtils_0", (String)"taxc-tcret", (Object[])new Object[0]);
    }

    public static String getMonthCn() {
        return ResManager.loadKDString((String)"\u6708\u4efd", (String)"HouseRentEngineUtils_1", (String)"taxc-tcret", (Object[])new Object[0]);
    }

    public static String getSeasonCn() {
        return ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"HouseRentEngineUtils_2", (String)"taxc-tcret", (Object[])new Object[0]);
    }

    public static String getFirstHalfYearCn() {
        return ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"HouseRentEngineUtils_3", (String)"taxc-tcret", (Object[])new Object[0]);
    }

    public static String getSecondHalfYearCN() {
        return ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"HouseRentEngineUtils_4", (String)"taxc-tcret", (Object[])new Object[0]);
    }

    public static Map<String, Object> error(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", "no");
        result.put("msg", msg);
        return result;
    }

    public static Map<String, Object> success() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", "ok");
        result.put("msg", "");
        return result;
    }
}

