/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class QFilterUtils {
    public static QFilter buildQFilter(OperationStatus operationStatus, String taxSourceType, Long sbbid) {
        QFilter q1 = new QFilter("source", "=", (Object)taxSourceType);
        QFilter q2 = new QFilter("applytemplates", "like", (Object)"%,ccxws,%");
        DynamicObject sourceRelation = BusinessDataServiceHelper.loadSingleFromCache((String)"bdtaxr_source_relation", (QFilter[])new QFilter[]{q1, q2});
        if (sourceRelation != null) {
            String sbbIdField;
            String relationType = sourceRelation.getString("relationtype");
            String mappingField = sourceRelation.getString("mappingfield");
            String string = sbbIdField = EmptyCheckUtils.isEmpty((Object)mappingField) ? "sbbid" : mappingField;
            if (OperationStatus.VIEW.equals((Object)operationStatus)) {
                return new QFilter(sbbIdField, "=", (Object)sbbid);
            }
            if ("master_slave".equals(relationType)) {
                return new QFilter(sbbIdField, "=", (Object)sbbid);
            }
            if ("mapping".equals(relationType)) {
                List taxSourceIds = SourceOperateHelper.queryTaxSourceIds((String)taxSourceType, (Long)sbbid);
                return new QFilter("id", "in", (Object)taxSourceIds);
            }
        }
        return null;
    }

    public static QFilter buildQFilter(OperationStatus operationStatus, String taxSourceType, Long sbbid, QFilter qFilter) {
        QFilter filter = QFilterUtils.buildQFilter(operationStatus, taxSourceType, sbbid);
        if (filter != null) {
            return filter.and(qFilter);
        }
        return null;
    }
}

