/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class RuleUtils {
    public static final String YSHTPZ = "yshtpz";
    public static final String CQZYSJ = "cqzysj";
    public static final String ZJZB = "zjzb";
    public static final String TCSD_CONTRACT_VOUCHER = "tcsd_rule_yshtpz";
    public static final String TCSD_TRANSFER_DOCUMENTS = "tcsd_rule_cqzysj";
    public static final String TCSD_MONEY_ACCOUNT_BOOK = "tcsd_rule_zjzb";
    private static String selectFields = "enable,id,number,org,ruletype,name,taxitem,taxation,taxitem.number as tnumber";

    public static DynamicObjectCollection getPublicRules(String orgId, String ruleType, String ruleuse) {
        ArrayList<QFilter> planQfilters = new ArrayList<QFilter>();
        QFilter sharingOrg = new QFilter("orgentity.orgid", "=", (Object)Long.parseLong(orgId));
        planQfilters.add(sharingOrg);
        DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tcsd_sharingplan", (String)"ruleentity.ruleid as ruleid, ruleentity.type as type", (QFilter[])planQfilters.toArray(new QFilter[0]));
        Map<String, List<DynamicObject>> groups = sharingRules.stream().collect(Collectors.groupingBy(s -> s.getString("type")));
        Set yshtpzIds = ((List)groups.getOrDefault(YSHTPZ, new ArrayList())).stream().map(s -> s.getLong("ruleid")).collect(Collectors.toSet());
        Set cqzysjIds = ((List)groups.getOrDefault(CQZYSJ, new ArrayList())).stream().map(s -> s.getLong("ruleid")).collect(Collectors.toSet());
        Set zjzbIds = ((List)groups.getOrDefault(ZJZB, new ArrayList())).stream().map(s -> s.getLong("ruleid")).collect(Collectors.toSet());
        QFilter ruleUseFilter = new QFilter("rulepurpose", "like", (Object)("%" + ruleuse + "%"));
        if (!CollectionUtils.isEmpty(yshtpzIds) && ruleType.equals(YSHTPZ)) {
            return QueryServiceHelper.query((String)TCSD_CONTRACT_VOUCHER, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", yshtpzIds), ruleUseFilter});
        }
        if (!CollectionUtils.isEmpty(cqzysjIds) && ruleType.equals(CQZYSJ)) {
            return QueryServiceHelper.query((String)TCSD_TRANSFER_DOCUMENTS, (String)(selectFields + ",subtaxitem"), (QFilter[])new QFilter[]{new QFilter("id", "in", cqzysjIds), ruleUseFilter});
        }
        if (!CollectionUtils.isEmpty(zjzbIds) && ruleType.equals(ZJZB)) {
            return QueryServiceHelper.query((String)TCSD_MONEY_ACCOUNT_BOOK, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", zjzbIds), ruleUseFilter});
        }
        return new DynamicObjectCollection();
    }

    public static DynamicObjectCollection getRuleList(String orgId, String ruleType, String entityName, String ruleuse) {
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter ruleTypeFilter = new QFilter("ruleType", "=", (Object)ruleType);
        QFilter ruleUseFilter = new QFilter("rulepurpose", "like", (Object)("%" + ruleuse + "%"));
        if (TCSD_MONEY_ACCOUNT_BOOK.equals(entityName)) {
            return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{orgFilter, enableFilter, ruleTypeFilter, ruleUseFilter});
        }
        if (TCSD_TRANSFER_DOCUMENTS.equals(entityName)) {
            return QueryServiceHelper.query((String)entityName, (String)(selectFields + ",subtaxitem"), (QFilter[])new QFilter[]{orgFilter, enableFilter, ruleTypeFilter, ruleUseFilter});
        }
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{orgFilter, enableFilter, ruleTypeFilter, ruleUseFilter});
    }
}

