/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;

public class SzyUtils {
    private static final String ENTRY = "tcwat_source_detail";

    public static void saveBills(Long sbbid) {
        QFilter[] qFilters = new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)};
        String sourceEntity = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.EDIT, (String)ENTRY);
        SzyUtils.saveEntry(ENTRY, sourceEntity, qFilters);
    }

    private static void saveEntry(String targetEntry, String sourceEntry, QFilter[] qFilters) {
        DeleteServiceHelper.delete((String)targetEntry, (QFilter[])qFilters);
        List pkids = QueryServiceHelper.queryPrimaryKeys((String)sourceEntry, (QFilter[])qFilters, null, (int)-1);
        DynamicObject[] sources = BusinessDataServiceHelper.load((Object[])pkids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceEntry));
        DynamicObject[] targets = BusinessDataServiceHelper.load((Object[])pkids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)targetEntry));
        ArrayList<DynamicObject> targetList = new ArrayList<DynamicObject>(sources.length);
        for (DynamicObject source : sources) {
            DynamicObject target = SzyUtils.getTargetObject(targetEntry, source, targets);
            BeanCopyUtils.copyDynamicObject((DynamicObject)source, (DynamicObject)target);
            targetList.add(target);
        }
        SaveServiceHelper.save((DynamicObject[])targetList.toArray(new DynamicObject[0]));
    }

    private static DynamicObject getTargetObject(String entry, DynamicObject source, DynamicObject[] targets) {
        for (DynamicObject target : targets) {
            if (!source.getPkValue().equals(target.getPkValue())) continue;
            return target;
        }
        return BusinessDataServiceHelper.newDynamicObject((String)entry);
    }
}

