/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.dto.YhsSjjtAdjust;
import kd.taxc.tcret.business.dto.YhsSjjtData;
import kd.taxc.tcret.business.dto.YhsSjjtDetail;

public class YhsAccrualUtils {
    public static List<String> getAmountList(BigDecimal amount, BigDecimal hdRate, BigDecimal jsbl, String taxRate, BigDecimal jmrate) {
        ArrayList<String> data = new ArrayList<String>(5);
        if (jsbl != null) {
            amount = amount.multiply(jsbl);
        }
        data.add(amount.toString());
        if (hdRate != null && !hdRate.equals(BigDecimal.ZERO)) {
            data.add(hdRate.toString());
        } else {
            data.add(null);
        }
        BigDecimal calsource = YhsAccrualUtils.calculateCalSource(amount, hdRate);
        data.add(calsource.toString());
        BigDecimal rate = new BigDecimal(taxRate).divide(new BigDecimal(1000));
        data.add(rate.toString());
        BigDecimal ynse = YhsAccrualUtils.calculateYnse(calsource, rate);
        data.add(ynse.toString());
        BigDecimal jmse = YhsAccrualUtils.calculateJmse(ynse, jmrate);
        data.add(jmse.toString());
        data.add(YhsAccrualUtils.calculateJtynse(ynse, jmse, BigDecimal.ZERO).toString());
        return data;
    }

    public static BigDecimal calculateJtynse(BigDecimal ynse, BigDecimal jmse, BigDecimal yjse) {
        return ynse.subtract(jmse).subtract(yjse);
    }

    public static BigDecimal calculateJmse(BigDecimal ynse, BigDecimal jmrate) {
        return ynse.multiply(jmrate).setScale(2, 4);
    }

    public static BigDecimal calculateYnse(BigDecimal calsource, BigDecimal rate) {
        return calsource.multiply(rate).setScale(2, 4);
    }

    public static BigDecimal calculateCalSource(BigDecimal jsje, BigDecimal hdRate) {
        BigDecimal calsource = jsje;
        if (hdRate != null && BigDecimal.ZERO.compareTo(hdRate) < 0) {
            calsource = jsje.multiply(hdRate);
        }
        return calsource;
    }

    public static BigDecimal findHdRateInYhsEntitys(List<DynamicObject> yhsEntityList, String taxitem, Date start, Date end, DynamicObject table) {
        String entityname = table.getString("entityname");
        if (!"tcret_yhs_tax_source_info".equals(entityname) && EmptyCheckUtils.isNotEmpty(yhsEntityList)) {
            String taxLimit = DateUtils.getTaxLimit((Date)start, (Date)end);
            Optional<BigDecimal> first = yhsEntityList.stream().filter(d -> d.getString("taxrate.name").equals(taxitem)).filter(d -> d.getBoolean("isverify")).filter(d -> taxLimit.equals(d.getString("period"))).filter(d -> d.getDate("effectivedate").compareTo(start) <= 0).filter(d -> d.getDate("expirydate") == null || d.getDate("expirydate").compareTo(end) >= 0).map(d -> d.getBigDecimal("hdrate")).findFirst();
            if (first.isPresent()) {
                return first.get();
            }
        }
        return null;
    }

    public static String findPeriodInYhsEntitys(List<DynamicObject> yhsEntityList, String taxitem, Date start, Date end, String declaretype) {
        if ("acsb".equals(declaretype)) {
            return "single";
        }
        if (EmptyCheckUtils.isNotEmpty(yhsEntityList)) {
            Optional<String> first = yhsEntityList.stream().filter(d -> d.getString("taxrate.name").equals(taxitem)).filter(d -> d.getDate("effectivedate").compareTo(start) <= 0).filter(d -> d.getDate("expirydate") == null || d.getDate("expirydate").compareTo(end) >= 0).map(d -> d.getString("period")).findFirst();
            return first.orElse("");
        }
        return "";
    }

    public static List<YhsSjjtDetail> convert(List<DynamicObject> detailList) {
        ArrayList<YhsSjjtDetail> yhsSjjtDetails = new ArrayList<YhsSjjtDetail>();
        if (EmptyCheckUtils.isNotEmpty(detailList)) {
            for (DynamicObject detail : detailList) {
                YhsSjjtDetail yhsSjjtDetail = new YhsSjjtDetail();
                yhsSjjtDetail.setOrg(detail.getLong("org"));
                yhsSjjtDetail.setTaxitem(detail.getString("taxitem"));
                yhsSjjtDetail.setSubtaxitem(detail.getLong("subtaxitem.id"));
                yhsSjjtDetail.setAccountorg(detail.getLong("accountorg"));
                yhsSjjtDetail.setBizdimensiontype(detail.getString("bizdimensiontype"));
                yhsSjjtDetail.setBizdimensionname(detail.getString("bizdimensionname"));
                yhsSjjtDetail.setBizdimensionid(detail.getString("bizdimensionid"));
                yhsSjjtDetail.setTaxperiod(detail.getString("taxperiod"));
                yhsSjjtDetail.setCreater(detail.getLong("creater"));
                yhsSjjtDetail.setCreatedate(detail.getDate("createdate"));
                yhsSjjtDetail.setModifier(detail.getLong("modifier.id"));
                yhsSjjtDetail.setModifydate(detail.getDate("modifydate"));
                yhsSjjtDetail.setFiltercondition(detail.getString("filtercondition"));
                yhsSjjtDetail.setTable(detail.getDynamicObject("table").getLong("id"));
                yhsSjjtDetail.setAmountfield(detail.getLong("amountfield"));
                yhsSjjtDetail.setDatatype(detail.getString("datatype"));
                yhsSjjtDetail.setDatadirection(detail.getString("datadirection"));
                yhsSjjtDetail.setFetchamount(detail.getBigDecimal("fetchamount"));
                yhsSjjtDetail.setAmount(detail.getBigDecimal("amount"));
                yhsSjjtDetail.setBizname(detail.getString("bizname"));
                yhsSjjtDetail.setSkssqq(detail.getDate("skssqq"));
                yhsSjjtDetail.setSkssqz(detail.getDate("skssqz"));
                yhsSjjtDetail.setType(detail.getString("type"));
                yhsSjjtDetail.setRuleid(detail.getString("ruleid"));
                yhsSjjtDetail.setSerialno(detail.getString("serialno"));
                yhsSjjtDetail.setAbsolute(detail.getString("absolute"));
                yhsSjjtDetail.setBusinessmap(detail.getString("businessmap"));
                yhsSjjtDetails.add(yhsSjjtDetail);
            }
        }
        return yhsSjjtDetails;
    }

    public static void addAdjust(YhsSjjtData yhsSjjtData, BigDecimal amount) {
        List<YhsSjjtDetail> details = yhsSjjtData.getDetails();
        if (EmptyCheckUtils.isNotEmpty(details)) {
            ArrayList<YhsSjjtAdjust> adjusts = new ArrayList<YhsSjjtAdjust>(details.size() + 1);
            for (YhsSjjtDetail yhsSjjtDetail : details) {
                YhsSjjtAdjust adjust = new YhsSjjtAdjust();
                adjust.setSerialno(yhsSjjtDetail.getSerialno());
                adjust.setAdjustamount(BigDecimal.ZERO);
                adjust.setAmount(yhsSjjtDetail.getAmount());
                adjust.setTotalamount(yhsSjjtDetail.getAmount());
                adjust.setOrg(yhsSjjtDetail.getOrg());
                adjust.setAccountorg(yhsSjjtDetail.getAccountorg());
                adjust.setBizdimensionid(yhsSjjtDetail.getBizdimensionid());
                adjust.setSkssqq(yhsSjjtDetail.getSkssqq());
                adjust.setSkssqz(yhsSjjtDetail.getSkssqz());
                adjust.setTaxitem(yhsSjjtDetail.getTaxitem());
                adjust.setSubtaxitem(yhsSjjtDetail.getSubtaxitem());
                adjust.setRuleid(yhsSjjtDetail.getRuleid());
                adjusts.add(adjust);
            }
            YhsSjjtDetail yhsSjjtDetail = details.get(0);
            YhsSjjtAdjust adjust = new YhsSjjtAdjust();
            adjust.setTitlename(ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"YhsAccrualUtils_0", (String)"taxc-tcret", (Object[])new Object[0]));
            adjust.setAdjustexplain(ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d\u5b58\u5728\u8d1f\u6570\u60c5\u51b5\uff0c\u5df2\u8c03\u6574\u4e3a0", (String)"YhsAccrualUtils_1", (String)"taxc-tcret", (Object[])new Object[0]));
            adjust.setAdjustamount(amount);
            adjust.setTotalamount(amount);
            adjust.setOrg(yhsSjjtDetail.getOrg());
            adjust.setAccountorg(yhsSjjtDetail.getAccountorg());
            adjust.setBizdimensionid(yhsSjjtDetail.getBizdimensionid());
            adjust.setSkssqq(yhsSjjtDetail.getSkssqq());
            adjust.setSkssqz(yhsSjjtDetail.getSkssqz());
            adjust.setTaxitem(yhsSjjtDetail.getTaxitem());
            adjust.setSubtaxitem(yhsSjjtDetail.getSubtaxitem());
            adjust.setRuleid("0");
            adjusts.add(adjust);
            yhsSjjtData.setAdjusts(adjusts);
        }
    }
}

