/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.account;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.plugin.AbstractTaxFormPlugin;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;

public class CjfcyzPlugin
extends AbstractTaxFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(CjfcyzPlugin.class);
    private static final String ORG = "org";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String TAXPAYLIMIT = "taxpaylimit";
    private static final String HOUSEMANAGEMENT = "housemanagement";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String ADJUSTEDVALUE = "adjustedvalue";
    private static final String ADJUSTEDCJJZVALUE = "adjustedcjjzvalue";
    private static final String ADJUSTEDRENTVALUE = "adjustedrentvalue";
    private String taxLimitValue;
    private static final String CALCULATE = "calculate";
    private static final String ENTRYENTITY = "entryentity";
    private static final String FIELDS = "period,area,rentarea,selfusearea,vacancyarea,publicarea,cjjzratio,assertvalue,cjjzassertvalue";
    private static final String REGETDATA_KEY = "regetdata";

    protected String getStartTime() {
        return STARTDATE;
    }

    protected String getEndTime() {
        return ENDDATE;
    }

    protected String[] getTaxLimits() {
        return new String[]{this.taxLimitValue};
    }

    protected void setTaxLimit(String taxLimitValue) {
        this.taxLimitValue = taxLimitValue;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(NUMBER);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)NUMBER)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            QFilter qFilter = new QFilter("org.name", "=", (Object)org.getString(NAME));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            this.calculateAdjustmentValue();
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            DynamicObject number = (DynamicObject)this.getModel().getValue(NUMBER);
            Date startDate = (Date)this.getModel().getValue(STARTDATE);
            Date endDate = (Date)this.getModel().getValue(ENDDATE);
            if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"CjfcyzPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (org != null && number != null && startDate != null && endDate != null) {
                Long id = (Long)this.getModel().getDataEntity().getPkValue();
                DynamicObject[] cjfcyzftCollection = BusinessDataServiceHelper.load((String)"tcret_cjfcyzft_info", (String)"id,org,number,startdate,enddate,", (QFilter[])new QFilter[]{new QFilter(ORG, "=", (Object)org.getLong("id")), new QFilter(NUMBER, "=", (Object)number.getLong("id")), new QFilter("id", "!=", (Object)id)});
                if (cjfcyzftCollection.length > 0) {
                    ArrayList list = new ArrayList(cjfcyzftCollection.length);
                    for (DynamicObject dynamicObject : cjfcyzftCollection) {
                        Date start = (Date)dynamicObject.get(STARTDATE);
                        Date end = (Date)dynamicObject.get(ENDDATE);
                        HashMap<String, String> dateMap = new HashMap<String, String>(2);
                        dateMap.put(STARTDATE, DateUtils.format((Date)start));
                        dateMap.put(ENDDATE, DateUtils.format((Date)end));
                        list.add(dateMap);
                    }
                    for (Map map : list) {
                        boolean flag;
                        String start = (String)map.get(STARTDATE);
                        String end = (String)map.get(ENDDATE);
                        if (start == null || end == null || !(flag = this.match(DateUtils.format((Date)startDate), DateUtils.format((Date)endDate), start, end))) continue;
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5b58\u91cf\u91cd\u590d\u6570\u636e\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"CjfcyzPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        logger.info("\u4ece\u4ef7\u623f\u4ea7\u5206\u644a\u4fe1\u606f\u64cd\u4f5c\uff1a" + operateKey);
        if (REGETDATA_KEY.equals(operateKey)) {
            Object fcNumber = this.getModel().getValue(NUMBER);
            if (null == fcNumber) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u623f\u4ea7\u7f16\u7801", (String)"CjfcyzPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection cjmjftCollection = this.getModel().getEntryEntity(ENTRYENTITY);
            if (CollectionUtils.isEmpty((Collection)cjmjftCollection)) {
                return;
            }
            this.confirmRemind();
        }
    }

    public void afterBindData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.ADDNEW) {
            this.getView().setEnable(Boolean.TRUE, new String[]{STARTDATE});
            this.getView().setEnable(Boolean.TRUE, new String[]{ENDDATE});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{STARTDATE});
            this.getView().setEnable(Boolean.FALSE, new String[]{ENDDATE});
            DynamicObject number = (DynamicObject)this.getModel().getValue(NUMBER);
            if (number == null) {
                return;
            }
            ComboProp comboProp = (ComboProp)this.getModel().getProperty(TAXPAYLIMIT);
            String taxpaylimit = (String)this.getModel().getValue(TAXPAYLIMIT);
            DynamicObject fcfttz = BusinessDataServiceHelper.loadSingle((String)"tdm_fcs_basic_info", (String)"id,taxpaylimit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)number.getLong("id"))});
            String fcstaxpaylimit = fcfttz.getString(TAXPAYLIMIT);
            String displayName = comboProp.getItemByName(fcstaxpaylimit);
            HashMap<String, String> cachemap = new HashMap<String, String>();
            cachemap.put(TAXPAYLIMIT, fcstaxpaylimit);
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"taxpaylimitParams", cachemap);
            if (!taxpaylimit.equals(fcstaxpaylimit)) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(TAXPAYLIMIT, (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u623f\u4ea7\u7eb3\u7a0e\u671f\u9650\u5df2\u53d8\u66f4\u4e3a%1$s\uff0c\u662f\u5426\u6839\u636e\u53d8\u66f4\u540e\u7684\u7eb3\u7a0e\u671f\u9650\u91cd\u7f6e\u5f53\u524d\u4ece\u4ef7\u623f\u4ea7\u539f\u503c\u5206\u644a\u4fe1\u606f\u8bb0\u5f55\uff1f", (String)"CjfcyzPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]), displayName), MessageBoxOptions.OKCancel, confirmCallBackListener);
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        String itemKey = e.getItemKey();
        if (CALCULATE.equals(itemKey)) {
            this.calculateAdjustmentValue();
        }
    }

    public void confirmRemind() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(REGETDATA_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PbtDeclareHomePlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"PbtDeclareHomePlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u5c06\u5bfc\u81f4\u4ece\u4ef7\u9762\u79ef\u5206\u644a\u9762\u677f\u3010\u51fa\u79df\u9762\u79ef\u3011\u548c\u3010\u623f\u4ea7\u539f\u503c\u3011\u5355\u5143\u683c\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u53d6\u6570\uff0c\u786e\u5b9a\u662f\u5426\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"CjfcyzPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void regetData() {
        Object org = this.getModel().getValue(ORG);
        Object fcNumber = this.getModel().getValue(NUMBER);
        DynamicObjectCollection cjmjftCollection = this.getModel().getEntryEntity(ENTRYENTITY);
        QFilter q1 = new QFilter(ORG, "=", ((DynamicObject)org).get("id"));
        QFilter q2 = new QFilter("fcsbasicinfo", "=", ((DynamicObject)fcNumber).get("id"));
        QFilter q3 = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] fcczxxs = BusinessDataServiceHelper.load((String)"tdm_house_rental_info", (String)"rententryentity.startdate,rententryentity.enddate,hirearea", (QFilter[])new QFilter[]{q1, q2, q3});
        QFilter q11 = new QFilter(ORG, "=", ((DynamicObject)org).get("id"));
        QFilter q12 = new QFilter("id", "=", ((DynamicObject)fcNumber).get("id"));
        QFilter q13 = new QFilter("enable", "=", (Object)"1");
        DynamicObject fcjcxx = BusinessDataServiceHelper.loadSingle((String)"tdm_fcs_basic_info", (QFilter[])new QFilter[]{q11, q12, q13});
        DynamicObjectCollection fcjcxxCollection = fcjcxx.getDynamicObjectCollection("bgentryentity");
        int cunrrentRow = 0;
        for (DynamicObject cjmjftObj : cjmjftCollection) {
            BigDecimal czmj = BigDecimal.ZERO;
            BigDecimal fcyz = fcjcxx.getBigDecimal("assertvalue");
            Date period = DateUtils.stringToDate2((String)DateUtils.formatMonth((Date)cjmjftObj.getDate("period")), (String)"yyyy-MM");
            Date periodLastMonth = DateUtils.addMonth((Date)period, (int)-1);
            for (DynamicObject fcczxx : fcczxxs) {
                DynamicObjectCollection fcczxxCollection = fcczxx.getDynamicObjectCollection("rententryentity");
                for (DynamicObject obj : fcczxxCollection) {
                    if (DateUtils.stringToDate2((String)DateUtils.formatMonth((Date)obj.getDate(STARTDATE)), (String)"yyyy-MM").getTime() > period.getTime() || period.getTime() > DateUtils.stringToDate2((String)DateUtils.formatMonth((Date)obj.getDate(ENDDATE)), (String)"yyyy-MM").getTime()) continue;
                    czmj = czmj.add(obj.getBigDecimal("hirearea"));
                }
            }
            DynamicObject newDynamicObject = null;
            for (DynamicObject obj1 : fcjcxxCollection) {
                String currentDate = DateUtils.formatMonth((Date)obj1.getDate("bgdate"));
                if (newDynamicObject == null && currentDate.compareTo(DateUtils.formatMonth((Date)periodLastMonth)) < 1) {
                    newDynamicObject = obj1;
                }
                if (newDynamicObject == null || DateUtils.formatMonth((Date)newDynamicObject.getDate("bgdate")).compareTo(currentDate) >= 0 || currentDate.compareTo(DateUtils.formatMonth((Date)periodLastMonth)) >= 1) continue;
                newDynamicObject = obj1;
            }
            if (newDynamicObject != null) {
                fcyz = newDynamicObject.getBigDecimal("bgassertvalue");
            }
            if (czmj.compareTo(cjmjftObj.getBigDecimal("area")) > 0) {
                czmj = czmj.setScale(2, 4);
                String msg = String.format(ResManager.loadKDString((String)"\u671f\u95f4\u3010%1$s\u3011\u51fa\u79df\u9762\u79ef\u3010%2$s\u3011\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u623f\u4ea7\u5efa\u7b51\u9762\u79ef\u3002", (String)"CjfcyzPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]), DateUtils.formatMonth((Date)period), czmj);
                this.getView().showTipNotification(msg);
                String appId = this.getView().getFormShowParameter().getAppId();
                String operateNameCh = ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570", (String)"CjfcyzPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]);
                OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)"tcret_cjfcyzft_info", (String)operateNameCh, (String)msg);
                czmj = BigDecimal.ZERO;
            }
            for (String field : FIELDS.split(",")) {
                this.getModel().setValue(field, cjmjftObj.get(field), cunrrentRow);
                if ("rentarea".equals(field)) {
                    this.getModel().setValue(field, (Object)czmj, cunrrentRow);
                }
                if (!"assertvalue".equals(field)) continue;
                this.getModel().setValue(field, (Object)fcyz, cunrrentRow);
            }
            ++cunrrentRow;
        }
        this.getView().updateView(ENTRYENTITY);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        DynamicObject basicinfo;
        boolean dateSelect;
        this.taxLimitValue = (String)this.getModel().getValue(TAXPAYLIMIT);
        String propertyName = args.getProperty().getName();
        boolean bl = dateSelect = STARTDATE.equals(propertyName) || ENDDATE.equals(propertyName);
        if (dateSelect) {
            Date date;
            if (null == this.getModel().getValue(NUMBER)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u623f\u4ea7\u7f16\u7801", (String)"CjfcyzPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            if ((STARTDATE.equals(propertyName) || ENDDATE.equals(propertyName)) && (date = (Date)this.getModel().getValue(propertyName)) != null && StringUtil.isNotBlank((CharSequence)this.taxLimitValue)) {
                Map period = DateUtils.getPeriodByTaxLimit((Date)date, (String)this.taxLimitValue);
                this.getModel().setValue(STARTDATE, period.get("startDate"));
                this.getModel().setValue(ENDDATE, period.get("endDate"));
            }
            super.propertyChanged(args);
            if (!this.validDates) {
                return;
            }
            this.getModel().deleteEntryData(ENTRYENTITY);
            basicinfo = (DynamicObject)this.getModel().getValue(NUMBER);
            Date startDate = (Date)this.getModel().getValue(STARTDATE);
            Date endDate = (Date)this.getModel().getValue(ENDDATE);
            if (null == startDate || null == endDate || null == basicinfo) {
                return;
            }
            List monthList = DateUtils.getMonthBetween((Date)startDate, (Date)endDate);
            for (String month : monthList) {
                int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue("period", (Object)DateUtils.stringToDate((String)month, (String)"yyyy-MM"), index);
                this.getModel().setValue("area", basicinfo.get("area"), index);
                this.getModel().setValue("assertvalue", basicinfo.get("assertvalue"), index);
            }
            this.getView().updateView(ENTRYENTITY);
            this.getView().updateView();
        }
        if (NUMBER.equals(propertyName) && (basicinfo = (DynamicObject)this.getModel().getValue(NUMBER)) != null) {
            this.taxLimitValue = basicinfo.getString(TAXPAYLIMIT);
            this.getModel().setValue(NAME, basicinfo.get(NAME));
            this.getModel().setValue(HOUSEMANAGEMENT, basicinfo.get("basedatafield"));
            this.getModel().setValue(TAXPAYLIMIT, (Object)basicinfo.getString(TAXPAYLIMIT));
            this.getModel().setValue(STARTDATE, (Object)"");
            this.getModel().setValue(ENDDATE, (Object)"");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if (TAXPAYLIMIT.equals(callBackId)) {
                Map baseParamMap = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"taxpaylimitParams", Map.class);
                this.getModel().setValue(STARTDATE, null);
                this.getModel().setValue(ENDDATE, null);
                this.getModel().setValue(ADJUSTEDVALUE, null);
                this.getModel().setValue(ADJUSTEDCJJZVALUE, null);
                this.getModel().setValue(ADJUSTEDRENTVALUE, null);
                this.getModel().setValue(TAXPAYLIMIT, baseParamMap.get(TAXPAYLIMIT));
                this.getView().setEnable(Boolean.TRUE, new String[]{STARTDATE});
                this.getView().setEnable(Boolean.TRUE, new String[]{ENDDATE});
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.getView().updateView(ENTRYENTITY);
            }
            if (REGETDATA_KEY.equals(callBackId)) {
                try {
                    this.regetData();
                }
                catch (Exception t) {
                    throw new KDBizException("System Error:" + t);
                }
            }
        }
    }

    private void calculateAdjustmentValue() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRYENTITY);
        BigDecimal rows = new BigDecimal(this.getModel().getEntryRowCount(ENTRYENTITY));
        if (this.getModel().getEntryRowCount(ENTRYENTITY) > 0) {
            BigDecimal assertvaluesum = BigDecimal.ZERO;
            BigDecimal cjjzassertvaluesum = BigDecimal.ZERO;
            for (DynamicObject object : dynamicObjectCollection) {
                BigDecimal assertvalue = (BigDecimal)object.get("assertvalue");
                BigDecimal cjjzassertvalue = (BigDecimal)object.get("cjjzassertvalue");
                assertvaluesum = assertvaluesum.add(assertvalue);
                cjjzassertvaluesum = cjjzassertvaluesum.add(cjjzassertvalue);
            }
            this.getModel().setValue(ADJUSTEDVALUE, (Object)assertvaluesum.divide(rows, 4));
            this.getModel().setValue(ADJUSTEDCJJZVALUE, (Object)cjjzassertvaluesum.divide(rows, 4));
            this.getModel().setValue(ADJUSTEDRENTVALUE, (Object)assertvaluesum.divide(rows, 4).subtract(cjjzassertvaluesum.divide(rows, 2)));
        }
    }

    private boolean match(String projectStartTime1, String projectEndTime1, String projectStartTime2, String projectEndTime2) {
        LocalDate startTime1 = this.formatDate(projectStartTime1);
        LocalDate endTime1 = this.formatDate(projectEndTime1);
        LocalDate startTime2 = this.formatDate(projectStartTime2);
        LocalDate endTime2 = this.formatDate(projectEndTime2);
        if (Objects.isNull(startTime1) || Objects.isNull(startTime2) || Objects.isNull(endTime1) || Objects.isNull(endTime2)) {
            return true;
        }
        return !startTime2.isAfter(endTime1) && !startTime1.isAfter(endTime2);
    }

    private LocalDate formatDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        return LocalDate.parse(date);
    }
}

