/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.account;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.tcret.business.taxsource.fcs.CjfcyzftConvertBusinessService;

public class CjfcyzftConvertPlugin
extends AbstractListPlugin {
    private static final String MONTHBYMONTHPERMID = "408ROGC/BI5R";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String org = (String)customParams.get("org");
        if (StringUtils.isNotEmpty((CharSequence)org)) {
            this.getModel().setValue("org", (Object)Long.valueOf(org));
        }
        long currUserId = RequestContext.get().getCurrUserId();
        long orgId = RequestContext.get().getOrgId();
        HasPermOrgResult allPermOrgsByUserId = PermissionUtils.getAllPermOrgsByUserId((String)"tcret", (String)"tcret_cjfcyzft_info", (String)MONTHBYMONTHPERMID, (Long)currUserId);
        if (allPermOrgsByUserId != null && !allPermOrgsByUserId.hasAllOrgPerm() && !allPermOrgsByUserId.getHasPermOrgs().contains(orgId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"monthbymonth"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (CjfcyzftConvertBusinessService.OPERATEKEYS.contains(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            BillList list = (BillList)this.getControl("billlistap");
            try {
                this.openCjjzBaseInfoBill(list.getSelectedRows(), afterDoOperationEventArgs.getOperateKey());
            }
            catch (Exception e) {
                throw new KDBizException("System Error:" + e);
            }
        }
    }

    private void openCjjzBaseInfoBill(ListSelectedRowCollection selectedRows, String operateKey) {
        String appId = this.getView().getFormShowParameter().getAppId();
        StringBuilder stringBuilder = new StringBuilder();
        Object[] pks = selectedRows.getPrimaryKeyValues();
        DynamicObject[] cjfcyzftCollection = BusinessDataServiceHelper.load((String)"tcret_cjfcyzft_info", (String)"id,billno,org,billstatus,enable,name,number,modifier,modifytime,housemanagement,startdate,enddate,adjustedvalue,adjustedrentvalue,adjustedcjjzvalue,entryentity,entryentity.period,entryentity.cjjzassertvalue,entryentity.assertvalue", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        ArrayList<Long> numbers = new ArrayList<Long>(cjfcyzftCollection.length);
        for (DynamicObject obj : cjfcyzftCollection) {
            DynamicObject object = obj.getDynamicObject("number");
            numbers.add(object.getLong("id"));
        }
        DynamicObject[] fcsCollection = BusinessDataServiceHelper.load((String)"tdm_fcs_basic_info", (String)"id,org,name,number,basedatafield,acquiredate,changedate,housevalue,equipmentvalue,value,bgentryentity,bgentryentity.bgdate,bgentryentity.bgtype,bgentryentity.bghousevalue,bgentryentity.datasource,bgentryentity.bgequipmentvalue,bgentryentity.bgvalue,bgentryentity.bgassertvalue,bgentryentity.bghireassertvalue,bgentryentity.remark,bgentryentity.bgmodifier,bgentryentity.bgmodifydate", (QFilter[])new QFilter[]{new QFilter("id", "in", numbers)});
        HashMap<Long, DynamicObject> fcsmap = new HashMap<Long, DynamicObject>(fcsCollection.length);
        for (DynamicObject obj : fcsCollection) {
            fcsmap.put(obj.getLong("id"), obj);
        }
        ArrayList<DynamicObject> pushDataNew = new ArrayList<DynamicObject>();
        ArrayList<Long> duplicates = new ArrayList<Long>();
        ArrayList<String> duplicateNumbers = new ArrayList<String>();
        String operateName = ResManager.loadKDString((String)"\u4e0b\u63a8\u623f\u4ea7\u7a0e\u6e90", (String)"CjfcyzftConvertPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]);
        String operateCh = CjfcyzftConvertBusinessService.getOperateNameByKey(operateKey);
        for (DynamicObject cjfcobj : cjfcyzftCollection) {
            boolean checkStartDate;
            String operateDescription2 = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s,%2$s\u623f\u4ea7\u7a0e\u6e90\u5931\u8d25\u3002", (String)"CjfcyzftConvertPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]), cjfcobj.getString("billno"), operateCh);
            Date startdate = (Date)cjfcobj.get("startdate");
            Date enddate = (Date)cjfcobj.get("enddate");
            if (startdate == null || enddate == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u6240\u5c5e\u7a0e\u671f\u4e3a\u7a7a", (String)"CjfcyzftConvertPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]), cjfcobj.getString("billno")));
                continue;
            }
            Date convertdate = this.convertDate(startdate, enddate, operateKey);
            boolean bgdatestatu = true;
            DynamicObject object = cjfcobj.getDynamicObject("number");
            DynamicObject cjfchousemanagement = cjfcobj.getDynamicObject("housemanagement");
            Long key = object.getLong("id");
            DynamicObject fcsobj = (DynamicObject)fcsmap.get(key);
            Date acquiredate = (Date)fcsobj.get("acquiredate");
            Date changedate = (Date)fcsobj.get("changedate");
            DynamicObject fcshousemanagement = fcsobj.getDynamicObject("basedatafield");
            DynamicObjectCollection dynamicObjectCollection = fcsobj.getDynamicObjectCollection("bgentryentity");
            if (dynamicObjectCollection.size() == 0) {
                bgdatestatu = false;
            }
            for (DynamicObject object1 : dynamicObjectCollection) {
                Date fcsbgdate = (Date)object1.get("bgdate");
                if (DateUtils.format((Date)convertdate, (String)"yyyy-MM").equals(DateUtils.format((Date)fcsbgdate, (String)"yyyy-MM"))) {
                    bgdatestatu = true;
                    break;
                }
                bgdatestatu = false;
            }
            Date minDate = null;
            Date maxDate = null;
            if ("currentperiod".equals(operateKey)) {
                minDate = maxDate = DateUtils.addMonth((Date)startdate, (int)-1);
            }
            if ("nextperiod".equals(operateKey)) {
                minDate = maxDate = enddate;
            }
            if ("monthbymonth".equals(operateKey)) {
                DynamicObjectCollection cjmjCollection = cjfcobj.getDynamicObjectCollection("entryentity");
                if (cjmjCollection == null || cjmjCollection.size() == 0) {
                    return;
                }
                minDate = maxDate = ((DynamicObject)cjmjCollection.get(0)).getDate("period");
                for (DynamicObject obj : cjmjCollection) {
                    Date bgdate = obj.getDate("period");
                    if (bgdate.after(maxDate)) {
                        maxDate = bgdate;
                    }
                    if (!bgdate.before(minDate)) continue;
                    minDate = bgdate;
                }
                minDate = DateUtils.addMonth((Date)minDate, (int)-1);
                maxDate = DateUtils.addMonth((Date)maxDate, (int)-1);
            }
            boolean fttzDataEnbale = cjfcobj.get("enable").equals("1");
            boolean isSameHouseManagement = cjfchousemanagement.getString("id").equals(fcshousemanagement.getString("id"));
            boolean checkStartDate1 = acquiredate != null && DateUtils.stringToDate((String)DateUtils.format((Date)minDate, (String)"yyyy-MM"), (String)"yyyy-MM").after(DateUtils.stringToDate((String)DateUtils.format((Date)acquiredate, (String)"yyyy-MM"), (String)"yyyy-MM"));
            boolean checkStartDate2 = changedate == null || DateUtils.stringToDate((String)DateUtils.format((Date)maxDate, (String)"yyyy-MM"), (String)"yyyy-MM").before(DateUtils.stringToDate((String)DateUtils.format((Date)changedate, (String)"yyyy-MM"), (String)"yyyy-MM"));
            boolean bl = checkStartDate = checkStartDate1 && checkStartDate2;
            if (isSameHouseManagement && fttzDataEnbale && checkStartDate) {
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s,%2$s\u623f\u4ea7\u7a0e\u6e90\u6210\u529f\u3002", (String)"CjfcyzftConvertPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]), cjfcobj.getString("billno"), operateCh);
                if ("monthbymonth".equals(operateKey)) {
                    if (!CjfcyzftConvertBusinessService.checkDuplicateData(fcsobj, cjfcobj)) {
                        duplicates.add(cjfcobj.getLong("id"));
                        duplicateNumbers.add("\u3010" + cjfcobj.getString("billno") + "\u3011");
                        continue;
                    }
                    CjfcyzftConvertBusinessService.dataPushDownByMonth(fcsobj, cjfcobj, stringBuilder, true, pushDataNew);
                    OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)"tcret_cjfcyzft_info", (String)operateName, (String)operateDescription);
                    continue;
                }
                if (!bgdatestatu) {
                    CjfcyzftConvertBusinessService.dataPushDown(dynamicObjectCollection, convertdate, startdate, enddate, cjfcobj, fcsobj, stringBuilder, operateKey);
                    OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)"tcret_cjfcyzft_info", (String)operateName, (String)operateDescription);
                    continue;
                }
                duplicates.add(cjfcobj.getLong("id"));
                duplicateNumbers.add("\u3010" + cjfcobj.getString("billno") + "\u3011");
                continue;
            }
            if (!fttzDataEnbale && isSameHouseManagement) {
                stringBuilder.append(cjfcobj.getString("billno")).append("\t").append(ResManager.loadKDString((String)"\u5355\u636e\u4e3a\u7981\u7528\u72b6\u6001\uff0c", (String)"CjfcyzftConvertPlugin_10", (String)"taxc-tcret", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\u3002", (String)"CjfcyzftConvertPlugin_16", (String)"taxc-tcret", (Object[])new Object[0]));
                stringBuilder.append("\n");
                OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)"tcret_cjfcyzft_info", (String)operateName, (String)operateDescription2);
                continue;
            }
            stringBuilder.append(cjfcobj.getString("billno")).append("\t").append(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a", (String)"CjfcyzftConvertPlugin_4", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getDynamicObject("org").getString("name")).append("\t").append(ResManager.loadKDString((String)"\u623f\u4ea7\uff1a", (String)"CjfcyzftConvertPlugin_5", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getString("name")).append("\t").append(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a", (String)"CjfcyzftConvertPlugin_6", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getDynamicObject("number").getString("number")).append("\n");
            if (!isSameHouseManagement) {
                stringBuilder.append(ResManager.loadKDString((String)"\u4e0e\u623f\u4ea7\u7a0e\u6e90\u767b\u8bb0\u7684\u623f\u4ea7\u5c5e\u5730\u7ba1\u7406\u4e0d\u4e00\u81f4\uff0c", (String)"CjfcyzftConvertPlugin_15", (String)"taxc-tcret", (Object[])new Object[0]));
                if (!fttzDataEnbale) {
                    stringBuilder.append(ResManager.loadKDString((String)"\u4e14", (String)"CjfcyzftConvertPlugin_14", (String)"taxc-tcret", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5355\u636e\u4e3a\u7981\u7528\u72b6\u6001\uff0c", (String)"CjfcyzftConvertPlugin_10", (String)"taxc-tcret", (Object[])new Object[0]));
                }
            }
            if (fttzDataEnbale && isSameHouseManagement && !checkStartDate) {
                stringBuilder.append(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e\u671f\u53d8\u66f4\u53f0\u8d26\u53d8\u66f4\u65f6\u95f4", (String)"CjfcyzftConvertPlugin_11", (String)"taxc-tcret", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u53ea\u80fd\u5927\u4e8e\u623f\u4ea7\u53d6\u5f97\u65f6\u95f4\uff0c\u4e14\u5c0f\u4e8e\u7eb3\u7a0e\u4e49\u52a1\u7ec8\u6b62\u65f6\u95f4\uff0c", (String)"CjfcyzftConvertPlugin_12", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\u3002", (String)"CjfcyzftConvertPlugin_16", (String)"taxc-tcret", (Object[])new Object[0]));
            stringBuilder.append("\n");
            OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)"tcret_cjfcyzft_info", (String)operateName, (String)operateDescription2);
        }
        if (!CollectionUtils.isEmpty(duplicates)) {
            this.getPageCache().put("duplicates", JsonUtil.toJson(duplicates));
            this.getPageCache().put("remindMsg", stringBuilder.toString());
            this.getPageCache().put("operateType", operateKey);
            this.confirmRemind(duplicateNumbers);
        } else {
            this.showPrompt(stringBuilder.toString());
        }
    }

    public void confirmRemind(List<String> duplicateNumbers) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("pushDown", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PbtDeclareHomePlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"PbtDeclareHomePlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u4e0e\u623f\u4ea7\u7a0e\u6e90\u53d8\u66f4\u53f0\u8d26\u5b58\u5728\u91cd\u590d\u7a0e\u671f\u7684\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u8986\u76d6\uff1f", (String)"CjfcyzftConvertPlugin_27", (String)"taxc-tcret", (Object[])new Object[0]), Joiner.on((String)"\u3001").join(duplicateNumbers));
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        try {
            if ("pushDown".equals(callBackId)) {
                String appId = this.getView().getFormShowParameter().getAppId();
                String duplicates = this.getPageCache().get("duplicates");
                String remindMsg = this.getPageCache().get("remindMsg");
                StringBuilder remindMsgBuilder = new StringBuilder(remindMsg);
                String operateType = this.getPageCache().get("operateType");
                String operateName = ResManager.loadKDString((String)"\u4e0b\u63a8\u623f\u4ea7\u7a0e\u6e90", (String)"CjfcyzftConvertPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]);
                String operateCh = CjfcyzftConvertBusinessService.getOperateNameByKey(operateType);
                List ids = SerializationUtils.fromJsonStringToList((String)duplicates, Long.class);
                DynamicObject[] cjfcyzftCollection = BusinessDataServiceHelper.load((String)"tcret_cjfcyzft_info", (String)"id,billno,org,billstatus,enable,name,number,modifier,modifytime,housemanagement,startdate,enddate,adjustedvalue,adjustedrentvalue,adjustedcjjzvalue,entryentity.period,entryentity.cjjzassertvalue,entryentity.assertvalue", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
                boolean updateData = false;
                if (e.getResult() == MessageBoxResult.Yes) {
                    updateData = true;
                    ArrayList<Long> numbers = new ArrayList<Long>(cjfcyzftCollection.length);
                    for (DynamicObject obj : cjfcyzftCollection) {
                        DynamicObject[] object = obj.getDynamicObject("number");
                        numbers.add(object.getLong("id"));
                    }
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tdm_fcs_basic_info");
                    DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
                    DynamicObject[] fcsCollection = BusinessDataServiceHelper.load((Object[])numbers.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tdm_fcs_basic_info"));
                    HashMap<Long, DynamicObject> fcsmap = new HashMap<Long, DynamicObject>(fcsCollection.length);
                    for (DynamicObject obj : fcsCollection) {
                        fcsmap.put(obj.getLong("id"), obj);
                    }
                    ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>();
                    for (DynamicObject cjfcobj : cjfcyzftCollection) {
                        Long fcid = cjfcobj.getLong("number.id");
                        DynamicObject fcsobj = (DynamicObject)fcsmap.get(fcid);
                        String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s,%2$s\u623f\u4ea7\u7a0e\u6e90\u6210\u529f\u3002", (String)"CjfcyzftConvertPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]), cjfcobj.getString("billno"), operateCh);
                        if ("monthbymonth".equals(operateType)) {
                            CjfcyzftConvertBusinessService.dataPushDownByMonth(fcsobj, cjfcobj, remindMsgBuilder, updateData, updateDataList);
                        } else {
                            Date startdate = (Date)cjfcobj.get("startdate");
                            Date enddate = (Date)cjfcobj.get("enddate");
                            if (startdate == null || enddate == null) {
                                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u6240\u5c5e\u7a0e\u671f\u4e3a\u7a7a", (String)"CjfcyzftConvertPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]), cjfcobj.getString("billno")));
                                continue;
                            }
                            Date convertdate = this.convertDate(startdate, enddate, operateType);
                            CjfcyzftConvertBusinessService.dataPushDown(fcsobj.getDynamicObjectCollection("bgentryentity"), convertdate, startdate, enddate, cjfcobj, fcsobj, remindMsgBuilder, operateType);
                        }
                        OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)"tcret_cjfcyzft_info", (String)operateName, (String)operateDescription);
                    }
                    this.showPrompt(remindMsgBuilder.toString());
                }
                if (e.getResult() == MessageBoxResult.Cancel) {
                    for (DynamicObject obj : cjfcyzftCollection) {
                        remindMsgBuilder.append((CharSequence)CjfcyzftConvertBusinessService.getComonMsg(obj).append(ResManager.loadKDString((String)"\u4e0e\u623f\u4ea7\u7a0e\u6e90\u53d8\u66f4\u53f0\u8d26\u5b58\u5728\u91cd\u590d\u5c5e\u671f\u7684\u6570\u636e", (String)"CjfcyzftConvertPlugin_13", (String)"taxc-tcret", (Object[])new Object[0])).append("\uff0c").append(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\u3002", (String)"CjfcyzftConvertPlugin_16", (String)"taxc-tcret", (Object[])new Object[0])).append("\n"));
                        String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s,%2$s\u623f\u4ea7\u7a0e\u6e90\u5931\u8d25\u3002", (String)"CjfcyzftConvertPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]), obj.getString("billno"), operateCh);
                        OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)"tcret_cjfcyzft_info", (String)operateName, (String)operateDescription);
                    }
                    this.showPrompt(remindMsgBuilder.toString());
                }
            }
        }
        catch (Exception t) {
            throw new KDBizException("System Error:" + e);
        }
    }

    private void showPrompt(String string) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tcret_cjfcyzft_prompt");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("prompt", (Object)string);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u63a8\u7ed3\u679c\u63d0\u793a", (String)"CjfcyzftConvertPlugin_17", (String)"taxc-tcret", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private Date convertDate(Date startdate, Date enddate, String operateKey) {
        if (operateKey.equals("currentperiod")) {
            Date predate = DateUtils.addMonth((Date)startdate, (int)-1);
            return DateUtils.getLastDateOfMonth2((Date)predate);
        }
        return enddate;
    }
}

