/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.account;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class YhsTaxAccountListPlugin
extends AbstractListPlugin {
    private static final String AUTOGET = "autoget";
    private static final String ADDNEW = "addnew";
    private static final String TAXOFFICEMANAGE = "taxofficemanage";
    private static final String TCRET_YHSSYCJ_COMFIRM = "tcret_yhssycj_comfirm";
    private static final String TCRET_TAX_SOURCE_TZ = "tcret_tax_source_tz";
    private static final String TCRET_YHS_TAX_ACCOUNT = "tcret_yhs_tax_account";
    private static final String TCRET_YHSTZ_TJBZ = "tcret_yhstz_tjbz";
    private static final String TCRET_YHS_PREPAY_TC = "tcret_yhs_prepay_tc";
    private static final String TCRET_YHS_TAX_ACCOUNT_ADD = "tcret_yhs_tax_account_add";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("skssqq".equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
            String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("orgid");
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if (org == null || !filterColumn.getFieldName().equals("org.id") || !(filterColumn instanceof CommonFilterColumn)) continue;
            filterColumn.setDefaultValue(org.toString());
            this.getPageCache().put("verifyOrg", (String)org);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("org", this.getPageCache().get("verifyOrg"));
        if (AUTOGET.equals(itemKey)) {
            String operateName = ResManager.loadKDString((String)"\u81ea\u52a8\u53d6\u6570", (String)"YhsTaxAccountListPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u6253\u5f00\u5370\u82b1\u7a0e\u53f0\u8d26\u81ea\u52a8\u53d6\u6570\u9875\u9762\u6210\u529f", (String)"YhsTaxAccountListPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]), new Object[0]);
            OperatorDialogUtils.operateDialog((String)"ccxws", (String)TCRET_YHS_TAX_ACCOUNT, (String)operateName, (String)operateDescription);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCRET_YHSSYCJ_COMFIRM, (IFormView)this.getView(), customParams, (IFormPlugin)this);
        } else if (TAXOFFICEMANAGE.equals(itemKey)) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bastax_taxorgan", (boolean)false, (int)2);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TAXOFFICEMANAGE));
            this.getView().showForm((FormShowParameter)parameter);
            String operateName = ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u7ba1\u7406", (String)"YhsTaxAccountListPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u6253\u5f00\u5370\u82b1\u7a0e\u53f0\u8d26\u7a0e\u52a1\u673a\u5173\u7ba1\u7406\u9875\u9762\u6210\u529f\u3002", (String)"YhsTaxAccountListPlugin_8", (String)"taxc-tcret", (Object[])new Object[0]), new Object[0]);
            OperatorDialogUtils.operateDialog((String)"ccxws", (String)TCRET_YHS_TAX_ACCOUNT, (String)operateName, (String)operateDescription);
        } else if (ADDNEW.equals(itemKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            this.setOrgid(showParameter);
            showParameter.setFormId(TCRET_YHS_TAX_ACCOUNT_ADD);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDNEW));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(showParameter);
        }
    }

    private void setOrgid(FormShowParameter showParameter) {
        String orgid = this.getPageCache().get("verifyOrg");
        showParameter.setCustomParam("org", (Object)(StringUtil.isNotBlank((CharSequence)orgid) ? Long.parseLong(orgid) : RequestContext.get().getOrgId()));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        String actionId = e.getActionId();
        BillList list = (BillList)this.getControl("billlistap");
        if (TCRET_YHSSYCJ_COMFIRM.equals(actionId) || TCRET_TAX_SOURCE_TZ.equals(actionId) || TCRET_YHSTZ_TJBZ.equals(actionId) || TCRET_YHS_PREPAY_TC.equals(actionId)) {
            list.refresh();
        } else if (TAXOFFICEMANAGE.equals(actionId)) {
            ListSelectedRowCollection returnData2 = (ListSelectedRowCollection)e.getReturnData();
            if (EmptyCheckUtils.isNotEmpty((Object)returnData2)) {
                this.updateTaxoffice(returnData2);
                String operateName = ResManager.loadKDString((String)"\u786e\u5b9a", (String)"YhsTaxAccountListPlugin_9", (String)"taxc-tcret", (Object[])new Object[0]);
                String operateDescription = String.format(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u53f0\u8d26\u7a0e\u52a1\u673a\u5173\u7ba1\u7406\u6210\u529f\u3002", (String)"YhsTaxAccountListPlugin_10", (String)"taxc-tcret", (Object[])new Object[0]), new Object[0]);
                OperatorDialogUtils.operateDialog((String)"ccxws", (String)TCRET_YHS_TAX_ACCOUNT, (String)operateName, (String)operateDescription);
            }
        } else if (ADDNEW.equals(actionId) && EmptyCheckUtils.isNotEmpty((Object)(returnData = e.getReturnData()))) {
            String msg = ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f", (String)"YhsTaxAccountListPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRow rowInfo = list.getCurrentSelectedRowInfo();
        Long pkid = (Long)rowInfo.getPrimaryKeyValue();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)rowInfo.getPrimaryKeyValue(), (String)TCRET_YHS_TAX_ACCOUNT);
        if (args.getFieldName().equals("remark")) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("billid", rowInfo.getPrimaryKeyValue());
            customParams.put("remark", object.getString("remark"));
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCRET_YHSTZ_TJBZ, (IFormView)this.getView(), customParams, (IFormPlugin)this);
            args.setCancel(true);
        } else if (args.getFieldName().equals("calctaxamount") && object != null) {
            String datasource = object.getString("datasource");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("billid", rowInfo.getPrimaryKeyValue());
            if (StringUtil.equals((CharSequence)"system", (CharSequence)datasource)) {
                customParams.put("org", String.valueOf(object.get("org.id")));
                customParams.put("skssqq", DateUtils.format((Date)object.getDate("skssqq")));
                customParams.put("skssqz", DateUtils.format((Date)object.getDate("skssqz")));
                customParams.put("serialno", object.getString("serialno"));
                customParams.put("accountorg", object.getString("accountorg.id"));
                customParams.put("bizdimensionid", object.getString("bizdimensionid"));
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCRET_TAX_SOURCE_TZ, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                args.setCancel(true);
            } else if (StringUtil.equals((CharSequence)"prepay", (CharSequence)datasource)) {
                customParams.put("pkid", pkid);
                customParams.put("org", String.valueOf(object.get("org.id")));
                customParams.put("skssqq", DateUtils.format((Date)object.getDate("skssqq")));
                customParams.put("skssqz", DateUtils.format((Date)object.getDate("skssqz")));
                customParams.put("serialno", object.getString("id"));
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCRET_YHS_PREPAY_TC, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                args.setCancel(true);
            }
        }
    }

    private void updateTaxoffice(ListSelectedRowCollection returnData) {
        DynamicObject[] dynamicObjects;
        ListSelectedRow row = returnData.get(0);
        Long taxofficeId = (Long)row.getPrimaryKeyValue();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Map<Object, Object> rowkeyMap = selectedRows.stream().collect(Collectors.toMap(ListSelectedRow::getPrimaryKeyValue, ListSelectedRow2 -> ListSelectedRow2.getRowKey() + 1));
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCRET_YHS_TAX_ACCOUNT))) {
            if (dynamicObject.get("datasource").equals("prepay")) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4ece\u589e\u503c\u7a0e\u9884\u7f34\u7533\u62a5\u8868\u5185\u53d6\u6570\uff0c\u4e0d\u80fd\u5207\u6362\u7a0e\u52a1\u673a\u5173\uff0c\u8bf7\u5173\u95ed\u4ece\u9884\u7f34\u7533\u62a5\u8868\u53d6\u6570\u53c2\u6570\u540e\uff0c\u518d\u64cd\u4f5c", (String)"YhsTaxAccountListPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]), rowkeyMap.get(dynamicObject.get("id"))));
                continue;
            }
            dynamicObject.set("taxoffice", (Object)taxofficeId);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        billList.refresh();
    }
}

