/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.accrual.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.common.constant.TcretAccrualConstant;
import kd.taxc.tcret.common.entity.AccrualCalcDto;
import kd.taxc.tcret.common.enums.FcsTypeEnum;
import kd.taxc.tcret.common.utils.CalUtils;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;
import kd.taxc.tcret.common.utils.TcretSystemParamUtil;

public abstract class AbstractFcsAccrualDraftCalHandler
implements TcretAccrualConstant {
    protected abstract FcsTypeEnum getType();

    protected abstract void setOtherValue(DynamicObject var1, DynamicObject var2, Long var3, String var4);

    protected abstract BigDecimal getCurrentPayable(BigDecimal var1, Date var2, Date var3, DynamicObject var4, DynamicObject var5, DynamicObject var6, String var7);

    public List<DynamicObject> cal(AccrualCalcDto accrualCalcDto) {
        DynamicObject[] sources = this.queryTaxSource(accrualCalcDto, this.getType());
        Long orgId = accrualCalcDto.getOrgId();
        Boolean changeEffectCurrentMonth = TcretSystemParamUtil.getChangeEffectCurrentMonth(orgId);
        ArrayList<DynamicObject> accrualDetailList = new ArrayList<DynamicObject>();
        for (DynamicObject source : sources) {
            List<DynamicObject> detailList = this.calDetail(source, this.getType(), accrualCalcDto, changeEffectCurrentMonth);
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(detailList)) continue;
            accrualDetailList.addAll(detailList);
        }
        this.calXgmJM(accrualDetailList);
        return accrualDetailList;
    }

    protected DynamicObject[] queryTaxSource(AccrualCalcDto accrualCalcDto, FcsTypeEnum fcsTypeEnum) {
        String entityName;
        DynamicObjectCollection ids;
        Long orgId = accrualCalcDto.getOrgId();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        if (FcsTypeEnum.FCS_BY_HIRE == fcsTypeEnum) {
            qFilters.add(new QFilter("fcsapanage.number", "!=", (Object)"SZSSWJ"));
        }
        if (!CollectionUtils.isEmpty((Collection)(ids = QueryServiceHelper.query((String)(entityName = fcsTypeEnum.getSourceEntity()), (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]))))) {
            return BusinessDataServiceHelper.load((Object[])ids.stream().map(e -> e.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        }
        return new DynamicObject[0];
    }

    protected List<DynamicObject> calDetail(DynamicObject source, FcsTypeEnum fcsTypeEnum, AccrualCalcDto accrualCalcDto, Boolean changeEffectCurrentMonth) {
        Date skssqq = accrualCalcDto.getSkssqq();
        Date skssqz = accrualCalcDto.getSkssqz();
        BigDecimal taxRate = this.getTaxRate(fcsTypeEnum, skssqq, skssqz);
        ArrayList<DynamicObject> splitObjects = new ArrayList();
        if (fcsTypeEnum == FcsTypeEnum.FCS_BY_PRICE || fcsTypeEnum == FcsTypeEnum.TDS) {
            Date changedate;
            Date acquiredate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)source.getDate(fcsTypeEnum.getAcquiredateKey()), (int)1));
            if (acquiredate.compareTo(skssqq) > 0) {
                skssqq = acquiredate;
            }
            if ((changedate = source.getDate(fcsTypeEnum.getChangedateKey())) != null && DateUtils.getLastDateOfMonth((Date)changedate).compareTo(skssqz) < 0) {
                skssqz = DateUtils.getLastDateOfMonth((Date)changedate);
            }
            if (skssqq.compareTo(skssqz) >= 0) {
                return null;
            }
            splitObjects = this.splitByBgEntryEntity(taxRate, skssqq, skssqz, fcsTypeEnum, source, changeEffectCurrentMonth);
        } else {
            String entityName = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.VIEW, (String)fcsTypeEnum.getEntityName());
            DynamicObject targetObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            targetObject.set("skssqq", (Object)skssqq);
            targetObject.set("skssqz", (Object)skssqz);
            BigDecimal currentPable = this.getCurrentPayable(taxRate, skssqq, skssqz, source, targetObject, null, fcsTypeEnum.getType());
            if (currentPable.compareTo(MAX_EPSILON) <= 0 && currentPable.compareTo(MIN_EPSILON) >= 0) {
                return null;
            }
            targetObject.set("currentpayable", (Object)currentPable);
            splitObjects.add(targetObject);
        }
        if (CollectionUtils.isEmpty(splitObjects)) {
            return splitObjects;
        }
        for (DynamicObject obj : splitObjects) {
            if (fcsTypeEnum == FcsTypeEnum.FCS_BY_PRICE || fcsTypeEnum == FcsTypeEnum.FCS_BY_HIRE) {
                obj.set("taxrate", (Object)taxRate);
            }
            Long orgId = accrualCalcDto.getOrgId();
            this.setOtherValue(source, obj, orgId, fcsTypeEnum.getType());
            obj.set("sourceid", (Object)source);
            obj.set("org", (Object)orgId);
        }
        return splitObjects;
    }

    private List<DynamicObject> splitByBgEntryEntity(BigDecimal taxRate, Date skssqq, Date skssqz, FcsTypeEnum fcsTypeEnum, DynamicObject sourceObject, Boolean changeEffectCurrentMonth) {
        DynamicObjectCollection bgentryentity = sourceObject.getDynamicObjectCollection("bgentryentity");
        bgentryentity.sort(Comparator.comparing(d -> d.getDate("bgdate")));
        LinkedHashMap<Date, DynamicObject> map = new LinkedHashMap<Date, DynamicObject>();
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.add(skssqq);
        for (DynamicObject object : bgentryentity) {
            Date start;
            Date end;
            Date bgdate = object.getDate("bgdate");
            if (changeEffectCurrentMonth.booleanValue()) {
                end = DateUtils.getLastDateOfMonth1((Date)DateUtils.addMonth((Date)bgdate, (int)-1));
                start = DateUtils.getFirstDateOfMonth((Date)bgdate);
            } else {
                end = DateUtils.getLastDateOfMonth1((Date)bgdate);
                start = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)bgdate, (int)1));
            }
            if (end.compareTo(skssqq) > 0 && start.compareTo(skssqz) < 0) {
                dates.add(end);
                dates.add(start);
            }
            map.put(start, object);
        }
        dates.add(skssqz);
        ArrayList<DynamicObject> splitObjects = new ArrayList<DynamicObject>(dates.size() / 2);
        for (int i = 0; i < dates.size(); i += 2) {
            Date startdate = (Date)dates.get(i);
            Date enddate = (Date)dates.get(i + 1);
            String entityName = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.VIEW, (String)fcsTypeEnum.getEntityName());
            DynamicObject targetObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            targetObject.set("skssqq", (Object)startdate);
            targetObject.set("skssqz", (Object)enddate);
            DynamicObject entryEntity = this.getEntryEntity(map, startdate);
            BigDecimal currentPable = this.getCurrentPayable(taxRate, startdate, enddate, sourceObject, targetObject, entryEntity, fcsTypeEnum.getType());
            if (currentPable.compareTo(MAX_EPSILON) <= 0 && currentPable.compareTo(MIN_EPSILON) >= 0) continue;
            targetObject.set("currentpayable", (Object)currentPable);
            splitObjects.add(targetObject);
        }
        return splitObjects;
    }

    private DynamicObject getEntryEntity(Map<Date, DynamicObject> map, Date startdate) {
        DynamicObject object = null;
        for (Map.Entry<Date, DynamicObject> entry : map.entrySet()) {
            Date date = entry.getKey();
            if (date.compareTo(startdate) > 0) continue;
            object = entry.getValue();
        }
        return object;
    }

    private BigDecimal getTaxRate(FcsTypeEnum fcsTypeEnum, Date skssqq, Date skssqz) {
        String taxRatioMergeCode = FcsTypeEnum.FCS_BY_PRICE == fcsTypeEnum ? "01" : "02";
        QFilter q1 = new QFilter("number", "=", (Object)"007");
        QFilter q2 = new QFilter("startdate", "<=", (Object)skssqq);
        QFilter q3 = new QFilter("enddate", "is null", null).or(new QFilter("enddate", ">=", (Object)skssqz));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tpo_tcret_taxrate", (String)"entryentity.mergecode,entryentity.taxrate,startdate,enddate", (QFilter[])new QFilter[]{q1, q2, q3});
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return new BigDecimal(0);
        }
        String ratio = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String[] taxRates;
            DynamicObjectCollection sonItems = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject sonObj : sonItems) {
                if (!taxRatioMergeCode.equals(sonObj.getString("mergecode"))) continue;
                ratio = sonObj.getString("taxrate");
                break;
            }
            if (null == ratio || ratio.trim().length() == 0 || (taxRates = ratio.split("%")).length < 1) continue;
            return BigDecimalUtil.divideObject((Object)taxRates[0], (Object)100, (int)10);
        }
        return new BigDecimal(0);
    }

    protected static int getMinusMonths(Date start, Date end, Date skssqq, Date skssqz) {
        if (end != null) {
            Date minDate = end.before(skssqz) ? end : skssqz;
            Date maxDate = start.after(skssqq) ? start : skssqq;
            int monthDiff = AbstractFcsAccrualDraftCalHandler.minusMonth(minDate, maxDate);
            return monthDiff < 0 ? 0 : monthDiff + 1;
        }
        Date minDate = skssqz;
        Date maxDate = start.after(skssqq) ? start : skssqq;
        int monthDiff = AbstractFcsAccrualDraftCalHandler.minusMonth(minDate, maxDate);
        return monthDiff < 0 ? 0 : monthDiff + 1;
    }

    protected static Integer minusMonth(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        int result = start.get(2) - end.get(2);
        int month = (start.get(1) - end.get(1)) * 12;
        return month + result;
    }

    private void calXgmJM(List<DynamicObject> accrualList) {
        Map<String, List<DynamicObject>> collect = accrualList.stream().collect(Collectors.groupingBy(e -> e.getString("number") + DateUtils.format((Date)e.getDate("skssqq")) + DateUtils.format((Date)e.getDate("skssqz"))));
        collect.forEach((k, v) -> {
            DynamicObject mainAccrualObj = (DynamicObject)v.get(0);
            String reliefPolicyType = TaxBaseDataUtils.getReliefPolicyType((Long)mainAccrualObj.getLong("org"), (Date)mainAccrualObj.getDate("skssqq"), (Date)mainAccrualObj.getDate("skssqz"), (boolean)true);
            if (StringUtil.isNotBlank((CharSequence)reliefPolicyType)) {
                BigDecimal currentpayable = CalUtils.calcAmount(v, "currentpayable");
                BigDecimal currentjmamount = CalUtils.calcAmount(v, "currentjmamount");
                BigDecimal jmhse = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.subtractObject((Object)currentpayable, (Object)currentjmamount), (Object)RATE, (int)2, (int)4);
                DynamicObject changeRecord = OrgChangeRecordUtil.loadChangeRecord((String)mainAccrualObj.getString("org"), (Date)mainAccrualObj.getDate("skssqq"), (Date)mainAccrualObj.getDate("skssqz"));
                jmhse = PbtDeclareUtil.ajustJmse(reliefPolicyType, changeRecord, mainAccrualObj.getDate("skssqq"), mainAccrualObj.getDate("skssqz"), jmhse);
                mainAccrualObj.set("currentjmamount", (Object)mainAccrualObj.getBigDecimal("currentjmamount").add(jmhse));
            }
        });
    }
}

