/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.accrual.handler;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.common.enums.FcsTypeEnum;
import kd.taxc.tcret.formplugin.accrual.handler.AbstractFcsAccrualDraftCalHandler;

public class FcsPriceAccrualCalHandler
extends AbstractFcsAccrualDraftCalHandler {
    @Override
    protected FcsTypeEnum getType() {
        return FcsTypeEnum.FCS_BY_PRICE;
    }

    @Override
    protected void setOtherValue(DynamicObject source, DynamicObject target, Long orgId, String type) {
        Date skssqq = target.getDate("skssqq");
        Date skssqz = target.getDate("skssqz");
        String fields = "taxpayer,number,name,fixassertnumber,fixassertunitcode,taxauthority,landnumber,detailaddr,buildingusage,acquiredate,changedate,changetype,area,taxratio";
        for (String field : fields.split(",")) {
            target.set(field, source.get(field));
        }
        target.set("taxlimit", source.get("taxpaylimit"));
        this.setJmAmount(source, target, skssqq, skssqz);
    }

    @Override
    protected BigDecimal getCurrentPayable(BigDecimal taxRate, Date startdate, Date enddate, DynamicObject sourceObject, DynamicObject targetObject, DynamicObject entry, String tabKey) {
        int monthLength = DateUtils.getMonthDiff((Date)enddate, (Date)startdate) + 1;
        BigDecimal assertValue = sourceObject.getBigDecimal("assertvalue");
        BigDecimal hireAssertValue = sourceObject.getBigDecimal("hireassertvalue");
        Date changeDate = sourceObject.getDate(FcsTypeEnum.FCS_BY_PRICE.getChangedateKey());
        String changeType = sourceObject.getString("changetype");
        if (entry != null) {
            assertValue = entry.getBigDecimal("bgassertvalue");
            hireAssertValue = entry.getBigDecimal("bghireassertvalue");
        }
        if (changeDate == null || changeDate.compareTo(startdate) < 0 || changeDate.compareTo(enddate) > 0) {
            if (entry != null) {
                changeDate = entry.getDate("bgdate");
                changeType = entry.getString("bgtype");
            } else {
                changeDate = null;
                changeType = null;
            }
        }
        targetObject.set("assertvalue", (Object)assertValue);
        targetObject.set("rentalvalue", (Object)hireAssertValue);
        targetObject.set("changedate", (Object)changeDate);
        targetObject.set("changetype", (Object)changeType);
        BigDecimal taxRatio = (BigDecimal)sourceObject.get("taxratio");
        if (null == assertValue || null == hireAssertValue || null == taxRatio) {
            return BigDecimal.ZERO;
        }
        BigDecimal taxbasis = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.subtractObject((Object)assertValue, (Object)hireAssertValue), (Object)taxRatio, (int)2, (int)4);
        targetObject.set("taxbasis", (Object)taxbasis);
        return BigDecimalUtil.divideObject((Object)assertValue.subtract(hireAssertValue).multiply(taxRatio).multiply(taxRate).multiply(new BigDecimal(monthLength)), (Object)12, (int)2);
    }

    protected void setJmAmount(DynamicObject sourceObject, DynamicObject targetObject, Date skssqq, Date skssqz) {
        BigDecimal totalJmamount = BigDecimal.ZERO;
        BigDecimal currentpayable = targetObject.getBigDecimal("currentpayable");
        BigDecimal originalAmount = BigDecimalUtil.subtractObject((Object)targetObject.getBigDecimal("assertvalue"), (Object)targetObject.getBigDecimal("rentalvalue"));
        DynamicObjectCollection entryentity = targetObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection sourceJmEntity = sourceObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject sourceJmObject : sourceJmEntity) {
            Date end;
            Date start = sourceJmObject.getDate("start");
            int minusMonths = FcsPriceAccrualCalHandler.getMinusMonths(start, end = sourceJmObject.getDate("end"), skssqq, skssqz);
            if (minusMonths <= 0) continue;
            DynamicObject entry = entryentity.addNew();
            String registerule = sourceJmObject.getString("registerule");
            BigDecimal amount = sourceJmObject.getBigDecimal("entervalue");
            if ("1".equals(registerule) || "2".equals(registerule)) {
                BigDecimal registeretio = sourceJmObject.getBigDecimal("registeretio");
                amount = BigDecimalUtil.multiplyObject((Object)originalAmount, (Object)registeretio, (int)2, (int)4);
            }
            entry.set("amount", (Object)amount);
            DynamicObject taxdeduction = sourceJmObject.getDynamicObject("taxdeduction");
            entry.set("jmcode", (Object)taxdeduction);
            BigDecimal jmamount = BigDecimal.ZERO;
            String deductiontype = taxdeduction.getString("deductiontype");
            BigDecimal taxrate = targetObject.getBigDecimal("taxrate");
            BigDecimal taxratio = targetObject.getBigDecimal("taxratio");
            boolean monthly = sourceJmObject.getBoolean("monthly");
            if (monthly || "6".equals(deductiontype)) {
                jmamount = BigDecimalUtil.multiplyObject((Object)sourceJmObject.getBigDecimal("monthlimit"), (Object)new BigDecimal(minusMonths), (int)2);
                jmamount = BigDecimalUtil.min((Object)jmamount, (Object)currentpayable);
            } else if ("1".equals(deductiontype)) {
                jmamount = amount.multiply(taxrate).multiply(taxratio).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(12), 2, 4);
            } else if ("2".equals(deductiontype)) {
                jmamount = amount.multiply(sourceJmObject.getBigDecimal("ratio")).multiply(taxrate).multiply(taxratio).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(12), 2, 4);
            }
            entry.set("jmamount", (Object)jmamount);
            totalJmamount = BigDecimalUtil.addObject((Object)totalJmamount, (Object)jmamount);
            entry.set("start", sourceJmObject.get("start"));
            entry.set("end", sourceJmObject.get("end"));
            BigDecimal yjmamount = BigDecimalUtil.divideObject((Object)jmamount, (Object)minusMonths, (int)2);
            entry.set("yjmamount", (Object)yjmamount);
        }
        targetObject.set("currentjmamount", (Object)totalJmamount);
    }
}

