/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.apphome;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public abstract class AbstractTcretTaxStatisticsPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(AbstractTcretTaxStatisticsPlugin.class);
    private IPageCache parentPageCache;
    private static final String YBSE = "ybse";
    private static final String JMSE = "jmse";

    public void afterCreateNewData(EventObject e) {
        this.refreshData();
    }

    private void refreshData() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"typeemptypanel"});
        IPageCache parentPageCache = this.getParentPageCache();
        if (parentPageCache == null) {
            return;
        }
        String orgid = parentPageCache.get("org");
        String declaremonth = parentPageCache.get("declaremonth");
        if (orgid == null || declaremonth == null) {
            this.showNoDataImg();
            return;
        }
        List<String> sbbidList = this.getSbbidList(orgid, declaremonth);
        BigDecimal bqybtsehj = this.getHj(sbbidList);
        if (bqybtsehj == null || BigDecimal.ZERO.compareTo(bqybtsehj) == 0) {
            this.showNoDataImg();
            return;
        }
        PieChart chart = (PieChart)this.getControl("piechartap");
        chart.clearData();
        PieSeries series = chart.createSeries(ResManager.loadKDString((String)"\u7eb3\u7a0e\u7edf\u8ba1", (String)"AbstractTcretTaxStatisticsPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"AbstractTcretTaxStatisticsPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]), (Number)this.getYhs(sbbidList).setScale(2, RoundingMode.HALF_UP), "#3F82F1"));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"AbstractTcretTaxStatisticsPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]), (Number)this.getFcs(sbbidList).setScale(2, RoundingMode.HALF_UP), "#4FCE9A"));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", (String)"AbstractTcretTaxStatisticsPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]), (Number)this.getTds(sbbidList).setScale(2, RoundingMode.HALF_UP), "#FEC035"));
        Map itemNormalStyle = series.getItemNormalStyle();
        HashMap<String, Boolean> lableMap = new HashMap<String, Boolean>();
        lableMap.put("show", Boolean.FALSE);
        itemNormalStyle.put("label", lableMap);
        HashMap<String, Boolean> lableLineMap = new HashMap<String, Boolean>();
        lableLineMap.put("show", Boolean.FALSE);
        itemNormalStyle.put("labelLine", lableLineMap);
        series.setRadius("50%", "70%");
        Map<String, Object> values = this.getValues(series);
        if (values != null) {
            this.setEmphasisLabel(values);
        }
        chart.setShowTooltip(true);
        chart.addTooltip("trigger", (Object)"item");
        chart.addTooltip("formatter", (Object)ResManager.loadKDString((String)"{a} <br/>{b} : {c}\u5143 ({d}%)", (String)"AbstractTcretTaxStatisticsPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
        chart.setLegendAlign(XAlign.right, YAlign.top);
        chart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 23});
        chart.setName(new LocaleString(String.format(ResManager.loadKDString((String)"\u5408\u8ba1%s", (String)"AbstractTcretTaxStatisticsPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]), BigDecimalUtil.format((Object)bqybtsehj, (String)",##0.00#"))));
        chart.setShowTitle(true);
        chart.setTitleAlign(XAlign.center, YAlign.center);
        chart.refresh();
        this.getView().updateView("content");
    }

    private List<String> getSbbidList(String orgid, String declaremonth) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String taxoffice = this.parentPageCache.get("taxoffice");
        filters.add(new QFilter("org", "=", (Object)Long.parseLong(orgid)));
        if (StringUtils.isNotBlank((CharSequence)taxoffice)) {
            filters.add(new QFilter("taxauthority", "=", (Object)Long.parseLong(taxoffice)));
        }
        Date date = DateUtils.stringToDate((String)declaremonth);
        Date start = DateUtils.getFirstDateOfMonth((Date)date);
        Date end = DateUtils.getLastDateOfMonth((Date)date);
        filters.add(new QFilter("declaredate", ">=", (Object)start).and("declaredate", "<=", (Object)end));
        DynamicObject[] allMainData = BusinessDataServiceHelper.load((String)"tcret_declare_main", (String)"id,sbbid", (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<String> sbbidList = new ArrayList<String>();
        for (DynamicObject allMainDatum : allMainData) {
            long id;
            DynamicObject[] nsrxx;
            String sbbid = allMainDatum.getString("sbbid");
            if (StringUtils.isBlank((CharSequence)sbbid) && (nsrxx = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{new QFilter("maindataid", "=", (Object)(id = allMainDatum.getLong("id")))})) != null && nsrxx.length > 0) {
                sbbid = nsrxx[0].getString("id");
            }
            if (!StringUtils.isNotBlank((CharSequence)sbbid)) continue;
            sbbidList.add(sbbid);
        }
        Set<String> ignoreSbbSet = this.getIgnoreSbbSet(sbbidList);
        sbbidList.removeAll(ignoreSbbSet);
        return sbbidList;
    }

    private void showNoDataImg() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"typeemptypanel"});
    }

    private void setEmphasisLabel(Map<String, Object> values) {
        Map itemStyle = (Map)values.get("itemStyle");
        HashMap emphasisMap = new HashMap();
        HashMap<String, Serializable> labelMap = new HashMap<String, Serializable>();
        HashMap<String, String> textStyleMap = new HashMap<String, String>();
        textStyleMap.put("fontSize", "24");
        textStyleMap.put("fontWeight", "bold");
        labelMap.put("show", Boolean.FALSE);
        labelMap.put("textStyle", textStyleMap);
        emphasisMap.put("label", labelMap);
        HashMap<String, Boolean> labelLineMap = new HashMap<String, Boolean>();
        labelLineMap.put("show", Boolean.FALSE);
        emphasisMap.put("labelLine", labelLineMap);
        itemStyle.put("emphasis", emphasisMap);
    }

    private Map<String, Object> getValues(PieSeries series) {
        try {
            Class<?> clazz = Class.forName("kd.bos.form.chart.Series");
            Method getValues = clazz.getDeclaredMethod("getValues", new Class[0]);
            AccessibleObject.setAccessible(new AccessibleObject[]{getValues}, Boolean.TRUE);
            return (Map)getValues.invoke((Object)series, (Object[])null);
        }
        catch (Exception var4) {
            logger.error(var4.getMessage());
            return null;
        }
    }

    private IPageCache getParentPageCache() {
        IFormView parentView;
        if (this.parentPageCache == null && (parentView = this.getView().getParentView()) != null) {
            this.parentPageCache = (IPageCache)parentView.getService(IPageCache.class);
        }
        return this.parentPageCache;
    }

    private Set<String> getIgnoreSbbSet(List<String> sbbidList) {
        HashSet<String> ignoreSbbSet = new HashSet<String>(4);
        DynamicObjectCollection ignoreSbbs = QueryServiceHelper.query((String)"tcret_ccxws_info", (String)"sbbid", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbidList), new QFilter("hjybse", "<", (Object)BigDecimal.ZERO).or("hjjmse", "<", (Object)BigDecimal.ZERO)});
        ignoreSbbs.stream().map(dyo -> dyo.getString("sbbid")).forEach(ignoreSbbSet::add);
        ignoreSbbs = QueryServiceHelper.query((String)"tcret_ccxws_zb_yhs", (String)"sbbid", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbidList), new QFilter(YBSE, "<", (Object)BigDecimal.ZERO).or(JMSE, "<", (Object)BigDecimal.ZERO)});
        ignoreSbbs.stream().map(dyo -> dyo.getString("sbbid")).forEach(ignoreSbbSet::add);
        ignoreSbbs = QueryServiceHelper.query((String)"tcret_ccxws_zb_fcs_cz", (String)"sbbid", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbidList), new QFilter(YBSE, "<", (Object)BigDecimal.ZERO).or(JMSE, "<", (Object)BigDecimal.ZERO)});
        ignoreSbbs.stream().map(dyo -> dyo.getString("sbbid")).forEach(ignoreSbbSet::add);
        ignoreSbbs = QueryServiceHelper.query((String)"tcret_ccxws_zb_fcs_cj", (String)"sbbid", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbidList), new QFilter(YBSE, "<", (Object)BigDecimal.ZERO).or(JMSE, "<", (Object)BigDecimal.ZERO)});
        ignoreSbbs.stream().map(dyo -> dyo.getString("sbbid")).forEach(ignoreSbbSet::add);
        ignoreSbbs = QueryServiceHelper.query((String)"tcret_ccxws_zb_tds", (String)"sbbid", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbidList), new QFilter(YBSE, "<", (Object)BigDecimal.ZERO).or(JMSE, "<", (Object)BigDecimal.ZERO)});
        ignoreSbbs.stream().map(dyo -> dyo.getString("sbbid")).forEach(ignoreSbbSet::add);
        return ignoreSbbSet;
    }

    public abstract BigDecimal getHj(List<String> var1);

    public abstract BigDecimal getYhs(List<String> var1);

    public abstract BigDecimal getFcs(List<String> var1);

    public abstract BigDecimal getTds(List<String> var1);
}

