/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.apphome;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.declare.declareitem.service.DeclareItemListService;
import kd.taxc.tcret.business.declare.declareitem.service.impl.FcsDeclareItemListServiceImpl;
import kd.taxc.tcret.business.declare.declareitem.service.impl.HbsDeclareItemListServiceImpl;
import kd.taxc.tcret.business.declare.declareitem.service.impl.YhsDeclareItemListServiceImpl;
import kd.taxc.tcret.common.enums.FcsTypeEnum;

public class DqProjectListPlugin
extends AbstractFormPlugin {
    private List<DeclareItemListService> serviceList = new ArrayList<DeclareItemListService>(10){
        {
            this.add(new YhsDeclareItemListServiceImpl());
            this.add(new HbsDeclareItemListServiceImpl());
            this.add(new FcsDeclareItemListServiceImpl());
        }
    };

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection resultCollection = new DynamicObjectCollection();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = parentView.getPageCache();
        String orgid = pageCache.get("org");
        String declaremonth = pageCache.get("declaremonth");
        if (orgid == null || declaremonth == null) {
            return;
        }
        Date declareDate = DateUtils.stringToDate((String)declaremonth);
        Date startDate = DateUtils.getFirstDateOfMonth((Date)declareDate);
        Date endDate = DateUtils.getLastDateOfMonth((Date)declareDate);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        HashSet<Long> taxOfficeList = new HashSet<Long>(16);
        String taxoffice = pageCache.get("taxoffice");
        if (taxoffice == null) {
            for (FcsTypeEnum fcsTypeEnum : FcsTypeEnum.values()) {
                DynamicObject[] taxauthorities = BusinessDataServiceHelper.load((String)fcsTypeEnum.getSourceEntity(), (String)"taxauthority", (QFilter[])new QFilter[]{orgFilter});
                Stream.of(taxauthorities).filter(s -> s.getDynamicObject("taxauthority") != null).map(s -> s.getDynamicObject("taxauthority")).map(s -> s.getLong("id")).forEach(taxOfficeList::add);
            }
        } else {
            taxOfficeList.add(Long.parseLong(taxoffice));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (taxOfficeList.size() > 0) {
            for (Long taxofficeId : taxOfficeList) {
                this.queryList(filters, orgFilter, taxofficeId, startDate, endDate, orgid, declaremonth, resultCollection);
            }
        } else {
            this.queryList(filters, orgFilter, null, startDate, endDate, orgid, declaremonth, resultCollection);
        }
        int row = 0;
        IDataModel model = this.getModel();
        if (resultCollection.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", resultCollection.size());
            for (DynamicObject object : resultCollection) {
                model.setValue("taxtype", (Object)object.getString("taxtype"), row);
                model.setValue("skssqq", (Object)object.getDate("skssqq"), row);
                model.setValue("skssqz", (Object)object.getDate("skssqz"), row);
                if (!"yhsac".equals(object.getString("taxtype"))) {
                    model.setValue("taxstatus", (Object)object.getString("taxstatus"), row);
                }
                ++row;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void queryList(List<QFilter> filters, QFilter orgFilter, Long taxofficeId, Date startDate, Date endDate, String orgid, String declaremonth, DynamicObjectCollection resultCollection) {
        filters.clear();
        filters.add(orgFilter);
        if (taxofficeId != null) {
            QFilter taxofficeFilter = new QFilter("taxauthority", "=", (Object)taxofficeId);
            filters.add(taxofficeFilter);
        }
        QFilter declareMonthFilter = new QFilter("declaredate", ">=", (Object)DateUtils.getDayFirst((Date)startDate)).and(new QFilter("declaredate", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        filters.add(declareMonthFilter);
        QFilter taxtypeFilter = new QFilter("entryentity.taxtype", "!=", (Object)"yhsac");
        filters.add(taxtypeFilter);
        DynamicObjectCollection declareQueryCollection = QueryServiceHelper.query((String)"tcret_declare_main", (String)"id, entryentity.taxtype as taxtype, entryentity.skssqq as skssqq, entryentity.skssqz as skssqz, entryentity.taxlimit as taxlimit, entryentity.taxstatus as taxstatus,billstatus, status", (QFilter[])filters.toArray(new QFilter[0]));
        DynamicObjectCollection taxstatusACollection = declareQueryCollection.stream().filter(d -> "A".equals(d.getString("billstatus"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        DynamicObjectCollection taxstatusBCCollection = declareQueryCollection.stream().filter(d -> null != d.getString("billstatus") && !"A".equals(d.getString("billstatus"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("orgid", orgid);
        if (taxofficeId != null) {
            customParams.put("taxoffice", String.valueOf(taxofficeId));
        } else {
            customParams.remove("taxoffice");
        }
        customParams.put("declaremonth", declaremonth);
        DynamicObjectCollection result = new DynamicObjectCollection();
        this.serviceList.forEach(s -> result.addAll((Collection)s.queryList(customParams)));
        result.forEach(r -> {
            taxstatusACollection.forEach(t -> {
                if (r.getString("taxtype").equals(t.getString("taxtype")) && DateUtils.format((Date)r.getDate("skssqq")).equals(DateUtils.format((Date)t.getDate("skssqq"))) && DateUtils.format((Date)r.getDate("skssqz")).equals(DateUtils.format((Date)t.getDate("skssqz")))) {
                    r.set("taxstatus", (Object)t.getString("billstatus"));
                }
            });
            taxstatusBCCollection.forEach(t -> {
                if (r.getString("taxtype").equals(t.getString("taxtype")) && DateUtils.format((Date)r.getDate("skssqq")).equals(DateUtils.format((Date)t.getDate("skssqq"))) && DateUtils.format((Date)r.getDate("skssqz")).equals(DateUtils.format((Date)t.getDate("skssqz")))) {
                    r.set("taxstatus", (Object)t.getString("billstatus"));
                }
            });
        });
        resultCollection.addAll((Collection)result);
    }
}

