/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.apphome;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class NewTcretAppHomePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        List hasPermOrgList = OrgCheckUtil.hasPermOrgList((HasPermOrgResult)hasPermOrgs);
        this.getPageCache().put("orgList", SerializationUtils.toJsonString((Object)hasPermOrgList));
        String appId = this.getView().getFormShowParameter().getAppId();
        Object object = this.getModel().getValue("org");
        Long orgid = null;
        if (object == null) {
            orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (List)hasPermOrgList);
            if (null == orgid) {
                return;
            }
            if (OrgCheckUtil.check((IFormView)this.getView(), (String)String.valueOf(orgid), (String)appId, (String)TaxAppEnum.TCRET.getCategoryCode())) {
                orgid = null;
            }
        } else {
            orgid = ((DynamicObject)object).getLong("id");
        }
        this.getModel().setValue("org", (Object)orgid);
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid);
        if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            this.getModel().setValue("taxoffice", (Object)((DynamicObject)taxResult.getData()).getLong("taxoffice.id"));
        }
        this.refreshCache();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("org".equals(e.getProperty().getName())) {
            String appId = this.getView().getFormShowParameter().getAppId();
            String orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getString("id")).orElse(null);
            if (orgId == null) {
                return;
            }
            boolean check = OrgCheckUtil.check((IFormView)this.getView(), (String)orgId, (String)appId, (String)"fcscztdsys");
            if (!check) {
                TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId));
                if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                    this.getModel().setValue("taxoffice", (Object)((DynamicObject)taxResult.getData()).getLong("taxoffice.id"));
                }
                this.refreshCache();
                this.refreshView();
            } else {
                this.getModel().setValue("org", null);
                this.getModel().setValue("taxoffice", null);
            }
        } else {
            this.refreshCache();
            this.refreshView();
        }
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.refreshView();
        }
    }

    private void refreshCache() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getPageCache().remove("org");
            return;
        }
        this.getPageCache().put("org", org.getString("id"));
        this.getPageCache().put("orgid", org.getString("id"));
        Date declaremonth = this.getModel().getDataEntity().getDate("declaremonth");
        if (declaremonth == null) {
            this.getPageCache().remove("declaremonth");
            return;
        }
        this.getPageCache().put("declaremonth", DateUtils.format((Date)declaremonth));
        DynamicObject taxoffice = this.getModel().getDataEntity().getDynamicObject("taxoffice");
        if (taxoffice == null) {
            this.getPageCache().remove("taxoffice");
            return;
        }
        this.getPageCache().put("taxoffice", taxoffice.getString("id"));
    }

    private void refreshView() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }
}

