/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.draft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.draft.DraftServiceHelpler;
import kd.taxc.tcret.common.enums.CcsTypeEnum;
import kd.taxc.tcret.formplugin.draft.AbstractDraftPlugin;

public class CcsDraftPlugin
extends AbstractDraftPlugin
implements HyperLinkClickListener {
    public Long getBaseTaxCategory() {
        return BaseTaxCategory.CCS;
    }

    @Override
    public void calcDraftDetails(DynamicObject draftObj, DynamicObject taxorg, Long taxofficeId, Date collectionDate) {
        String sourcetype = this.getModel().getDataEntity().getString("sourcetype");
        if (StringUtil.isBlank((CharSequence)sourcetype)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6e90\u7c7b\u578b\u3002", (String)"CcsDraftPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        super.calcDraftDetails(draftObj, taxorg, taxofficeId, collectionDate, sourcetype, "id,number,sourceid,taxtype,ccsbdm,ccpzdm,cclx,cczcrq,zxrq,skssqq,skssqz,taxbasis,taxrate,currentpayable,currentjmamount");
    }

    @Override
    protected void setValue(DynamicObjectCollection detailList, List<DynamicObject> sourceDetailList, String selectField) {
        ArrayList<Long> clSourceIds = new ArrayList<Long>();
        ArrayList<Long> cbSourceIds = new ArrayList<Long>();
        for (DynamicObject obj : sourceDetailList) {
            String taxType = obj.getString("taytype");
            if (CcsTypeEnum.CCSCL.getType().equals(taxType)) {
                clSourceIds.add(obj.getLong("sourceid"));
            }
            if (!CcsTypeEnum.CCSCB.getType().equals(taxType)) continue;
            cbSourceIds.add(obj.getLong("sourceid"));
        }
        DynamicObjectCollection clCollection = QueryServiceHelper.query((String)CcsTypeEnum.CCSCL.getSourceEntity(), (String)"id,number,accountorg.id", (QFilter[])new QFilter[]{new QFilter("id", "in", clSourceIds)});
        DynamicObjectCollection cbCollection = QueryServiceHelper.query((String)CcsTypeEnum.CCSCB.getSourceEntity(), (String)"id,number,accountorg.id", (QFilter[])new QFilter[]{new QFilter("id", "in", cbSourceIds)});
        for (DynamicObject dynamicObject : sourceDetailList) {
            String taxType = dynamicObject.getString("taytype");
            Long sourceId = dynamicObject.getLong("sourceid");
            DynamicObject obj = null;
            if (CcsTypeEnum.CCSCL.getType().equals(taxType)) {
                obj = clCollection.stream().filter(e -> sourceId.equals(e.getLong("id"))).findFirst().orElse(null);
            }
            if (CcsTypeEnum.CCSCB.getType().equals(taxType)) {
                obj = cbCollection.stream().filter(e -> sourceId.equals(e.getLong("id"))).findFirst().orElse(null);
            }
            if (obj == null) continue;
            DynamicObject currency = DraftServiceHelpler.getCurrency();
            String entity = dynamicObject.getDataEntityType().getName();
            DynamicObject detail = detailList.addNew();
            for (String field : selectField.split(",")) {
                if ("number".equals(field)) {
                    Object value = null;
                    value = obj.get("number");
                    detail.set(field, value);
                    continue;
                }
                String getValueField = this.getValueFieldName(entity, field);
                detail.set(field, dynamicObject.get(getValueField));
            }
            detail.set("sourcedetailid", (Object)dynamicObject.getLong("id"));
            detail.set("currency", (Object)currency);
            detail.set("paidtaxes", (Object)BigDecimal.ZERO);
            detail.set("ybtse", (Object)detail.getBigDecimal("currentpayable").subtract(detail.getBigDecimal("currentjmamount")));
        }
    }

    private String getValueFieldName(String entity, String field) {
        String getValueField = field;
        if ("tcret_pbt_ccs_sum_tp".equals(entity)) {
            if ("taxtype".equals(field)) {
                getValueField = "taytype";
            }
            if ("currentpayable".equals(field)) {
                getValueField = "ynse";
            }
            if ("currentjmamount".equals(field)) {
                getValueField = "jmse";
            }
        }
        return getValueField;
    }

    private Object getValue(DynamicObject dynamicObject, String field) {
        String taxType = dynamicObject.getString("taytype");
        CcsTypeEnum source = CcsTypeEnum.getByTaxType(taxType);
        String entityName = source.getSourceEntity();
        Long sourceid = dynamicObject.getLong("sourceid");
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)entityName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceid)});
        return obj.get(field);
    }

    @Override
    public void registerListener(EventObject e) {
        EntryGrid reportlist = (EntryGrid)this.getView().getControl("entryentity");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        super.registerListener(e);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        HashMap<String, Object> param = new HashMap<String, Object>(6);
        param.put("id", this.getModel().getValue("sourcedetailid", rowIndex));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        PageShowCommon.showForm((OperationStatus)formShowParameter.getStatus(), (ShowType)ShowType.Modal, (String)"tcret_ccs_syjminfo", (IFormView)this.getView(), param, (IFormPlugin)this);
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        this.deleteSourceDetail();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("accountorg".equals(name) || "taxoffice".equals(name) || "collectiondate".equals(name) || "org".equals(name) || "isxxwlqy".equals(name)) {
            this.deleteSourceDetail();
        }
        super.propertyChanged(e);
    }

    private void deleteSourceDetail() {
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id.equals(0L)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            List sourcedetailid = entryentity.stream().map(e -> e.getLong("sourcedetailid")).collect(Collectors.toList());
            DeleteServiceHelper.delete((String)"tcret_pbt_fcs_price_sum_tp", (QFilter[])new QFilter[]{new QFilter("id", "in", sourcedetailid)});
        }
    }
}

