/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.pbtdeclare;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.mq.datasynchronize.DataSynchronizeMQSender;
import kd.taxc.bdtaxr.common.mq.datasynchronize.SynchronizeParam;
import kd.taxc.bdtaxr.common.taxdeclare.DeclarePageType;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.formplugin.pbtdeclare.PbtDeclareHomePlugin;

public class TcretDeclareImportEditPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PbtDeclareHomePlugin.class);
    private static final String DECLARE_DATE = "declaredate";
    private static final String BILLNO = "billno";
    private static final String TAXAUTHORITY = "taxauthority";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarapdeclare"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("sbbid", String.valueOf(customParams.get("sbbid")));
        this.loadFromHyperLinkClick(customParams);
    }

    private void loadFromHyperLinkClick(Map<String, Object> customParams) {
        Object sbbid = customParams.get("sbbid");
        if (sbbid instanceof String) {
            sbbid = Long.parseLong(String.valueOf(sbbid));
        }
        DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"org, billno,taxauthority, declaredate", (QFilter[])new QFilter[]{new QFilter("id", "=", sbbid)});
        String billno = nsrxx.getString(BILLNO);
        this.getModel().setValue(BILLNO, (Object)billno);
        this.getPageCache().put(BILLNO, billno);
        String orgid = nsrxx.getString("org");
        this.getModel().setValue("org", (Object)orgid);
        this.getPageCache().put("org", orgid);
        customParams.put("org", orgid);
        String taxOfficeId = nsrxx.getString(TAXAUTHORITY);
        this.getModel().setValue(TAXAUTHORITY, (Object)taxOfficeId);
        this.getPageCache().put(TAXAUTHORITY, taxOfficeId);
        customParams.put(TAXAUTHORITY, taxOfficeId);
        Date declaremonth = nsrxx.getDate(DECLARE_DATE);
        this.getModel().setValue(DECLARE_DATE, (Object)declaremonth);
        this.getPageCache().put(DECLARE_DATE, DateUtils.format((Date)declaremonth, (String)"yyyy-MM-dd"));
        customParams.put(DECLARE_DATE, this.getPageCache().get(DECLARE_DATE));
        if (OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)"tcret", null)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_edit", "bar_cancel", "bar_save", "bar_refresh"});
            return;
        }
        this.showInnerTbPage(false);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_refresh": {
                this.showInnerTbPage(false);
                break;
            }
            case "bar_cancel": {
                boolean dataChanged;
                IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
                IPageCache childPageCache = childPage.getPageCache();
                Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
                boolean bl = dataChanged = updateMap != null && updateMap.size() > 0;
                if (dataChanged) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_cancel", (IFormPlugin)this);
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TcretDeclareImportEditPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"TcretDeclareImportEditPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
                    MessageBoxOptions options = MessageBoxOptions.OKCancel;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TcretDeclareImportEditPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                    break;
                }
                this.showInnerTbPage(false);
                break;
            }
            case "bar_save": {
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"TcretDeclareImportEditPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 3000);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.error(ex.getMessage());
                }
                this.save();
                this.showInnerTbPage(false);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult.isSuccess() && "edit".equals(operateKey = afterDoOperationEventArgs.getOperateKey())) {
            SourceOperateHelper.saveSourceTemporaryEntity((String)"ccxws", (String)this.getPageCache().get("sbbid"));
            this.showInnerTbPage(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if ("bar_cancel".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("OperationStatus", OperationStatus.VIEW.name());
            FormulaService.cancel((IPageCache)this.getPageCache());
            this.showInnerTbPage(false);
        }
    }

    public void save() {
        String sbbid = this.getPageCache().get("sbbid");
        if (EmptyCheckUtils.isEmpty((Object)sbbid)) {
            return;
        }
        DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sbbid))});
        if (nsrxx != null && !"A".equals(nsrxx.getString("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u6216\u8005\u5df2\u5ba1\u6838", (String)"TcretDeclareImportEditPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("TaxDeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try (TXHandle h = TX.requiresNew();){
                try {
                    Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class, DeclareRequestModel.class);
                    Map customParams = this.getView().getFormShowParameter().getCustomParams();
                    DeclareRequestModel declareRequestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)((String)customParams.get("declareRequestData")), DeclareRequestModel.class);
                    declareRequestModel.setId(Long.valueOf(Long.parseLong(sbbid)));
                    saveClick.invoke(taxDeclarePlugin, childPageCache, declareRequestModel);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"TcretDeclareImportEditPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
                    DataSynchronizeMQSender.sendMessage((SynchronizeParam)new SynchronizeParam(declareRequestModel.getId(), "ccxws", declareRequestModel.getOrgId()));
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"TcretDeclareImportEditPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]));
                    h.markRollback();
                }
            }
        }
    }

    private void showInnerTbPage(boolean isEdit) {
        if (isEdit) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_cancel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_edit", "bar_refresh"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_edit", "bar_refresh"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_cancel"});
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)((String)customParams.get("declareRequestData")), DeclareRequestModel.class);
        String sbbid = this.getPageCache().get("sbbid");
        requestModel.setId(Long.valueOf(Long.parseLong(sbbid)));
        requestModel.setOperation(isEdit ? "edit" : "read");
        requestModel.setRefresh(Boolean.valueOf(false));
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        customParams.put("from", "history");
        customParams.put("btn_visible", true);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(DeclarePageType.PBT_PAGE2.getEntity());
        if (isEdit) {
            parameter.setStatus(OperationStatus.EDIT);
        }
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexcontent");
        parameter.setCustomParams(customParams);
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(parameter);
        String pageid = parameter.getPageId();
        this.getPageCache().put("declarepageid", pageid);
    }
}

