/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.pbtdeclare.declareitem;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;
import kd.taxc.tcret.common.utils.TcretSystemParamUtil;

public class PbtDeclareitemPlugin
extends AbstractBillPlugIn {
    private static final Set<String> GTGSH = new LinkedHashSet<String>(Arrays.asList("410", "411", "412", "413"));

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refreshlist".equals(itemKey)) {
            this.refreshList();
        } else if ("selectitems".equals(itemKey)) {
            this.selectitems();
        }
    }

    private void selectitems() {
        HashMap<String, String> customParams = new HashMap<String, String>();
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        if (StringUtil.isBlank((CharSequence)pageCache.get("sbbid"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u65b0\u5efa\u7533\u62a5\u8868\u3002", (String)"PbtDeclareitemPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        customParams.put("orgid", pageCache.get("orgid"));
        customParams.put("declarenumber", pageCache.get("declarenumber"));
        customParams.put("taxoffice", pageCache.get("taxoffice"));
        customParams.put("declaremonth", pageCache.get("declaremonth"));
        customParams.put("sbbid", pageCache.get("sbbid"));
        customParams.put("zerodeclare", pageCache.get("zerodeclare"));
        customParams.put("haslicense", pageCache.get("haslicense"));
        customParams.put("entryentity", (String)this.getModel().getEntryEntity("entryentity"));
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcret_pbt_depending_items", (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map returnData;
        String formId;
        if ("tcret_pbt_depending_items".equals(e.getActionId())) {
            if (e.getReturnData() == null) {
                return;
            }
            DynamicObjectCollection collection = (DynamicObjectCollection)e.getReturnData();
            this.refreshEntryEntity(collection);
            this.refreshXxwlqy(collection);
        } else if ("hbs_source_info_dialog".equals(e.getActionId()) && EmptyCheckUtils.isNotEmpty((Object)(formId = (String)(returnData = (Map)e.getReturnData()).get("formId")))) {
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)formId, (IFormView)this.getView(), (Map)returnData);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.refreshList();
    }

    private void refreshList() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("isxxwlqy", customParams.get("isxxwlqy"));
        String detaildeclare = (String)customParams.get("detaildeclare");
        if (EmptyCheckUtils.isEmpty((Object)detaildeclare) && EmptyCheckUtils.isNotEmpty(customParams.get("orgid"))) {
            Boolean parameter = TcretSystemParamUtil.getDetailDeclare(Long.parseLong((String)customParams.get("orgid")));
            detaildeclare = Boolean.toString(parameter);
        }
        this.getModel().setValue("detaildeclare", (Object)(EmptyCheckUtils.isNotEmpty((Object)detaildeclare) ? detaildeclare : "false"));
        if (null == customParams.get("taxoffice") || "0".equals(customParams.get("taxoffice"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u673a\u5173", (String)"PbtDeclareitemPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        Long sbbid = Long.parseLong(StringUtil.isNotBlank((CharSequence)((String)customParams.get("sbbid"))) ? (String)customParams.get("sbbid") : "0");
        QFilter q1 = new QFilter("sbbid", "=", (Object)sbbid);
        DynamicObjectCollection declareQueryCollection = QueryServiceHelper.query((String)EntityMappingUtils.getEntityName((OperationStatus)operationStatus, (String)"tcret_declare_main"), (String)"id, entryentity.taxtype as taxtype, entryentity.skssqq as skssqq, entryentity.skssqz as skssqz, entryentity.taxlimit as taxlimit, entryentity.taxstatus as taxstatus,billstatus,isxxwlqy,detaildeclare", (QFilter[])new QFilter[]{q1});
        declareQueryCollection.removeIf(d -> d.get("skssqq") == null);
        this.refreshEntryEntity(declareQueryCollection);
        if (!declareQueryCollection.isEmpty()) {
            String isxxwlqy = ((DynamicObject)declareQueryCollection.get(0)).getString("isxxwlqy");
            this.getModel().setValue("isxxwlqy", (Object)isxxwlqy);
            customParams.put("isxxwlqy", isxxwlqy);
            detaildeclare = ((DynamicObject)declareQueryCollection.get(0)).getString("detaildeclare");
            this.getModel().setValue("detaildeclare", (Object)detaildeclare);
            customParams.put("detaildeclare", detaildeclare);
            if (!this.getXxwlqyDate(declareQueryCollection, null).isEmpty()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"isxxwlqy"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"isxxwlqy"});
            }
        } else {
            this.getModel().setValue("isxxwlqy", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"isxxwlqy"});
            customParams.put("isxxwlqy", "");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        int focusRow = entryentity.getEntryState().getFocusRow();
        DynamicObject selectedRow = this.getModel().getEntryRowEntity("entryentity", focusRow);
        PbtDeclareUtil.taxSourceHyperLink(selectedRow, this.getView(), (IFormPlugin)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("isxxwlqy".equals(name)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("isxxwlqy", this.getModel().getValue("isxxwlqy"));
        } else if ("detaildeclare".equals(name)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("detaildeclare", this.getModel().getValue("detaildeclare"));
        }
    }

    private void refreshEntryEntity(DynamicObjectCollection declareQueryCollection) {
        int row = 0;
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (declareQueryCollection.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", declareQueryCollection.size());
            for (DynamicObject object : declareQueryCollection) {
                model.setValue("taxtype", (Object)object.getString("taxtype"), row);
                model.setValue("skssqq", (Object)object.getDate("skssqq"), row);
                model.setValue("skssqz", (Object)object.getDate("skssqz"), row);
                model.setValue("taxstatus", (Object)object.getString("taxstatus"), row);
                model.setValue("status", (Object)object.getString("taxstatus"), row);
                model.setValue("taxlimit", (Object)object.getString("taxlimit"), row);
                ++row;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void refreshXxwlqy(DynamicObjectCollection declareQueryCollection) {
        if (declareQueryCollection.size() > 0) {
            int registerYear;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String orgId = (String)customParams.get("orgid");
            DynamicObject taxMainInfo = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgId)).getData();
            if (null == taxMainInfo) {
                this.getModel().setValue("isxxwlqy", (Object)"false");
                customParams.put("isxxwlqy", "false");
                this.getView().setEnable(Boolean.FALSE, new String[]{"isxxwlqy"});
                return;
            }
            int year = DateUtils.getYearOfDate((Date)DateUtils.stringToDate((String)((String)customParams.get("declaremonth"))));
            if (year <= (registerYear = DateUtils.getYearOfDate((Date)taxMainInfo.getDate("registertime")))) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"isxxwlqy"});
                String result = TaxBaseDataUtils.checkXxwlqyByTaxMainInfo((DynamicObject)taxMainInfo);
                if ("1".equals(result)) {
                    this.getModel().setValue("isxxwlqy", (Object)"true");
                    customParams.put("isxxwlqy", "true");
                } else {
                    this.getModel().setValue("isxxwlqy", (Object)"false");
                    customParams.put("isxxwlqy", "false");
                }
                return;
            }
            HashMap<String, Date> xxwlqyDate = this.getXxwlqyDate(declareQueryCollection, taxMainInfo);
            if (!xxwlqyDate.isEmpty()) {
                Date skssqq = xxwlqyDate.get("skssqq");
                Date skssqz = xxwlqyDate.get("skssqz");
                this.getView().setEnable(Boolean.TRUE, new String[]{"isxxwlqy"});
                DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)orgId, (Date)skssqq, (Date)skssqz);
                String xxwlqy = TaxBaseDataUtils.queryQysdsXxwlqy((Long)Long.valueOf(orgId), (Date)skssqq, (Date)skssqz, (DynamicObject)dynamicObject, (DynamicObject)taxMainInfo);
                if ("1".equals(xxwlqy)) {
                    this.getModel().setValue("isxxwlqy", (Object)"true");
                    customParams.put("isxxwlqy", "true");
                } else if ("0".equals(xxwlqy)) {
                    this.getModel().setValue("isxxwlqy", (Object)"false");
                    customParams.put("isxxwlqy", "false");
                } else {
                    this.getModel().setValue("isxxwlqy", null);
                    customParams.put("isxxwlqy", "");
                }
            } else {
                this.getModel().setValue("isxxwlqy", (Object)"false");
                this.getView().setEnable(Boolean.FALSE, new String[]{"isxxwlqy"});
                customParams.put("isxxwlqy", "false");
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isxxwlqy"});
        }
    }

    private HashMap<String, Date> getXxwlqyDate(DynamicObjectCollection declareQueryCollection, DynamicObject taxMainInfo) {
        Date start = ((DynamicObject)declareQueryCollection.get(0)).getDate("skssqq");
        Date end = ((DynamicObject)declareQueryCollection.get(0)).getDate("skssqz");
        for (DynamicObject dynamicObject : declareQueryCollection) {
            if (dynamicObject.getDate("skssqq").before(start)) {
                start = dynamicObject.getDate("skssqq");
            }
            if (!dynamicObject.getDate("skssqz").after(end)) continue;
            end = dynamicObject.getDate("skssqz");
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgId = (String)customParams.get("orgid");
        DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)orgId, (Date)start, (Date)end);
        if (dynamicObject != null) {
            String registertype;
            String taxpayertype = dynamicObject.getString("taxpayertype");
            if (taxMainInfo == null) {
                taxMainInfo = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgId)).getData();
            }
            String string = registertype = taxMainInfo != null ? taxMainInfo.getString("registertype.number") : "";
            if ("ybnsr".equals(taxpayertype) && !GTGSH.contains(registertype)) {
                HashMap<String, Date> map = new HashMap<String, Date>();
                map.put("skssqq", start);
                map.put("skssqz", end);
                return map;
            }
        }
        return new HashMap<String, Date>();
    }
}

