/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.pbtdeclare.taxdetail.yhs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.taxsource.YhsTaxSourceServiceHelper;

public class YhsTaxDetailFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String TCRET_YHS_TAX_SOURCE_INFO = "tcret_yhs_tax_source_info";
    private static final String TCRET_YHS_SY_TZCJMX = "tcret_yhs_sy_tzcjmx";
    private static final String DECLARE_TYPE_ACSB = "acsb";
    private static final String DECLARE_TYPE_AQSB = "aqsb";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryentity1 = (EntryGrid)this.getControl("entryentity1");
        entryentity1.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.get("sbbid") != null) {
            Long sbbid = Long.parseLong(String.valueOf(customParams.get("sbbid")));
            QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)sbbid);
            QFilter isxgm = new QFilter("isxgm", "!=", (Object)"1");
            QFilter[] qFilters = new QFilter[]{sbbIdFilter, isxgm};
            String entityName = EntityMappingUtils.getEntityName((OperationStatus)formShowParameter.getStatus(), (String)TCRET_YHS_TAX_SOURCE_INFO);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)entityName, (String)MetadataUtil.getAllFieldToQuery((String)entityName), (QFilter[])qFilters);
            Map<String, List<DynamicObject>> declaretype = Arrays.stream(load).collect(Collectors.groupingBy(a -> a.getString("declaretype")));
            this.updateEntity(declaretype.get(DECLARE_TYPE_AQSB), "");
            this.updateEntity(declaretype.get(DECLARE_TYPE_ACSB), "1");
        }
    }

    private void updateEntity(List<DynamicObject> dynamicObjects, String suffix) {
        if (EmptyCheckUtils.isNotEmpty(dynamicObjects)) {
            this.getModel().beginInit();
            String entityKey = ENTRYENTITY + suffix;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityKey);
            for (DynamicObject object : dynamicObjects) {
                DynamicObject dynamicObject = entryEntity.addNew();
                dynamicObject.set("taxitem" + suffix, object.get("taxitem"));
                dynamicObject.set("subtaxitem" + suffix, object.get("subtaxitem"));
                String number = object.getString("taxitem.number");
                String taxrate = "02001".equals(number) ? object.getString("subtaxitem.value") : object.getString("taxitem.taxrate");
                dynamicObject.set("taxrate" + suffix, (Object)taxrate);
                dynamicObject.set("id" + suffix, object.get("id"));
                dynamicObject.set("skssqq" + suffix, object.get("skssqq"));
                dynamicObject.set("skssqz" + suffix, object.get("skssqz"));
                dynamicObject.set("voucherno" + suffix, object.get("voucherno"));
                dynamicObject.set("voucherdate" + suffix, object.get("voucherdate"));
                String datasource = object.getString("datasource");
                String calctaxamount = DataFormatUtils.formatMicrometer((String)object.getBigDecimal("calctaxamount").toString());
                if (StringUtil.equals((CharSequence)"fromacc", (CharSequence)datasource)) {
                    dynamicObject.set("calctaxamount" + suffix, (Object)calctaxamount);
                } else {
                    dynamicObject.set("calctaxamount" + suffix, (Object)("<nolink>" + calctaxamount));
                }
                dynamicObject.set("verifyrate" + suffix, object.get("verifyrate"));
                dynamicObject.set("deductioncode" + suffix, object.get("deductioncode"));
            }
            this.getModel().endInit();
            this.getView().updateView(entityKey);
        }
    }

    public void afterBindData(EventObject e) {
        ArrayList<CellStyle> csaqlist = new ArrayList<CellStyle>();
        ArrayList<CellStyle> csaclist = new ArrayList<CellStyle>();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl("entryentity1");
        HashMap<Long, Integer> idMap = new HashMap<Long, Integer>();
        this.creatIdIndexmap(idMap, "");
        this.creatIdIndexmap(idMap, "1");
        DynamicObjectCollection taxSourceCollection = YhsTaxSourceServiceHelper.getTaxSource(new ArrayList<Long>(idMap.keySet()));
        List gathernumberList = taxSourceCollection.stream().map(a -> a.getString("gathernumber")).collect(Collectors.toCollection(ArrayList::new));
        List<Long> orgList = taxSourceCollection.stream().map(a -> a.getLong("org")).collect(Collectors.toList());
        DynamicObjectCollection accountFbCollection = YhsTaxSourceServiceHelper.getAccountFb(orgList, gathernumberList);
        Map<String, List<DynamicObject>> map = accountFbCollection.stream().collect(Collectors.groupingBy(o -> o.getLong("org") + o.getString("taxsourceno")));
        List<Long> orignalidList = accountFbCollection.stream().map(a -> a.getLong("orignalid")).collect(Collectors.toList());
        DynamicObjectCollection accountCollection = YhsTaxSourceServiceHelper.getAccount(orignalidList);
        List<String> serialnoList = accountCollection.stream().map(a -> a.getString("serialno")).collect(Collectors.toList());
        DynamicObjectCollection adjustDetailCollection = YhsTaxSourceServiceHelper.getAdjustDetail(serialnoList);
        DynamicObjectCollection adjustDetailBySyxxCollection = YhsTaxSourceServiceHelper.getAdjustDetailBySyxxId(new ArrayList<Long>(idMap.keySet()));
        for (DynamicObject object : taxSourceCollection) {
            if (map.get(object.getLong("org") + object.getString("gathernumber")) == null) continue;
            List orignalids = map.get(object.getLong("org") + object.getString("gathernumber")).stream().map(a -> a.getLong("orignalid")).collect(Collectors.toList());
            List serialnos = accountCollection.stream().filter(a -> orignalids.contains(a.getLong("id"))).map(a -> a.getString("serialno")).collect(Collectors.toList());
            List dynamicObjects = adjustDetailCollection.stream().filter(a -> serialnos.contains(a.getString("serialno"))).collect(Collectors.toList());
            List dynamicObjectsBySyxx = adjustDetailBySyxxCollection.stream().filter(a -> object.get("id").toString().equals(a.getString("ruleid"))).collect(Collectors.toList());
            if (dynamicObjects.size() <= 0 && dynamicObjectsBySyxx.size() <= 0) continue;
            CellStyle cs = new CellStyle();
            cs.setBackColor("#DCFAE4");
            cs.setRow(((Integer)idMap.get(object.getLong("id"))).intValue());
            if (DECLARE_TYPE_AQSB.equals(object.getString("declaretype"))) {
                cs.setFieldKey("calctaxamount");
                csaqlist.add(cs);
                continue;
            }
            cs.setFieldKey("calctaxamount1");
            csaclist.add(cs);
        }
        entryGrid.setCellStyle(csaqlist);
        entryGrid1.setCellStyle(csaclist);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        String suffix = fieldName.replace("calctaxamount", "");
        Object id = this.getModel().getValue("id" + suffix, rowIndex);
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)TCRET_YHS_TAX_SOURCE_INFO);
        if (object != null) {
            String datasource = object.getString("datasource");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("billid", id);
            if (StringUtil.equals((CharSequence)"fromacc", (CharSequence)datasource)) {
                customParams.put("org", String.valueOf(object.get("org.id")));
                customParams.put("skssqq", DateUtils.format((Date)object.getDate("skssqq")));
                customParams.put("skssqz", DateUtils.format((Date)object.getDate("skssqz")));
                customParams.put("originalamount", object.getBigDecimal("calctaxamount"));
                customParams.put("serialno", object.getString("gathernumber"));
                customParams.put("sbbbillstatus", object.getString("sbbbillstatus"));
                customParams.put("readonly", "true");
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCRET_YHS_SY_TZCJMX, (IFormView)this.getView(), customParams, (IFormPlugin)this);
            }
        }
    }

    private void creatIdIndexmap(Map<Long, Integer> idMap, String suffix) {
        String entityKey = ENTRYENTITY + suffix;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityKey);
        int rowIndex = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            idMap.put(dynamicObject.getLong("id" + suffix), rowIndex);
            ++rowIndex;
        }
    }
}

