/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FclxzmImportPlugin
extends BatchImportPlugin {
    private static final String tabLine = "\n";

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            StringBuilder message = new StringBuilder();
            ImportBillData data = it.next();
            this.validBillData(data, message);
            if (!StringUtils.isNotBlank((CharSequence)message.toString())) continue;
            logger.log(Integer.valueOf(data.getStartIndex()), message.toString()).fail();
            it.remove();
        }
        return super.save(rowdatas, logger);
    }

    private void validBillData(ImportBillData data, StringBuilder message) {
        BigDecimal taxStandard;
        JSONObject taxoffice;
        DynamicObject orgObject;
        JSONObject fclx = data.getData().getJSONObject("fclxmc");
        boolean isexist = QueryServiceHelper.exists((String)"tpo_tdzzs_bizdef", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"LVAT-fclx-001"), new QFilter("entry_detail.subnumber", "=", fclx.get((Object)"number"))});
        if (!isexist) {
            FclxzmImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"\u623f\u4ea7\u7c7b\u578b\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7f16\u7801%s", (String)"FclxzmImportPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), fclx.get((Object)"number")));
        }
        if ((orgObject = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorgan", (String)"id,number,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (taxoffice = data.getData().getJSONObject("group")).get((Object)"number"))})) == null) {
            FclxzmImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u6570\u636e\u4e0d\u5b58\u5728,\u7f16\u7801%s", (String)"FclxzmImportPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]), taxoffice.get((Object)"number")));
        } else if (orgObject.get("enable").equals("0")) {
            FclxzmImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u672a\u542f\u7528\uff1a\u7f16\u7801%s", (String)"FclxzmImportPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]), taxoffice.get((Object)"number")));
        }
        String yzl = data.getData().getString("yzl");
        boolean checkTaxstandard = this.checkNumeric(yzl, ResManager.loadKDString((String)"\u9884\u5f81\u7387", (String)"FclxzmImportPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]), message);
        if (yzl != null && checkTaxstandard && ((taxStandard = new BigDecimal(yzl)).compareTo(BigDecimal.ZERO) < 0 || taxStandard.compareTo(BigDecimal.ONE) > 0)) {
            FclxzmImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u9884\u5f81\u7387\u8f93\u5165\u503c\u8981\u5927\u4e8e\u7b49\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e1", (String)"FclxzmImportPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    private static void errorMsg(StringBuilder errors, String msg) {
        errors.append(msg).append(tabLine);
    }

    private boolean checkNumeric(String value, String fieldName, StringBuilder message) {
        if (value == null) {
            return true;
        }
        if (!(value = value.replaceAll(",", "")).matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            FclxzmImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"%s\uff1a\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"FclxzmImportPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]), fieldName));
            return false;
        }
        return true;
    }
}

