/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.common.constant.HbsConstant;
import kd.taxc.tcret.common.utils.HbsUtils;

public class HbsFirstTaxAirFormPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final Map<Object, String> FROMNUMBER = new HashMap<Object, String>();

    public void registerListener(EventObject e) {
        BasedataEdit jmxzdmhxmmc = (BasedataEdit)this.getControl("jmxzdmhxmmc");
        jmxzdmhxmmc.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object fromno = customParams.get("fromno");
        if (!Objects.equals("first", fromno)) {
            return;
        }
        String key = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("zgndz".equals(key) || "bzndz".equals(key) || "ydndz".equals(key)) {
            BigDecimal zgndz = (BigDecimal)this.getModel().getValue("zgndz", rowIndex);
            BigDecimal bzndz = (BigDecimal)this.getModel().getValue("bzndz", rowIndex);
            BigDecimal ydndz = (BigDecimal)this.getModel().getValue("ydndz", rowIndex);
            DynamicObject jmxzdmhxmmc = (DynamicObject)this.getModel().getValue("jmxzdmhxmmc", rowIndex);
            if (zgndz == null || bzndz == null || ydndz == null || BigDecimal.ZERO.compareTo(zgndz) >= 0 || BigDecimal.ZERO.compareTo(bzndz) >= 0 || BigDecimal.ZERO.compareTo(ydndz) >= 0) {
                if (jmxzdmhxmmc != null && (Objects.equals(jmxzdmhxmmc.getString("number"), "16064006") || Objects.equals(jmxzdmhxmmc.getString("number"), "16064007"))) {
                    this.getModel().setValue("jmxzdmhxmmc", null, rowIndex);
                }
                return;
            }
            if (HbsUtils.isJmzcdm_16064006(zgndz, bzndz, ydndz)) {
                this.getModel().setValue("jmxzdmhxmmc", (Object)HbsConstant.JMZCDM_ID_16064006, rowIndex);
                return;
            }
            if (HbsUtils.isJmzcdm_16064007(zgndz, bzndz, ydndz)) {
                this.getModel().setValue("jmxzdmhxmmc", (Object)HbsConstant.JMZCDM_ID_16064007, rowIndex);
                return;
            }
            if (jmxzdmhxmmc != null && (Objects.equals(jmxzdmhxmmc.getString("number"), "16064006") || Objects.equals(jmxzdmhxmmc.getString("number"), "16064007"))) {
                this.getModel().setValue("jmxzdmhxmmc", null, rowIndex);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object status;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object v = status = customParams.get("status") == null ? customParams.get("statusTest") : customParams.get("status");
        if (status != null && "batchnew".equals(status) && this.newData(customParams, "batchnew")) {
            return;
        }
        if (status != null && "temporarystorage".equals(status)) {
            Object fromno = customParams.get("fromno");
            IDataModel parentModel = this.getView().getParentView().getModel();
            DynamicObject orgid = (DynamicObject)parentModel.getValue("org");
            Date taxmonth = (Date)parentModel.getValue("taxmonth");
            if (orgid == null || taxmonth == null) {
                return;
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)orgid.getLong("id"));
            QFilter taxPeriodFilter = new QFilter("month", "=", (Object)taxmonth);
            QFilter templateFilter = new QFilter("templatefrom", "=", (Object)FROMNUMBER.get(fromno));
            String selectProperties = "id,pfksszgswjg,number,number1,pfknum,name,wrwlb,swrzl,wrwname,wrwmc,zszm,wrwpfljsff,startdate,enddate,execstandard,bzndz,emissions,scndz,yjndz,zgndz,wrwdw,jsjcdw,syxs,cwxs,pwxs,hsz,sdcbbs,qcwrwdw,qcpwxs,tzl,wrwpfl,wrwdlz,wrwdls,dwse,ynse,jmxzdmhxmmc,jmbl,jmse,bqyjse,bqybtse,testreport,attachmentfield,constructionarea,dustgenerationcoefficie,reductioncoefficient,characteristiccoefficien";
            DynamicObject[] needAddCollection = BusinessDataServiceHelper.load((String)"tdm_pollute_airwater_tp", (String)selectProperties, (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, templateFilter});
            IDataModel model = this.getModel();
            if (needAddCollection.length > 0) {
                model.beginInit();
                model.batchCreateNewEntryRow("entryentity", needAddCollection.length);
                int rowIndex = 0;
                for (DynamicObject dynamicObject : needAddCollection) {
                    DynamicObjectCollection attachment = (DynamicObjectCollection)dynamicObject.get("attachmentfield");
                    ArrayList attchIdSet = new ArrayList();
                    attachment.forEach(attach -> attchIdSet.add(attach.getDynamicObject("fbasedataId").getLong("id")));
                    HbsUtils.entryToObject4(model, dynamicObject, rowIndex);
                    model.setValue("attachmentfield", (Object)attchIdSet.toArray(), rowIndex);
                    switch (fromno.toString()) {
                        case "first": {
                            model.setValue("execstandard", dynamicObject.get("execstandard"), rowIndex);
                            model.setValue("bzndz", dynamicObject.get("bzndz"), rowIndex);
                            model.setValue("fqfspfl", dynamicObject.get("emissions"), rowIndex);
                            model.setValue("scndz", dynamicObject.get("scndz"), rowIndex);
                            model.setValue("ydndz", dynamicObject.get("yjndz"), rowIndex);
                            model.setValue("zgndz", dynamicObject.get("zgndz"), rowIndex);
                            break;
                        }
                        case "second": {
                            model.setValue("execstandard", dynamicObject.get("execstandard"), rowIndex);
                            model.setValue("bzndz", dynamicObject.get("bzndz"), rowIndex);
                            model.setValue("wrwdw", dynamicObject.get("wrwdw"), rowIndex);
                            model.setValue("jsjcdw", dynamicObject.get("jsjcdw"), rowIndex);
                            model.setValue("syxs", dynamicObject.get("syxs"), rowIndex);
                            model.setValue("cwxs", dynamicObject.get("cwxs"), rowIndex);
                            model.setValue("pwxs", dynamicObject.get("pwxs"), rowIndex);
                            model.setValue("hsz", dynamicObject.get("hsz"), rowIndex);
                            break;
                        }
                        case "third": {
                            model.setValue("execstandard", dynamicObject.get("execstandard"), rowIndex);
                            model.setValue("bzndz", dynamicObject.get("bzndz"), rowIndex);
                            break;
                        }
                        case "fourth": {
                            model.setValue("execstandard", dynamicObject.get("execstandard"), rowIndex);
                            model.setValue("bzndz", dynamicObject.get("bzndz"), rowIndex);
                            model.setValue("fqfspfl", dynamicObject.get("emissions"), rowIndex);
                            model.setValue("sdcbbs", dynamicObject.get("sdcbbs"), rowIndex);
                            break;
                        }
                        case "five": {
                            model.setValue("qcwrwdw", dynamicObject.get("qcwrwdw"), rowIndex);
                            model.setValue("qcpwxs", dynamicObject.get("qcpwxs"), rowIndex);
                            model.setValue("tzl", dynamicObject.get("tzl"), rowIndex);
                            break;
                        }
                        case "six": {
                            model.setValue("constructionarea", dynamicObject.get("constructionarea"), rowIndex);
                            model.setValue("dustgenerationcoefficie", dynamicObject.get("dustgenerationcoefficie"), rowIndex);
                            model.setValue("reductioncoefficient", dynamicObject.get("reductioncoefficient"), rowIndex);
                            model.setValue("characteristiccoefficien", dynamicObject.get("characteristiccoefficien"), rowIndex);
                            break;
                        }
                    }
                    ++rowIndex;
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
            } else {
                this.newData(customParams, "temporarystorage");
            }
        }
    }

    private boolean newData(Map<String, Object> customParams, String operationKey) {
        DynamicObjectCollection dynamicObjects;
        QFilter wrwpfljsffFilter;
        QFilter taxPeriodFilter;
        Object fromno = customParams.get("fromno");
        IDataModel parentModel = this.getView().getParentView().getModel();
        DynamicObject orgid = (DynamicObject)parentModel.getValue("org");
        Date taxmonth = (Date)parentModel.getValue("taxmonth");
        if (orgid == null || taxmonth == null) {
            return true;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid.getLong("id"));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tdm_pollute_airwater_tp", (String)"org,month", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter = new QFilter("month", "=", (Object)taxmonth)});
        if (dynamicObjectCollection.size() != 0 && "batchnew".equals(operationKey)) {
            this.getModel().deleteEntryData("entryentity");
            return true;
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter timeFilter = new QFilter("startdate", "<=", (Object)taxmonth).and(new QFilter("enddate", ">=", (Object)taxmonth));
        QFilter wrwlbFilter = new QFilter("entryentity.wrwlb", "=", (Object)1215008151309769729L).or(new QFilter("entryentity.wrwlb", "=", (Object)1215008151309769728L).and(new QFilter("entryentity.swrwzl", "in", (Object)Lists.newArrayList((Object[])new Long[]{1215009637242625025L, 1215009637242625026L}))));
        if (Objects.equals("first", fromno)) {
            wrwpfljsffFilter = new QFilter("entryentity.wrwpfljsff", "in", (Object)Lists.newArrayList((Object[])new Long[]{1215009051147361281L, 1215009051147361282L}));
            dynamicObjects = QueryServiceHelper.query((String)"tcret_pollution_basedata", (String)"id,pfksszgswjg,number,pfknum,name,entryentity.wrwlb,entryentity.swrwzl,entryentity.wrwmc,entryentity.zszm,entryentity.wrwpfljsff,entryentity.bzndz,startdate,enddate", (QFilter[])new QFilter[]{orgFilter, enableFilter, timeFilter, wrwlbFilter, wrwpfljsffFilter});
        } else if (Objects.equals("second", fromno)) {
            wrwpfljsffFilter = new QFilter("entryentity.wrwpfljsff", "=", (Object)1215009051147361283L);
            dynamicObjects = QueryServiceHelper.query((String)"tcret_pollution_basedata", (String)"id,pfksszgswjg,number,pfknum,name,entryentity.wrwlb,entryentity.swrwzl,entryentity.wrwmc,entryentity.zszm,entryentity.wrwpfljsff,entryentity.bzndz,startdate,enddate", (QFilter[])new QFilter[]{orgFilter, enableFilter, timeFilter, wrwlbFilter, wrwpfljsffFilter});
        } else if (Objects.equals("third", fromno)) {
            wrwpfljsffFilter = new QFilter("entryentity.wrwpfljsff", "=", (Object)1215009051147361284L);
            dynamicObjects = QueryServiceHelper.query((String)"tcret_pollution_basedata", (String)"id,pfksszgswjg,number,pfknum,name,entryentity.wrwlb,entryentity.swrwzl,entryentity.wrwmc,entryentity.zszm,entryentity.wrwpfljsff,entryentity.bzndz,startdate,enddate", (QFilter[])new QFilter[]{orgFilter, enableFilter, timeFilter, wrwlbFilter, wrwpfljsffFilter});
        } else if (Objects.equals("fourth", fromno)) {
            wrwlbFilter = new QFilter("entryentity.wrwlb", "=", (Object)1215008151309769728L).and(new QFilter("entryentity.swrwzl", "=", (Object)1215009637242625027L));
            wrwpfljsffFilter = new QFilter("entryentity.wrwpfljsff", "!=", (Object)1215009051147361285L);
            dynamicObjects = QueryServiceHelper.query((String)"tcret_pollution_basedata", (String)"id,pfksszgswjg,number,pfknum,name,entryentity.wrwlb,entryentity.swrwzl,entryentity.wrwmc,entryentity.zszm,entryentity.wrwpfljsff,entryentity.bzndz,startdate,enddate", (QFilter[])new QFilter[]{orgFilter, enableFilter, timeFilter, wrwlbFilter, wrwpfljsffFilter});
        } else if (Objects.equals("five", fromno)) {
            wrwlbFilter = new QFilter("entryentity.wrwlb", "=", (Object)1215008151309769728L).and(new QFilter("entryentity.swrwzl", "=", (Object)1215009637242625028L));
            wrwpfljsffFilter = new QFilter("entryentity.wrwpfljsff", "=", (Object)1215009051147361285L);
            dynamicObjects = QueryServiceHelper.query((String)"tcret_pollution_basedata", (String)"id,pfksszgswjg,number,pfknum,name,entryentity.wrwlb,entryentity.swrwzl,entryentity.wrwmc,entryentity.zszm,entryentity.wrwpfljsff,entryentity.bzndz,startdate,enddate", (QFilter[])new QFilter[]{orgFilter, enableFilter, timeFilter, wrwlbFilter, wrwpfljsffFilter});
        } else {
            wrwlbFilter = new QFilter("entryentity.wrwlb", "=", (Object)1215008151309769729L);
            QFilter wrwmcfFilter = new QFilter("entryentity.wrwmc", "=", (Object)1215010325099995148L);
            wrwpfljsffFilter = new QFilter("entryentity.wrwpfljsff", "=", (Object)1215009051147361285L);
            dynamicObjects = QueryServiceHelper.query((String)"tcret_pollution_basedata", (String)"id,pfksszgswjg,number,pfknum,name,entryentity.wrwlb,entryentity.swrwzl,entryentity.wrwmc,entryentity.zszm,entryentity.wrwpfljsff,entryentity.bzndz,startdate,enddate", (QFilter[])new QFilter[]{orgFilter, enableFilter, timeFilter, wrwlbFilter, wrwmcfFilter, wrwpfljsffFilter});
        }
        DynamicObjectCollection needAddCollection = new DynamicObjectCollection();
        ArrayList<String> numberList = new ArrayList<String>(16);
        ArrayList<Long> wrwmcList = new ArrayList<Long>(16);
        ArrayList<Object> wrwlbList = new ArrayList<Object>(16);
        ArrayList<Object> swrzlList = new ArrayList<Object>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            numberList.add(dynamicObject.getString("number"));
            wrwmcList.add(dynamicObject.getLong("entryentity.wrwmc"));
            wrwlbList.add(dynamicObject.get("entryentity.wrwlb"));
            swrzlList.add(dynamicObject.get("entryentity.swrwzl"));
        }
        QFilter taxNumberFilter = new QFilter("number", "in", numberList);
        QFilter wrwmcnameFilter = new QFilter("wrwmc", "in", wrwmcList);
        QFilter wrwlb2Filter = new QFilter("wrwlb", "in", wrwlbList);
        QFilter swrwzlFilter = new QFilter("swrzl", "in", swrzlList);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)HbsFirstTaxAirFormPlugin.class.getName(), (String)"tdm_pollution_air_water", (String)"number,wrwmc,wrwlb,swrzl", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, taxNumberFilter, wrwmcnameFilter, wrwlb2Filter, swrwzlFilter}, null);
        List<Map<String, Object>> list = this.dataSetToList(dataSet);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (null != this.findOne(dynamicObject, list)) continue;
            needAddCollection.add((Object)dynamicObject);
        }
        numberList = new ArrayList(16);
        wrwmcList = new ArrayList(16);
        wrwlbList = new ArrayList(16);
        swrzlList = new ArrayList(16);
        ArrayList<Date> monthList = new ArrayList<Date>(16);
        HashSet<Long> detailIdList = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : needAddCollection) {
            monthList.add(DateUtils.addMonth((Date)taxmonth, (int)-1));
            numberList.add(dynamicObject.getString("number"));
            wrwmcList.add(dynamicObject.getLong("entryentity.wrwmc"));
            wrwlbList.add(dynamicObject.get("entryentity.wrwlb"));
            swrzlList.add(dynamicObject.get("entryentity.swrwzl"));
            if (dynamicObject.get("entryentity.zszm") == null || dynamicObject.getLong("entryentity.zszm") == 0L) {
                detailIdList.add(dynamicObject.getLong("entryentity.wrwmc"));
                continue;
            }
            detailIdList.add(dynamicObject.getLong("entryentity.zszm"));
        }
        taxNumberFilter = new QFilter("number", "in", numberList);
        wrwmcnameFilter = new QFilter("wrwmc", "in", wrwmcList);
        wrwlb2Filter = new QFilter("wrwlb", "in", wrwlbList);
        swrwzlFilter = new QFilter("swrzl", "in", swrzlList);
        taxPeriodFilter = new QFilter("month", "in", monthList);
        DataSet ds = QueryServiceHelper.queryDataSet((String)HbsFirstTaxAirFormPlugin.class.getName(), (String)"tdm_pollution_air_water", (String)"number,wrwmc,wrwlb,swrzl,wrwzszm,execstandard,bzndz,dwse,wrwdw,jsjcdw,syxs,cwxs,pwxs,hsz,qcpwxs,constructionarea,dustgenerationcoefficie,reductioncoefficient,characteristiccoefficien,wrwpfl,wrwdls,ynse", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, taxNumberFilter, wrwmcnameFilter, wrwlb2Filter, swrwzlFilter}, null);
        list = this.dataSetToList(ds);
        QFilter detailIdFilter = new QFilter("entry_detail.id", "in", detailIdList);
        DataSet detailId = QueryServiceHelper.queryDataSet((String)HbsFirstTaxAirFormPlugin.class.getName(), (String)"tpo_hbs_bizdef", (String)"entry_detail.id,entry_detail.value", (QFilter[])new QFilter[]{detailIdFilter}, null);
        List<Map<String, Object>> detailIdDs = this.dataSetToList(detailId);
        IDataModel model = this.getModel();
        if (needAddCollection.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", needAddCollection.size());
            int rowIndex = 0;
            for (DynamicObject dynamicObject : needAddCollection) {
                Map<String, Object> rowSix;
                Map<String, Object> row;
                HbsUtils.entryToObject2(model, dynamicObject, rowIndex);
                if (!(Objects.equals("five", fromno) || Objects.equals("fourth", fromno) || Objects.equals("six", fromno))) {
                    model.setValue("bzndz", (Object)dynamicObject.getBigDecimal("entryentity.bzndz"), rowIndex);
                }
                if ((row = this.findOne(dynamicObject, list)) != null) {
                    if (Objects.equals("second", fromno)) {
                        model.setValue("wrwdw", row.get("wrwdw"), rowIndex);
                        model.setValue("jsjcdw", row.get("jsjcdw"), rowIndex);
                        model.setValue("jsjcdw", row.get("jsjcdw"), rowIndex);
                        model.setValue("syxs", row.get("syxs"), rowIndex);
                        model.setValue("cwxs", row.get("cwxs"), rowIndex);
                        model.setValue("pwxs", row.get("pwxs"), rowIndex);
                        model.setValue("hsz", row.get("hsz"), rowIndex);
                    }
                    model.setValue("dwse", row.get("dwse"), rowIndex);
                    if (Objects.equals("five", fromno)) {
                        model.setValue("qcpwxs", row.get("qcpwxs"), rowIndex);
                    } else if (!Objects.equals("six", fromno)) {
                        model.setValue("execstandard", row.get("execstandard"), rowIndex);
                    }
                }
                if (Objects.equals("six", fromno) && (rowSix = this.findSix(dynamicObject, list)) != null) {
                    model.setValue("constructionarea", rowSix.get("constructionarea"), rowIndex);
                    model.setValue("dustgenerationcoefficie", rowSix.get("dustgenerationcoefficie"), rowIndex);
                    model.setValue("reductioncoefficient", rowSix.get("reductioncoefficient"), rowIndex);
                    model.setValue("characteristiccoefficien", rowSix.get("characteristiccoefficien"), rowIndex);
                    model.setValue("dwse", rowSix.get("dwse"), rowIndex);
                    model.setValue("wrwpfl", rowSix.get("wrwpfl"), rowIndex);
                    model.setValue("wrwdls", rowSix.get("wrwdls"), rowIndex);
                    model.setValue("ynse", rowSix.get("ynse"), rowIndex);
                    model.setValue("bqybtse", rowSix.get("ynse"), rowIndex);
                }
                if (dynamicObject.get("entryentity.zszm") == null || dynamicObject.getLong("entryentity.zszm") == 0L) {
                    for (Map<String, Object> detailRow : detailIdDs) {
                        if (((Long)detailRow.get("entry_detail.id")).longValue() != dynamicObject.getLong("entryentity.wrwmc")) continue;
                        model.setValue("wrwdlz", detailRow.get("entry_detail.value"), rowIndex);
                    }
                } else {
                    for (Map<String, Object> detailRow : detailIdDs) {
                        if (((Long)detailRow.get("entry_detail.id")).longValue() != dynamicObject.getLong("entryentity.zszm")) continue;
                        model.setValue("wrwdlz", detailRow.get("entry_detail.value"), rowIndex);
                    }
                }
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
        return false;
    }

    private Map<String, Object> findSix(DynamicObject dynamicObject, List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            if (!this.getProValue(dynamicObject, "number").equals(this.getProValueToDataSet(map, "number")) || !this.getProValue(dynamicObject, "entryentity.wrwmc").equals(this.getProValueToDataSet(map, "wrwmc")) || !this.getProValue(dynamicObject, "entryentity.zszm").equals(this.getProValueToDataSet(map, "wrwzszm"))) continue;
            return map;
        }
        return null;
    }

    private Map<String, Object> findOne(DynamicObject dynamicObject, List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            if (!this.getProValue(dynamicObject, "number").equals(this.getProValueToDataSet(map, "number")) || !this.getProValue(dynamicObject, "entryentity.wrwmc").equals(this.getProValueToDataSet(map, "wrwmc")) || !this.getProValue(dynamicObject, "entryentity.wrwlb").equals(this.getProValueToDataSet(map, "wrwlb")) || !this.getProValue(dynamicObject, "entryentity.swrwzl").equals(this.getProValueToDataSet(map, "swrwzl"))) continue;
            return map;
        }
        return null;
    }

    private String getProValue(DynamicObject dynamicObject, String propertyName) {
        return dynamicObject.get(propertyName) != null ? dynamicObject.get(propertyName).toString() : "";
    }

    private String getProValueToDataSet(Map<String, Object> map, String propertyName) {
        return map.get(propertyName) != null ? map.get(propertyName).toString() : "";
    }

    private List<Map<String, Object>> dataSetToList(DataSet dataSet) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            result.add(dataSet.getRowMeta().toMap(row));
        }
        return result;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object fromno = customParams.get("fromno");
        Object org = this.getView().getParentView().getModel().getValue("org");
        QFilter numberFliter = new QFilter("number", "!=", (Object)"16064003");
        if ("jmxzdmhxmmc".equals(name) && Objects.equals("six", fromno)) {
            if (Objects.isNull(org)) {
                evt.setCustomQFilters(Collections.singletonList(numberFliter));
            } else if (HbsFirstTaxAirFormPlugin.isCxwsjzclcsOrshljjzclcs(((DynamicObject)org).getLong("id"))) {
                evt.setCustomQFilters(Collections.singletonList(numberFliter));
            }
        }
    }

    private static boolean isCxwsjzclcsOrshljjzclcs(Long orgId) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainHjbhsByOrgId(Collections.singletonList(orgId));
        if (!taxResult.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)taxResult.getData()))) {
            return true;
        }
        DynamicObject taxMain = (DynamicObject)((List)taxResult.getData()).get(0);
        if (CollectionUtils.isEmpty((Collection)taxMain.getDynamicObjectCollection("hjbhsentity"))) {
            return true;
        }
        DynamicObject hjbhsentity = (DynamicObject)taxMain.getDynamicObjectCollection("hjbhsentity").get(0);
        return !hjbhsentity.getBoolean("hjbhs_cxwsjzclcs") && !hjbhsentity.getBoolean("hjbhs_shljjzclcs");
    }

    static {
        FROMNUMBER.put("first", "1");
        FROMNUMBER.put("second", "2");
        FROMNUMBER.put("third", "3");
        FROMNUMBER.put("fourth", "4");
        FROMNUMBER.put("five", "5");
        FROMNUMBER.put("six", "6");
    }
}

