/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class HbsSolidWasteSourceInfoFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TDM_SOLID_WASTE_INFO = "tdm_solid_waste_info";
    private static final String TDM_SOLIDWASTE_INFO_TP = "tdm_solidwaste_info_tp";
    private static final String SAVE = "save";
    private static final String QUIT = "quit";
    private static final String TEMPORARYSTORAGE = "temporarystorage";
    private static final String TAX_MONTH = "taxmonth";
    private static final String TAX_ORG = "taxorg";
    private static final String ORG_ID = "orgid";
    private static final String ORG = "org";
    private static final String MONTH = "month";
    private static final Set<String> mustInputs = new HashSet<String>(Arrays.asList("bydtfwcsl", "wrwpfl", "dwse", "ynse", "bqybtse"));
    private static final Set<String> largeZeros = new HashSet<String>(Arrays.asList("bydtfwcsl", "bygtfwccl", "bygtfwczl", "bygtfwzhlyl", "wrwpfl", "bqyjse"));
    private static final Set<String> LessGtfwcsl = new HashSet<String>(Arrays.asList("bygtfwccl", "bygtfwczl", "bygtfwzhlyl"));
    private Map<String, String> disPlayName = new HashMap<String, String>(32);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbara"});
        BasedataEdit base = (BasedataEdit)this.getView().getControl(TAX_ORG);
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        OrgUtils.addFilterByConditionBeforeF7Select((Object)event, (IFormView)this.getView(), null, null, null);
    }

    public void afterCreateNewData(EventObject e) {
        Object status;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgId = customParams.get(ORG_ID);
        Object v = status = customParams.get("status") == null ? customParams.get("statusTest") : customParams.get("status");
        if (orgId == null) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        if (status != null && status.equals("batchnew")) {
            QFilter taxPeriodFilter;
            Date taxMonth = this.getTaxMonth(orgId);
            QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.valueOf(orgId.toString()));
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tdm_solidwaste_tp", (String)"org,month", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter = new QFilter(MONTH, "=", (Object)taxMonth)});
            if (dynamicObjectCollection.size() != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5c5e\u671f\u5df2\u5b58\u5728\u6682\u5b58\u6570\u636e\uff0c\u8bf7\u5207\u6362\u7ec4\u7ec7\u5c5e\u671f\u6216\u7f16\u8f91\u6682\u5b58\u6570\u636e", (String)"HbsSolidWasteSourceInfoFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                this.getModel().setValue(TAX_ORG, orgId);
                this.getModel().setValue(TAX_MONTH, (Object)this.getTaxMonth(orgId));
                this.getModel().deleteEntryData("entryentity");
                return;
            }
            this.getModel().setValue(TAX_ORG, orgId);
            this.getModel().setValue(TAX_MONTH, (Object)this.getTaxMonth(orgId));
            this.showListData(orgId, taxMonth);
        } else if (status != null && status.equals(TEMPORARYSTORAGE)) {
            Object taxMonth = customParams.get(MONTH);
            Object pkid = customParams.get("pkid");
            this.getModel().setValue(TAX_ORG, orgId);
            this.getModel().setValue(TAX_MONTH, taxMonth);
            this.getView().setEnable(Boolean.FALSE, new String[]{TAX_ORG});
            this.getView().setEnable(Boolean.FALSE, new String[]{TAX_MONTH});
            this.showTpListData(orgId, taxMonth, pkid);
        }
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        this.checkLicense();
    }

    private boolean checkLicense() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(TAX_ORG);
        if (org != null) {
            Long orgid = org.getLong("id");
            boolean notAuthorize = LicenseCheckServiceHelper.check((Object)orgid, (IFormView)this.getView(), (String)"tcret");
            if (notAuthorize) {
                this.getModel().setValue(TAX_ORG, null);
            }
            return notAuthorize;
        }
        return false;
    }

    public void itemClick(ItemClickEvent evt) {
        Object p3;
        Object status;
        String itemKey = evt.getItemKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object v = status = customParams.get("status") == null ? customParams.get("statusTest") : customParams.get("status");
        if (SAVE.equals(itemKey)) {
            DynamicObject taxorgCheck = (DynamicObject)this.getModel().getValue(TAX_ORG);
            if (taxorgCheck != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)taxorgCheck.getLong("id")).isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"HbsSolidWasteSourceInfoFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryentity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u9700\u8981\u4fdd\u5b58", (String)"HbsSolidWasteSourceInfoFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            this.disPlayName = HbsSolidWasteSourceInfoFormPlugin.getDisplayName(entryentity);
            HashMap errorsMsg = new HashMap(32);
            UnaryOperator p1 = objects -> this.checkMustInput((DynamicObjectCollection)objects, errorsMsg);
            UnaryOperator p2 = objects -> this.checkBigThanZero((DynamicObjectCollection)objects, errorsMsg);
            p3 = objects -> this.checkLessGtfwcsl((DynamicObjectCollection)objects, errorsMsg);
            UnaryOperator p4 = objects -> this.checkLessWrwpfl((DynamicObjectCollection)objects, errorsMsg);
            UnaryOperator p5 = objects -> this.checkMoreBygtfwzhlyl((DynamicObjectCollection)objects, errorsMsg);
            UnaryOperator p6 = objects -> this.checkUnique((DynamicObjectCollection)objects, errorsMsg);
            Function checkFunction = p1.andThen(p2).andThen(p3).andThen(p4).andThen(p5).andThen(p6);
            checkFunction.apply(entryentity);
            if (!errorsMsg.isEmpty()) {
                String collect = errorsMsg.entrySet().stream().map(s -> ((List)s.getValue()).stream().collect(Collectors.joining("\r\n"))).collect(Collectors.joining());
                this.getView().showErrorNotification(collect);
                return;
            }
            try (TXHandle handle = TX.required();){
                try {
                    this.saveDataToTable(entryentity, TDM_SOLID_WASTE_INFO);
                    DynamicObject org = (DynamicObject)this.getModel().getValue(TAX_ORG);
                    Date taxMonth = (Date)this.getModel().getValue(TAX_MONTH);
                    QFilter orgFilter = new QFilter(ORG, "=", org.get("id"));
                    QFilter taxPeriodFilter = new QFilter(MONTH, "=", (Object)DateUtils.getFirstDateOfMonth((Date)taxMonth));
                    DeleteServiceHelper.delete((String)"tdm_solidwaste_tp", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
                    DeleteServiceHelper.delete((String)TDM_SOLIDWASTE_INFO_TP, (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
                }
                catch (Exception e) {
                    handle.markRollback();
                    throw new RuntimeException(e);
                }
            }
            this.closeView();
        }
        if (QUIT.equals(itemKey)) {
            this.close(null);
        }
        if (TEMPORARYSTORAGE.equals(itemKey)) {
            Object org = this.getModel().getValue(TAX_ORG);
            Object taxmonth = this.getModel().getValue(TAX_MONTH);
            Object pkid = customParams.get("pkid");
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            if (org == null || taxmonth == null || CollectionUtils.isEmpty((Collection)entryentity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u5b58\u5931\u8d25\uff1a\u7a0e\u52a1\u7ec4\u7ec7\u3001\u7a0e\u6b3e\u6240\u5c5e\u6708\u4efd\u4e3a\u7a7a\uff0c\u6216\u5f53\u524d\u7ec4\u7ec7\u5c5e\u671f\u4e0d\u5b58\u5728\u9700\u8981\u91c7\u96c6\u7684\u6570\u636e", (String)"HbsSolidWasteSourceInfoFormPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            TXHandle handle = TX.required();
            p3 = null;
            try {
                try {
                    QFilter orgFilter = new QFilter(ORG, "=", ((DynamicObject)org).get("id"));
                    QFilter taxPeriodFilter = new QFilter(MONTH, "=", (Object)DateUtils.getFirstDateOfMonth((Date)((Date)taxmonth)));
                    DeleteServiceHelper.delete((String)"tdm_solidwaste_tp", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
                    DeleteServiceHelper.delete((String)TDM_SOLIDWASTE_INFO_TP, (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
                    this.getView().updateView();
                    this.saveDataToTpTable(entryentity, TDM_SOLIDWASTE_INFO_TP, status);
                    DynamicObject dynamicObject = HbsSolidWasteSourceInfoFormPlugin.saveToObject((DynamicObject)org, taxmonth);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                }
                catch (Exception e) {
                    handle.markRollback();
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                p3 = throwable;
                throw throwable;
            }
            finally {
                if (handle != null) {
                    if (p3 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)p3).addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
            String operateName = ResManager.loadKDString((String)"\u6682\u5b58", (String)"HbsSolidWasteSourceInfoFormPlugin_18", (String)"taxc-tcret", (Object[])new Object[0]);
            String operateDescription = ResManager.loadKDString((String)"\u56fa\u4f53\u5e9f\u7269\u4fe1\u606f\u91c7\u96c6\u6682\u5b58\u6210\u529f\u3002", (String)"HbsSolidWasteSourceInfoFormPlugin_19", (String)"taxc-tcret", (Object[])new Object[0]);
            OperatorDialogUtils.operateDialog((String)"ccxws", (String)TDM_SOLID_WASTE_INFO, (String)operateName, (String)operateDescription);
            this.getPageCache().put("close", "true");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object status = customParams.get("status") == null ? customParams.get("statusTest") : customParams.get("status");
        String callBackId = e.getCallBackId();
        if ("bar_cancel".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.closeView();
        }
    }

    private void saveDataToTable(DynamicObjectCollection entryentity, String entityName) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        for (DynamicObject entry : entryentity) {
            DynamicObject object = HbsSolidWasteSourceInfoFormPlugin.getInitDynamicObject(entityName);
            object.set("billno", (Object)codeRuleService.getNumber(entityName, object, null));
            for (IDataEntityProperty mainPro : mainPros) {
                DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
                if (!properties.containsKey((Object)mainPro.getName())) continue;
                object.set(mainPro.getName(), entry.get(mainPro.getName()));
            }
            collection.add((Object)object);
        }
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            this.recordOperatorLog(collection.stream().map(s -> s.getString("billno")).collect(Collectors.toList()));
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])collection.toArray((Object[])new DynamicObject[0])));
    }

    private void saveDataToTpTable(DynamicObjectCollection entryentity, String entityName, Object status) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        for (DynamicObject entry : entryentity) {
            DynamicObject object = HbsSolidWasteSourceInfoFormPlugin.getTpInitDynamicObject();
            for (IDataEntityProperty mainPro : mainPros) {
                DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
                if (!properties.containsKey((Object)mainPro.getName()) || mainPro.getName().equals("id") || mainPro.getName().equals("attachmentfield")) continue;
                object.set(mainPro.getName(), entry.get(mainPro.getName()));
            }
            object.set("attachmentfield", entry.get("attachmentfield"));
            collection.add((Object)object);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])collection.toArray((Object[])new DynamicObject[0])));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u5b58\u6210\u529f", (String)"HbsSolidWasteSourceInfoFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
    }

    private static DynamicObject saveToObject(DynamicObject org, Object taxMonth) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tdm_solidwaste_tp");
        dynamicObject.set(ORG, (Object)org);
        dynamicObject.set(MONTH, (Object)DateUtils.getFirstDateOfMonth((Date)((Date)taxMonth)));
        return dynamicObject;
    }

    private static DynamicObject getInitDynamicObject(String entityName) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        object.set("status", (Object)"A");
        object.set("enable", (Object)"1");
        object.set("datasource", (Object)"1");
        return object;
    }

    private static DynamicObject getTpInitDynamicObject() {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)TDM_SOLIDWASTE_INFO_TP);
        object.set("status", (Object)"A");
        object.set("enable", (Object)"1");
        object.set("datasource", (Object)"1");
        return object;
    }

    private static Map<String, String> getDisplayName(DynamicObjectCollection entryentity) {
        Map<String, String> collect = ((DynamicObject)entryentity.get(0)).getDataEntityType().getProperties().stream().collect(Collectors.toMap(s -> s.getName(), s -> s.getDisplayName() != null ? s.getDisplayName().getLocaleValue() : ""));
        return collect;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal bygtfwzhlyl;
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        if (TAX_ORG.equals(key)) {
            if (newValue == null) {
                this.getModel().deleteEntryData("entryentity");
                return;
            }
            String orgId = ((DynamicObject)newValue).getString("id");
            if (OrgCheckUtil.check((IFormView)this.getView(), (String)orgId, (String)"tcret", (String)"hjbhs")) {
                this.getView().getModel().setValue(TAX_ORG, changeSet[0].getOldValue() == null ? null : ((DynamicObject)changeSet[0].getOldValue()).get("id"));
                return;
            }
            this.showListData(orgId, this.getModel().getValue(TAX_MONTH));
            this.checkTpData(this.getModel().getValue(TAX_ORG), this.getModel().getValue(TAX_MONTH));
        }
        if (TAX_MONTH.equals(key)) {
            Object value = this.getModel().getValue(TAX_ORG);
            String orgId = value != null ? ((DynamicObject)value).getString("id") : null;
            this.showListData(orgId, newValue);
            this.checkTpData(value, this.getModel().getValue(TAX_MONTH));
        }
        if (Sets.newHashSet((Object[])new String[]{"bydtfwcsl", "bygtfwccl", "bygtfwczl"}).contains(key)) {
            BigDecimal bydtfwcsl = (BigDecimal)this.getModel().getValue("bydtfwcsl", rowIndex);
            BigDecimal bygtfwccl = (BigDecimal)this.getModel().getValue("bygtfwccl", rowIndex);
            BigDecimal bygtfwczl = (BigDecimal)this.getModel().getValue("bygtfwczl", rowIndex);
            this.getModel().setValue("wrwpfl", (Object)bydtfwcsl.subtract(bygtfwccl).subtract(bygtfwczl), rowIndex);
        }
        if (Sets.newHashSet((Object[])new String[]{"wrwpfl", "dwse"}).contains(key)) {
            BigDecimal wrwpfl = (BigDecimal)this.getModel().getValue("wrwpfl", rowIndex);
            BigDecimal dwse = (BigDecimal)this.getModel().getValue("dwse", rowIndex);
            this.getModel().setValue("ynse", (Object)wrwpfl.multiply(dwse), rowIndex);
        }
        if (Sets.newHashSet((Object[])new String[]{"bygtfwzhlyl", "testreport"}).contains(key)) {
            boolean testreport = (Boolean)this.getModel().getValue("testreport");
            if (testreport) {
                if ("bygtfwzhlyl".equals(key)) {
                    bygtfwzhlyl = (BigDecimal)this.getModel().getValue("bygtfwzhlyl", rowIndex);
                    this.getModel().setItemValueByNumber("taxdeduction", bygtfwzhlyl.compareTo(BigDecimal.ZERO) > 0 ? "16064004" : null, rowIndex);
                }
            } else {
                this.getModel().setValue("taxdeduction", null, rowIndex);
            }
        }
        if (Sets.newHashSet((Object[])new String[]{"taxdeduction", "bygtfwzhlyl", "dwse", "testreport"}).contains(key)) {
            Object value = this.getModel().getValue("taxdeduction", rowIndex);
            if (value == null) {
                this.getModel().setValue("jmse", (Object)BigDecimal.ZERO, rowIndex);
            } else {
                bygtfwzhlyl = (BigDecimal)this.getModel().getValue("bygtfwzhlyl", rowIndex);
                BigDecimal dwse = (BigDecimal)this.getModel().getValue("dwse", rowIndex);
                this.getModel().setValue("jmse", (Object)bygtfwzhlyl.multiply(dwse), rowIndex);
            }
        }
        if (Sets.newHashSet((Object[])new String[]{"ynse", "jmse", "bqyjse"}).contains(key)) {
            BigDecimal ynse = (BigDecimal)this.getModel().getValue("ynse", rowIndex);
            BigDecimal jmse = (BigDecimal)this.getModel().getValue("jmse", rowIndex);
            BigDecimal bqyjse = (BigDecimal)this.getModel().getValue("bqyjse", rowIndex);
            this.getModel().setValue("bqybtse", (Object)ynse.subtract(jmse).subtract(bqyjse), rowIndex);
        }
    }

    private void showListData(Object orgId, Object taxMonth) {
        Map<String, BigDecimal> bizDef = this.getBizDef("GTFWWRMC");
        this.getModel().deleteEntryData("entryentity");
        if (orgId == null || taxMonth == null) {
            return;
        }
        QFilter filter = QFilter.of((String)"enable=? and entryentity.wrwlb.number=? ", (Object[])new Object[]{"1", "104"});
        filter.and(new QFilter(ORG, "=", (Object)Long.valueOf(orgId.toString())));
        filter.and(new QFilter("startdate", "<=", taxMonth).and(new QFilter("enddate", ">=", taxMonth)).or(new QFilter("startdate", "<=", taxMonth).and(new QFilter("enddate", "is null", null))));
        String selectPros = "id,org,number,pfksszgswjg,pfknum,name,entryentity.wrwlb,entryentity.wrwmc,entryentity.wrwmc.number as wrwmcNumber,entryentity.zszm,startdate,enddate";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"tcret_pollution_basedata", (String)selectPros, (QFilter[])new QFilter[]{filter});
        datas = datas.stream().filter(s -> this.isNotExists((DynamicObject)s, taxMonth)).collect(Collectors.toCollection(DynamicObjectCollection::new));
        if (CollectionUtils.isEmpty((Collection)datas)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow("entryentity", datas.size());
        int rowIndex = 0;
        for (DynamicObject dynamicObject : datas) {
            this.getModel().setValue(ORG, dynamicObject.get(ORG), rowIndex);
            this.getModel().setValue(MONTH, (Object)DateUtils.getFirstDateOfMonth((Date)((Date)taxMonth)), rowIndex);
            this.getModel().setValue("endmonth", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)((Date)taxMonth))), rowIndex);
            this.getModel().setValue("number", dynamicObject.get("number"), rowIndex);
            this.getModel().setValue("startdate", dynamicObject.get("startdate"), rowIndex);
            this.getModel().setValue("enddate", dynamicObject.get("enddate"), rowIndex);
            this.getModel().setValue("pfksszgswjg", dynamicObject.get("pfksszgswjg"), rowIndex);
            this.getModel().setValue("pfknumber", dynamicObject.get("pfknum"), rowIndex);
            this.getModel().setValue("pfkname", dynamicObject.get("name"), rowIndex);
            this.getModel().setValue("wrwlb", dynamicObject.get("entryentity.wrwlb"), rowIndex);
            this.getModel().setValue("wrwmc", dynamicObject.get("entryentity.wrwmc"), rowIndex);
            this.getModel().setValue("wrwzszm", dynamicObject.get("entryentity.zszm"), rowIndex);
            DynamicObject preOne = this.getPreMonthData(orgId, taxMonth, dynamicObject.get("number"), dynamicObject.get("entryentity.wrwmc"));
            this.getModel().setValue("ccqk", (Object)(preOne != null ? preOne.getString("ccqk") : ""), rowIndex);
            this.getModel().setValue("czqk", (Object)(preOne != null ? preOne.getString("czqk") : ""), rowIndex);
            this.getModel().setValue("zhlyqk", (Object)(preOne != null ? preOne.getString("zhlyqk") : ""), rowIndex);
            if (dynamicObject.get("entryentity.zszm") == null || dynamicObject.getLong("entryentity.zszm") == 0L) {
                this.getModel().setValue("dwse", (Object)bizDef.get(dynamicObject.getString("wrwmcNumber")), rowIndex);
            } else {
                DynamicObject tpoHbsBizdef = QueryServiceHelper.queryOne((String)"tpo_hbs_bizdef", (String)"entry_detail.value", (QFilter[])new QFilter[]{new QFilter("entry_detail.id", "in", dynamicObject.get("entryentity.zszm"))});
                if (tpoHbsBizdef != null && tpoHbsBizdef.getBigDecimal("entry_detail.value") != null && BigDecimal.ZERO.compareTo(tpoHbsBizdef.getBigDecimal("entry_detail.value")) < 0) {
                    this.getModel().setValue("dwse", (Object)tpoHbsBizdef.getBigDecimal("entry_detail.value").setScale(10, 4).toString(), rowIndex);
                }
            }
            this.getModel().setValue("pollutiondataid", dynamicObject.get("id"), rowIndex);
            ++rowIndex;
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void showTpListData(Object orgId, Object taxMonth, Object pkid) {
        QFilter pkidFilter = new QFilter("id", "=", pkid);
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.valueOf(orgId.toString()));
        QFilter taxMonthFilter = new QFilter(MONTH, "=", (Object)DateUtils.stringToDate((String)taxMonth.toString()));
        String selectProperties = "id,org,month,endmonth,pfksszgswjg,number,pfknumber,pfkname,wrwlb,wrwname,wrwmc,zszm,startdate,enddate,ccqk,czqk,zhlyqk,bydtfwcsl,bygtfwccl,bygtfwczl,bygtfwzhlyl,wrwpfl,ynse,taxdeduction,jmse,bqyjse,bqybtse,dwse,pollutiondataid,testreport,attachmentfield";
        DynamicObject[] needAddCollection = BusinessDataServiceHelper.load((String)TDM_SOLIDWASTE_INFO_TP, (String)selectProperties, (QFilter[])new QFilter[]{orgFilter, taxMonthFilter});
        IDataModel model = this.getModel();
        if (needAddCollection.length > 0) {
            model.beginInit();
            model.deleteEntryData("entryentity");
            model.batchCreateNewEntryRow("entryentity", needAddCollection.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : needAddCollection) {
                this.getModel().setValue(ORG, dynamicObject.get(ORG), rowIndex);
                this.getModel().setValue(MONTH, dynamicObject.get(MONTH), rowIndex);
                this.getModel().setValue("endmonth", dynamicObject.get("endmonth"), rowIndex);
                this.getModel().setValue("number", dynamicObject.get("number"), rowIndex);
                this.getModel().setValue("startdate", dynamicObject.get("startdate"), rowIndex);
                this.getModel().setValue("enddate", dynamicObject.get("enddate"), rowIndex);
                this.getModel().setValue("pfksszgswjg", dynamicObject.get("pfksszgswjg"), rowIndex);
                this.getModel().setValue("pfknumber", dynamicObject.get("pfknumber"), rowIndex);
                this.getModel().setValue("pfkname", dynamicObject.get("pfkname"), rowIndex);
                this.getModel().setValue("wrwlb", dynamicObject.get("wrwlb"), rowIndex);
                this.getModel().setValue("wrwmc", dynamicObject.get("wrwmc"), rowIndex);
                this.getModel().setValue("wrwname", dynamicObject.get("wrwname"), rowIndex);
                this.getModel().setValue("zszm", dynamicObject.get("zszm"), rowIndex);
                this.getModel().setValue("ccqk", dynamicObject.get("ccqk"), rowIndex);
                this.getModel().setValue("czqk", dynamicObject.get("czqk"), rowIndex);
                this.getModel().setValue("zhlyqk", dynamicObject.get("zhlyqk"), rowIndex);
                this.getModel().setValue("bydtfwcsl", dynamicObject.get("bydtfwcsl"), rowIndex);
                this.getModel().setValue("bygtfwccl", dynamicObject.get("bygtfwccl"), rowIndex);
                this.getModel().setValue("bygtfwczl", dynamicObject.get("bygtfwczl"), rowIndex);
                this.getModel().setValue("bygtfwzhlyl", dynamicObject.get("bygtfwzhlyl"), rowIndex);
                this.getModel().setValue("wrwpfl", dynamicObject.get("wrwpfl"), rowIndex);
                this.getModel().setValue("ynse", dynamicObject.get("ynse"), rowIndex);
                this.getModel().setValue("taxdeduction", dynamicObject.get("taxdeduction"), rowIndex);
                this.getModel().setValue("jmse", dynamicObject.get("jmse"), rowIndex);
                this.getModel().setValue("bqyjse", dynamicObject.get("bqyjse"), rowIndex);
                this.getModel().setValue("bqybtse", dynamicObject.get("bqybtse"), rowIndex);
                this.getModel().setValue("dwse", dynamicObject.get("dwse"), rowIndex);
                this.getModel().setValue("pollutiondataid", dynamicObject.get("pollutiondataid"), rowIndex);
                this.getModel().setValue("testreport", dynamicObject.get("testreport"), rowIndex);
                DynamicObjectCollection attachment = (DynamicObjectCollection)dynamicObject.get("attachmentfield");
                ArrayList attchIdSet = new ArrayList();
                attachment.forEach(attach -> attchIdSet.add(attach.getDynamicObject("fbasedataId").getLong("id")));
                model.setValue("attachmentfield", (Object)attchIdSet.toArray(), rowIndex);
                ++rowIndex;
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    private DynamicObject getPreMonthData(Object orgId, Object taxMonth, Object number, Object wrwmc) {
        DynamicObjectCollection query;
        Date preDate = null;
        if (taxMonth != null) {
            preDate = DateUtils.addMonth((Date)((Date)taxMonth), (int)-1);
        }
        if (CollectionUtils.isEmpty((Collection)(query = this.getDynamicObjects(orgId, preDate, number, wrwmc)))) {
            return null;
        }
        return (DynamicObject)query.get(0);
    }

    private Boolean isNotExists(DynamicObject data, Object taxMonth) {
        Object orgId = data.get(ORG) instanceof DynamicObject ? data.getDynamicObject(ORG).get("id") : data.get(ORG);
        Object number = data.get("number");
        Object wrwmc = data.get("entryentity.wrwmc") instanceof DynamicObject ? data.getDynamicObject("entryentity.wrwmc").get("id") : data.get("entryentity.wrwmc");
        DynamicObjectCollection query = this.getDynamicObjects(orgId, taxMonth, number, wrwmc);
        return CollectionUtils.isEmpty((Collection)query);
    }

    private Boolean isNotExists1(DynamicObject data, Object taxMonth) {
        Object orgId = data.get(ORG) instanceof DynamicObject ? data.getDynamicObject(ORG).get("id") : data.get(ORG);
        Object number = data.get("number");
        Object wrwmc = data.get("wrwmc") instanceof DynamicObject ? data.getDynamicObject("wrwmc").get("id") : data.get("wrwmc");
        DynamicObjectCollection query = this.getDynamicObjects(orgId, taxMonth, number, wrwmc);
        return CollectionUtils.isEmpty((Collection)query);
    }

    private DynamicObjectCollection getDynamicObjects(Object orgId, Object taxMonth, Object number, Object wrwmc) {
        QFilter q1 = new QFilter(ORG, "=", (Object)Long.parseLong(orgId.toString()));
        QFilter q2 = new QFilter("number", "=", number);
        QFilter q3 = new QFilter("wrwmc", "=", wrwmc);
        if (taxMonth != null) {
            q3.and(new QFilter(MONTH, "=", taxMonth));
        }
        return QueryServiceHelper.query((String)TDM_SOLID_WASTE_INFO, (String)"id,ccqk,czqk,zhlyqk", (QFilter[])new QFilter[]{q1, q2, q3});
    }

    private DynamicObjectCollection checkMustInput(DynamicObjectCollection objects, Map<String, List<String>> errorsMsg) {
        objects.stream().forEach(s -> {
            List columns = mustInputs.stream().filter(m -> Objects.isNull(s.get(m))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(columns)) {
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s", (String)"HbsSolidWasteSourceInfoFormPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]), columns.stream().map(c -> this.disPlayName.get(c)).collect(Collectors.joining("\uff0c")));
                this.putMsg(errorsMsg, (DynamicObject)s, msg);
            }
        });
        return objects;
    }

    private void putMsg(Map<String, List<String>> errorsMsg, DynamicObject s, String msg) {
        if (errorsMsg.containsKey(s.getString("seq"))) {
            List<String> list = errorsMsg.get(s.getString("seq"));
            list.add(msg);
        } else {
            msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s", (String)"HbsSolidWasteSourceInfoFormPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]), s.getString("seq"), msg);
            errorsMsg.put(s.getString("seq"), Lists.newArrayList((Object[])new String[]{msg}));
        }
    }

    private DynamicObjectCollection checkBigThanZero(DynamicObjectCollection objects, Map<String, List<String>> errorsMsg) {
        objects.stream().forEach(s -> {
            List columns = largeZeros.stream().filter(m -> s.getBigDecimal(m).compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(columns)) {
                String msg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"HbsSolidWasteSourceInfoFormPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]), columns.stream().map(c -> this.disPlayName.get(c)).collect(Collectors.joining("\uff0c")));
                this.putMsg(errorsMsg, (DynamicObject)s, msg);
            }
        });
        return objects;
    }

    private DynamicObjectCollection checkLessGtfwcsl(DynamicObjectCollection objects, Map<String, List<String>> errorsMsg) {
        objects.stream().forEach(s -> {
            List<String> columns = LessGtfwcsl.stream().filter(m -> s.getBigDecimal(m).compareTo(s.getBigDecimal("bydtfwcsl")) > 0).collect(Collectors.toList());
            if (columns.size() > 0) {
                columns.forEach(c -> {
                    String msg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u53ef\u8d85\u8fc7\u672c\u6708\u56fa\u4f53\u5e9f\u7269\u4ea7\u751f\u91cf\uff08\u5428\uff09", (String)"HbsSolidWasteSourceInfoFormPlugin_8", (String)"taxc-tcret", (Object[])new Object[0]), this.disPlayName.get(c));
                    this.putMsg(errorsMsg, (DynamicObject)s, msg);
                });
            }
        });
        return objects;
    }

    private DynamicObjectCollection checkLessWrwpfl(DynamicObjectCollection objects, Map<String, List<String>> errorsMsg) {
        objects.stream().forEach(s -> {
            if (s.getBigDecimal("bygtfwzhlyl").compareTo(s.getBigDecimal("wrwpfl")) > 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u672c\u6708\u56fa\u4f53\u5e9f\u7269\u7efc\u5408\u5229\u7528\u91cf\uff08\u5428\uff09\u4e0d\u53ef\u8d85\u8fc7\u6c61\u67d3\u7269\u6392\u653e\u91cf\uff08\u5428\uff09", (String)"HbsSolidWasteSourceInfoFormPlugin_9", (String)"taxc-tcret", (Object[])new Object[0]), new Object[0]);
                this.putMsg(errorsMsg, (DynamicObject)s, msg);
            }
        });
        return objects;
    }

    private DynamicObjectCollection checkMoreBygtfwzhlyl(DynamicObjectCollection objects, Map<String, List<String>> errorsMsg) {
        objects.stream().forEach(s -> {
            if (s.getDynamicObject("taxdeduction") != null && s.getBigDecimal("bygtfwzhlyl").compareTo(BigDecimal.ZERO) <= 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u82e5\u4eab\u53d7\u7efc\u5408\u5229\u7528\u56fa\u4f53\u5e9f\u7269\u7a0e\u6536\u4f18\u60e0\uff0c\u8bf7\u786e\u4fdd\u201c\u672c\u6708\u56fa\u4f53\u5e9f\u7269\u7efc\u5408\u5229\u7528\u91cf\uff08\u5428\uff09\u201d\u5927\u4e8e0", (String)"HbsSolidWasteSourceInfoFormPlugin_10", (String)"taxc-tcret", (Object[])new Object[0]), new Object[0]);
                this.putMsg(errorsMsg, (DynamicObject)s, msg);
            }
        });
        return objects;
    }

    private DynamicObjectCollection checkUnique(DynamicObjectCollection objects, Map<String, List<String>> errorsMsg) {
        objects.stream().forEach(s -> {
            if (!this.isNotExists1((DynamicObject)s, s.get(MONTH)).booleanValue()) {
                String msg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7ec4\u7ec7\u3001\u76f8\u540c\u7a0e\u6e90\u7f16\u53f7\u3001\u76f8\u540c\u7a0e\u671f\u3001\u76f8\u540c\u6c61\u67d3\u7269\u540d\u79f0\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539", (String)"HbsSolidWasteSourceInfoFormPlugin_11", (String)"taxc-tcret", (Object[])new Object[0]), new Object[0]);
                this.putMsg(errorsMsg, (DynamicObject)s, msg);
            }
        });
        return objects;
    }

    private void checkTpData(Object org, Object month) {
        QFilter taxPeriodFilter;
        if (org == null || month == null) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        QFilter orgFilter = new QFilter(ORG, "=", (Object)((DynamicObject)org).getLong("id"));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tdm_solidwaste_tp", (String)"org,month", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter = new QFilter(MONTH, "=", month)});
        if (dynamicObjectCollection.size() != 0) {
            this.getModel().setValue(TAX_ORG, null);
            this.getModel().setValue(TAX_MONTH, null);
            this.getModel().deleteEntryData("entryentity");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7ec4\u7ec7\u3001\u5c5e\u671f\u5df2\u5b58\u5728\u6682\u5b58\u6570\u636e\uff0c\u8bf7\u5207\u6362\u5176\u5b83\u7ec4\u7ec7\u3001\u5c5e\u671f", (String)"HbsSolidWasteSourceInfoFormPlugin_12", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    private Date getTaxMonth(Object orgId) {
        if (orgId == null) {
            return null;
        }
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId.toString()));
        QFilter monthFilter = new QFilter(MONTH, "is not null", null);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TDM_SOLID_WASTE_INFO, (String)MONTH, (QFilter[])new QFilter[]{orgFilter, monthFilter}, (String)"month desc", (int)1);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return DateUtils.trunc((Date)new Date());
        }
        return DateUtils.addMonth((Date)((DynamicObject)query.get(0)).getDate(MONTH), (int)1);
    }

    private Map<String, BigDecimal> getBizDef(String number) {
        Map<String, BigDecimal> result = new HashMap<String, BigDecimal>(16);
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObjectCollection custConst = QueryServiceHelper.query((String)"tpo_hbs_bizdef", (String)"entry_detail.subnumber,entry_detail.value", (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)custConst)) {
            return result;
        }
        result = custConst.stream().collect(Collectors.toMap(e -> e.getString("entry_detail.subnumber"), e -> e.getBigDecimal("entry_detail.value")));
        return result;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String code_close = this.getPageCache().get("code_close");
        if (!"true".equals(code_close)) {
            this.close(e);
        }
    }

    private void close(BeforeClosedEvent e) {
        boolean isclose;
        boolean haveChange = this.getView().getModel().getDataChanged();
        boolean bl = isclose = this.getPageCache().get("close") == null || !this.getPageCache().get("close").equals("true");
        if (haveChange && isclose) {
            if (e != null) {
                e.setCancel(true);
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_cancel", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"HbsSolidWasteSourceInfoFormPlugin_13", (String)"taxc-tcret", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"HbsSolidWasteSourceInfoFormPlugin_14", (String)"taxc-tcret", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"HbsSolidWasteSourceInfoFormPlugin_15", (String)"taxc-tcret", (Object[])new Object[0]), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            this.closeView();
        }
    }

    protected void closeView() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object status = customParams.get("status") == null ? customParams.get("statusTest") : customParams.get("status");
        this.getPageCache().put("code_close", "true");
        this.getView().close();
        if (status != null && !status.equals("batchnew") && this.getView().getParentView() != null) {
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void recordOperatorLog(List<String> billnos) {
        billnos.forEach(billno -> {
            String appId = this.getView().getFormShowParameter().getAppId();
            String billFormId = TDM_SOLID_WASTE_INFO;
            String operateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"HbsSolidWasteSourceInfoFormPlugin_16", (String)"taxc-tcret", (Object[])new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u4fdd\u5b58\u6210\u529f", (String)"HbsSolidWasteSourceInfoFormPlugin_17", (String)"taxc-tcret", (Object[])new Object[0]), billno);
            OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)billFormId, (String)operateName, (String)operateDescription);
        });
    }
}

