/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.common.utils.HbsUtils;

public class HbsTaxSourceInfoFormPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String TABAP = "tabap";
    private static final String CHANGED_TYPE = "changed_type";
    private static final String OLDTYPE = "OLDTYPE";
    private static final List<String> ONE_MUSTINPUT = Lists.newArrayList((Object[])new String[]{"fqfspfl", "scndz", "ydndz", "zgndz", "wrwpfl", "wrwdlz", "dwse"});
    private static final List<String> SIX_MUSTINPUT = Lists.newArrayList((Object[])new String[]{"constructionarea", "characteristiccoefficien", "dwse"});
    private static final List<String> TWO_MUSTINPUT = Lists.newArrayList((Object[])new String[]{"wrwdw", "jsjcdw", "jsjc", "syxs", "wrwdlz", "dwse"});
    private static final List<String> THIRD_MUSTINPUT = Lists.newArrayList((Object[])new String[]{"wrwpfl", "wrwdlz", "dwse"});
    private static final List<String> ONE_BIGTHANZERO = Lists.newArrayList((Object[])new String[]{"fqfspfl", "scndz", "ydndz", "zgndz", "wrwpfl", "bzndz", "bqyjse"});
    private static final List<String> TWO_BIGTHANZERO = Lists.newArrayList((Object[])new String[]{"jsjc", "bzndz", "cwxs", "pwxs", "bqyjse"});
    private static final List<String> THIRD_BIGTHANZERO = Lists.newArrayList((Object[])new String[]{"wrwpfl", "bzndz", "bqyjse"});
    private static final List<String> FOURTH_MUSTINPUT = Lists.newArrayList((Object[])new String[]{"fqfspfl", "wrwpfl", "dwse", "sdcbbs"});
    private static final List<String> FOURTH_BIGTHANZERO = Lists.newArrayList((Object[])new String[]{"fqfspfl", "wrwpfl", "bzndz", "bqyjse"});
    private static final List<String> FIVE_MUSTINPUT = Lists.newArrayList((Object[])new String[]{"qcwrwdw", "tzl", "qcpwxs", "dwse"});
    private static final List<String> FIVE_BIGTHANZERO = Lists.newArrayList((Object[])new String[]{"qcpwxs", "bqyjse"});
    private static final List<String> MUST_BIGTHANZERO = Lists.newArrayList((Object[])new String[]{"wrwdlz", "dwse"});
    private static final List<String> SIX_BIGTHANZERO = Lists.newArrayList((Object[])new String[]{"constructionarea", "dustgenerationcoefficie", "reductioncoefficient", "characteristiccoefficien"});

    public void afterCreateNewData(EventObject e) {
        Object status;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        Object v = status = customParams.get("status") == null ? customParams.get("statusTest") : customParams.get("status");
        if (orgid == null || "".equals(orgid)) {
            this.setTab();
            this.showTab();
            return;
        }
        if (status != null && "batchnew".equals(status)) {
            String orgId = String.valueOf(orgid);
            if (OrgCheckUtil.orgEnable((IFormView)this.getView(), (Long)Long.valueOf(orgId), (boolean)true) || OrgCheckUtil.checkTaxcMainEnable((IFormView)this.getView(), (String)orgId, (boolean)true) || OrgCheckUtil.isTaxPayerAuth((IFormView)this.getView(), (String)orgId, (boolean)true) || OrgCheckUtil.taxCategoryEnable((String)orgId, (IFormView)this.getView(), (String)"tcret", (String)"hjbhs", (boolean)true)) {
                return;
            }
            this.getModel().setValue("org", orgid);
            this.monthLinkage((String)orgid);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                QFilter taxPeriodFilter;
                QFilter orgFilter;
                DynamicObjectCollection dynamicObjectCollection;
                Long orgid1 = (Long)org.get("id");
                Date taxmonth = (Date)this.getModel().getValue("taxmonth");
                if (taxmonth != null && (dynamicObjectCollection = QueryServiceHelper.query((String)"tdm_airwater_tp", (String)"org,month", (QFilter[])new QFilter[]{orgFilter = new QFilter("org", "=", (Object)orgid1), taxPeriodFilter = new QFilter("month", "=", (Object)taxmonth)})).size() != 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5c5e\u671f\u5df2\u5b58\u5728\u6682\u5b58\u6570\u636e\uff0c\u8bf7\u5207\u6362\u7ec4\u7ec7\u5c5e\u671f\u6216\u7f16\u8f91\u6682\u5b58\u6570\u636e\u3002", (String)"HbsTaxSourceInfoFormPlugin_24", (String)"taxc-tcret", (Object[])new Object[0]));
                    this.getModel().setValue("org", orgid);
                    this.getModel().setValue("taxmonth", (Object)taxmonth);
                }
            }
        }
        if (status != null && "temporarystorage".equals(status)) {
            Object month = customParams.get("month");
            Object type = customParams.get("type");
            this.getModel().setValue("org", orgid);
            this.getModel().setValue("taxmonth", month);
            this.getModel().setValue("type", type);
            this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxmonth"});
        }
        this.setTab();
        this.showTab();
    }

    private void setTab() {
        String[] typeList;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"first", "second", "third", "fourth", "five", "six"});
        String types = (String)this.getModel().getValue("type");
        if (types == null) {
            this.getModel().setValue("type", (Object)this.getPageCache().get(OLDTYPE));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7533\u62a5\u7684\u6c61\u67d3\u7269\u79cd\u7c7b\u53ca\u5176\u8ba1\u7b97\u65b9\u6cd5\u201d\u81f3\u5c11\u9009\u62e9\u4e00\u9879\u3002", (String)"HbsTaxSourceInfoFormPlugin_37", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        for (String type : typeList = types.split(",")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{type});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        block56: {
            String itemKey = evt.getItemKey();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object status = customParams.get("status") == null ? customParams.get("statusTest") : customParams.get("status");
            Object pkid = customParams.get("pkid");
            try {
                DynamicObjectCollection entryentity;
                Object dynamicObject;
                DynamicObjectCollection entryentity2;
                DynamicObjectCollection entryentity3;
                DynamicObjectCollection entryentity4;
                DynamicObjectCollection entryentity5;
                DynamicObjectCollection entryentity6;
                Object type;
                Object taxMonth;
                DynamicObject org;
                IDataModel model;
                if ("quit".equals(itemKey)) {
                    this.close(null);
                }
                if ("save".equals(itemKey)) {
                    model = this.getView().getModel();
                    org = (DynamicObject)model.getValue("org");
                    if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"HbsTaxSourceInfoFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                        return;
                    }
                    taxMonth = model.getValue("taxmonth");
                    type = (String)model.getValue("type");
                    ArrayList errorMesge = Lists.newArrayList();
                    DynamicObjectCollection needAdd = new DynamicObjectCollection();
                    if (((String)type).contains("first") && this.firstEntryHandle(org, taxMonth, errorMesge, needAdd)) {
                        return;
                    }
                    if (((String)type).contains("second") && this.twoEntryHandle(org, taxMonth, errorMesge, needAdd)) {
                        return;
                    }
                    if (((String)type).contains("third") && this.thirdEntryHandle(org, taxMonth, errorMesge, needAdd)) {
                        return;
                    }
                    if (((String)type).contains("fourth") && this.fourEntryHandle(org, taxMonth, errorMesge, needAdd)) {
                        return;
                    }
                    if (((String)type).contains("five") && this.fiveEntryHandle(org, taxMonth, errorMesge, needAdd)) {
                        return;
                    }
                    if (((String)type).contains("six") && this.sixEntryHandle(org, taxMonth, errorMesge, needAdd)) {
                        return;
                    }
                    if (!CollectionUtils.isEmpty((Collection)needAdd)) {
                        try (TXHandle handle = TX.required();){
                            try {
                                this.recordOperatorLog(needAdd.stream().map(s -> s.getString("billno")).collect(Collectors.toList()));
                                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])needAdd.toArray((Object[])new DynamicObject[0])));
                                QFilter orgFilter = new QFilter("org", "=", org.get("id"));
                                Iterator taxPeriodFilter = new QFilter("month", "=", taxMonth);
                                DeleteServiceHelper.delete((String)"tdm_airwater_tp", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
                                DeleteServiceHelper.delete((String)"tdm_pollute_airwater_tp", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
                            }
                            catch (Exception e) {
                                handle.markRollback();
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    this.closeView();
                }
                if (!"temporarystorage".equals(itemKey)) break block56;
                model = this.getView().getModel();
                org = (DynamicObject)model.getValue("org");
                taxMonth = model.getValue("taxmonth");
                type = model.getValue("type");
                DynamicObjectCollection needAdd = new DynamicObjectCollection();
                boolean emptyEntryentity = true;
                if (org == null || taxMonth == null || ",,".equals(type)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u5b58\u5931\u8d25\uff1a\u7a0e\u52a1\u7ec4\u7ec7\u3001\u7a0e\u6b3e\u6240\u5c5e\u6708\u4efd\u3001\u7533\u62a5\u7684\u6c61\u67d3\u7269\u79cd\u7c7b\u53ca\u5176\u8ba1\u7b97\u65b9\u6cd5\u5747\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HbsTaxSourceInfoFormPlugin_21", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
                String firstPageId = this.getPageCache().get("loadtb-first");
                IFormView firstView = this.getView().getView(firstPageId);
                if (firstView != null && !CollectionUtils.isEmpty((Collection)(entryentity6 = firstView.getModel().getEntryEntity("entryentity")))) {
                    for (DynamicObject entry : entryentity6) {
                        Iterator dynamicObject2 = HbsUtils.entryToObject3(entry, org, taxMonth, status);
                        dynamicObject2.set("execstandard", entry.get("execstandard"));
                        dynamicObject2.set("bzndz", entry.get("bzndz"));
                        dynamicObject2.set("emissions", entry.get("fqfspfl"));
                        dynamicObject2.set("scndz", entry.get("scndz"));
                        dynamicObject2.set("yjndz", entry.get("ydndz"));
                        dynamicObject2.set("zgndz", entry.get("zgndz"));
                        dynamicObject2.set("templatefrom", "1");
                        needAdd.add((Object)dynamicObject2);
                        emptyEntryentity = false;
                    }
                }
                String secondPageId = this.getPageCache().get("loadtb-second");
                IFormView secondView = this.getView().getView(secondPageId);
                if (secondView != null && !CollectionUtils.isEmpty((Collection)(entryentity5 = secondView.getModel().getEntryEntity("entryentity")))) {
                    for (DynamicObject entry : entryentity5) {
                        Iterator dynamicObject3 = HbsUtils.entryToObject3(entry, org, taxMonth, status);
                        dynamicObject3.set("execstandard", entry.get("execstandard"));
                        dynamicObject3.set("bzndz", entry.get("bzndz"));
                        dynamicObject3.set("wrwdw", entry.get("wrwdw"));
                        dynamicObject3.set("jsjcdw", entry.get("jsjcdw"));
                        dynamicObject3.set("jsjc", entry.get("jsjc"));
                        dynamicObject3.set("syxs", entry.get("syxs"));
                        dynamicObject3.set("wrwpfl", entry.get("wrwpfl"));
                        dynamicObject3.set("cwxs", entry.get("cwxs"));
                        dynamicObject3.set("pwxs", entry.get("pwxs"));
                        dynamicObject3.set("hsz", entry.get("hsz"));
                        dynamicObject3.set("templatefrom", "2");
                        needAdd.add((Object)dynamicObject3);
                        emptyEntryentity = false;
                    }
                }
                String thirdPageId = this.getPageCache().get("loadtb-third");
                IFormView thirdView = this.getView().getView(thirdPageId);
                if (thirdView != null && !CollectionUtils.isEmpty((Collection)(entryentity4 = thirdView.getModel().getEntryEntity("entryentity")))) {
                    for (DynamicObject entry : entryentity4) {
                        Iterator dynamicObject4 = HbsUtils.entryToObject3(entry, org, taxMonth, status);
                        dynamicObject4.set("execstandard", entry.get("execstandard"));
                        dynamicObject4.set("bzndz", entry.get("bzndz"));
                        dynamicObject4.set("templatefrom", "3");
                        needAdd.add((Object)dynamicObject4);
                        emptyEntryentity = false;
                    }
                }
                String fourthPageId = this.getPageCache().get("loadtb-fourth");
                IFormView fourthView = this.getView().getView(fourthPageId);
                if (fourthView != null && !CollectionUtils.isEmpty((Collection)(entryentity3 = fourthView.getModel().getEntryEntity("entryentity")))) {
                    for (DynamicObject entry : entryentity3) {
                        Iterator dynamicObject5 = HbsUtils.entryToObject3(entry, org, taxMonth, status);
                        dynamicObject5.set("execstandard", entry.get("execstandard"));
                        dynamicObject5.set("bzndz", entry.get("bzndz"));
                        dynamicObject5.set("emissions", entry.get("fqfspfl"));
                        dynamicObject5.set("sdcbbs", entry.get("sdcbbs"));
                        dynamicObject5.set("templatefrom", "4");
                        needAdd.add((Object)dynamicObject5);
                        emptyEntryentity = false;
                    }
                }
                String fivePageId = this.getPageCache().get("loadtb-five");
                IFormView fiveView = this.getView().getView(fivePageId);
                if (fiveView != null && !CollectionUtils.isEmpty((Collection)(entryentity2 = fiveView.getModel().getEntryEntity("entryentity")))) {
                    for (DynamicObject entry : entryentity2) {
                        dynamicObject = HbsUtils.entryToObject3(entry, org, taxMonth, status);
                        dynamicObject.set("qcwrwdw", entry.get("qcwrwdw"));
                        dynamicObject.set("qcpwxs", entry.get("qcpwxs"));
                        dynamicObject.set("tzl", entry.get("tzl"));
                        dynamicObject.set("templatefrom", (Object)"5");
                        needAdd.add(dynamicObject);
                        emptyEntryentity = false;
                    }
                }
                String sixPageId = this.getPageCache().get("loadtb-six");
                IFormView sixView = this.getView().getView(sixPageId);
                if (sixView != null && !CollectionUtils.isEmpty((Collection)(entryentity = sixView.getModel().getEntryEntity("entryentity")))) {
                    for (DynamicObject entry : entryentity) {
                        DynamicObject dynamicObject6 = HbsUtils.entryToObject3(entry, org, taxMonth, status);
                        dynamicObject6.set("constructionarea", entry.get("constructionarea"));
                        dynamicObject6.set("dustgenerationcoefficie", entry.get("dustgenerationcoefficie"));
                        dynamicObject6.set("reductioncoefficient", entry.get("reductioncoefficient"));
                        dynamicObject6.set("characteristiccoefficien", entry.get("characteristiccoefficien"));
                        dynamicObject6.set("templatefrom", (Object)"6");
                        needAdd.add((Object)dynamicObject6);
                        emptyEntryentity = false;
                    }
                }
                if (emptyEntryentity) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u5b58\u5931\u8d25\uff1a\u5f53\u524d\u7ec4\u7ec7\u5c5e\u671f\u7533\u62a5\u7c7b\u578b\u4e0d\u5b58\u5728\u9700\u8981\u91c7\u96c6\u7684\u6570\u636e\u3002", (String)"HbsTaxSourceInfoFormPlugin_36", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
                if (!CollectionUtils.isEmpty((Collection)needAdd)) {
                    TXHandle handle = TX.required();
                    dynamicObject = null;
                    try {
                        try {
                            QFilter orgFilter = new QFilter("org", "=", org.get("id"));
                            QFilter taxPeriodFilter = new QFilter("month", "=", taxMonth);
                            DeleteServiceHelper.delete((String)"tdm_airwater_tp", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
                            DeleteServiceHelper.delete((String)"tdm_pollute_airwater_tp", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
                            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])needAdd.toArray((Object[])new DynamicObject[0])));
                            DynamicObject dynamicObject7 = HbsUtils.saveToObject(org, taxMonth, this.getModel().getDataEntity().getString("type"));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject7});
                        }
                        catch (Exception e) {
                            handle.markRollback();
                            throw new RuntimeException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        dynamicObject = throwable;
                        throw throwable;
                    }
                    finally {
                        if (handle != null) {
                            if (dynamicObject != null) {
                                try {
                                    handle.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)dynamicObject).addSuppressed(throwable);
                                }
                            } else {
                                handle.close();
                            }
                        }
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u5b58\u6210\u529f", (String)"HbsTaxSourceInfoFormPlugin_22", (String)"taxc-tcret", (Object[])new Object[0]));
                    String operateName = ResManager.loadKDString((String)"\u6682\u5b58", (String)"YhsTaxSourceGatherFormPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]);
                    String operateDescription = ResManager.loadKDString((String)"\u5927\u6c14\u548c\u6c34\u6c61\u67d3\u7269\u91c7\u96c6\u6682\u5b58\u6210\u529f\u3002", (String)"YhsTaxSourceGatherFormPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]);
                    OperatorDialogUtils.operateDialog((String)"ccxws", (String)"tdm_pollution_air_water", (String)operateName, (String)operateDescription);
                }
                this.getPageCache().put("close", "true");
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d", (String)"HbsTaxSourceInfoFormPlugin_23", (String)"taxc-tcret", (Object[])new Object[0]));
            }
        }
    }

    private boolean sixEntryHandle(DynamicObject org, Object taxMonth, List<String> errorMesge, DynamicObjectCollection needAdd) {
        DynamicObjectCollection entryentity;
        String fivePageId = this.getPageCache().get("loadtb-six");
        IFormView sixView = this.getView().getView(fivePageId);
        if (sixView != null && !CollectionUtils.isEmpty((Collection)(entryentity = sixView.getModel().getEntryEntity("entryentity")))) {
            for (DynamicObject dynamicObject : entryentity) {
                HbsUtils.checkMustinput(SIX_MUSTINPUT, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u65bd\u5de5\u6392\u653e\u626c\u5c18-\u62bd\u6837\u6d4b\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"HbsTaxSourceInfoFormPlugin_31", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(SIX_BIGTHANZERO, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u65bd\u5de5\u6392\u653e\u626c\u5c18-\u62bd\u6837\u6d4b\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"HbsTaxSourceInfoFormPlugin_32", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(MUST_BIGTHANZERO, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u65bd\u5de5\u6392\u653e\u626c\u5c18-\u62bd\u6837\u6d4b\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u5f55\u5165\u7684\u503c\u9700\u8981\u5927\u4e8e0", (String)"HbsTaxSourceInfoFormPlugin_33", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkOnlyOne(dynamicObject, org.get("id"), taxMonth, errorMesge, ResManager.loadKDString((String)"\u3010\u65bd\u5de5\u6392\u653e\u626c\u5c18-\u62bd\u6837\u6d4b\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_34", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(errorMesge)) {
                this.getView().showErrorNotification(HbsUtils.checkMustinput(errorMesge));
                return true;
            }
            for (DynamicObject entry : entryentity) {
                DynamicObject dynamicObject = HbsUtils.entryToObject(entry, org, taxMonth);
                dynamicObject.set("constructionarea", entry.get("constructionarea"));
                dynamicObject.set("dustgenerationcoefficie", entry.get("dustgenerationcoefficie"));
                dynamicObject.set("reductioncoefficient", entry.get("reductioncoefficient"));
                dynamicObject.set("characteristiccoefficien", entry.get("characteristiccoefficien"));
                dynamicObject.set("templatefrom", (Object)"6");
                needAdd.add((Object)dynamicObject);
            }
        }
        return false;
    }

    private boolean fiveEntryHandle(DynamicObject org, Object taxMonth, List<String> errorMesge, DynamicObjectCollection needAdd) {
        DynamicObjectCollection entryentityFive;
        String fivePageId = this.getPageCache().get("loadtb-five");
        IFormView fiveView = this.getView().getView(fivePageId);
        if (fiveView != null && !CollectionUtils.isEmpty((Collection)(entryentityFive = fiveView.getModel().getEntryEntity("entryentity")))) {
            for (DynamicObject dynamicObject : entryentityFive) {
                HbsUtils.checkMustinput(FIVE_MUSTINPUT, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u79bd\u755c\u517b\u6b96\u4e1a\u3001\u5c0f\u578b\u4f01\u4e1a\u548c\u7b2c\u4e09\u4ea7\u4e1a-\u62bd\u6837\u6d4b\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"HbsTaxSourceInfoFormPlugin_17", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(FIVE_BIGTHANZERO, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u79bd\u755c\u517b\u6b96\u4e1a\u3001\u5c0f\u578b\u4f01\u4e1a\u548c\u7b2c\u4e09\u4ea7\u4e1a-\u62bd\u6837\u6d4b\u7b97\u6cd5\u3011\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"HbsTaxSourceInfoFormPlugin_18", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(Lists.newArrayList((Object[])new String[]{"wrwdlz", "dwse", "tzl", "qcpwxs"}), dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u79bd\u755c\u517b\u6b96\u4e1a\u3001\u5c0f\u578b\u4f01\u4e1a\u548c\u7b2c\u4e09\u4ea7\u4e1a-\u62bd\u6837\u6d4b\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u5f55\u5165\u7684\u503c\u9700\u8981\u5927\u4e8e0", (String)"HbsTaxSourceInfoFormPlugin_19", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkWrwdlz(dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u79bd\u755c\u517b\u6b96\u4e1a\u3001\u5c0f\u578b\u4f01\u4e1a\u548c\u7b2c\u4e09\u4ea7\u4e1a-\u62bd\u6837\u6d4b\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_20", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(errorMesge)) {
                this.getView().showErrorNotification(HbsUtils.checkMustinput(errorMesge));
                return true;
            }
            for (DynamicObject dynamicObject : entryentityFive) {
                HbsUtils.checkJmxzDm(dynamicObject, org.getLong("id"), errorMesge, "2", ResManager.loadKDString((String)"\u3010\u79bd\u755c\u517b\u6b96\u4e1a\u3001\u5c0f\u578b\u4f01\u4e1a\u548c\u7b2c\u4e09\u4ea7\u4e1a-\u62bd\u6837\u6d4b\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_20", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkOnlyOne(dynamicObject, org.get("id"), taxMonth, errorMesge, ResManager.loadKDString((String)"\u3010\u79bd\u755c\u517b\u6b96\u4e1a\u3001\u5c0f\u578b\u4f01\u4e1a\u548c\u7b2c\u4e09\u4ea7\u4e1a-\u62bd\u6837\u6d4b\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_20", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(errorMesge)) {
                this.getView().showErrorNotification(HbsUtils.checkMustinput(errorMesge));
                return true;
            }
            for (DynamicObject entry : entryentityFive) {
                DynamicObject dynamicObject = HbsUtils.entryToObject(entry, org, taxMonth);
                dynamicObject.set("qcwrwdw", entry.get("qcwrwdw"));
                dynamicObject.set("qcpwxs", entry.get("qcpwxs"));
                dynamicObject.set("tzl", entry.get("tzl"));
                dynamicObject.set("templatefrom", (Object)"5");
                needAdd.add((Object)dynamicObject);
            }
        }
        return false;
    }

    private boolean fourEntryHandle(DynamicObject org, Object taxMonth, List<String> errorMesge, DynamicObjectCollection needAdd) {
        DynamicObjectCollection entryentityFourth;
        String fourthPageId = this.getPageCache().get("loadtb-fourth");
        IFormView fourthView = this.getView().getView(fourthPageId);
        if (fourthView != null && !CollectionUtils.isEmpty((Collection)(entryentityFourth = fourthView.getModel().getEntryEntity("entryentity")))) {
            for (DynamicObject dynamicObject : entryentityFourth) {
                HbsUtils.checkMustinput(FOURTH_MUSTINPUT, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010PH\u503c\u3001\u8272\u5ea6\u3001\u5927\u80a0\u83cc\u7fa4\u6570\u3001\u4f59\u6c2f\u91cf\u6c34\u6c61\u67d3\u7269\u3011\u7b2c%s\u884c\uff1a\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"HbsTaxSourceInfoFormPlugin_13", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(FOURTH_BIGTHANZERO, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010PH\u503c\u3001\u8272\u5ea6\u3001\u5927\u80a0\u83cc\u7fa4\u6570\u3001\u4f59\u6c2f\u91cf\u6c34\u6c61\u67d3\u7269\u3011\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"HbsTaxSourceInfoFormPlugin_14", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(Lists.newArrayList((Object[])new String[]{"wrwdlz", "dwse", "sdcbbs"}), dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010PH\u503c\u3001\u8272\u5ea6\u3001\u5927\u80a0\u83cc\u7fa4\u6570\u3001\u4f59\u6c2f\u91cf\u6c34\u6c61\u67d3\u7269\u3011\u7b2c%s\u884c\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u5f55\u5165\u7684\u503c\u9700\u8981\u5927\u4e8e0", (String)"HbsTaxSourceInfoFormPlugin_15", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(errorMesge)) {
                this.getView().showErrorNotification(HbsUtils.checkMustinput(errorMesge));
                return true;
            }
            for (DynamicObject dynamicObject : entryentityFourth) {
                HbsUtils.checkJmxzDm(dynamicObject, org.getLong("id"), errorMesge, "2", ResManager.loadKDString((String)"\u3010PH\u503c\u3001\u8272\u5ea6\u3001\u5927\u80a0\u83cc\u7fa4\u6570\u3001\u4f59\u6c2f\u91cf\u6c34\u6c61\u67d3\u7269\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_16", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkOnlyOne(dynamicObject, org.get("id"), taxMonth, errorMesge, ResManager.loadKDString((String)"\u3010PH\u503c\u3001\u8272\u5ea6\u3001\u5927\u80a0\u83cc\u7fa4\u6570\u3001\u4f59\u6c2f\u91cf\u6c34\u6c61\u67d3\u7269\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_16", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(errorMesge)) {
                this.getView().showErrorNotification(HbsUtils.checkMustinput(errorMesge));
                return true;
            }
            for (DynamicObject entry : entryentityFourth) {
                DynamicObject dynamicObject = HbsUtils.entryToObject(entry, org, taxMonth);
                dynamicObject.set("execstandard", entry.get("execstandard"));
                dynamicObject.set("bzndz", entry.get("bzndz"));
                dynamicObject.set("emissions", entry.get("fqfspfl"));
                dynamicObject.set("sdcbbs", entry.get("sdcbbs"));
                dynamicObject.set("templatefrom", (Object)"4");
                needAdd.add((Object)dynamicObject);
            }
        }
        return false;
    }

    private boolean thirdEntryHandle(DynamicObject org, Object taxMonth, List<String> errorMesge, DynamicObjectCollection needAdd) {
        DynamicObjectCollection entryentityThird;
        String thirdPageId = this.getPageCache().get("loadtb-third");
        IFormView thirdView = this.getView().getView(thirdPageId);
        if (thirdView != null && !CollectionUtils.isEmpty((Collection)(entryentityThird = thirdView.getModel().getEntryEntity("entryentity")))) {
            for (DynamicObject dynamicObject : entryentityThird) {
                HbsUtils.checkMustinput(THIRD_MUSTINPUT, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u7269\u6599\u8861\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"HbsTaxSourceInfoFormPlugin_9", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(THIRD_BIGTHANZERO, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u7269\u6599\u8861\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"HbsTaxSourceInfoFormPlugin_10", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(MUST_BIGTHANZERO, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u7269\u6599\u8861\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u5f55\u5165\u7684\u503c\u9700\u8981\u5927\u4e8e0", (String)"HbsTaxSourceInfoFormPlugin_11", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(errorMesge)) {
                this.getView().showErrorNotification(HbsUtils.checkMustinput(errorMesge));
                return true;
            }
            for (DynamicObject dynamicObject : entryentityThird) {
                HbsUtils.checkJmxzDm(dynamicObject, org.getLong("id"), errorMesge, "3", ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u7269\u6599\u8861\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_12", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkOnlyOne(dynamicObject, org.get("id"), taxMonth, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u7269\u6599\u8861\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_12", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(errorMesge)) {
                this.getView().showErrorNotification(HbsUtils.checkMustinput(errorMesge));
                return true;
            }
            for (DynamicObject entry : entryentityThird) {
                DynamicObject dynamicObject = HbsUtils.entryToObject(entry, org, taxMonth);
                dynamicObject.set("execstandard", entry.get("execstandard"));
                dynamicObject.set("bzndz", entry.get("bzndz"));
                dynamicObject.set("templatefrom", (Object)"3");
                needAdd.add((Object)dynamicObject);
            }
        }
        return false;
    }

    private boolean twoEntryHandle(DynamicObject org, Object taxMonth, List<String> errorMesge, DynamicObjectCollection needAdd) {
        DynamicObjectCollection entryentitySecond;
        String secondPageId = this.getPageCache().get("loadtb-second");
        IFormView secondView = this.getView().getView(secondPageId);
        if (secondView != null && !CollectionUtils.isEmpty((Collection)(entryentitySecond = secondView.getModel().getEntryEntity("entryentity")))) {
            for (DynamicObject dynamicObject : entryentitySecond) {
                HbsUtils.checkMustinput(TWO_MUSTINPUT, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u4ea7\u6392\u6c61\u7cfb\u6570\u6cd5\u3011\u7b2c%s\u884c\uff1a\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"HbsTaxSourceInfoFormPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(TWO_BIGTHANZERO, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u4ea7\u6392\u6c61\u7cfb\u6570\u6cd5\u3011\u7b2c%s\u884c\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"HbsTaxSourceInfoFormPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(MUST_BIGTHANZERO, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u4ea7\u6392\u6c61\u7cfb\u6570\u6cd5\u3011\u7b2c%s\u884c\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u5f55\u5165\u7684\u503c\u9700\u8981\u5927\u4e8e0", (String)"HbsTaxSourceInfoFormPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(errorMesge)) {
                this.getView().showErrorNotification(HbsUtils.checkMustinput(errorMesge));
                return true;
            }
            for (DynamicObject dynamicObject : entryentitySecond) {
                HbsUtils.checkJmxzDm(dynamicObject, org.getLong("id"), errorMesge, "2", ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u4ea7\u6392\u6c61\u7cfb\u6570\u6cd5\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_8", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkOnlyOne(dynamicObject, org.get("id"), taxMonth, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u4ea7\u6392\u6c61\u7cfb\u6570\u6cd5\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_8", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(errorMesge)) {
                this.getView().showErrorNotification(HbsUtils.checkMustinput(errorMesge));
                return true;
            }
            for (DynamicObject entry : entryentitySecond) {
                DynamicObject dynamicObject = HbsUtils.entryToObject(entry, org, taxMonth);
                dynamicObject.set("execstandard", entry.get("execstandard"));
                dynamicObject.set("bzndz", entry.get("bzndz"));
                dynamicObject.set("wrwdw", entry.get("wrwdw"));
                dynamicObject.set("jsjcdw", entry.get("jsjcdw"));
                dynamicObject.set("jsjc", entry.get("jsjc"));
                dynamicObject.set("syxs", entry.get("syxs"));
                dynamicObject.set("wrwpfl", entry.get("wrwpfl"));
                dynamicObject.set("cwxs", entry.get("cwxs"));
                dynamicObject.set("pwxs", entry.get("pwxs"));
                dynamicObject.set("hsz", entry.get("hsz"));
                dynamicObject.set("templatefrom", (Object)"2");
                needAdd.add((Object)dynamicObject);
            }
        }
        return false;
    }

    private boolean firstEntryHandle(DynamicObject org, Object taxMonth, List<String> errorMesge, DynamicObjectCollection needAdd) {
        DynamicObjectCollection entryentityOne;
        String firstPageId = this.getPageCache().get("loadtb-first");
        IFormView firstView = this.getView().getView(firstPageId);
        if (firstView != null && !CollectionUtils.isEmpty((Collection)(entryentityOne = firstView.getModel().getEntryEntity("entryentity")))) {
            for (DynamicObject dynamicObject : entryentityOne) {
                HbsUtils.checkMustinput(ONE_MUSTINPUT, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u76d1\u6d4b\u8ba1\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"HbsTaxSourceInfoFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(ONE_BIGTHANZERO, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u76d1\u6d4b\u8ba1\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"HbsTaxSourceInfoFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkBigThanZero(MUST_BIGTHANZERO, dynamicObject, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u76d1\u6d4b\u8ba1\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a\u4ee5\u4e0b\u5b57\u6bb5\u5f55\u5165\u7684\u503c\u9700\u8981\u5927\u4e8e0", (String)"HbsTaxSourceInfoFormPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(errorMesge)) {
                this.getView().showErrorNotification(HbsUtils.checkMustinput(errorMesge));
                return true;
            }
            for (DynamicObject dynamicObject : entryentityOne) {
                HbsUtils.checkJmxzDm(dynamicObject, org.getLong("id"), errorMesge, "1", ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u76d1\u6d4b\u8ba1\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
                HbsUtils.checkOnlyOne(dynamicObject, org.get("id"), taxMonth, errorMesge, ResManager.loadKDString((String)"\u3010\u4e00\u7c7b\u6c34\u3001\u4e8c\u7c7b\u6c34\u3001\u5927\u6c14\u6c61\u67d3\u7269-\u76d1\u6d4b\u8ba1\u7b97\u6cd5\u3011\u7b2c%s\u884c\uff1a", (String)"HbsTaxSourceInfoFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(errorMesge)) {
                this.getView().showErrorNotification(HbsUtils.checkMustinput(errorMesge));
                return true;
            }
            for (DynamicObject entry : entryentityOne) {
                DynamicObject dynamicObject = HbsUtils.entryToObject(entry, org, taxMonth);
                dynamicObject.set("execstandard", entry.get("execstandard"));
                dynamicObject.set("bzndz", entry.get("bzndz"));
                dynamicObject.set("emissions", entry.get("fqfspfl"));
                dynamicObject.set("scndz", entry.get("scndz"));
                dynamicObject.set("yjndz", entry.get("ydndz"));
                dynamicObject.set("zgndz", entry.get("zgndz"));
                dynamicObject.set("templatefrom", (Object)"1");
                needAdd.add((Object)dynamicObject);
            }
        }
        return false;
    }

    private boolean haveChange() {
        String[] split;
        String type = this.getModel().getDataEntity().getString("type");
        if (type == null) {
            return true;
        }
        for (String name : split = type.split(",")) {
            if (!StringUtils.isNotEmpty((String)name) || !this.getControl(name).getView().getModel().getDataChanged()) continue;
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object status = customParams.get("status") == null ? customParams.get("statusTest") : customParams.get("status");
        String callBackId = e.getCallBackId();
        if ("bar_cancel".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.closeView();
        }
        if (CHANGED_TYPE.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                this.setTab();
            } else {
                this.getPageCache().put(CHANGED_TYPE, "1");
                this.getModel().setValue("type", (Object)this.getPageCache().get(OLDTYPE));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, TABAP);
        this.addItemClickListeners(new String[]{"toolbara"});
    }

    public void addTabSelectListener(TabSelectListener form, String ... tabName) {
        Tab tab = null;
        int len = tabName.length;
        for (int i = 0; i < len; ++i) {
            tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
    }

    private void showPage(String tabKey) {
        if (StringUtils.isEmpty((String)tabKey)) {
            return;
        }
        switch (tabKey) {
            case "first": {
                this.showFormInnerTabPage("tcret_one_air_jcjsf", tabKey);
                break;
            }
            case "second": {
                this.showFormInnerTabPage("tcret_two_air_cpwxsf", tabKey);
                break;
            }
            case "third": {
                this.showFormInnerTabPage("tcret_third_air_wlhsf", tabKey);
                break;
            }
            case "fourth": {
                this.showFormInnerTabPage("tcret_fourth_water_psdcyl", tabKey);
                break;
            }
            case "five": {
                this.showFormInnerTabPage("tcret_five_qc_cycsf", tabKey);
                break;
            }
            case "six": {
                this.showFormInnerTabPage("tcret_six_sgpfyc", tabKey);
            }
        }
    }

    private boolean isLoaded(String key) {
        return null != this.getPageCache().get("loadtb-" + key);
    }

    private void batchRemove() {
        this.getPageCache().remove("loadtb-first");
        this.getPageCache().remove("loadtb-second");
        this.getPageCache().remove("loadtb-third");
        this.getPageCache().remove("loadtb-fourth");
        this.getPageCache().remove("loadtb-five");
        this.getPageCache().remove("loadtb-six");
    }

    private void showFormInnerTabPage(String pageName, String tbName) {
        String flag = "loadtb-" + tbName;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("fromno", tbName);
        FormShowParameter parameter = new FormShowParameter();
        String pageId = parameter.getPageId();
        parameter.setFormId(pageName);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(tbName);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
        this.getPageCache().put(flag, pageId);
    }

    private void monthLinkage(String orgid) {
        if (StringUtils.isEmpty((String)orgid)) {
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tdm_pollution_air_water", (String)"month", (QFilter[])new QFilter[]{orgFilter}, (String)"month desc", (int)1);
        if (query != null && query.size() > 0 && ((DynamicObject)query.get(0)).get("month") != null) {
            this.getModel().setValue("taxmonth", (Object)DateUtils.addMonth((Date)((DynamicObject)query.get(0)).getDate("month"), (int)1));
        } else {
            this.getModel().setValue("taxmonth", null);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("org".equals(key)) {
            ChangeData[] changeSet = e.getChangeSet();
            DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
            if (newValue == null) {
                return;
            }
            if (OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)newValue.getString("id"), (String)"tcret", (String)"hjbhs")) {
                this.getView().getModel().setValue("org", changeSet[0].getOldValue() == null ? null : ((DynamicObject)changeSet[0].getOldValue()).get("id"));
                return;
            }
            this.monthLinkage(newValue.getString("id"));
            if (!this.checkTpData(this.getModel().getValue("org"), this.getModel().getValue("taxmonth"))) {
                return;
            }
            this.showTab();
        }
        if ("taxmonth".equals(key)) {
            if (!this.checkTpData(this.getModel().getValue("org"), this.getModel().getValue("taxmonth"))) {
                return;
            }
            this.showTab();
        }
        if (!"type".equals(key)) return;
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        String oldValue = (String)e.getChangeSet()[0].getOldValue();
        if (StringUtils.isNotEmpty((String)newValue)) {
            void var5_9;
            String[] newValues = newValue.split(",");
            if (StringUtils.isNotEmpty((String)oldValue)) {
                String[] oldValues = oldValue.split(",");
                if (newValues.length <= oldValues.length) {
                    this.showConfirmDialog(oldValue);
                    return;
                }
                List list = Arrays.stream(newValues).filter(n -> !Arrays.asList(oldValues).contains(n)).collect(Collectors.toList());
            } else {
                List<String> list = Arrays.asList(newValues);
            }
            if ("1".equals(this.getPageCache().get(CHANGED_TYPE))) {
                this.getPageCache().put(CHANGED_TYPE, "0");
                return;
            }
            this.setTab();
            for (String s : var5_9) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                this.showPage(s);
            }
            return;
        } else {
            this.showConfirmDialog(oldValue);
        }
    }

    private void showTab() {
        String type = this.getModel().getDataEntity().getString("type");
        if (StringUtils.isNotEmpty((String)type)) {
            String[] types;
            for (String s : types = type.split(",")) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                this.showPage(s);
            }
            if (types.length > 0) {
                Tab tab = (Tab)this.getControl(TABAP);
                tab.selectTab(types[0]);
                tab.activeTab(types[0]);
            }
        }
    }

    private void showConfirmDialog(String oldValue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CHANGED_TYPE, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u52fe\u9009\u4fee\u6539\u6570\u636e\u5c06\u4f1a\u88ab\u6e05\u7a7a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d6\u6d88\u52fe\u9009\u3002", (String)"HbsTaxSourceInfoFormPlugin_35", (String)"taxc-tcret", (Object[])new Object[0]), options, ConfirmTypes.Save, confirmCallBacks);
        this.getPageCache().put(OLDTYPE, oldValue);
    }

    private boolean checkTpData(Object org, Object month) {
        QFilter taxPeriodFilter;
        if (org == null || month == null) {
            return false;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)((DynamicObject)org).getLong("id"));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tdm_airwater_tp", (String)"org,month", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter = new QFilter("month", "=", month)});
        if (dynamicObjectCollection.size() != 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7ec4\u7ec7\u3001\u5c5e\u671f\u5df2\u5b58\u5728\u6682\u5b58\u6570\u636e\uff0c\u8bf7\u5207\u6362\u5176\u5b83\u7ec4\u7ec7\u3001\u5c5e\u671f", (String)"HbsTaxSourceInfoFormPlugin_25", (String)"taxc-tcret", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String code_close = this.getPageCache().get("code_close");
        if (!"true".equals(code_close)) {
            this.close(e);
        }
    }

    private void close(BeforeClosedEvent e) {
        try {
            boolean isclose;
            boolean haveChange = this.haveChange();
            boolean bl = isclose = this.getPageCache().get("close") == null || !this.getPageCache().get("close").equals("true");
            if (haveChange && isclose) {
                if (e != null) {
                    e.setCancel(true);
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_cancel", (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"HbsTaxSourceInfoFormPlugin_26", (String)"taxc-tcret", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"HbsTaxSourceInfoFormPlugin_27", (String)"taxc-tcret", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"HbsTaxSourceInfoFormPlugin_28", (String)"taxc-tcret", (Object[])new Object[0]), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            } else {
                this.closeView();
            }
        }
        catch (Exception ex) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d", (String)"HbsTaxSourceInfoFormPlugin_23", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    protected void closeView() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object status = customParams.get("status") == null ? customParams.get("statusTest") : customParams.get("status");
        this.getPageCache().put("code_close", "true");
        this.getView().close();
        if (status != null && !status.equals("batchnew") && this.getView().getParentView() != null) {
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void recordOperatorLog(List<String> billnos) {
        billnos.forEach(billno -> {
            String appId = this.getView().getFormShowParameter().getAppId();
            String billFormId = "tdm_pollution_air_water";
            String operateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"HbsTaxSourceInfoFormPlugin_29", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u4fdd\u5b58\u6210\u529f", (String)"HbsTaxSourceInfoFormPlugin_30", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), billno);
            OperatorDialogUtils.operateDialog((String)TaxNameUtil.getTaxName((String)appId), (String)billFormId, (String)operateName, (String)operateDescription);
        });
    }
}

