/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class LandLevelImportPlugin
extends BatchImportPlugin {
    private static final String tabLine = "\n";

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            StringBuilder message = new StringBuilder();
            ImportBillData data = it.next();
            this.validBillData(data, message);
            if (!StringUtils.isNotBlank((CharSequence)message.toString())) continue;
            logger.log(Integer.valueOf(data.getStartIndex()), message.toString()).fail();
            it.remove();
        }
        return super.save(rowdatas, logger);
    }

    private void validBillData(ImportBillData data, StringBuilder message) {
        BigDecimal taxStandard;
        JSONObject taxoffice = data.getData().getJSONObject("group");
        DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorgan", (String)"id,number,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", taxoffice.get((Object)"number"))});
        if (orgObject == null) {
            LandLevelImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u6570\u636e\u4e0d\u5b58\u5728,\u7f16\u7801%s", (String)"LandLevelImportPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), taxoffice.get((Object)"number")));
        } else if (orgObject.get("enable").equals("0")) {
            LandLevelImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u672a\u542f\u7528\uff1a\u7f16\u7801%s", (String)"LandLevelImportPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]), taxoffice.get((Object)"number")));
        }
        String taxstandard = data.getData().getString("taxstandard");
        boolean checkTaxstandard = this.checkNumeric(taxstandard, ResManager.loadKDString((String)"\u7a0e\u989d\u6807\u51c6\uff08\u5143/\u5e73\u65b9\u7c73\uff09", (String)"LandLevelImportPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]), message);
        if (taxstandard != null && checkTaxstandard && (taxStandard = new BigDecimal(taxstandard)).compareTo(BigDecimal.ZERO) < 0) {
            LandLevelImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u7a0e\u989d\u6807\u51c6\u8f93\u5165\u503c\u8981\u5927\u4e8e\u7b49\u4e8e0", (String)"LandLevelImportPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    private static void errorMsg(StringBuilder errors, String msg) {
        errors.append(msg).append(tabLine);
    }

    private boolean checkNumeric(String value, String fieldName, StringBuilder message) {
        if (value == null) {
            return true;
        }
        if (!(value = value.replaceAll(",", "")).matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            LandLevelImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"%s\uff1a\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"LandLevelImportPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]), fieldName));
            return false;
        }
        return true;
    }
}

