/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TcretDeductTZDetailFormPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String SBBID = "sbbid";
    private static final String ORG = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String RULEID = "ruleid";
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    private static final String ENTRYENTITY_LIST = "entryentitylist";
    private static final String TCRET_TDZZSYJ_ADJUST_DE = "tcret_tdzzsyj_adjust_de";
    private static final String TCRET_TDZZS_YJ_DET = "tcret_tdzzs_yj_det";
    private static final String TCRET_TDZZDYJ_EDIT = "tcret_tdzzdyj_edit";
    private static final String TCRET_LVAT_RULE = "tcret_lvat_rule";
    private static boolean ENABLE = true;

    public void initialize() {
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String selectPro = "org,ruleid,yjxm,adjustamount,totalamount,titlename,adjustexplain,amount";
        String operation = (String)customParams.get("operation");
        String adjustEdtEntity = EntityMappingUtils.getEntityName((String)operation, (String)TCRET_TDZZSYJ_ADJUST_DE);
        DynamicObject[] adjustDetails = this.getAdjustData(customParams, adjustEdtEntity, selectPro);
        this.doSetAdjusRecordtList(customParams);
        String yjDetEntity = EntityMappingUtils.getEntityName((String)operation, (String)TCRET_TDZZS_YJ_DET);
        DynamicObject[] genericObjects = this.loadDetailData(customParams, yjDetEntity);
        if (genericObjects.length == 0) {
            this.appendCard(adjustDetails, null, customParams);
            return;
        }
        Map<String, List<DynamicObject>> map = Arrays.stream(genericObjects).sorted(Comparator.comparing(d -> d.getLong("id"))).collect(Collectors.groupingBy(s -> s.getString(RULEID)));
        this.getModel().beginInit();
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
            DynamicObject detail = entry.getValue().get(0);
            DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((Object)detail.getLong(RULEID), (String)TCRET_LVAT_RULE);
            this.getModel().setValue(RULEID, (Object)rule.getLong("id"), rowIndex);
            DynamicObject taxorg = entry.getValue().get(0).getDynamicObject(ORG);
            this.getModel().setValue(ORG, (Object)Long.parseLong((String)customParams.get(ORG)), rowIndex);
            this.getModel().setValue("titlename", (Object)rule.getString("name"), rowIndex);
            Object tdzzsxmid = customParams.get("tdzzsxmid");
            DynamicObject object = BusinessDataServiceHelper.loadSingle(tdzzsxmid, (String)"tdm_tdzzs_clearing_unit");
            this.getModel().setValue("itemname", (Object)object.getString("name"), rowIndex);
            this.getModel().setValue("amount", (Object)this.getAmount(detail.getString(RULEID), entry.getValue()), rowIndex);
            this.getModel().setValue("adjustamount", (Object)this.getAdjustamount(rule.getString("id"), adjustDetails), rowIndex);
            this.getModel().setValue("totalamount", (Object)this.getTotalamount(detail, adjustDetails, entry.getValue()), rowIndex);
            this.getModel().setValue("cardadjustexplain", (Object)this.getAdjustExplain(rule.getString("id"), adjustDetails), rowIndex);
            this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"adjustamount"});
            this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"totalamount"});
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_CARD);
        this.appendCard(adjustDetails, genericObjects, customParams);
        Map.Entry first = (Map.Entry)map.entrySet().stream().findFirst().get();
        this.clearEntry(ENTRYENTITY_LIST);
        this.setEntryentitylist((String)first.getKey(), yjDetEntity);
    }

    private void doSetAdjusRecordtList(Map<String, Object> customParams) {
        String selectPrope = "adjusttype,itemname,org,preadjust,postadjust,adjustexplain,creator,createtime";
        String operation = (String)customParams.get("operation");
        String yjEditEntity = EntityMappingUtils.getEntityName((String)operation, (String)TCRET_TDZZDYJ_EDIT);
        DynamicObject[] adjustDetails = this.getAdjustData(customParams, yjEditEntity, selectPrope);
        if (adjustDetails == null || adjustDetails.length == 0) {
            return;
        }
        for (DynamicObject a : adjustDetails) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("adjusttype", a.get("adjusttype"), rowIndex);
            this.getModel().setValue("title", a.get("itemname"), rowIndex);
            this.getModel().setValue("orgname", a.get(ORG), rowIndex);
            this.getModel().setValue("preadjust", a.get("preadjust"), rowIndex);
            this.getModel().setValue("postadjust", a.get("postadjust"), rowIndex);
            this.getModel().setValue("adjustexplain", a.get("adjustexplain"), rowIndex);
            this.getModel().setValue("creator", a.get("creator_id"), rowIndex);
            this.getModel().setValue("createtime", a.get("createtime"), rowIndex);
        }
    }

    private DynamicObject[] getAdjustData(Map<String, Object> customParams, String entryname, String selectPrope) {
        String sbbid = (String)customParams.get(SBBID);
        QFilter sbbIdFilter = new QFilter(SBBID, "=", (Object)Long.parseLong(sbbid));
        QFilter yjxmFilter = new QFilter("yjxm", "=", customParams.get("tdzzsxmid"));
        QFilter rowindexFilter = new QFilter("rowindex", "=", customParams.get("rowindex"));
        QFilter columntypeFilter = new QFilter("columntype", "=", customParams.get("columntype"));
        QFilter[] filters = new QFilter[]{sbbIdFilter, yjxmFilter, rowindexFilter, columntypeFilter};
        return BusinessDataServiceHelper.load((String)entryname, (String)selectPrope, (QFilter[])filters);
    }

    private DynamicObject[] loadDetailData(Map<String, Object> customParams, String entryname) {
        String sbbId = (String)customParams.get(SBBID);
        QFilter sbbIdQFlter = new QFilter(SBBID, "=", (Object)Long.parseLong(sbbId));
        QFilter yjxmFilter = new QFilter("yjxm", "=", customParams.get("tdzzsxmid"));
        QFilter buildingtypeFilter = new QFilter("buildingtype", "=", customParams.get("buildingtype"));
        QFilter subbuildingtypeFilter = new QFilter("subbuildingtype", "=", customParams.get("subbuildingtype"));
        Long srlxId = 1361447775962687488L;
        Object columntype = customParams.get("columntype");
        if ("swjqtsr".equals(columntype)) {
            srlxId = 1361447775962687489L;
        } else if ("stxssr".equals(columntype)) {
            srlxId = 1361447775962687490L;
        }
        QFilter sblxFilter = new QFilter("incometype", "=", (Object)srlxId);
        String selectProperties = "ruleid,serialno,skssqq,table,amountfield,datatype,datadirection,amount,fetchamount,filtercondition,org";
        return BusinessDataServiceHelper.load((String)entryname, (String)selectProperties, (QFilter[])new QFilter[]{sbbIdQFlter, yjxmFilter, buildingtypeFilter, subbuildingtypeFilter, sblxFilter});
    }

    private Object calcAdjustsumamount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal totalamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalamount;
    }

    private void appendCard(DynamicObject[] adjustDetails, DynamicObject[] genericObjects, Map<String, Object> customParams) {
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> "0".equals(s.getString(RULEID))).findFirst();
        DynamicObject dynamicObject = optional.isPresent() ? optional.get() : null;
        int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        this.getModel().setValue("titlename", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"TcretDeductTZDetailFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), rowIndex);
        this.getModel().setValue("cardadjustexplain", (Object)(dynamicObject != null ? dynamicObject.getString("adjustexplain") : ""), rowIndex);
        this.getModel().setValue("totalamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("totalamount") : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue("adjustamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("adjustamount") : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue(RULEID, (Object)0L, rowIndex);
        this.getModel().setValue(ORG, (Object)Long.parseLong((String)customParams.get(ORG)), rowIndex);
        Object tdzzsxmid = customParams.get("tdzzsxmid");
        Object cellvalue = customParams.get("cellvalue");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)tdzzsxmid, (String)"tdm_tdzzs_clearing_unit");
        this.getModel().setValue("itemname", (Object)object.getString("name"), rowIndex);
        if (genericObjects == null && cellvalue != null) {
            if (dynamicObject == null) {
                this.getModel().setValue("amount", cellvalue, rowIndex);
                this.getModel().setValue("sumamount", cellvalue);
                this.getModel().setValue("adjustsumamount", cellvalue);
            } else {
                BigDecimal amount = dynamicObject.getBigDecimal("amount");
                BigDecimal adjustamount = dynamicObject.getBigDecimal("adjustamount");
                this.getModel().setValue("amount", (Object)amount, rowIndex);
                this.getModel().setValue("sumamount", (Object)amount);
                this.getModel().setValue("adjustsumamount", (Object)amount.add(adjustamount));
            }
        } else {
            this.getModel().setValue("amount", (Object)0, rowIndex);
            this.getModel().setValue("sumamount", (Object)this.calcSumAmount(genericObjects));
            this.getModel().setValue("adjustsumamount", this.calcAdjustsumamount());
        }
        this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"adjustamount"});
        this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"totalamount"});
    }

    private BigDecimal getTotalamount(DynamicObject detail, DynamicObject[] adjustDetails, List<DynamicObject> genericObjects) {
        String ruleid = detail.getString(RULEID);
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> StringUtil.equals((CharSequence)s.getString(RULEID), (CharSequence)ruleid)).findFirst();
        BigDecimal result = optional.isPresent() ? optional.get().getBigDecimal("totalamount") : this.getAmount(ruleid, genericObjects);
        return result;
    }

    private BigDecimal getAdjustamount(String ruleid, DynamicObject[] adjustDetails) {
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> StringUtil.equals((CharSequence)s.getString(RULEID), (CharSequence)ruleid)).findFirst();
        if (optional.isPresent()) {
            return optional.get().getBigDecimal("adjustamount");
        }
        return BigDecimal.ZERO;
    }

    private String getAdjustExplain(String ruleid, DynamicObject[] adjustDetails) {
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> s.get(RULEID).equals(ruleid)).findFirst();
        return optional.map(dynamicObject -> dynamicObject.getString("adjustexplain")).orElse(null);
    }

    private BigDecimal calcSumAmount(DynamicObject[] genericObjects) {
        if (genericObjects == null || genericObjects.length == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = Arrays.stream(genericObjects).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    private BigDecimal getAmount(String ruleid, List<DynamicObject> genericObjects) {
        BigDecimal sum = genericObjects.stream().filter(s -> StringUtil.equals((CharSequence)s.getString(RULEID), (CharSequence)ruleid)).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("adjustamount".equals(name) || "totalamount".equals(name) || "otheradjustamount".equals(name)) {
            BigDecimal amount;
            if ("adjustamount".equals(name)) {
                BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("totalamount", (Object)adjustamount.add(amount), rowIndex);
            }
            if ("totalamount".equals(name)) {
                BigDecimal totalamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("adjustamount", (Object)totalamount.subtract(amount), rowIndex);
            }
            this.refreshAdjustSumAmount();
        }
    }

    private void refreshAdjustSumAmount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal adjustsumamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("adjustsumamount", (Object)adjustsumamount);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "save".equals(((Donothing)args.getSource()).getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String billstatus = (String)customParams.get("billstatus");
            if (billstatus != null) {
                if ("C".equals(billstatus)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6e90\u5df2\u5ba1\u6838\uff0c\u4e0d\u652f\u6301\u4fee\u6539", (String)"TcretDeductTZDetailFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
                if ("B".equals(billstatus)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6e90\u5df2\u63d0\u4ea4\uff0c\u4e0d\u652f\u6301\u4fee\u6539", (String)"TcretDeductTZDetailFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
            }
            String orgid = (String)customParams.get(ORG);
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
            DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
            ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
            if (!CollectionUtils.isEmpty((Collection)entryentitycard)) {
                BigDecimal adjustsumamount = (BigDecimal)this.getModel().getValue("adjustsumamount");
                if (BigDecimal.ZERO.compareTo(adjustsumamount) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u5408\u8ba1\u91d1\u989d\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"TcretDeductTZDetailFormPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
                this.addAdjustRecord(entryentitycard);
                String operation = (String)customParams.get("operation");
                String entityName = EntityMappingUtils.getEntityName((String)operation, (String)TCRET_TDZZSYJ_ADJUST_DE);
                String sbbid = (String)customParams.get(SBBID);
                this.deleteDetail(entityName, orgid, skssqq, skssqz);
                for (DynamicObject dynamicObject : entryentitycard) {
                    DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
                    object.set(SBBID, (Object)Long.parseLong(sbbid));
                    object.set(RULEID, (Object)dynamicObject.getString(RULEID));
                    object.set("titlename", (Object)dynamicObject.getString("titlename"));
                    object.set("itemname", (Object)dynamicObject.getString("itemname"));
                    object.set("amount", (Object)dynamicObject.getBigDecimal("amount"));
                    object.set("adjustamount", (Object)dynamicObject.getBigDecimal("adjustamount"));
                    object.set("totalamount", (Object)dynamicObject.getBigDecimal("totalamount"));
                    object.set("adjustexplain", (Object)dynamicObject.getString("cardadjustexplain"));
                    object.set(ORG, (Object)orgid);
                    object.set(SKSSQQ, (Object)skssqq);
                    object.set(SKSSQZ, (Object)skssqz);
                    object.set("yjxm", customParams.get("tdzzsxmid"));
                    object.set("columntype", customParams.get("columntype"));
                    object.set("rowindex", customParams.get("rowindex"));
                    datas.add(object);
                }
            }
            SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
            customParams.put("adjustsumamout", this.getModel().getValue("adjustsumamount").toString());
            this.getView().returnDataToParent((Object)customParams);
            this.getView().close();
        }
    }

    private void deleteDetail(String entityName, String orgid, Object skssqq, Object skssqz) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        QFilter yjxmFilter = new QFilter("yjxm", "=", customParams.get("tdzzsxmid"));
        QFilter rowindexFilter = new QFilter("rowindex", "=", customParams.get("rowindex"));
        QFilter columntypeFilter = new QFilter("columntype", "=", customParams.get("columntype"));
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(SKSSQQ, "=", skssqq).and(new QFilter(SKSSQZ, "=", skssqz)).and(new QFilter(ORG, "=", (Object)Long.valueOf(orgid))), yjxmFilter, rowindexFilter, columntypeFilter});
    }

    private void addAdjustRecord(DynamicObjectCollection entryentitycard) {
        String manualAdjust = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"TcretDeductTZDetailFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]);
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get(ORG);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        String selectPrope = "org,ruleid,yjxm,adjustamount,totalamount,titlename,adjustexplain,columntype,rowindex,skssqq,skssqz";
        String operation = (String)customParams.get("operation");
        String adjustEdtEntity = EntityMappingUtils.getEntityName((String)operation, (String)TCRET_TDZZSYJ_ADJUST_DE);
        DynamicObject[] adjustDetails = this.getAdjustData(customParams, adjustEdtEntity, selectPrope);
        Map<String, BigDecimal> adjustDetailMap = Arrays.asList(adjustDetails).stream().collect(Collectors.toMap(a -> this.getRuleCardKey((DynamicObject)a, customParams).concat(a.getDynamicObject(ORG).getString("id")), a -> a.getBigDecimal("adjustamount"), (k, v) -> k));
        String yjEditEntity = EntityMappingUtils.getEntityName((String)operation, (String)TCRET_TDZZDYJ_EDIT);
        String sbbid = (String)customParams.get(SBBID);
        for (DynamicObject d : entryentitycard) {
            BigDecimal currentAdjustAmount;
            String key = this.getRuleCardKey(d, customParams);
            BigDecimal preAdjustAmount = adjustDetailMap.get(key = key.concat(d.getDynamicObject(ORG).getString("id")));
            preAdjustAmount = preAdjustAmount == null ? BigDecimal.ZERO : preAdjustAmount;
            if (preAdjustAmount.compareTo(currentAdjustAmount = d.getBigDecimal("adjustamount")) == 0) continue;
            DynamicObject adjustObj = BusinessDataServiceHelper.newDynamicObject((String)yjEditEntity);
            adjustObj.set(SBBID, (Object)Long.parseLong(sbbid));
            adjustObj.set("adjusttype", (Object)(manualAdjust.equals(d.getString("titlename")) ? 2 : 1));
            adjustObj.set(RULEID, (Object)d.getString(RULEID));
            adjustObj.set("titlename", (Object)d.getString("titlename"));
            adjustObj.set("itemname", (Object)d.getString("itemname"));
            adjustObj.set("preadjust", (Object)preAdjustAmount);
            adjustObj.set("postadjust", (Object)currentAdjustAmount);
            adjustObj.set("adjustexplain", d.get("cardadjustexplain"));
            adjustObj.set(ORG, orgid);
            adjustObj.set(SKSSQQ, (Object)skssqq);
            adjustObj.set(SKSSQZ, (Object)skssqz);
            adjustObj.set("yjxm", customParams.get("tdzzsxmid"));
            adjustObj.set("columntype", customParams.get("columntype"));
            adjustObj.set("rowindex", customParams.get("rowindex"));
            saveList.add(adjustObj);
        }
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
    }

    private String getRuleCardKey(DynamicObject d, Map<String, Object> customParams) {
        return String.join((CharSequence)"", d.getString(RULEID), (String)customParams.get(SKSSQQ), (String)customParams.get(SKSSQZ), customParams.get("tdzzsxmid").toString(), customParams.get("rowindex").toString(), (String)customParams.get("columntype"), d.getString("titlename"));
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        List rows = evt.getNewRows();
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        if (entryentitycard.size() - 1 == (Integer)rows.get(0)) {
            return;
        }
        if (rows.isEmpty()) {
            return;
        }
        this.clearEntry(ENTRYENTITY_LIST);
        Long ruleid = (Long)cardEntry.getModel().getValue(RULEID);
        if (ruleid != null) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String operation = (String)customParams.get("operation");
            String yjDetEntity = EntityMappingUtils.getEntityName((String)operation, (String)TCRET_TDZZS_YJ_DET);
            this.setEntryentitylist(ruleid.toString(), yjDetEntity);
        }
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }

    private void setEntryentitylist(String ruleid, String entryname) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        QFilter ruleFilter = new QFilter(RULEID, "=", (Object)Long.parseLong(ruleid));
        String sbbid = (String)customParams.get(SBBID);
        QFilter sbbIdQFilter = new QFilter(SBBID, "=", (Object)Long.parseLong(sbbid));
        QFilter yjxmFilter = new QFilter("yjxm", "=", customParams.get("tdzzsxmid"));
        QFilter buildingtypeFilter = new QFilter("buildingtype", "=", customParams.get("buildingtype"));
        QFilter subbuildingtypeFilter = new QFilter("subbuildingtype", "=", customParams.get("subbuildingtype"));
        Long srlxId = 1361447775962687488L;
        Object columntype = customParams.get("columntype");
        if ("swjqtsr".equals(columntype)) {
            srlxId = 1361447775962687489L;
        } else if ("stxssr".equals(columntype)) {
            srlxId = 1361447775962687490L;
        }
        QFilter sblxFilter = new QFilter("incometype", "=", (Object)srlxId);
        QFilter[] filters = new QFilter[]{sbbIdQFilter, ruleFilter, yjxmFilter, buildingtypeFilter, subbuildingtypeFilter, sblxFilter};
        String selectProperties = "skssqq,absolute,bizname,table,datatype,amountfield,datadirection,fetchamount,amount,filtercondition,ruleid,serialno,taxperiod";
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entryname, (String)selectProperties, (QFilter[])filters);
        this.getModel().beginInit();
        for (DynamicObject object : collection) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_LIST);
            this.getModel().setValue("taxperiod", object.get("taxperiod"), rowIndex);
            this.getModel().setValue("bizname", object.get("bizname"), rowIndex);
            this.getModel().setValue("table", object.get("table"), rowIndex);
            this.getModel().setValue("amountfield", object.get("amountfield"), rowIndex);
            this.getModel().setValue("datatype", (Object)object.getString("datatype"), rowIndex);
            this.getModel().setValue("absolute", object.get("absolute"), rowIndex);
            this.getModel().setValue("datadirection", object.get("datadirection"), rowIndex);
            this.getModel().setValue("fetchamount", object.get("amount"), rowIndex);
            this.getModel().setValue("filtercondition", object.get("filtercondition"), rowIndex);
            this.getModel().setValue("filtercondition_tag", object.get("filtercondition"), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_LIST);
    }

    public void afterBindData(EventObject e) {
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.selectCard(Integer.valueOf(0));
        entryentitycard.selectRowsChanged(Collections.singletonList(0), null);
    }
}

