/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.taxsource.BeforeF7FilterHelper;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;
import kd.taxc.tcret.common.utils.YhsUtils;

public class YhsTaxAccountEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String ORG = "org";
    private static final String TAXITEM = "taxitem";
    private static final String SUB_TAX_ITEM = "subtaxitem";
    private static final String QLXK = "014";
    private static final String QTZP = "013";
    private static final String JZZP = "012";
    private static final String DEDUCTIONCODE = "deductioncode";
    private static final Set<String> LockList = Sets.newHashSet((Object[])new String[]{"014", "013", "012"});

    public void initialize() {
        BasedataEdit taxitem = (BasedataEdit)this.getControl(TAXITEM);
        taxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit subTaxItem = (BasedataEdit)this.getControl(SUB_TAX_ITEM);
        subTaxItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit deductioncode = (BasedataEdit)this.getControl(DEDUCTIONCODE);
        deductioncode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org != null) {
            boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)org.getLong("id"));
            if (zeroDeclare) {
                String orgname = OrgUtils.getOrgNameById((String)org.getString("id"));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u7684\u5370\u82b1\u7a0e\u4e3a\u96f6\u7533\u62a5\uff0c\u4e0d\u80fd\u751f\u6210\u53f0\u8d26", (String)"YhsTaxAccountEdit_0", (String)"taxc-tcret", (Object[])new Object[0]), orgname));
                this.getModel().setValue(ORG, null);
                return;
            }
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"));
            if (result.getData() != null) {
                this.getModel().setValue("taxoffice", (Object)((DynamicObject)result.getData()).getLong("taxoffice.id"));
            }
            if (YhsAccountServiceHelper.verifyTaxoffice(this.getModel().getValue(ORG), this.getModel().getValue("taxoffice"))) {
                this.getModel().setValue("paytype", (Object)"bdjn");
            } else {
                this.getModel().setValue("paytype", (Object)"ydjn");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        BeforeF7FilterHelper.beforeF7(evt, this.getView());
    }

    public void afterBindData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.EDIT) {
            this.setFieldEnable();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        IDataModel model = this.getModel();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObject taxItem = (DynamicObject)model.getValue(TAXITEM);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (status == OperationStatus.ADDNEW) {
            if (TAXITEM.equals(name)) {
                DynamicObject newValue;
                if (EmptyCheckUtils.isNotEmpty((Object)changeData.getOldValue())) {
                    model.setValue("skssqq", null);
                    model.setValue("skssqz", null);
                    model.setValue("voucherno", null);
                    model.setValue("voucherdate", null);
                    model.setValue("calctaxamount", (Object)BigDecimal.ZERO);
                    model.setValue("taxation", null);
                    model.setValue("verifyrate", (Object)BigDecimal.ZERO);
                    model.setValue(DEDUCTIONCODE, null);
                }
                if ((newValue = (DynamicObject)changeData.getNewValue()) != null) {
                    DynamicObject subtaxitem = (DynamicObject)this.getModel().getValue(SUB_TAX_ITEM);
                    String number = newValue.getString("number");
                    if (subtaxitem != null && !StringUtils.equals((CharSequence)subtaxitem.getString("parent.number"), (CharSequence)number)) {
                        this.getModel().setValue(SUB_TAX_ITEM, null);
                    }
                    BasedataEdit subvouchertypeEdit = (BasedataEdit)this.getControl(SUB_TAX_ITEM);
                    subvouchertypeEdit.setMustInput("02001".equals(number));
                } else {
                    this.getModel().setValue(SUB_TAX_ITEM, null);
                }
                if (taxItem != null) {
                    String number = taxItem.getString("number");
                    if (LockList.contains(number)) {
                        model.setValue("taxation", (Object)"aqhz");
                        this.getView().setEnable(Boolean.FALSE, new String[]{"taxation"});
                    } else {
                        this.getView().setEnable(Boolean.TRUE, new String[]{"taxation"});
                    }
                    if (StringUtil.equals((CharSequence)JZZP, (CharSequence)number)) {
                        this.setDeductioncode("09129906");
                    } else if (StringUtil.equals((CharSequence)QTZP, (CharSequence)number)) {
                        this.setDeductioncode("09129907");
                    }
                }
            }
        } else if (TAXITEM.equals(name)) {
            String declaretype = (String)model.getValue("declaretype");
            if (EmptyCheckUtils.isNotEmpty((Object)changeData.getOldValue())) {
                DynamicObject object;
                model.setValue(SUB_TAX_ITEM, null);
                model.setValue("voucherno", null);
                model.setValue("vouchername", null);
                model.setValue("vouchernum", null);
                model.setValue("voucherdate", null);
                model.setValue("calctaxamount", (Object)BigDecimal.ZERO);
                model.setValue(DEDUCTIONCODE, null);
                model.setValue("yjse", null);
                if (!StringUtil.equals((CharSequence)"aqsb", (CharSequence)declaretype)) {
                    model.setValue("taxation", null);
                    model.setValue("verifyrate", (Object)BigDecimal.ZERO);
                }
                if (taxItem != null && (object = YhsUtils.getTaxItem(org, taxItem.getString("number"))) != null) {
                    model.setValue("taxation", (Object)(object.getBoolean("isverify") ? "hdzs" : "aqhz"));
                    model.setValue("verifyrate", (Object)object.getBigDecimal("hdrate"));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if ("save".equals(afterDoOperationEventArgs.getOperateKey()) && opResult.isSuccess()) {
            this.setFieldEnable();
        }
    }

    private void setDeductioncode(String deductioncode) {
        QFilter qFilter = new QFilter("taxcategory.number", "=", (Object)"008").and("number", "=", (Object)deductioncode);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_taxdeduction", (String)"id,number", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            this.getModel().setValue(DEDUCTIONCODE, (Object)dynamicObject.getLong("id"));
        }
    }

    private void setFieldEnable() {
        String declaretype = (String)this.getModel().getValue("declaretype");
        String taxation = (String)this.getModel().getValue("taxation");
        if ("aqsb".equals(declaretype)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxation", "verifyrate"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"taxation"});
            if ("hdzs".equals(taxation)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"verifyrate"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"verifyrate"});
            }
        }
    }
}

