/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class YhsTaxSourceGetDetailFormPlugin
extends AbstractListPlugin
implements HyperLinkClickListener {
    private static final String BTNOK = "btnok";
    private static final String YHS_TAX_ACCOUNT_FB = "tcret_yhs_tax_account_fb";
    private static final String TCRET_YHS_TAX_ACCOUNT = "tcret_yhs_tax_account";
    private static final String TCRET_SYCJ_ADJUST_DETAIL = "tcret_sycj_adjust_detail";
    private static final String YHS_TAX_SOURCE_INFO = "tcret_yhs_tax_source_info";
    private static final String SERIALNO = "serialno";
    private static final String ORG = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ADJUST_DATA_ID = "adjustDataId";
    private static final String CALCTAXAMOUNT = "calctaxamount";

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addPackageDataListener(this::packageData);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] genericObjects;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!PermissionUtils.hasSpecificPerm((IFormView)this.getView().getParentView(), (String)"4715a0df000000ac")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNOK});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTNOK});
        }
        BigDecimal originalamount = (BigDecimal)customParams.get("originalamount");
        DynamicObject adjustData = this.getAdjustData(customParams);
        this.getModel().setValue("originalamount", (Object)(adjustData == null ? originalamount : adjustData.getBigDecimal("amount")));
        this.getModel().setValue("adjustamount", (Object)(adjustData == null ? BigDecimal.ZERO : adjustData.getBigDecimal("adjustamount")));
        this.getModel().setValue("totalamount", (Object)(adjustData == null ? originalamount : adjustData.getBigDecimal("totalamount")));
        if (adjustData != null) {
            this.getPageCache().put(ADJUST_DATA_ID, adjustData.getString("id"));
        }
        String billstatus = (String)customParams.get("sbbbillstatus");
        String readonly = (String)customParams.get("readonly");
        if (Objects.equals("C", billstatus) || Objects.equals("B", billstatus) || "true".equals(readonly)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"adjustamount"});
        }
        if ((genericObjects = this.loadDetailData(customParams)) != null && genericObjects.length > 0) {
            this.getModel().beginInit();
            for (int i = 0; i < genericObjects.length; ++i) {
                DynamicObject object = genericObjects[i];
                int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue("taxitem", object.get("taxitem"), index);
                this.getModel().setValue("subtaxitem", object.get("subtaxitem"), index);
                this.getModel().setValue(SKSSQQ, object.get(SKSSQQ), index);
                this.getModel().setValue(SKSSQZ, object.get(SKSSQZ), index);
                DynamicObject taxItem = object.getDynamicObject("taxitem");
                DynamicObject subtaxitem = object.getDynamicObject("subtaxitem");
                String number = taxItem.getString("number");
                String taxrate = "02001".equals(number) && subtaxitem != null ? subtaxitem.getString("value") : taxItem.getString("taxrate");
                this.getModel().setValue("taxrate", (Object)taxrate, index);
                this.getModel().setValue(CALCTAXAMOUNT, object.get(CALCTAXAMOUNT), index);
                this.getModel().setValue("verifyrate", object.get("verifyrate"), index);
                this.getModel().setValue("deductioncode", object.get("deductioncode"), index);
                this.getModel().setValue("orignalid", object.get("orignalid"), index);
                this.getModel().setValue("accountorg", object.get("accountorg"), index);
                this.getModel().setValue("bizdimensiontype", object.get("bizdimensiontype"), index);
                this.getModel().setValue("bizdimensionname", object.get("bizdimensionname"), index);
                this.getModel().setValue("bizdimensionid", object.get("bizdimensionid"), index);
            }
            this.getModel().endInit();
            this.getView().updateView();
        }
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        this.refreshDimensionFieldsVisible(skssqq, skssqz);
    }

    private void refreshDimensionFieldsVisible(Date skssqq, Date skssqz) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get(ORG);
        if (orgid != null) {
            TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(Long.parseLong(String.valueOf(orgid))), (Long)BaseTaxCategory.YHS, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)skssqq, (Date)skssqz);
            if (EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                DynamicObject entry = (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
                long provisionId = entry.getLong("ruleentity.rule");
                DynamicObject provision = BusinessDataServiceHelper.loadSingleFromCache((Object)provisionId, (String)"itp_proviston_plan");
                String provisiondimension = provision.getString("provisiondimension");
                if (provision.getBoolean("isdimprovision") && provisiondimension.contains("accountorg")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"accountorg"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg"});
                }
                if (provision.getBoolean("isdimprovision") && provisiondimension.contains("businessdimension")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bizdimensiontype", "bizdimensionname"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bizdimensiontype", "bizdimensionname"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg", "bizdimensiontype", "bizdimensionname", "bizdimensionid"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg", "bizdimensiontype", "bizdimensionname", "bizdimensionid"});
        }
    }

    private DynamicObject[] loadDetailData(Map<String, Object> customParams) {
        String selectProperties = "org,taxitem,subtaxitem,taxsourceno,skssqq,skssqz,declaretype,taxation,calctaxamount,verifyrate,taxlimit,voucherno,voucherdate,deductioncode,orignalid,createtime,accountorg,bizdimensiontype,bizdimensionname,bizdimensionid";
        Object orgid = customParams.get(ORG);
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.parseLong((String)orgid));
        String serialno = (String)customParams.get(SERIALNO);
        QFilter serialnoFilter = new QFilter("taxsourceno", "=", (Object)serialno);
        QFilter[] filters = new QFilter[]{orgFilter, serialnoFilter};
        return BusinessDataServiceHelper.load((String)YHS_TAX_ACCOUNT_FB, (String)selectProperties, (QFilter[])filters);
    }

    private DynamicObject getAdjustData(Map<String, Object> customParams) {
        Object orgid = customParams.get(ORG);
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        String serialno = (String)customParams.get(SERIALNO);
        QFilter serialnoFilter = new QFilter(SERIALNO, "=", (Object)serialno);
        String billid = String.valueOf(customParams.get("billid"));
        QFilter typeFilter = new QFilter("type", "=", (Object)"tcsdtaxsource").and("ruleid", "=", (Object)Long.parseLong(billid));
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, serialnoFilter};
        return BusinessDataServiceHelper.loadSingle((String)TCRET_SYCJ_ADJUST_DETAIL, (String)MetadataUtil.getAllFieldToQuery((String)TCRET_SYCJ_ADJUST_DETAIL), (QFilter[])filters);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button && ((Button)source).getKey().equals(BTNOK)) {
            BigDecimal verifybasis;
            DynamicObject dynamicObject;
            BigDecimal totalamount = (BigDecimal)this.getModel().getValue("totalamount");
            if (totalamount.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u7a0e\u91d1\u989d\u4e0d\u53ef\u4e3a\u8d1f\u6570\u3002", (String)"YhsTaxSourceGetDetailFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            BigDecimal adjustamount = (BigDecimal)this.getModel().getValue("adjustamount");
            BigDecimal originalamount = (BigDecimal)this.getModel().getValue("originalamount");
            String adjsustId = this.getPageCache().get(ADJUST_DATA_ID);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object billid = customParams.get("billid");
            if (StringUtil.isNotEmpty((CharSequence)adjsustId)) {
                dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(adjsustId), (String)TCRET_SYCJ_ADJUST_DETAIL);
            } else {
                Object orgId = customParams.get(ORG);
                Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
                Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
                dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCRET_SYCJ_ADJUST_DETAIL));
                dynamicObject.set(ORG, orgId);
                dynamicObject.set(SKSSQQ, (Object)skssqq);
                dynamicObject.set(SKSSQZ, (Object)skssqz);
                dynamicObject.set(SERIALNO, customParams.get(SERIALNO));
                dynamicObject.set("amount", (Object)originalamount);
                dynamicObject.set("ruleid", billid);
                dynamicObject.set("type", (Object)"tcsdtaxsource");
                dynamicObject.set("titlename", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"YhsTaxSourceGetDetailFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            dynamicObject.set("adjustamount", (Object)adjustamount);
            dynamicObject.set("totalamount", (Object)totalamount);
            DynamicObject summary = BusinessDataServiceHelper.loadSingle(billid, (String)YHS_TAX_SOURCE_INFO);
            summary.set(CALCTAXAMOUNT, (Object)totalamount);
            if (Objects.equals("hdzs", summary.getString("taxation"))) {
                BigDecimal verifyrate = summary.getBigDecimal("verifyrate");
                verifybasis = verifyrate.multiply(totalamount).setScale(2, 4);
            } else {
                verifybasis = totalamount;
            }
            summary.set("verifybasis", (Object)verifybasis);
            String taxrate = summary.getString("taxrate");
            BigDecimal taxrateBigDecimal = new BigDecimal(taxrate.replace("\u2030", ""));
            if (taxrate.contains("\u2030")) {
                taxrateBigDecimal = taxrateBigDecimal.divide(BigDecimal.valueOf(1000L));
            }
            BigDecimal ynse = BigDecimalUtil.multiplyObject((Object)taxrateBigDecimal, (Object)(verifybasis == null ? BigDecimal.ZERO : verifybasis), (int)2);
            summary.set("ynse", (Object)ynse);
            DynamicObject deduction = (DynamicObject)summary.get("deductioncode");
            if (deduction != null) {
                String deductiontype;
                switch (deductiontype = deduction.getString("deductiontype")) {
                    case "1": {
                        summary.set("deducttax", (Object)ynse);
                        break;
                    }
                    case "2": {
                        summary.set("deducttax", (Object)ynse.divide(BigDecimal.valueOf(2L)).setScale(2, 4));
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{summary});
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("adjustamount".equals(name)) {
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            BigDecimal originalamount = (BigDecimal)this.getModel().getValue("originalamount");
            this.getModel().setValue("totalamount", (Object)originalamount.add(newValue));
        }
    }

    public void packageData(PackageDataEvent e) {
        Object sourceObj = e.getSource();
        if (DecimalEdit.class.isAssignableFrom(sourceObj.getClass())) {
            QFilter serialnoFilter;
            QFilter skssqzFilter;
            QFilter skssqqFilter;
            QFilter orgidFilter;
            boolean exists;
            String datasource;
            DecimalEdit decimalEdit = (DecimalEdit)e.getSource();
            Boolean result = true;
            QFilter filter = new QFilter("id", "=", (Object)e.getRowData().getLong("orignalid"));
            DynamicObject object = QueryServiceHelper.queryOne((String)TCRET_YHS_TAX_ACCOUNT, (String)"datasource,org,skssqq,skssqz,serialno", (QFilter[])new QFilter[]{filter});
            if (object != null && "system".equals(datasource = object.getString("datasource"))) {
                result = false;
            }
            if (decimalEdit.getFieldKey().equals(CALCTAXAMOUNT) && result.booleanValue()) {
                e.getNoLinkKey().add(CALCTAXAMOUNT);
            } else if (decimalEdit.getFieldKey().equals(CALCTAXAMOUNT) && object != null && (exists = QueryServiceHelper.exists((String)TCRET_SYCJ_ADJUST_DETAIL, (QFilter[])new QFilter[]{orgidFilter = new QFilter(ORG, "=", (Object)object.getLong(ORG)), skssqqFilter = new QFilter(SKSSQQ, "=", object.get(SKSSQQ)), skssqzFilter = new QFilter(SKSSQZ, "=", object.get(SKSSQZ)), serialnoFilter = new QFilter(SERIALNO, "=", object.get(SERIALNO))}))) {
                MetadataUtil.setCellColor((Control)this.getControl(ENTRYENTITY), (int)e.getRowIndex(), (String)CALCTAXAMOUNT, (String)"#DCFAE4");
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        if (StringUtil.equals((CharSequence)event.getFieldName(), (CharSequence)CALCTAXAMOUNT)) {
            Object orignalid = this.getModel().getValue("orignalid", event.getRowIndex());
            Object skssqq = this.getModel().getValue(SKSSQQ, event.getRowIndex());
            Object skssqz = this.getModel().getValue(SKSSQZ, event.getRowIndex());
            QFilter filter = new QFilter("id", "=", orignalid);
            DynamicObject object = QueryServiceHelper.queryOne((String)TCRET_YHS_TAX_ACCOUNT, (String)"org,serialno,accountorg,bizdimensionid", (QFilter[])new QFilter[]{filter});
            if (object != null) {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("billid", orignalid);
                customParams.put(ORG, String.valueOf(object.get(ORG)));
                customParams.put(SKSSQQ, skssqq);
                customParams.put(SKSSQZ, skssqz);
                customParams.put(SERIALNO, object.getString(SERIALNO));
                customParams.put("accountorg", object.getString("accountorg"));
                customParams.put("bizdimensionid", object.getString("bizdimensionid"));
                customParams.put("btclose", true);
                PageShowCommon.showForm((OperationStatus)OperationStatus.VIEW, (ShowType)ShowType.Modal, (String)"tcret_tax_source_tz", (IFormView)this.getView(), customParams, (IFormPlugin)this);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53f0\u8d26\u5df2\u88ab\u5220\u9664\u3002", (String)"YhsTaxSourceGetDetailFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
            }
        }
    }
}

