/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.orgmapping.TaxcOrgMappingDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.zerodeclare.AbstractLicenseCheckBillPlugin;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.taxsource.BeforeF7FilterHelper;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;
import kd.taxc.tcret.common.utils.DateCheckUtils;
import kd.taxc.tcret.common.utils.YhsUtils;
import org.apache.commons.collections.CollectionUtils;

public class YhsTaxSourceHandAddFormPlugin
extends AbstractLicenseCheckBillPlugin
implements BeforeF7SelectListener {
    private static final String YHS_TAX_SOURCE_INFO = "tcret_yhs_tax_source_info";
    private static final String BTNOK = "btnok";
    private static final String ORG = "org";
    private static final String TAX_ITEM = "taxitem";
    private static final String SUB_TAX_ITEM = "subtaxitem";
    private static final String TAXATION = "taxation";
    private static final String DECLARETYPE = "declaretype";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TAXOFFICE = "taxoffice";
    private static final String DEDUCTIONCODE = "deductioncode";
    private static final String AQSB = "aqsb";
    private static final String ACSB = "acsb";
    private static final String VERIFYBASIS = "verifybasis";
    private static String[] keys = new String[]{"vouchernum", "vouchername", "voucherno", "subtaxitem", "voucherdate", "calctaxamount", "taxation", "actualsettledate", "dfslrmc", "dfslrnssbh", "dfslrsjje", "isfixed", "verifybasis", "ynse", "yjse", "deductioncode"};
    private static final Pattern pattern = Pattern.compile("^[0-9]\\d*\\.0*$");

    public void initialize() {
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        BasedataEdit taxItem = (BasedataEdit)this.getControl(TAX_ITEM);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTNOK});
        BasedataEdit subTaxItem = (BasedataEdit)this.getControl(SUB_TAX_ITEM);
        subTaxItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountorg = (BasedataEdit)this.getControl("accountorg");
        accountorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit bizdimensionname = (TextEdit)this.getControl("bizdimensionname");
        bizdimensionname.addClickListener((ClickListener)this);
        BasedataEdit deductioncode = (BasedataEdit)this.getControl(DEDUCTIONCODE);
        deductioncode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advconbaritemap", "newentry"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        BeforeF7FilterHelper.beforeF7(evt, this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String isreverse = (String)customParams.get("isreverse");
        String org = null;
        if (StringUtil.isNotBlank((CharSequence)isreverse)) {
            Map reverseCustomParams = (Map)SerializationUtils.fromJsonString((String)isreverse, Map.class);
            org = (String)reverseCustomParams.get("orgid");
            this.getModel().setValue(ORG, (Object)Long.valueOf(org));
            this.getModel().setValue(SKSSQQ, (Object)DateUtils.stringToDate((String)((String)reverseCustomParams.get(SKSSQQ))));
            this.getModel().setValue(SKSSQZ, (Object)DateUtils.stringToDate((String)((String)reverseCustomParams.get(SKSSQZ))));
            this.getModel().setValue(DECLARETYPE, (Object)("yhsaq".equals(reverseCustomParams.get("taxType")) ? AQSB : ACSB));
            this.getModel().setValue(TAXOFFICE, (Object)Long.valueOf(reverseCustomParams.get(TAXOFFICE) != null ? reverseCustomParams.get(TAXOFFICE).toString() : "0"));
            String declaretype = this.getModel().getValue(DECLARETYPE).toString();
            if (AQSB.equals(declaretype)) {
                this.preLoadData(Long.valueOf(org));
            }
        } else {
            org = (String)customParams.get(ORG);
            this.getModel().setValue(DECLARETYPE, StringUtil.isNotEmpty((CharSequence)((String)customParams.get(DECLARETYPE))) ? customParams.get(DECLARETYPE) : AQSB);
            String declaretype = this.getModel().getValue(DECLARETYPE).toString();
            this.initStartDateAndEndDate(declaretype);
            if (StringUtil.isNotEmpty((CharSequence)org)) {
                boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)Long.parseLong(org));
                if (zeroDeclare) {
                    this.setZeroDeclareView();
                }
                this.getModel().setValue(ORG, (Object)Long.valueOf(org));
                TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(org));
                if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                    this.getModel().setValue(TAXOFFICE, (Object)((DynamicObject)taxResult.getData()).getLong("taxoffice.id"));
                }
                if (AQSB.equals(declaretype)) {
                    this.preLoadData(Long.valueOf(org));
                }
            }
        }
        this.refreshDimensionFieldsVisible();
    }

    private void refreshDimensionFieldsVisible() {
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue(ORG);
        if (taxorg != null) {
            TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(taxorg.getLong("id")), (Long)BaseTaxCategory.YHS, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)this.getModel().getDataEntity().getDate(SKSSQQ), (Date)this.getModel().getDataEntity().getDate(SKSSQZ));
            if (EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                DynamicObject entry = (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
                long provisionId = entry.getLong("ruleentity.rule");
                DynamicObject provision = BusinessDataServiceHelper.loadSingleFromCache((Object)provisionId, (String)"itp_proviston_plan");
                String provisiondimension = provision.getString("provisiondimension");
                BasedataEdit accountorg = (BasedataEdit)this.getControl("accountorg");
                FieldProp property = (FieldProp)this.getModel().getProperty("bizdimensionname");
                BasedataEdit bizdimensiontype = (BasedataEdit)this.getControl("bizdimensiontype");
                TextEdit bizdimensionname = (TextEdit)this.getControl("bizdimensionname");
                if (provision.getBoolean("isdimprovision") && provisiondimension.contains("accountorg")) {
                    accountorg.setMustInput(true);
                    this.getView().setVisible(Boolean.TRUE, new String[]{"accountorg"});
                } else {
                    accountorg.setMustInput(false);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg"});
                }
                if (provision.getBoolean("isdimprovision") && provisiondimension.contains("businessdimension")) {
                    DynamicObjectCollection businessdimensions = provision.getDynamicObjectCollection("businessdimension");
                    if (EmptyCheckUtils.isNotEmpty((Object)businessdimensions)) {
                        DynamicObject basedata = ((DynamicObject)businessdimensions.get(0)).getDynamicObject("fbasedataid");
                        this.getPageCache().put("bizdimensiontype", basedata.getString("mapobject.id"));
                    }
                    bizdimensiontype.setMustInput(true);
                    bizdimensionname.setMustInput(true);
                    property.setMustInput(true);
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bizdimensiontype", "bizdimensionname"});
                } else {
                    bizdimensiontype.setMustInput(false);
                    bizdimensionname.setMustInput(false);
                    property.setMustInput(false);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bizdimensiontype", "bizdimensionname"});
                    this.getPageCache().put("bizdimensiontype", "");
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg", "bizdimensiontype", "bizdimensionname", "bizdimensionid"});
                BasedataEdit accountorg = (BasedataEdit)this.getControl("accountorg");
                FieldProp property = (FieldProp)this.getModel().getProperty("bizdimensionname");
                BasedataEdit bizdimensiontype = (BasedataEdit)this.getControl("bizdimensiontype");
                TextEdit bizdimensionname = (TextEdit)this.getControl("bizdimensionname");
                accountorg.setMustInput(false);
                bizdimensiontype.setMustInput(false);
                bizdimensionname.setMustInput(false);
                property.setMustInput(false);
                this.getPageCache().put("bizdimensiontype", "");
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg", "bizdimensiontype", "bizdimensionname", "bizdimensionid"});
        }
    }

    private void setMustInput(boolean status) {
        FieldProp vouchername = (FieldProp)this.getModel().getProperty("vouchername");
        FieldProp vouchernum = (FieldProp)this.getModel().getProperty("vouchernum");
        FieldProp voucherdate = (FieldProp)this.getModel().getProperty("voucherdate");
        vouchername.setMustInput(status);
        vouchernum.setMustInput(status);
        voucherdate.setMustInput(status);
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey = evt.getOperationKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if ("newentry".equals(operationKey) && org != null) {
            boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)org.getLong("id"));
            DynamicObjectCollection entryentitys = (DynamicObjectCollection)this.getModel().getValue("entryentity");
            if (zeroDeclare) {
                this.setEnable(entryentitys.size() - 1);
            } else {
                this.getModel().setValue("voucherdate", this.getModel().getValue(SKSSQZ), entryentitys.size() - 1);
            }
        }
    }

    private void setEnable(int index) {
        this.getView().setEnable(Boolean.valueOf(false), index, keys);
        this.getModel().setValue("vouchernum", (Object)0, index);
        this.getModel().setValue("voucherdate", null, index);
        this.getModel().setValue("yjse", (Object)0.0, index);
        this.getModel().setValue("dfslrsjje", (Object)0.0, index);
        this.getModel().setValue("vouchername", (Object)"", index);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Boolean isfixed;
        EntryGrid entryentity;
        int[] selectRows;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        String operateKey = ((AbstractOperate)source).getOperateKey();
        if ("deleteentry".equals(operateKey) && (selectRows = (entryentity = (EntryGrid)this.getControl("entryentity")).getSelectRows()).length > 0 && (isfixed = Boolean.valueOf(Arrays.stream(selectRows).boxed().map(s -> (String)this.getModel().getValue("isfixed", s.intValue())).anyMatch(s -> s.equals("1")))).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e26\u51fa\u7a0e\u76ee\u884c\u4e0d\u53ef\u5220\u9664", (String)"YhsTaxSourceHandAddFormPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        IDataModel model = this.getModel();
        if (ACSB.equals(this.getModel().getValue(DECLARETYPE))) {
            Arrays.stream(e.getRowDataEntities()).map(RowDataEntity::getRowIndex).forEach(b -> model.setValue(TAXATION, (Object)"aqhz", b.intValue()));
        }
        String bizdimensiontype = this.getPageCache().get("bizdimensiontype");
        Arrays.stream(e.getRowDataEntities()).map(RowDataEntity::getRowIndex).forEach(b -> model.setValue("bizdimensiontype", (Object)bizdimensiontype, b.intValue()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String declaretype;
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Long orgId = org != null ? org.getLong("id") : 0L;
        boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)orgId);
        if (ORG.equals(name)) {
            this.getModel().deleteEntryData("entryentity");
            if (zeroDeclare) {
                boolean isLogout = LicenseCheckServiceHelper.checkOrgIsLogout((Long)orgId, (IFormView)this.getView());
                if (isLogout) {
                    this.getModel().setValue(ORG, null);
                    this.getModel().setValue(TAXOFFICE, null);
                    return;
                }
                this.setZeroDeclareView();
            } else {
                boolean notAuthorize = LicenseCheckServiceHelper.check((Object)orgId, (IFormView)this.getView(), (String)"tcret");
                if (notAuthorize) {
                    this.getModel().setValue(ORG, null);
                    this.getModel().setValue(TAXOFFICE, null);
                    return;
                }
                this.setMustInput(true);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{DECLARETYPE});
            }
            DynamicObject result = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId).getData();
            if (result != null) {
                this.getModel().setValue(TAXOFFICE, (Object)result.getLong("taxoffice.id"));
            }
            if (AQSB.equals(this.getModel().getValue(DECLARETYPE))) {
                this.getModel().deleteEntryData("entryentity");
                this.preLoadData(orgId);
            } else {
                this.getModel().deleteEntryData("entryentity");
                this.getModel().createNewEntryRow("entryentity");
            }
            this.refreshDimensionFieldsVisible();
        } else if (DECLARETYPE.equals(name)) {
            this.getModel().deleteEntryData("entryentity");
            String declaretype2 = (String)newValue;
            this.getPageCache().put("switch_aqsb", declaretype2.equals(AQSB) ? "true" : "false");
            this.initStartDateAndEndDate(declaretype2);
            if (declaretype2.equals(AQSB)) {
                this.preLoadData(orgId);
            } else {
                this.getModel().createNewEntryRow("entryentity");
            }
            this.getPageCache().remove("switch_aqsb");
        } else if (SKSSQQ.equals(name) || SKSSQZ.equals(name)) {
            Date skssqq;
            this.getModel().deleteEntryData("entryentity");
            Date date = SKSSQQ.equals(name) ? (newValue != null ? (Date)newValue : null) : (skssqq = (Date)this.getModel().getValue(SKSSQQ));
            Date skssqz = SKSSQZ.equals(name) ? (newValue != null ? (Date)newValue : null) : (Date)this.getModel().getValue(SKSSQZ);
            String value = (String)this.getModel().getValue(DECLARETYPE);
            String switch_aqsb = this.getPageCache().get("switch_aqsb");
            if (AQSB.equals(value)) {
                if (skssqq != null && SKSSQQ.equals(name) && !skssqq.equals(DateUtils.getFirstDateOfMonth((Date)skssqq))) {
                    this.getModel().setValue(SKSSQQ, (Object)DateUtils.getFirstDateOfMonth((Date)skssqq));
                    return;
                }
                if (skssqz != null && SKSSQZ.equals(name) && !skssqz.equals(DateUtils.getLastDateOfMonth2((Date)skssqz))) {
                    this.getModel().setValue(SKSSQZ, (Object)DateUtils.getLastDateOfMonth2((Date)skssqz));
                    return;
                }
                if (!"true".equals(switch_aqsb) && DateCheckUtils.checkDate(skssqq, skssqz, this.getView())) {
                    this.preLoadData(orgId);
                }
            } else {
                this.getModel().setValue(SKSSQQ, newValue);
                this.getModel().setValue(SKSSQZ, newValue);
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconbaritemap", "advconbaritemap1"});
            }
            this.refreshDimensionFieldsVisible();
        } else if (TAX_ITEM.equals(name)) {
            int rowIndex = changeData.getRowIndex();
            Lists.newArrayList((Object[])new String[]{"voucherno", "calctaxamount", "verifyrate", DEDUCTIONCODE}).forEach(s -> this.getModel().setValue(s, null, rowIndex));
            DynamicObject taxItem = (DynamicObject)newValue;
            if (taxItem != null) {
                DynamicObject object;
                String number = taxItem.getString("number");
                String declaretype3 = (String)this.getModel().getValue(DECLARETYPE);
                if (ACSB.equals(declaretype3)) {
                    this.getModel().setValue(TAXATION, (Object)"aqhz", rowIndex);
                } else if (AQSB.equals(declaretype3) && org != null && (object = YhsUtils.getTaxItem(org, taxItem.getString("number"))) != null) {
                    this.getModel().setValue(TAXATION, (Object)(object.getBoolean("isverify") ? "hdzs" : "aqhz"), rowIndex);
                    this.getModel().setValue("verifyrate", (Object)object.getBigDecimal("hdrate"), rowIndex);
                }
                this.getModel().setValue(DEDUCTIONCODE, (Object)this.getDefaultCode(taxItem), rowIndex);
                this.refreshYnse(rowIndex, (BigDecimal)this.getModel().getValue(VERIFYBASIS), taxItem);
                DynamicObject subtaxitem = (DynamicObject)this.getModel().getValue(SUB_TAX_ITEM, rowIndex);
                if (subtaxitem != null && !StringUtils.equals((CharSequence)subtaxitem.getString("parent.number"), (CharSequence)number)) {
                    this.getModel().setValue(SUB_TAX_ITEM, null, rowIndex);
                }
                if (!zeroDeclare) {
                    this.getModel().setValue("vouchername", (Object)taxItem.getString("name"), rowIndex);
                    this.getModel().setValue("vouchernum", (Object)1, rowIndex);
                    this.getModel().setValue("voucherdate", this.getModel().getValue(SKSSQZ), rowIndex);
                }
            } else {
                this.getModel().setValue(SUB_TAX_ITEM, null, rowIndex);
            }
        } else if (VERIFYBASIS.equals(name)) {
            int rowIndex = changeData.getRowIndex();
            BigDecimal verifybasis = (BigDecimal)newValue;
            DynamicObject taxitem = (DynamicObject)this.getModel().getValue(TAX_ITEM, rowIndex);
            this.refreshYnse(rowIndex, verifybasis, taxitem);
        } else if (TAXOFFICE.equals(name) && AQSB.equals(declaretype = (String)this.getModel().getValue(DECLARETYPE))) {
            this.preLoadData(orgId);
        }
    }

    private void setZeroDeclareView() {
        this.getModel().setValue(DECLARETYPE, (Object)AQSB);
        this.initStartDateAndEndDate(AQSB);
        this.setMustInput(false);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{DECLARETYPE});
    }

    private void refreshYnse(int rowIndex, BigDecimal verifybasis, DynamicObject taxItem) {
        if (taxItem == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxSourceHandAddFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        String number = taxItem.getString("number");
        DynamicObject subtaxitem = (DynamicObject)this.getModel().getValue(SUB_TAX_ITEM, rowIndex);
        Object org = this.getModel().getValue(ORG);
        boolean zeroDeclare = false;
        if (null != org) {
            zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)((DynamicObject)org).getLong("id"));
        }
        String taxrate = "02001".equals(number) && !zeroDeclare && subtaxitem != null ? subtaxitem.getString("value") : taxItem.getString("taxrate");
        String replace = taxrate.replace("\u2030", "");
        BigDecimal bigDecimal = new BigDecimal(replace);
        if (taxrate.contains("\u2030")) {
            bigDecimal = bigDecimal.divide(BigDecimal.valueOf(1000L));
        }
        BigDecimal multiply = BigDecimalUtil.multiplyObject((Object)bigDecimal, (Object)(verifybasis == null ? BigDecimal.ZERO : verifybasis), (int)2);
        this.getModel().setValue("ynse", (Object)multiply, rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (BTNOK.equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess() && this.validata()) {
            this.saveData();
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"YhsTaxSourceHandAddFormPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
            this.getView().close();
            String operateName = ResManager.loadKDString((String)"\u786e\u5b9a", (String)"YhsTaxSourceHandAddFormPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]);
            String operateDescription = ResManager.loadKDString((String)"\u65b0\u589e\u5370\u82b1\u7a0e\u7a0e\u6e90\u6210\u529f", (String)"YhsTaxSourceHandAddFormPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]);
            OperatorDialogUtils.operateDialog((String)"ccxws", (String)YHS_TAX_SOURCE_INFO, (String)operateName, (String)operateDescription);
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof TextEdit && "bizdimensionname".equals(((TextEdit)source).getKey())) {
            Map map;
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject bizdimensiontype = (DynamicObject)this.getModel().getValue("bizdimensiontype", rowIndex);
            if (bizdimensiontype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6\u4e3a\u7a7a", (String)"YhsTaxSourceHandAddFormPlugin_8", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            DynamicObject taxorg = (DynamicObject)this.getModel().getValue(ORG);
            Date skssqq = (Date)this.getModel().getValue(SKSSQQ);
            Date skssqz = (Date)this.getModel().getValue(SKSSQZ);
            if (taxorg == null || skssqq == null || skssqz == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u57fa\u672c\u4fe1\u606f", (String)"YhsTaxSourceHandAddFormPlugin_9", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)bizdimensiontype.getString("id"), (boolean)false);
            Map allFields = EntityMetadataCache.getDataEntityType((String)bizdimensiontype.getString("id")).getAllFields();
            if (allFields.get("enable") != null) {
                listShowParameter.getListFilterParameter().setFilter(new QFilter("enable", "=", (Object)"1"));
            }
            if (allFields.get("status") != null) {
                listShowParameter.getListFilterParameter().setFilter(new QFilter("status", "=", (Object)"C"));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)(map = (Map)TaxcOrgMappingDataServiceHelper.getOrgMappingByOrgIdAndCategoryId((Long)taxorg.getLong("id"), (Long)BaseTaxCategory.YHS, (Date)skssqq, (Date)skssqz).getData())) && EmptyCheckUtils.isNotEmpty(map.get(bizdimensiontype.getString("id")))) {
                List businessid = ((List)map.get(bizdimensiontype.getString("id"))).stream().map(e -> e.get("businessid")).collect(Collectors.toList());
                listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", businessid));
            } else {
                listShowParameter.getListFilterParameter().setFilter(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            }
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bizdimensionname"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        if ("bizdimensionname".equals(closedCallBackEvent.getActionId()) && EmptyCheckUtils.isNotEmpty((Object)(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("bizdimensionname", (Object)returnData.get(0).getName(), rowIndex);
            this.getModel().setValue("bizdimensionid", returnData.get(0).getPrimaryKeyValue(), rowIndex);
        }
    }

    private void saveData() {
        IDataModel model = this.getModel();
        ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Object org = model.getValue(ORG);
        boolean zeroDeclare = false;
        if (null != org) {
            zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)((DynamicObject)org).getLong("id"));
        }
        for (DynamicObject dynamicObject : entryentity) {
            DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)YHS_TAX_SOURCE_INFO));
            summary.set(ORG, org);
            summary.set("accountorg", dynamicObject.get("accountorg"));
            summary.set("bizdimensiontype", dynamicObject.get("bizdimensiontype"));
            summary.set("bizdimensionname", dynamicObject.get("bizdimensionname"));
            summary.set("bizdimensionid", dynamicObject.get("bizdimensionid"));
            DynamicObject taxitem = dynamicObject.getDynamicObject(TAX_ITEM);
            summary.set(TAX_ITEM, (Object)taxitem);
            Date skssqq = (Date)model.getValue(SKSSQQ);
            Date skssqz = (Date)model.getValue(SKSSQZ);
            summary.set(SKSSQQ, (Object)DateUtils.trunc((Date)skssqq));
            summary.set(SKSSQZ, (Object)DateUtils.trunc((Date)skssqz));
            summary.set(TAXOFFICE, model.getValue(TAXOFFICE));
            String billno = CodeRuleServiceHelper.getNumber((String)YHS_TAX_SOURCE_INFO, (DynamicObject)summary, null);
            summary.set("billno", (Object)billno);
            String declaretype = (String)model.getValue(DECLARETYPE);
            summary.set(DECLARETYPE, (Object)declaretype);
            summary.set("taxlimit", (Object)(ACSB.equals(declaretype) ? "single" : DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz)));
            summary.set("voucherno", (Object)dynamicObject.getString("voucherno"));
            summary.set("voucherdate", (Object)dynamicObject.getDate("voucherdate"));
            summary.set("billstatus", (Object)"A");
            summary.set("createtime", (Object)new Date());
            summary.set("datasource", (Object)"useradd");
            summary.set(TAXATION, (Object)dynamicObject.getString(TAXATION));
            summary.set("verifyrate", (Object)dynamicObject.getString("verifyrate"));
            summary.set("calctaxamount", (Object)dynamicObject.getBigDecimal("calctaxamount"));
            DynamicObject deductioncode = dynamicObject.getDynamicObject(DEDUCTIONCODE);
            summary.set(DEDUCTIONCODE, (Object)deductioncode);
            summary.set("vouchername", dynamicObject.get("vouchername"));
            summary.set("dfslrmc", dynamicObject.get("dfslrmc"));
            summary.set("dfslrnssbh", dynamicObject.get("dfslrnssbh"));
            summary.set("dfslrsjje", dynamicObject.get("dfslrsjje"));
            summary.set("yjse", dynamicObject.get("yjse"));
            summary.set("actualsettleamount", dynamicObject.get("actualsettleamount"));
            if (dynamicObject.get("actualsettledate") != null) {
                summary.set("actualsettledate", (Object)DateUtils.trunc((Date)dynamicObject.getDate("actualsettledate")));
            }
            summary.set("vouchernum", dynamicObject.get("vouchernum"));
            DynamicObject subtaxitem = dynamicObject.getDynamicObject(SUB_TAX_ITEM);
            summary.set(SUB_TAX_ITEM, (Object)subtaxitem);
            summary.set("voucherdate", dynamicObject.get("voucherdate"));
            String number = taxitem.getString("number");
            String taxrate = "02001".equals(number) && !zeroDeclare ? subtaxitem.getString("value") : taxitem.getString("taxrate");
            summary.set("taxrate", (Object)taxrate);
            summary.set(VERIFYBASIS, dynamicObject.get(VERIFYBASIS));
            BigDecimal ynse = (BigDecimal)dynamicObject.get("ynse");
            summary.set("ynse", (Object)ynse);
            if (deductioncode != null) {
                String deductiontype;
                DynamicObject deduction = deductioncode;
                switch (deductiontype = deduction.getString("deductiontype")) {
                    case "1": {
                        summary.set("deducttax", (Object)ynse);
                        break;
                    }
                    case "2": {
                        summary.set("deducttax", (Object)ynse.divide(BigDecimal.valueOf(2L)).setScale(2, 4));
                    }
                }
            } else {
                summary.set("deducttax", (Object)BigDecimal.ZERO);
            }
            if (YhsAccountServiceHelper.verifyTaxoffice(model.getValue(ORG), model.getValue(TAXOFFICE))) {
                summary.set("paytype", (Object)"bdjn");
            } else {
                summary.set("paytype", (Object)"ydjn");
            }
            saveDatas.add(summary);
        }
        if (saveDatas.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveDatas.toArray(new DynamicObject[0]));
        }
    }

    private boolean validata() {
        Optional<DynamicObject> any;
        boolean anyMatch3;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        DynamicObject taxoffice = (DynamicObject)this.getModel().getValue(TAXOFFICE);
        if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"YhsTaxSourceHandAddFormPlugin_10", (String)"taxc-tcret", (Object[])new Object[0]));
            return false;
        }
        String declaretype = (String)this.getModel().getValue(DECLARETYPE);
        Date skssqq = (Date)this.getModel().getValue(SKSSQQ);
        Date skssqz = (Date)this.getModel().getValue(SKSSQZ);
        if (AQSB.equals(declaretype) && !DateCheckUtils.checkDate(skssqq, skssqz, this.getView())) {
            return false;
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return true;
        }
        boolean anyMatch = entryentity.stream().anyMatch(s -> s.getDynamicObject(TAX_ITEM) == null);
        if (anyMatch) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxSourceHandAddFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
            return false;
        }
        boolean anyMatch1 = entryentity.stream().anyMatch(s -> "02001".equals(s.getDynamicObject(TAX_ITEM).getString("number")) && null == s.getDynamicObject(SUB_TAX_ITEM));
        boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)org.getLong("id"));
        if (anyMatch1 && !zeroDeclare) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ea7\u6743\u8f6c\u79fb\u4e66\u636e\u7684\u5b50\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxSourceHandAddFormPlugin_11", (String)"taxc-tcret", (Object[])new Object[0]));
            return false;
        }
        boolean anyMatch2 = entryentity.stream().anyMatch(s -> null == s.get("voucherdate"));
        if (anyMatch2 && !zeroDeclare) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7a0e\u51ed\u8bc1\u4e66\u7acb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxSourceHandAddFormPlugin_12", (String)"taxc-tcret", (Object[])new Object[0]));
            return false;
        }
        FieldProp property = (FieldProp)this.getModel().getProperty("bizdimensionname");
        boolean mustInput = property.isMustInput();
        if (mustInput && (anyMatch3 = entryentity.stream().anyMatch(s -> EmptyCheckUtils.isEmpty((Object)s.getString("bizdimensionname"))))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxSourceHandAddFormPlugin_13", (String)"taxc-tcret", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject entity : entryentity) {
            long vouchernum = entity.getLong("vouchernum");
            if (vouchernum != 1L) continue;
            String dfslrmc = entity.getString("dfslrmc");
            String dfslrnssbh = entity.getString("dfslrnssbh");
            if (!StringUtils.isNotBlank((CharSequence)dfslrmc) && !StringUtils.isNotBlank((CharSequence)dfslrnssbh)) continue;
            if (StringUtils.isBlank((CharSequence)dfslrmc)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5bf9\u65b9\u4e66\u7acb\u4eba\u540d\u79f0\u201d\u3002", (String)"YhsTaxSourceHandAddFormPlugin_14", (String)"taxc-tcret", (Object[])new Object[0]));
                return false;
            }
            if (!StringUtils.isBlank((CharSequence)dfslrnssbh)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5bf9\u65b9\u4e66\u7acb\u4eba\u7eb3\u7a0e\u8bc6\u522b\u53f7\uff08\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\u201d\u3002", (String)"YhsTaxSourceHandAddFormPlugin_15", (String)"taxc-tcret", (Object[])new Object[0]));
            return false;
        }
        List numbers = entryentity.stream().filter(s -> Lists.newArrayList((Object[])new String[]{"013", "014"}).contains(s.getDynamicObject(TAX_ITEM).getString("number"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(numbers) && (any = numbers.stream().filter(s -> !YhsTaxSourceHandAddFormPlugin.isNumericSend(s.getBigDecimal("calctaxamount").toString())).findAny()).isPresent()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u8ba1\u7a0e\u91d1\u989d\u7684\u503c\u5fc5\u987b\u662f\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"YhsTaxSourceHandAddFormPlugin_17", (String)"taxc-tcret", (Object[])new Object[0]), any.get().getDynamicObject(TAX_ITEM).getString("name")));
            return false;
        }
        if (AQSB.equals(declaretype)) {
            Map<String, List<DynamicObject>> groups = entryentity.stream().collect(Collectors.groupingBy(s -> this.getDynamicObjectStringFunction((DynamicObject)s)));
            List filterGroups = groups.entrySet().stream().filter(s -> ((List)s.getValue()).size() > 1).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterGroups)) {
                List seqs = filterGroups.stream().map(s -> ((List)s.getValue()).stream().map(a -> a.getString("seq")).collect(Collectors.joining(","))).collect(Collectors.toList());
                String rows = seqs.stream().sorted().collect(Collectors.joining("|", "\u3010", "\u3011"));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u91cd\u590d\uff0c\u76f8\u540c\u7a0e\u76ee\u3001\u5b50\u76ee\u3001\u5f81\u6536\u65b9\u5f0f\u548c\u51cf\u514d\u653f\u7b56\u53ea\u53ef\u65b0\u589e\u4e00\u6761\u7a0e\u6e90\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"YhsTaxSourceHandAddFormPlugin_18", (String)"taxc-tcret", (Object[])new Object[0]), rows));
                return false;
            }
            List<DynamicObject> yhsEntity = YhsUtils.queryYhsEntity(org.getLong("id"), skssqq, skssqz, AQSB);
            if (CollectionUtils.isEmpty(yhsEntity)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u79cd\u5361\u7247\u6ca1\u6709\u7ef4\u62a4", (String)"YhsTaxSourceHandAddFormPlugin_19", (String)"taxc-tcret", (Object[])new Object[0]));
                return false;
            }
            Optional<DynamicObject> exists = entryentity.stream().filter(entry -> this.existsTaxSource((DynamicObject)entry, org.getLong("id"), skssqq, skssqz, taxoffice)).findFirst();
            if (exists.isPresent()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7a0e\u6e90\u5df2\u5b58\u5728\uff0c\u8bf7\u76f4\u63a5\u4fee\u6539\u5df2\u6709\u7684\u7a0e\u6e90\u6570\u636e\uff0c\u4e0d\u652f\u6301\u65b0\u589e\u91cd\u590d\u7a0e\u6e90\u3002", (String)"YhsTaxSourceHandAddFormPlugin_20", (String)"taxc-tcret", (Object[])new Object[0]), exists.get().getString("seq")));
                return false;
            }
            Optional<DynamicObject> first = entryentity.stream().filter(s -> !this.isCardExists(skssqq, skssqz, (DynamicObject)s, yhsEntity)).findFirst();
            if (first.isPresent()) {
                String name = first.get().getDynamicObject(TAX_ITEM).getString("name");
                String taxation = first.get().getString(TAXATION);
                String taxatonName = taxation.equalsIgnoreCase("aqhz") ? ResManager.loadKDString((String)"\u6309\u671f\u6c47\u603b", (String)"YhsTaxSourceHandAddFormPlugin_21", (String)"taxc-tcret", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6838\u5b9a\u5f81\u6536", (String)"YhsTaxSourceHandAddFormPlugin_22", (String)"taxc-tcret", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u7a0e\u79cd\u5361\u7247\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u5c5e\u671f\u751f\u6548\u7684%1$s,%2$s\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u7a0e\u76ee\u3001\u5f81\u6536\u65b9\u5f0f\u3001\u6838\u5b9a\u6bd4\u4f8b\u7b49\u76f8\u5173\u4fe1\u606f\uff0c\u6216\u524d\u5f80\u5370\u82b1\u7a0e\u7a0e\u79cd\u5361\u7247\u4e2d\u7ef4\u62a4\u672c\u6b21\u9700\u8981\u65b0\u589e\u7684\u7a0e\u76ee\u6570\u636e\u3002", (String)"YhsTaxSourceHandAddFormPlugin_23", (String)"taxc-tcret", (Object[])new Object[0]), name, taxatonName));
                return false;
            }
        } else if (ACSB.equals(declaretype)) {
            boolean allMatch = entryentity.stream().allMatch(s -> s.getBigDecimal("calctaxamount").compareTo(BigDecimal.ZERO) > 0);
            if (!allMatch) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u3010\u8ba1\u7a0e\u91d1\u989d\u3011\u5fc5\u987b\u5927\u4e8e0", (String)"YhsTaxSourceHandAddFormPlugin_24", (String)"taxc-tcret", (Object[])new Object[0]));
                return false;
            }
            allMatch = entryentity.stream().filter(s -> s.getDate("voucherdate") != null).allMatch(s -> DateUtils.format((Date)s.getDate("voucherdate")).equals(DateUtils.format((Date)skssqq)));
            if (!allMatch) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u7684\u7a0e\u6e90\u6570\u636e\u7684\u5e94\u7a0e\u51ed\u8bc1\u4e66\u7acb\u65e5\u671f\u9700\u8981\u4e0e\u6240\u5c5e\u7a0e\u671f\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539", (String)"YhsTaxSourceHandAddFormPlugin_25", (String)"taxc-tcret", (Object[])new Object[0]));
                return false;
            }
            boolean match = entryentity.stream().anyMatch(s -> s.getString(TAXATION).equals("hdzs") && s.getBigDecimal("verifyrate").compareTo(BigDecimal.ZERO) <= 0);
            if (match) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u5b9a\u5f81\u6536\u65f6\u6838\u5b9a\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0", (String)"YhsTaxSourceHandAddFormPlugin_26", (String)"taxc-tcret", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean isCardExists(Date skssqq, Date skssqz, DynamicObject dynamicObject, List<DynamicObject> yhsEntity) {
        String number = dynamicObject.getDynamicObject(TAX_ITEM).getString("number");
        String taxation = dynamicObject.getString(TAXATION);
        BigDecimal verifyrate = dynamicObject.getBigDecimal("verifyrate");
        return yhsEntity.stream().anyMatch(s -> {
            boolean a = s.getDynamicObject("taxrate").getString("number").equals(number);
            boolean b = s.getBigDecimal("hdrate").compareTo(verifyrate) == 0;
            boolean c = (s.getBoolean("isverify") ? "hdzs" : "aqhz").equals(taxation);
            Date startdate = s.getDate("effectivedate");
            Date enddate = s.getDate("expirydate");
            boolean d = !startdate.after(skssqq) && !enddate.before(skssqz);
            return a && b && c && d;
        });
    }

    private String getDynamicObjectStringFunction(DynamicObject s) {
        DynamicObject taxItem = s.getDynamicObject(TAX_ITEM);
        DynamicObject subtaxitem = s.getDynamicObject(SUB_TAX_ITEM);
        DynamicObject deductioncode = s.getDynamicObject(DEDUCTIONCODE);
        String key = String.format("%s_%s_%s_%s", taxItem.getString("number"), s.getString(TAXATION), deductioncode != null ? deductioncode.getString("number") : "", subtaxitem != null ? subtaxitem.getString("number") : "empty");
        return key;
    }

    public static boolean isNumericSend(String str) {
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public void loadData(Long orgId, Date startDate, Date endDate) {
        if (orgId == null || startDate == null || endDate == null) {
            return;
        }
        boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)orgId);
        Map<String, DynamicObject> filterTaxSourceList = this.getExistsTaxSourceList(orgId, startDate, endDate);
        Boolean yhsEnable = (Boolean)TaxcMainDataServiceHelper.isTaxcMainYhsEnableByOrgId((Long)orgId).getData();
        if (yhsEnable.booleanValue()) {
            List<DynamicObject> yhsEntity = this.filterYhsEntity(orgId, startDate, endDate, filterTaxSourceList);
            if (CollectionUtils.isEmpty(yhsEntity)) {
                this.getModel().deleteEntryData("entryentity");
            } else {
                String bizdimensiontype = "";
                TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgId), (Long)BaseTaxCategory.YHS, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)startDate, (Date)endDate);
                if (EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                    DynamicObjectCollection businessdimensions;
                    DynamicObject entry = (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
                    long provisionId = entry.getLong("ruleentity.rule");
                    DynamicObject provision = BusinessDataServiceHelper.loadSingleFromCache((Object)provisionId, (String)"itp_proviston_plan");
                    String provisiondimension = provision.getString("provisiondimension");
                    if (provision.getBoolean("isdimprovision") && provisiondimension.contains("businessdimension") && EmptyCheckUtils.isNotEmpty((Object)(businessdimensions = provision.getDynamicObjectCollection("businessdimension")))) {
                        DynamicObject basedata = ((DynamicObject)businessdimensions.get(0)).getDynamicObject("fbasedataid");
                        bizdimensiontype = basedata.getString("mapobject.id");
                    }
                }
                this.getModel().deleteEntryData("entryentity");
                this.getModel().batchCreateNewEntryRow("entryentity", yhsEntity.size());
                int index = 0;
                for (DynamicObject object : yhsEntity) {
                    this.getModel().setValue("isfixed", (Object)"1", index);
                    this.getModel().setValue(TAX_ITEM, object.get("taxrate"), index);
                    this.getModel().setValue(TAXATION, (Object)(object.getBoolean("isverify") ? "hdzs" : "aqhz"), index);
                    this.getModel().setValue("verifyrate", object.get("hdrate"), index);
                    this.getModel().setValue(DEDUCTIONCODE, (Object)this.getDefaultCode(object.getDynamicObject("taxrate")), index);
                    this.getModel().setValue("vouchername", object.get("taxrate") != null ? object.getDynamicObject("taxrate").get("name") : "", index);
                    this.getModel().setValue("voucherdate", (Object)endDate, index);
                    this.getModel().setValue("bizdimensiontype", (Object)bizdimensiontype, index);
                    if (zeroDeclare) {
                        this.setEnable(index);
                    }
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{TAX_ITEM, TAXATION, "verifyrate"});
                    ++index;
                }
            }
        }
    }

    private Long getDefaultCode(DynamicObject taxrate) {
        String number = taxrate.getString("number");
        if (number.equals("012")) {
            return this.getDeductiontype("09129906");
        }
        if (number.equals("013")) {
            return this.getDeductiontype("09129907");
        }
        return null;
    }

    public Long getDeductiontype(String number) {
        QFilter idFilter = new QFilter("number", "=", (Object)number);
        DynamicObject taxdeduction = QueryServiceHelper.queryOne((String)"tpo_taxdeduction", (String)"id,deductiontype", (QFilter[])new QFilter[]{idFilter});
        if (taxdeduction != null) {
            return taxdeduction.getLong("id");
        }
        return 0L;
    }

    private List<DynamicObject> filterYhsEntity(Long orgId, Date startDate, Date endDate, Map<String, DynamicObject> filterTaxSourceList) {
        List<Object> yhsEntity = YhsUtils.queryYhsEntity(orgId, startDate, endDate, AQSB);
        if (yhsEntity == null) {
            return new DynamicObjectCollection();
        }
        yhsEntity = yhsEntity.stream().filter(s -> {
            if (filterTaxSourceList.isEmpty()) {
                return true;
            }
            String key = s.getDynamicObject("taxrate").getString("number") + (s.getBoolean("isverify") ? "hdzs" : "aqhz");
            return !filterTaxSourceList.containsKey(key);
        }).collect(Collectors.toList());
        return yhsEntity;
    }

    private boolean validSbbStatus(DynamicObject org, Date skssqq, Date skssqz) {
        DynamicObject taxoffice = (DynamicObject)this.getModel().getValue(TAXOFFICE);
        String billStatus = YhsUtils.getSbbBillStatus(org.getLong("id"), skssqq, skssqz, taxoffice);
        if ("C".equals(billStatus) || "B".equals(billStatus)) {
            String orgName = org.getString("name");
            String sq = String.format("\u3010%s~%s\u3011", DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u7a0e\u671f\u5df2\u63d0\u4ea4\u5ba1\u6838\uff0c\u4e0d\u652f\u6301\u65b0\u589e\u7a0e\u6e90\u3002", (String)"YhsTaxSourceHandAddFormPlugin_27", (String)"taxc-tcret", (Object[])new Object[0]), orgName, sq);
            this.getModel().deleteEntryData("entryentity");
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap", "advconbaritemap1"});
            this.getView().showErrorNotification(msg);
            return false;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"advconbaritemap", "advconbaritemap1"});
        return true;
    }

    private void initStartDateAndEndDate(String declaretype) {
        if (AQSB.equals(declaretype)) {
            Date lastMonth = DateUtils.addMonth((Date)new Date(), (int)-3);
            this.getModel().setValue(SKSSQQ, (Object)DateUtils.getFirstDateOfSeason((Date)lastMonth));
            this.getModel().setValue(SKSSQZ, (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)lastMonth)));
        } else {
            Date now = DateUtils.trunc((Date)new Date());
            this.getModel().setValue(SKSSQQ, (Object)now);
            this.getModel().setValue(SKSSQZ, (Object)now);
        }
    }

    private Map<String, DynamicObject> getExistsTaxSourceList(Long org, Date skssqq, Date skssqz) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
        QFilter orgIdFilter = new QFilter(ORG, "=", (Object)org);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(SKSSQZ, "=", (Object)DateUtils.getLastDateOfMonth2((Date)skssqz));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)YHS_TAX_SOURCE_INFO, (String)"taxitem.number as number,taxation", (QFilter[])new QFilter[]{orgIdFilter, dateFilter});
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            dynamicObjects.stream().forEach(s -> result.computeIfAbsent(s.getString("number") + s.getString(TAXATION), v -> s));
        }
        return result;
    }

    public boolean existsTaxSource(DynamicObject entry, Long org, Date skssqq, Date skssqz, DynamicObject taxoffice) {
        QFilter deductioncodeFilter;
        Long taxItem = entry.getDynamicObject(TAX_ITEM).getLong("id");
        String taxation = entry.getString(TAXATION);
        DynamicObject deductioncode = entry.getDynamicObject(DEDUCTIONCODE);
        Long subtaxitem = entry.getLong("subtaxitem.id");
        long accountorg = entry.getLong("accountorg.id");
        Object bizdimensionid = entry.get("bizdimensionid");
        QFilter orgIdFilter = new QFilter(ORG, "=", (Object)org);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(SKSSQZ, "=", (Object)DateUtils.getLastDateOfMonth2((Date)skssqz));
        QFilter taxItemFilter = new QFilter(TAX_ITEM, "=", (Object)taxItem);
        QFilter subTaxItemFilter = new QFilter(SUB_TAX_ITEM, "=", (Object)subtaxitem);
        QFilter taxationFilter = new QFilter(TAXATION, "=", (Object)taxation);
        QFilter accountorgFilter = new QFilter("accountorg", "=", (Object)accountorg);
        QFilter bizdimensionidFilter = new QFilter("bizdimensionid", "=", bizdimensionid);
        QFilter filter = orgIdFilter.and(dateFilter).and(taxItemFilter).and(taxationFilter).and(subTaxItemFilter).and(accountorgFilter).and(bizdimensionidFilter);
        if (deductioncode != null) {
            deductioncodeFilter = new QFilter(DEDUCTIONCODE, "=", (Object)deductioncode.getLong("id"));
            filter.and(deductioncodeFilter);
        } else {
            deductioncodeFilter = new QFilter(DEDUCTIONCODE, "is null", null).or(new QFilter(DEDUCTIONCODE, "=", (Object)0L));
            filter.and(deductioncodeFilter);
        }
        if (taxoffice != null) {
            QFilter taxofficeFilter = new QFilter(TAXOFFICE, "=", (Object)taxoffice.getLong("id"));
            filter.and(taxofficeFilter);
        }
        return QueryServiceHelper.exists((String)YHS_TAX_SOURCE_INFO, (QFilter[])new QFilter[]{filter});
    }

    private void preLoadData(Long orgId) {
        if (orgId == null || orgId == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u7a0e\u52a1\u7ec4\u7ec7", (String)"YhsTaxSourceHandAddFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        boolean b = this.validSbbStatus((DynamicObject)this.getModel().getValue(ORG), (Date)this.getModel().getValue(SKSSQQ), (Date)this.getModel().getValue(SKSSQZ));
        if (b) {
            this.loadData(orgId, (Date)this.getModel().getValue(SKSSQQ), (Date)this.getModel().getValue(SKSSQZ));
        } else {
            this.getModel().deleteEntryData("entryentity");
        }
    }
}

