/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.common.utils.TcretSystemParamUtil;

public class YhsTaxSourceImportPlugin
implements IImportPlugin {
    private static final Log logger = LogFactory.getLog(YhsTaxSourceImportPlugin.class);

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        try {
            QFilter q2;
            QFilter q1;
            String calctaxamount;
            String skssqz;
            JSONObject taxitem;
            String vouchernumStr;
            JSONObject org = (JSONObject)data.get("org");
            if (org == null) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7a0e\u52a1\u7ec4\u7ec7", (String)"YhsTaxSourceImportPlugin_0", (String)"taxc-tcret", (Object[])new Object[0])));
                return super.importData(data, option, importlogs);
            }
            String declaretype = (String)data.get("declaretype");
            if (StringUtils.isEmpty((CharSequence)declaretype)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7533\u62a5\u671f\u9650\u7c7b\u578b", (String)"YhsTaxSourceImportPlugin_1", (String)"taxc-tcret", (Object[])new Object[0])));
            }
            if (StringUtils.isEmpty((CharSequence)(vouchernumStr = (String)data.get("vouchernum")))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e94\u7a0e\u51ed\u8bc1\u6570\u91cf", (String)"YhsTaxSourceImportPlugin_2", (String)"taxc-tcret", (Object[])new Object[0])));
            }
            if ((taxitem = (JSONObject)data.get("taxitem")) == null) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7a0e\u76ee", (String)"YhsTaxSourceImportPlugin_3", (String)"taxc-tcret", (Object[])new Object[0])));
                return super.importData(data, option, importlogs);
            }
            String skssqq = (String)data.get("skssqq");
            if (StringUtils.isEmpty((CharSequence)skssqq)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f.\u5f00\u59cb", (String)"YhsTaxSourceImportPlugin_4", (String)"taxc-tcret", (Object[])new Object[0])));
            }
            if (StringUtils.isEmpty((CharSequence)(skssqz = (String)data.get("skssqz")))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f.\u7ed3\u675f", (String)"YhsTaxSourceImportPlugin_5", (String)"taxc-tcret", (Object[])new Object[0])));
            }
            if (StringUtils.isEmpty((CharSequence)(calctaxamount = (String)data.get("calctaxamount")))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u7a0e\u91d1\u989d", (String)"YhsTaxSourceImportPlugin_6", (String)"taxc-tcret", (Object[])new Object[0])));
                return super.importData(data, option, importlogs);
            }
            if (importlogs.size() > 0) {
                return super.importData(data, option, importlogs);
            }
            DynamicObject bastaxTaxorg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org,status,istaxpayer", (QFilter[])new QFilter[]{new QFilter("org.number", "=", org.get((Object)"number"))});
            if (bastaxTaxorg == null) {
                importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7f16\u7801%s", (String)"YhsTaxSourceImportPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]), org.get((Object)"number"))));
                return super.importData(data, option, importlogs);
            }
            TaxResult taxResult = TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)bastaxTaxorg.getLong("org"));
            if (!taxResult.isSuccess()) {
                importlogs.add(new ImportLogger.ImportLog(taxResult.getMessage()));
                return super.importData(data, option, importlogs);
            }
            boolean notAuthorize = LicenseCheckServiceHelper.check((Object)bastaxTaxorg.getLong("org"), null, (String)"tcret");
            if (notAuthorize) {
                importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u7684\u8bb8\u53ef\u5c1a\u672a\u6fc0\u6d3b", (String)"YhsTaxSourceImportPlugin_10", (String)"taxc-tcret", (Object[])new Object[0]), org.get((Object)"number"))));
                return super.importData(data, option, importlogs);
            }
            Boolean parameter = TcretSystemParamUtil.getZeroDeclare(bastaxTaxorg.getLong("org"));
            if (parameter.booleanValue()) {
                importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u7684\u5370\u82b1\u7a0e\u4e3a\u96f6\u7533\u62a5\uff0c\u4e0d\u652f\u6301\u5f15\u5165", (String)"YhsTaxSourceImportPlugin_11", (String)"taxc-tcret", (Object[])new Object[0]), org.get((Object)"number"))));
                return super.importData(data, option, importlogs);
            }
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(bastaxTaxorg.getLong("org")));
            DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
            JSONObject taxoffice = (JSONObject)data.get("taxoffice");
            if (taxoffice == null) {
                taxoffice = new JSONObject();
                taxoffice.put("importprop", (Object)"number");
                taxoffice.put("number", (Object)taxMain.getString("taxoffice.number"));
                data.put("taxoffice", taxoffice);
                data.put("paytype", "bdjn");
            } else {
                DynamicObject bastaxTaxorgan = QueryServiceHelper.queryOne((String)"bastax_taxorgan", (String)"enable", (QFilter[])new QFilter[]{new QFilter("number", "=", taxoffice.get((Object)"number"))});
                if (bastaxTaxorgan == null) {
                    importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7f16\u7801%s", (String)"YhsTaxSourceImportPlugin_12", (String)"taxc-tcret", (Object[])new Object[0]), taxoffice.get((Object)"number"))));
                    return super.importData(data, option, importlogs);
                }
                if (!"1".equals(bastaxTaxorgan.get("enable"))) {
                    importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u672a\u542f\u7528\uff1a\u7f16\u7801%s", (String)"YhsTaxSourceImportPlugin_13", (String)"taxc-tcret", (Object[])new Object[0]), taxoffice.get((Object)"number"))));
                    return super.importData(data, option, importlogs);
                }
                DynamicObject orgResult = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)org.getString("number")).getData();
                if (orgResult != null) {
                    if (orgResult.getString("taxoffice.number").equals(taxoffice.getString("number"))) {
                        data.put("paytype", "bdjn");
                    } else {
                        data.put("paytype", "ydjn");
                    }
                }
            }
            DynamicObjectCollection yhsentity = taxMain.getDynamicObjectCollection("yhsentity");
            Integer vouchernum = Integer.parseInt(vouchernumStr);
            Date skssqqDate = DateUtils.stringToDate((String)skssqq);
            Date skssqzDate = DateUtils.stringToDate((String)skssqz);
            String taxitemNumber = taxitem.getString("number");
            DynamicObject taxitemObj = new DynamicObject();
            if ("aqsb".equals(declaretype)) {
                List collect = yhsentity.stream().filter(s -> taxitemNumber.equals(s.get("taxrate.number"))).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) {
                    importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"%s\u5728\u5370\u82b1\u7a0e\u7a0e\u79cd\u5361\u7247\u4e2d\u4e0d\u5b58\u5728", (String)"YhsTaxSourceImportPlugin_14", (String)"taxc-tcret", (Object[])new Object[0]), taxitemNumber)));
                    return super.importData(data, option, importlogs);
                }
                Optional<DynamicObject> first = collect.stream().filter(s -> skssqqDate.compareTo(s.getDate("effectivedate")) >= 0 && skssqzDate.compareTo(s.getDate("expirydate")) <= 0 && "aqsb".equals(s.getString("declaretype"))).findFirst();
                if (!first.isPresent()) {
                    importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u7a0e\u79cd\u5361\u7247\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u5c5e\u671f\u751f\u6548\u7684\u6309\u671f\u7533\u62a5%s\u6570\u636e", (String)"YhsTaxSourceImportPlugin_15", (String)"taxc-tcret", (Object[])new Object[0]), taxitemNumber)));
                    return super.importData(data, option, importlogs);
                }
                taxitemObj = first.get();
                if (!DateUtils.validDateRange((String)taxitemObj.getString("period"), (Date)skssqqDate, (Date)skssqzDate)) {
                    importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u7a0e\u76ee%s\u7684\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u4e0e\u5370\u82b1\u7a0e\u7a0e\u79cd\u5361\u7247\u4e2d\u7684\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26", (String)"YhsTaxSourceImportPlugin_16", (String)"taxc-tcret", (Object[])new Object[0]), taxitemNumber)));
                    return super.importData(data, option, importlogs);
                }
                if (BigDecimal.ZERO.compareTo(new BigDecimal(calctaxamount)) > 0) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8ba1\u7a0e\u91d1\u989d\u9700\u8981\u5927\u4e8e\u7b49\u4e8e0", (String)"YhsTaxSourceImportPlugin_17", (String)"taxc-tcret", (Object[])new Object[0])));
                    return super.importData(data, option, importlogs);
                }
                data.put("taxlimit", taxitemObj.get("period"));
                data.put("verifyrate", taxitemObj.get("hdrate"));
            }
            String voucherdate = (String)data.get("voucherdate");
            if ("acsb".equals(declaretype)) {
                QFilter subNumberFilter;
                QFilter numberFilter = new QFilter("number", "=", (Object)"001");
                if (skssqzDate.compareTo(DateUtils.stringToDate((String)"2022-06-30")) >= 0) {
                    numberFilter = new QFilter("number", "=", (Object)"002");
                }
                if (!QueryServiceHelper.exists((String)"tpo_tcsd_taxrate", (QFilter[])new QFilter[]{numberFilter, subNumberFilter = new QFilter("entryentity.subnumber", "=", (Object)taxitemNumber)})) {
                    importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"%s\u5728\u5370\u82b1\u7a0e\u7a0e\u76ee\u8868\u4e2d\u4e0d\u5b58\u5728", (String)"YhsTaxSourceImportPlugin_18", (String)"taxc-tcret", (Object[])new Object[0]), taxitemNumber)));
                    return super.importData(data, option, importlogs);
                }
                if (!skssqq.equals(skssqz)) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u7684\u7a0e\u76ee\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u65e5\u671f\u5e94\u76f8\u540c", (String)"YhsTaxSourceImportPlugin_19", (String)"taxc-tcret", (Object[])new Object[0])));
                    return super.importData(data, option, importlogs);
                }
                if (StringUtils.isNotEmpty((CharSequence)voucherdate) && !skssqz.equals(voucherdate)) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u7684\u7a0e\u6e90\u6570\u636e\u7684\u5e94\u7a0e\u51ed\u8bc1\u4e66\u7acb\u65e5\u671f\u9700\u8981\u4e0e\u6240\u5c5e\u7a0e\u671f\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539", (String)"YhsTaxSourceImportPlugin_20", (String)"taxc-tcret", (Object[])new Object[0])));
                    return super.importData(data, option, importlogs);
                }
                data.put("taxlimit", "single");
                if (BigDecimal.ZERO.compareTo(new BigDecimal(calctaxamount)) >= 0) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\uff0c\u8ba1\u7a0e\u91d1\u989d\u9700\u5927\u4e8e0", (String)"YhsTaxSourceImportPlugin_21", (String)"taxc-tcret", (Object[])new Object[0])));
                    return super.importData(data, option, importlogs);
                }
            }
            DynamicObject taxItemBase = QueryServiceHelper.queryOne((String)"tpo_tcsd_taxrateentrytree", (String)"id,taxrate,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)taxitemNumber)});
            String vouchername = (String)data.get("vouchername");
            if (StringUtils.isEmpty((CharSequence)vouchername)) {
                data.put("vouchername", taxItemBase.get("name"));
            }
            data.put("taxrate", taxItemBase.get("taxrate"));
            JSONObject subtaxitem = (JSONObject)data.get("subtaxitem");
            if ("02001".equals(taxitemNumber) && subtaxitem == null) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u4ea7\u6743\u8f6c\u79fb\u6570\u636e\u7684\u5b50\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxSourceImportPlugin_22", (String)"taxc-tcret", (Object[])new Object[0])));
                return super.importData(data, option, importlogs);
            }
            DynamicObject subtaxitemObj = null;
            if (subtaxitem != null) {
                subtaxitemObj = QueryServiceHelper.queryOne((String)"tpo_tcsd_bizdef_entry", (String)"id,number,parent,value", (QFilter[])new QFilter[]{new QFilter("number", "=", subtaxitem.get((Object)"number"))});
                if (subtaxitemObj == null) {
                    importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"%s\u5728\u5370\u82b1\u7a0e\u5b50\u76ee\u8868\u4e2d\u4e0d\u5b58\u5728", (String)"YhsTaxSourceImportPlugin_23", (String)"taxc-tcret", (Object[])new Object[0]), subtaxitem.get((Object)"number"))));
                    return super.importData(data, option, importlogs);
                }
                DynamicObject queryOne = QueryServiceHelper.queryOne((String)"tpo_tcsd_bizdef_entry", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", subtaxitemObj.get("parent"))});
                if (queryOne == null || !taxitemNumber.equals(queryOne.get("number"))) {
                    importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u5b50\u76ee\u4e0e\u7a0e\u76ee\u4e0d\u5339\u914d\uff0c\u5b50\u76ee%1$s\u4e0d\u5c5e\u4e8e\u7a0e\u76ee%2$s", (String)"YhsTaxSourceImportPlugin_24", (String)"taxc-tcret", (Object[])new Object[0]), subtaxitem.get((Object)"number"), taxitemNumber)));
                    return super.importData(data, option, importlogs);
                }
                if ("02001".equals(taxitemNumber)) {
                    data.put("taxrate", subtaxitemObj.get("value"));
                }
            }
            if (StringUtils.isEmpty((CharSequence)voucherdate)) {
                data.put("voucherdate", skssqz);
            }
            String taxation = "aqhz";
            if ("aqsb".equals(declaretype) && taxitemObj.getBoolean("isverify")) {
                taxation = "hdzs";
            }
            data.put("taxation", taxation);
            data.put("datasource", "import");
            BigDecimal verifybasis = new BigDecimal(calctaxamount);
            if ("hdzs".equals(taxation)) {
                verifybasis = verifybasis.multiply(taxitemObj.getBigDecimal("hdrate")).setScale(2, 4);
            }
            data.put("verifybasis", verifybasis.toString());
            String taxrate = (String)data.get("taxrate");
            if (StringUtils.isNotEmpty((CharSequence)"taxrate")) {
                String replace = taxrate.replace("\u2030", "");
                BigDecimal bigDecimal = new BigDecimal(replace);
                if (taxrate.contains("\u2030")) {
                    bigDecimal = bigDecimal.divide(BigDecimal.valueOf(1000L));
                }
                BigDecimal multiply = bigDecimal.multiply(verifybasis == null ? BigDecimal.ZERO : verifybasis).setScale(2, 4);
                data.put("ynse", multiply.toString());
            }
            JSONObject deductioncode = (JSONObject)data.get("deductioncode");
            DynamicObject deductionObj = null;
            if (deductioncode != null && (deductionObj = QueryServiceHelper.queryOne((String)"tpo_taxdeduction", (String)"id", (QFilter[])new QFilter[]{q1 = new QFilter("number", "=", (Object)deductioncode.getString("number")), q2 = new QFilter("taxcategory", "=", (Object)8L)})) == null) {
                importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u51cf\u514d\u653f\u7b56\u4ee3\u7801%s\u4e0d\u5b58\u5728", (String)"YhsTaxSourceImportPlugin_25", (String)"taxc-tcret", (Object[])new Object[0]), deductioncode.getString("number"))));
                return super.importData(data, option, importlogs);
            }
            if (vouchernum == 1 || vouchernum == 0) {
                if (!(data.get("dfslrmc") == null && data.get("dfslrnssbh") == null && data.get("dfslrsjje") == null || data.get("dfslrmc") != null && data.get("dfslrnssbh") != null && data.get("dfslrsjje") != null)) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5bf9\u65b9\u4e66\u7acb\u4eba\u540d\u79f0\u3001\u5bf9\u65b9\u4e66\u7acb\u4eba\u7eb3\u7a0e\u8bc6\u522b\u53f7\uff08\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09\u3001\u5bf9\u65b9\u4e66\u7acb\u4eba\u6d89\u53ca\u91d1\u989d\u9700\u8981\u540c\u65f6\u586b\u5199", (String)"YhsTaxSourceImportPlugin_26", (String)"taxc-tcret", (Object[])new Object[0])));
                    return super.importData(data, option, importlogs);
                }
            } else {
                data.put("dfslrmc", null);
                data.put("dfslrnssbh", null);
                data.put("dfslrsjje", null);
            }
            if ("aqsb".equals(declaretype)) {
                QFilter q9;
                QFilter q8;
                q1 = new QFilter("org", "=", bastaxTaxorg.get("org"));
                q2 = new QFilter("taxitem", "=", taxItemBase.get("id"));
                QFilter q3 = new QFilter("subtaxitem", "=", (Object)0L);
                if (subtaxitemObj != null) {
                    q3 = new QFilter("subtaxitem", "=", subtaxitemObj.get("id"));
                }
                QFilter q4 = new QFilter("taxation", "=", (Object)taxation);
                QFilter q5 = new QFilter("skssqq", "=", (Object)skssqqDate);
                QFilter q6 = new QFilter("skssqz", "=", (Object)skssqzDate);
                QFilter q7 = new QFilter("deductioncode", "=", (Object)0L);
                if (deductionObj != null) {
                    q7 = new QFilter("deductioncode", "=", deductionObj.get("id"));
                }
                if (QueryServiceHelper.exists((String)"tcret_yhs_tax_source_info", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6, q7, q8 = new QFilter("declaretype", "=", (Object)"aqsb"), q9 = new QFilter("taxoffice.number", "=", (Object)taxoffice.getString("number"))})) {
                    importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u7a0e\u6e90\u5df2\u5b58\u5728\uff0c\u8bf7\u76f4\u63a5\u4fee\u6539\u5df2\u6709\u7684\u7a0e\u6e90\u6570\u636e\uff0c\u4e0d\u652f\u6301\u65b0\u589e\u91cd\u590d\u7a0e\u6e90", (String)"YhsTaxSourceImportPlugin_27", (String)"taxc-tcret", (Object[])new Object[0])));
                    return super.importData(data, option, importlogs);
                }
            }
            data.put("sbbbillno", ResManager.loadKDString((String)"\u672a\u751f\u6210\u7533\u62a5\u8868", (String)"YhsTaxSourceImportPlugin_28", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("yhs taxsource import param error:", (Throwable)e);
        }
        return super.importData(data, option, importlogs);
    }
}

