/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.taxsource;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import org.apache.commons.lang.StringUtils;

public class YhsTaxitemMappingFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Long ID_TAXITEM = 1426774653384272896L;

    public void registerListener(EventObject e) {
        BasedataEdit taxitem = (BasedataEdit)this.getView().getControl("taxitem");
        BasedataEdit subitem = (BasedataEdit)this.getView().getControl("subitem");
        taxitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        subitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"cardentryfixrowpanelap", "vector_addorg", "label_addorg", "label_moreorg"});
    }

    public void afterCreateNewData(EventObject e) {
        this.updateEntity();
    }

    public void afterBindData(EventObject e) {
        this.updateEntity();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        EntryGrid entity = (EntryGrid)this.getControl("entryentity");
        if (name.equals("taxitem")) {
            ListShowParameter ListShowParameter2 = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            TreeFilterParameter treeFilterParameter = ListShowParameter2.getTreeFilterParameter();
            treeFilterParameter.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{new QFilter("taxrange", "=", (Object)ID_TAXITEM)}));
            ListFilterParameter listFilterParameter = ListShowParameter2.getListFilterParameter();
            listFilterParameter.setFilter(new QFilter("taxrange", "=", (Object)ID_TAXITEM));
        } else if (name.equals("subitem")) {
            int focusRow = entity.getEntryState().getFocusRow();
            DynamicObject taxitem = (DynamicObject)this.getModel().getValue("taxitem", focusRow);
            if (taxitem != null) {
                ListShowParameter ListShowParameter3 = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = ListShowParameter3.getListFilterParameter();
                listFilterParameter.setFilter(new QFilter("parent.projectname", "=", (Object)taxitem.getString("name")));
            }
        }
    }

    private void updateEntity() {
        CardEntry entry = (CardEntry)this.getControl("orgentryentity");
        DynamicObjectCollection orgentity = this.getModel().getEntryEntity("orgentryentity");
        if (orgentity.getRowCount() > 15) {
            for (int i = 15; i < orgentity.getRowCount(); ++i) {
                entry.setChildVisible(false, i, new String[]{"cardentryrowap"});
            }
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Vector && "vector_addorg".equals(((Vector)source).getKey()) || source instanceof Label && "label_addorg".equals(((Label)source).getKey()) || source instanceof Label && "label_moreorg".equals(((Label)source).getKey()) || source instanceof Container && "flex_addorg".equals(((Container)source).getKey())) {
            this.showOrgSelect();
        }
    }

    private void showOrgSelect() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)2);
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u7ec4\u7ec7", (String)"YhsTaxitemMappingFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orgentryentity");
        if (orgEntity != null) {
            for (DynamicObject entity : orgEntity) {
                ListSelectedRow row = new ListSelectedRow();
                DynamicObject org = entity.getDynamicObject("orgid");
                row.setName(org.getString("name"));
                row.setNumber(org.getString("number"));
                row.setPrimaryKeyValue(org.get("id"));
                listSelectedRowCollection.add((Object)row);
            }
        }
        parameter.setListSelectedRowCollection(listSelectedRowCollection);
        List filters = parameter.getListFilterParameter().getQFilters();
        List orgIds = OrgUnitServiceHelper.getAllOrgByViewId((long)Long.parseLong("40"), (boolean)false);
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("id", "in", (Object)orgIds.toArray()));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectorg"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection orgs;
        if ("selectorg".equals(evt.getActionId()) && (orgs = (ListSelectedRowCollection)evt.getReturnData()) != null) {
            CardEntry entry = (CardEntry)this.getControl("orgentryentity");
            this.getModel().beginInit();
            this.getModel().deleteEntryData("orgentryentity");
            for (ListSelectedRow selectedRow : orgs) {
                int index = this.getModel().createNewEntryRow("orgentryentity");
                this.getModel().setValue("orgid", selectedRow.getPrimaryKeyValue(), index);
                if (index <= 14) continue;
                entry.setChildVisible(false, index, new String[]{"cardentryrowap"});
            }
            this.getModel().endInit();
            this.getView().updateView("orgentryentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DeleteEntry deleteEntry;
        super.beforeDoOperation(args);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (args.getSource() instanceof Save) {
            DynamicObjectCollection orgentity = this.getModel().getEntryEntity("orgentryentity");
            if (orgentity.size() != 0) {
                DynamicObjectCollection orgdynamicObjectCollection = QueryServiceHelper.query((String)"tcret_taxitem_mapping", (String)"orgentryentity.orgid", (QFilter[])new QFilter[]{new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue())});
                List orgids = orgdynamicObjectCollection.stream().map(s -> s.get("orgentryentity.orgid")).collect(Collectors.toList());
                for (DynamicObject orgobject : orgentity) {
                    DynamicObject orgid = (DynamicObject)orgobject.get("orgid");
                    if (!orgids.contains(orgid.getLong("id"))) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7a0e\u52a1\u7ec4\u7ec7\u6709\u91cd\u590d\uff0c\u540c\u4e00\u7ec4\u7ec7\u4e0d\u80fd\u51fa\u73b0\u5728\u4e24\u4e2a\u6620\u5c04\u91cc", (String)"YhsTaxitemMappingFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]), orgid.get("name")));
                    args.setCancel(true);
                }
            }
        } else if (args.getSource() instanceof Refresh) {
            this.getPageCache().put("refresh", "true");
        } else if (args.getSource() instanceof DeleteEntry && "deleteorg".equals((deleteEntry = (DeleteEntry)args.getSource()).getOperateKey())) {
            args.setCancel(true);
            EntryGrid entrye = (EntryGrid)this.getControl("orgentryentity");
            entrye.getSelectRows();
            String orgName = this.getModel().getEntryRowEntity("orgentryentity", entrye.getSelectRows()[0]).getString("orgid.name");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgDeleteConform", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"YhsTaxitemMappingFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"YhsTaxitemMappingFormPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u662f\u5426\u5c06\u201c%1$s\u201d\u5254\u9664\uff1f", (String)"YhsTaxitemMappingFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]), orgName);
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"orgDeleteConform", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                EntryGrid entrye = (EntryGrid)this.getControl("orgentryentity");
                this.getModel().deleteEntryRows("orgentryentity", entrye.getSelectRows());
                this.getView().updateView("orgentryentity");
                this.updateEntity();
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int i = entryGrid.getEntryState().getFocusRow();
        if ("taxitem".equals(name)) {
            this.getModel().setValue("subitem", null, i);
        }
    }
}

